<!DOCTYPE html>
<!--[if IE 8]> <html lang="en" class="ie8"> <![endif]-->
<!--[if !IE]><!-->
<html lang="en">
<!--<![endif]-->
<head>
	<meta charset="utf-8" />
	<title>Focus | Login</title>
	<meta content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" name="viewport" />
	<meta content="" name="description" />
	<meta content="" name="author" />
	
	<!-- ================== BEGIN BASE CSS STYLE ================== -->
	<link href="http://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700" rel="stylesheet" />
        <link href="<?php echo base_url() ?>/assets/plugins/jquery-ui/jquery-ui.min.css" rel="stylesheet" />
	<link href="<?php echo base_url() ?>/assets/plugins/bootstrap/4.1.0/css/bootstrap.min.css" rel="stylesheet" />
	<link href="<?php echo base_url() ?>/assets/plugins/font-awesome/5.0/css/fontawesome-all.min.css" rel="stylesheet" />
	<link href="<?php echo base_url() ?>/assets/plugins/animate/animate.min.css" rel="stylesheet" />
	<link href="<?php echo base_url() ?>/assets/css/default/style.min.css" rel="stylesheet" />
	<link href="<?php echo base_url() ?>/assets/css/default/style-responsive.min.css" rel="stylesheet" />
	<link href="<?php echo base_url() ?>/assets/css/default/theme/orange.css" rel="stylesheet" id="theme" />
	<!-- ================== END BASE CSS STYLE ================== -->
	
	<!-- ================== BEGIN BASE JS ================== -->
	<script src="<?php echo base_url() ?>/assets/plugins/pace/pace.min.js"></script>
	<!-- ================== END BASE JS ================== -->
</head>
<body class="pace-top bg-white">
	<!-- begin #page-loader -->
	<div id="page-loader" class="fade show "><span class="spinner"></span></div>
	<!-- end #page-loader -->
	
	<!-- begin #page-container -->
	<div id="page-container" class="fade">
	    <!-- begin login -->
        <div class="login login-with-news-feed">
            <!-- begin news-feed -->
            <div class="news-feed">
                <div class="news-image" style="background-image: url(<?php echo base_url() ?>/assets/img/login-bg/login-bg-9.jpg)"></div>
<!--                <div class="news-caption">
                    <h4 class="caption-title"><b>Focus</b></h4>
                    <p>
                        Um olhar profundo ao resumo dos seus negócios
                    </p>
                </div>-->
            </div>
            <!-- end news-feed -->
            <!-- begin right-content -->
            <div class="right-content">
                <!-- begin login-header -->
                <div class="login-header" style="text-align: center; align-content: center; align-items: center">
                    <div class="brand">
                        <span class="logo "></span> <b>Quidec</b> 
                        <small></small>
                    </div>
                    <div class="icon">
                        <i class="fa fa-sign-in"></i>
                    </div>
                </div>
                <!-- end login-header -->
                <div id="msg"></div>
                <div id="msgPulse"></div>
                <!-- begin login-content -->
                <div class="login-content">
                    <form action="#" name="form_login" method="POST" class="margin-bottom-0">
                        <div class="form-group m-b-20">
                            <input type="text" name="email" class="form-control form-control-lg" placeholder="email ou nº de telefone" required />
                        </div>
                        <div class="form-group m-b-20">
                            <input type="password" name="password" class="form-control form-control-lg" placeholder="senha" required />
                        </div>
                        <div class="login-buttons">
                            <button type="submit" class="btn btn-yellow btn-block btn-lg">Entrar</button>
                        </div>
                        <br>
                        <hr />
                        <p class="text-center text-grey-darker">
                            &copy; <?php echo date('Y') ?> <b>Quidec</b> todos direitos reservados.
                        </p>
                    </form>
                </div>
                <!-- end login-content -->
            </div>
            <!-- end right-container -->
        </div>
        <!-- end login -->
	</div>
	<!-- end page container -->
	
	<!-- ================== BEGIN BASE JS ================== -->
	<script src="<?php echo base_url() ?>/assets/plugins/jquery/jquery-3.2.1.min.js"></script>
	<script src="<?php echo base_url() ?>/assets/plugins/jquery-ui/jquery-ui.min.js"></script>
	<script src="<?php echo base_url() ?>/assets/plugins/bootstrap/4.1.0/js/bootstrap.bundle.min.js"></script>
	<!--[if lt IE 9]>
		<script src="../assets/crossbrowserjs/html5shiv.js"></script>
		<script src="../assets/crossbrowserjs/respond.min.js"></script>
		<script src="../assets/crossbrowserjs/excanvas.min.js"></script>
	<![endif]-->
	<script src="<?php echo base_url() ?>/assets/plugins/slimscroll/jquery.slimscroll.min.js"></script>
	<script src="<?php echo base_url() ?>/assets/plugins/js-cookie/js.cookie.js"></script>
	<!--<script src="<?php // echo base_url() ?>/assets/js/theme/default.min.js"></script>-->
        <script src="<?php echo base_url() ?>/assets/js/theme/default.js"></script>
	<script src="<?php echo base_url() ?>/assets/js/apps.js"></script>
	<!-- ================== END BASE JS ================== -->

	<script>
		$(document).ready(function() {
			App.init();
		});
	</script>
        
        <script type="text/javascript">

            $('form[name="form_login"]').submit(function (e) {
                e.preventDefault();

                var forma = $(this);
                var botao = $(this).find(':button');

                $.ajax({
                    url: "<?php echo base_url(); ?>Login/entrar",
                    type: "POST",
                    data: forma.serialize(),
                    dataType: "json",
                    beforeSend: function () {
                        botao.attr('disabled', true);
                        $('.load').fadeIn('slow');
//                        alert(forma.serialize());
                    },
                    success: function (retorno) {
//                        botao.attr('disabled', false);
//                        console.log(retorno);
                        if (retorno.success === 'diferente') {
                            $('#msg').html('<div class="alert alert-danger fade show flash-msg" style="text-align: center"> <strong>AVISO!  </strong>SENHA ERRADA.</div>');
                            $('.flash-msg').delay(3000).fadeOut('slow', function(){});
                            botao.attr('disabled', false);
                        } else if (retorno.success === 'naoexiste') {
                            $('#msg').html('<div class="alert alert-danger fade show flash-msg" style="text-align: center"> <strong>AVISO!  </strong>Email ou Telefone ERRADOS, Procure rever de novo!</div>');
                            $('.flash-msg').delay(3000).fadeOut('slow', function(){});
                            botao.attr('disabled', false);
                        } else if ((retorno.success === 'entrou')) {
                            forma.fadeOut('fast', function () {
                                $('#msgPulse').html('<center><div class="fa-3x"><i class="fas fa-spinner fa-pulse"></i></div></center>');
                                $('#msg').html('<div class="alert alert-success fade show flash-msg" style="text-align: center"> <strong>AVISO!  </strong> BEM VINDO(A)! AGUARDE...</div>');
                                $('.flash-msg').delay(3000).fadeOut('slow', function(){});
                                $('#load').fadeIn('slow');
                            });

                            setTimeout(function () {
                                $(location).attr('href', '<?php echo base_url(); ?>');
                            }, 3000);
                        }


                    },
                    error: function (e) {
                        console.log(e.responseText);
                        $('#msg').html('<div class="alert alert-danger fade show flash-msg" style="text-align: center"> <strong>AVISO!  </strong> ERRO 2: DESCONHECIDO </div>');
                            $('.flash-msg').delay(4000).fadeOut('slow', function(){});
                     }
                    

                });

            });

        </script>
</body>
</html>
