/*
Template Name: Color Admin - Responsive Admin Dashboard Template build with Bootstrap 5
Version: 5.1.5
Author: Sean Ngu
Website: http://www.seantheme.com/color-admin/frontend/one-page-parallax/
	----------------------------
			APPS CONTENT TABLE
	----------------------------
	
	<!-- ======== GLOBAL SCRIPT SETTING ======== -->
	01. Handle Home Content Height
	02. Handle Header Navigation State
	03. Handle Commas to Number
	04. Handle Page Container Show
	05. Handle Page Scroll Content Animation
	06. Handle Header Scroll To Action
	07. Handle Tooltip Activation
	08. Handle Theme Panel Expand
	09. Handle Theme Page Control
	10. Handle Paroller
	11. Handle Get Css Variable

	<!-- ======== APPLICATION SETTING ======== -->
	Application Controller
*/

var app = {
	font: {
	
	},
	color: {
	
	}
}



/* 01. Handle Home Content Height
------------------------------------------------ */
var handleHomeContentHeight = function() {
	$('#home').height($(window).height());

	$(window).on('resize', function() {
		$('#home').height($(window).height());
	});
};


/* 02. Handle Header Navigation State
------------------------------------------------ */
var handleHeaderNavigationState = function() {
	$(window).on('scroll load', function() {
		if ($('#header').attr('data-state-change') != 'disabled') {
			var totalScroll = $(window).scrollTop();
			var headerHeight = $('#header').height();
			if (totalScroll > headerHeight) {
				$('#header').addClass('navbar-sm');
			} else {
				$('#header').removeClass('navbar-sm');
			}
		}
	});
};


/* 03. Handle Commas to Number
------------------------------------------------ */
var handleAddCommasToNumber = function(value) {
    return value.toString().replace(/(\d)(?=(\d\d\d)+(?!\d))/g, "$1,");
};


/* 04. Handle Page Container Show
------------------------------------------------ */
var handlePageContainerShow = function() {
	$('#page-container').addClass('show');
};


/* 05. Handle Page Scroll Content Animation
------------------------------------------------ */
var handlePageScrollContentAnimation = function() {
	$('[data-scrollview="true"]').each(function() {
		var myElement = $(this);
		var elementWatcher = scrollMonitor.create( myElement, 60 );

		elementWatcher.enterViewport(function() {
			$(myElement).find('[data-animation=true]').each(function() {
				var targetAnimation = $(this).attr('data-animation-type');
				var targetElement = $(this);
				if (!$(targetElement).hasClass('contentAnimated')) {
					if (targetAnimation == 'number') {
						var finalNumber = parseInt($(targetElement).attr('data-final-number'));
						$({animateNumber: 0}).animate({animateNumber: finalNumber}, {
							duration: 1000,
							easing:'swing',
							step: function() {
								var displayNumber = handleAddCommasToNumber(Math.ceil(this.animateNumber));
								$(targetElement).text(displayNumber).addClass('contentAnimated');
							}
						});
					} else {
						$(this).addClass(targetAnimation + ' contentAnimated');
						setTimeout(function() {
							$(targetElement).addClass('finishAnimated');
						}, 1500);
					}
				}
			});
		});
	});
};


/* 06. Handle Header Scroll To Action
------------------------------------------------ */
var handleHeaderScrollToAction = function() {
	$(document).on('click', '[data-click=scroll-to-target]', function(e) {
		e.preventDefault();
		e.stopPropagation();
		var target = ($(this).attr('data-scroll-target')) ? $(this).attr('data-scroll-target') : '';
		var target = (!target && $(this).attr('href')) ? $(this).attr('href') : target;
		var fromHeader = $(this).closest('.header').length;
		var headerHeight = 50;
		$('html, body').animate({
			scrollTop: $(target).offset().top - headerHeight
		}, 500);

		var targetLi = $(this).closest('.nav-item');
		if ($(targetLi).hasClass('dropdown')) {
			if ($(targetLi).hasClass('open')) {
				$(targetLi).removeClass('open');
			} else {
				$(targetLi).addClass('open');
			}
		}
		if ($(window).width() < 769 && !$(targetLi).hasClass('dropdown') && fromHeader) {
			$('#header [data-toggle="collapse"]').trigger('click');
		}
	});
	$(document).click(function(e) {
		if (!e.isPropagationStopped() && $(window).width() > 768) {
			$('.dropdown.open').removeClass('open'); 
		}
	});
};


/* 07. Handle Tooltip Activation
------------------------------------------------ */
var handleTooltipActivation = function() {
	if ($('[data-bs-toggle=tooltip]').length !== 0) {
		$('[data-bs-toggle=tooltip]').tooltip();
	}
};


/* 08. Handle Theme Panel Expand
------------------------------------------------ */
var handleThemePanelExpand = function() {
	$(document).on('click', '[data-click="theme-panel-expand"]', function() {
	var targetContainer = '.theme-panel';
	var targetClass = 'active';
	if ($(targetContainer).hasClass(targetClass)) {
		$(targetContainer).removeClass(targetClass);
	} else {
		$(targetContainer).addClass(targetClass);
	}
	});
};


/* 09. Handle Theme Page Control
------------------------------------------------ */
var handleThemePageControl = function() {
	if (typeof Cookies !== 'undefined') {
		$(document).on('click', '.theme-list [data-theme]', function(e) {	
			e.preventDefault();
			var targetThemeClass = $(this).attr('data-theme');
		
			for (var x = 0; x < document.body.classList.length; x++) {
				var targetClass = document.body.classList[x];
				if (targetClass.search('theme-') > -1) {
					$('body').removeClass(targetClass);
				}
			}
		
			$('body').addClass(targetThemeClass);
			$('.theme-list [data-theme]').not(this).closest('li').removeClass('active');
			$(this).closest('li').addClass('active');
		
			if (Cookies) {
				Cookies.set('theme', $(this).attr('data-theme'));
				$(document).trigger('theme-change');
			}
		});
		
		$(document).on('change', '.theme-panel [name="app-theme-dark-mode"]', function() {
			var targetCookie = '';
		
			if ($(this).is(':checked')) {
				$('html').addClass('dark-mode');
				targetCookie = 'dark-mode';
			} else {
				$('html').removeClass('dark-mode');
			}
		
			if (Cookies) {
				App.initVariable();
				Cookies.set('app-theme-dark-mode', targetCookie);
				$(document).trigger('theme-change');
			}
		});
		
		if (Cookies.get('theme') && $('.theme-list').length !== 0) {
			var targetElm = '.theme-list [data-theme="'+ Cookies.get('theme') +'"]';
			$(targetElm).trigger('click');
		}
		if (Cookies.get('app-theme-dark-mode') && $('.theme-panel [name="app-theme-dark-mode"]').length !== 0) {
			$('.theme-panel [name="app-theme-dark-mode"]').prop('checked', true).trigger('change');
		}
	}
};


/* 10. Handle Paroller
------------------------------------------------ */
var handleParoller = function() {
	if (typeof $.fn.paroller !== 'undefined') {
		if ($('[data-paroller="true"]').length !== 0) {
			$('[data-paroller="true"]').paroller();
		}
	}
};


/* 11. Handle Get Css Variable
------------------------------------------------ */
var getCssVariable = function(variable) {
	return window.getComputedStyle(document.body).getPropertyValue(variable).trim();
};


/* Application Controller
------------------------------------------------ */
var App = function () {
	"use strict";
	
	return {
		//main function
		init: function () {
			handleHomeContentHeight();
			handleHeaderNavigationState();
			handlePageContainerShow();
			handlePageScrollContentAnimation();
			handleHeaderScrollToAction();
			handleTooltipActivation();
			handleThemePanelExpand();
			handleThemePageControl();
			handleParoller();
			
			this.initVariable();
		},
		initVariable: function() {
			app.color.theme          = getCssVariable('--app-theme');
			app.font.family          = getCssVariable('--bs-body-font-family');
			app.font.size            = getCssVariable('--bs-body-font-size');
			app.font.weight          = getCssVariable('--bs-body-font-weight');
			app.color.componentColor = getCssVariable('--app-component-color');
			app.color.componentBg    = getCssVariable('--app-component-bg');
			app.color.dark           = getCssVariable('--bs-dark');
			app.color.light          = getCssVariable('--bs-light');
			app.color.blue           = getCssVariable('--bs-blue');
			app.color.indigo         = getCssVariable('--bs-indigo');
			app.color.purple         = getCssVariable('--bs-purple');
			app.color.pink           = getCssVariable('--bs-pink');
			app.color.red            = getCssVariable('--bs-red');
			app.color.orange         = getCssVariable('--bs-orange');
			app.color.yellow         = getCssVariable('--bs-yellow');
			app.color.green          = getCssVariable('--bs-green');
			app.color.success        = getCssVariable('--bs-success');
			app.color.teal           = getCssVariable('--bs-teal');
			app.color.cyan           = getCssVariable('--bs-cyan');
			app.color.white          = getCssVariable('--bs-white');
			app.color.gray           = getCssVariable('--bs-gray');
			app.color.lime           = getCssVariable('--bs-lime');
			app.color.gray100        = getCssVariable('--bs-gray-100');
			app.color.gray200        = getCssVariable('--bs-gray-200');
			app.color.gray300        = getCssVariable('--bs-gray-300');
			app.color.gray400        = getCssVariable('--bs-gray-400');
			app.color.gray500        = getCssVariable('--bs-gray-500');
			app.color.gray600        = getCssVariable('--bs-gray-600');
			app.color.gray700        = getCssVariable('--bs-gray-700');
			app.color.gray800        = getCssVariable('--bs-gray-800');
			app.color.gray900        = getCssVariable('--bs-gray-900');
			app.color.black          = getCssVariable('--bs-black');
			
			app.color.themeRgb          = getCssVariable('--app-theme-rgb');
			app.font.familyRgb          = getCssVariable('--bs-body-font-family-rgb');
			app.font.sizeRgb            = getCssVariable('--bs-body-font-size-rgb');
			app.font.weightRgb          = getCssVariable('--bs-body-font-weight-rgb');
			app.color.componentColorRgb = getCssVariable('--app-component-color-rgb');
			app.color.componentBgRgb    = getCssVariable('--app-component-bg-rgb');
			app.color.darkRgb           = getCssVariable('--bs-dark-rgb');
			app.color.lightRgb          = getCssVariable('--bs-light-rgb');
			app.color.blueRgb           = getCssVariable('--bs-blue-rgb');
			app.color.indigoRgb         = getCssVariable('--bs-indigo-rgb');
			app.color.purpleRgb         = getCssVariable('--bs-purple-rgb');
			app.color.pinkRgb           = getCssVariable('--bs-pink-rgb');
			app.color.redRgb            = getCssVariable('--bs-red-rgb');
			app.color.orangeRgb         = getCssVariable('--bs-orange-rgb');
			app.color.yellowRgb         = getCssVariable('--bs-yellow-rgb');
			app.color.greenRgb          = getCssVariable('--bs-green-rgb');
			app.color.successRgb        = getCssVariable('--bs-success-rgb');
			app.color.tealRgb           = getCssVariable('--bs-teal-rgb');
			app.color.cyanRgb           = getCssVariable('--bs-cyan-rgb');
			app.color.whiteRgb          = getCssVariable('--bs-white-rgb');
			app.color.grayRgb           = getCssVariable('--bs-gray-rgb');
			app.color.limeRgb           = getCssVariable('--bs-lime-rgb');
			app.color.gray100Rgb        = getCssVariable('--bs-gray-100-rgb');
			app.color.gray200Rgb        = getCssVariable('--bs-gray-200-rgb');
			app.color.gray300Rgb        = getCssVariable('--bs-gray-300-rgb');
			app.color.gray400Rgb        = getCssVariable('--bs-gray-400-rgb');
			app.color.gray500Rgb        = getCssVariable('--bs-gray-500-rgb');
			app.color.gray600Rgb        = getCssVariable('--bs-gray-600-rgb');
			app.color.gray700Rgb        = getCssVariable('--bs-gray-700-rgb');
			app.color.gray800Rgb        = getCssVariable('--bs-gray-800-rgb');
			app.color.gray900Rgb        = getCssVariable('--bs-gray-900-rgb');
			app.color.blackRgb          = getCssVariable('--bs-black-rgb');
		}
  };
}();

$(document).ready(function() {
	App.init();
});
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
