/*
Template Name: Color Admin - Responsive Admin Dashboard Template build with Bootstrap 5
Version: 5.1.5
Author: Sean Ngu
Website: http://www.seantheme.com/color-admin/
	----------------------------
			APPS CONTENT TABLE
	----------------------------
	
	<!-- ======== GLOBAL SCRIPT SETTING ======== -->
	01. Handle Header Mobile Nav
	02. Handle Theme Panel Expand
	03. Handle Theme Page Control
  04. Handle Get Css Variable

	<!-- ======== APPLICATION SETTING ======== -->
	Application Controller
*/

var app = {
	font: {
	
	},
	color: {
	
	}
}


/* 01. Handle Header Mobile Nav
------------------------------------------------ */
var handleHeaderMobileNav = function() {
	$(document).on('click', '[data-toggle="header-mobile-nav"]', function(e) {
		e.preventDefault();
	
		$('.header .header-nav').slideToggle();
	});
};


/* 02. Handle Theme Panel Expand
------------------------------------------------ */
var handleThemePanelExpand = function() {
	$(document).on('click', '[data-click="theme-panel-expand"]', function() {
	var targetContainer = '.theme-panel';
	var targetClass = 'active';
	if ($(targetContainer).hasClass(targetClass)) {
		$(targetContainer).removeClass(targetClass);
	} else {
		$(targetContainer).addClass(targetClass);
	}
	});
};


/* 03. Handle Theme Page Control
------------------------------------------------ */
var handleThemePageControl = function() {
	if (typeof Cookies !== 'undefined') {
		$(document).on('click', '.theme-list [data-theme]', function(e) {	
			e.preventDefault();
			var targetThemeClass = $(this).attr('data-theme');
		
			for (var x = 0; x < document.body.classList.length; x++) {
				var targetClass = document.body.classList[x];
				if (targetClass.search('theme-') > -1) {
					$('body').removeClass(targetClass);
				}
			}
		
			$('body').addClass(targetThemeClass);
			$('.theme-list [data-theme]').not(this).closest('li').removeClass('active');
			$(this).closest('li').addClass('active');
		
			if (Cookies) {
				Cookies.set('theme', $(this).attr('data-theme'));
				$(document).trigger('theme-change');
			}
		});
		
		$(document).on('change', '.theme-panel [name="app-theme-dark-mode"]', function() {
			var targetCookie = '';
		
			if ($(this).is(':checked')) {
				$('html').addClass('dark-mode');
				targetCookie = 'dark-mode';
			} else {
				$('html').removeClass('dark-mode');
			}
		
			if (Cookies) {
				App.initVariable();
				Cookies.set('app-theme-dark-mode', targetCookie);
				$(document).trigger('theme-change');
			}
		});
		
		if (Cookies.get('theme') && $('.theme-list').length !== 0) {
			var targetElm = '.theme-list [data-theme="'+ Cookies.get('theme') +'"]';
			$(targetElm).trigger('click');
		}
		if (Cookies.get('app-theme-dark-mode') && $('.theme-panel [name="app-theme-dark-mode"]').length !== 0) {
			$('.theme-panel [name="app-theme-dark-mode"]').prop('checked', true).trigger('change');
		}
	}
};


/* 04. Handle Tooltip Activation
------------------------------------------------ */
var handleTooltipActivation = function() {
	if ($('[data-bs-toggle=tooltip]').length !== 0) {
		$('[data-bs-toggle=tooltip]').tooltip();
	}
};


/* 05. Handle Get Css Variable
------------------------------------------------ */
var getCssVariable = function(variable) {
	return window.getComputedStyle(document.body).getPropertyValue(variable).trim();
};


/* Application Controller
------------------------------------------------ */
var App = function () {
	"use strict";
	
	return {
		//main function
		init: function () {
			handleHeaderMobileNav();
			handleThemePanelExpand()
			handleThemePageControl();
			handleTooltipActivation();
			
			this.initVariable();
		},
		initVariable: function() {
			app.color.theme          = getCssVariable('--app-theme');
			app.font.family          = getCssVariable('--bs-body-font-family');
			app.font.size            = getCssVariable('--bs-body-font-size');
			app.font.weight          = getCssVariable('--bs-body-font-weight');
			app.color.componentColor = getCssVariable('--app-component-color');
			app.color.componentBg    = getCssVariable('--app-component-bg');
			app.color.dark           = getCssVariable('--bs-dark');
			app.color.light          = getCssVariable('--bs-light');
			app.color.blue           = getCssVariable('--bs-blue');
			app.color.indigo         = getCssVariable('--bs-indigo');
			app.color.purple         = getCssVariable('--bs-purple');
			app.color.pink           = getCssVariable('--bs-pink');
			app.color.red            = getCssVariable('--bs-red');
			app.color.orange         = getCssVariable('--bs-orange');
			app.color.yellow         = getCssVariable('--bs-yellow');
			app.color.green          = getCssVariable('--bs-green');
			app.color.success        = getCssVariable('--bs-success');
			app.color.teal           = getCssVariable('--bs-teal');
			app.color.cyan           = getCssVariable('--bs-cyan');
			app.color.white          = getCssVariable('--bs-white');
			app.color.gray           = getCssVariable('--bs-gray');
			app.color.lime           = getCssVariable('--bs-lime');
			app.color.gray100        = getCssVariable('--bs-gray-100');
			app.color.gray200        = getCssVariable('--bs-gray-200');
			app.color.gray300        = getCssVariable('--bs-gray-300');
			app.color.gray400        = getCssVariable('--bs-gray-400');
			app.color.gray500        = getCssVariable('--bs-gray-500');
			app.color.gray600        = getCssVariable('--bs-gray-600');
			app.color.gray700        = getCssVariable('--bs-gray-700');
			app.color.gray800        = getCssVariable('--bs-gray-800');
			app.color.gray900        = getCssVariable('--bs-gray-900');
			app.color.black          = getCssVariable('--bs-black');
			
			app.color.themeRgb          = getCssVariable('--app-theme-rgb');
			app.font.familyRgb          = getCssVariable('--bs-body-font-family-rgb');
			app.font.sizeRgb            = getCssVariable('--bs-body-font-size-rgb');
			app.font.weightRgb          = getCssVariable('--bs-body-font-weight-rgb');
			app.color.componentColorRgb = getCssVariable('--app-component-color-rgb');
			app.color.componentBgRgb    = getCssVariable('--app-component-bg-rgb');
			app.color.darkRgb           = getCssVariable('--bs-dark-rgb');
			app.color.lightRgb          = getCssVariable('--bs-light-rgb');
			app.color.blueRgb           = getCssVariable('--bs-blue-rgb');
			app.color.indigoRgb         = getCssVariable('--bs-indigo-rgb');
			app.color.purpleRgb         = getCssVariable('--bs-purple-rgb');
			app.color.pinkRgb           = getCssVariable('--bs-pink-rgb');
			app.color.redRgb            = getCssVariable('--bs-red-rgb');
			app.color.orangeRgb         = getCssVariable('--bs-orange-rgb');
			app.color.yellowRgb         = getCssVariable('--bs-yellow-rgb');
			app.color.greenRgb          = getCssVariable('--bs-green-rgb');
			app.color.successRgb        = getCssVariable('--bs-success-rgb');
			app.color.tealRgb           = getCssVariable('--bs-teal-rgb');
			app.color.cyanRgb           = getCssVariable('--bs-cyan-rgb');
			app.color.whiteRgb          = getCssVariable('--bs-white-rgb');
			app.color.grayRgb           = getCssVariable('--bs-gray-rgb');
			app.color.limeRgb           = getCssVariable('--bs-lime-rgb');
			app.color.gray100Rgb        = getCssVariable('--bs-gray-100-rgb');
			app.color.gray200Rgb        = getCssVariable('--bs-gray-200-rgb');
			app.color.gray300Rgb        = getCssVariable('--bs-gray-300-rgb');
			app.color.gray400Rgb        = getCssVariable('--bs-gray-400-rgb');
			app.color.gray500Rgb        = getCssVariable('--bs-gray-500-rgb');
			app.color.gray600Rgb        = getCssVariable('--bs-gray-600-rgb');
			app.color.gray700Rgb        = getCssVariable('--bs-gray-700-rgb');
			app.color.gray800Rgb        = getCssVariable('--bs-gray-800-rgb');
			app.color.gray900Rgb        = getCssVariable('--bs-gray-900-rgb');
			app.color.blackRgb          = getCssVariable('--bs-black-rgb');
		}
  };
}();

$(document).ready(function() {
	App.init();
});
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
