<?php
class ReciboPDF extends TCPDF {

            public function Footer() {
                //$pagenumtxt = $this->l['w_page'] . ' ' . $this->getAliasNumPage() . ' / ' . $this->getAliasNbPages();
                //$this->Cell(0, 0, $pagenumtxt, 'T', 0, 'R');
                $this->SetFont('Times', 'I', 10);
               
            }

        }

$pdf = new ReciboPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, 'ROLL_PAPER', true, 'UTF-8', false); // para imprimir nas termicas
//$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false); // para imprimir em A4

// set document information
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Adilson Figueira');
$pdf->SetTitle('RECIBO MÔ-JOGOS');
$pdf->SetSubject('TCPDF Tutorial');
$pdf->SetKeywords('TCPDF, PDF, example, test, guide');
// remove default header/footer
$pdf->setPrintHeader(false);
$pdf->setPrintFooter(false);

// set default monospaced font
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

// set margins
//$pdf->SetMargins(10, PDF_MARGIN_TOP, 10);
// set auto page breaks
$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

// set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

// set default header data
$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE, PDF_HEADER_STRING);

// set header and footer fonts
$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

// set default monospaced font
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

// set margins
$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

// set auto page breaks
$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

// set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

// set some language-dependent strings (optional)
if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
	require_once(dirname(__FILE__).'/lang/eng.php');
	$pdf->setLanguageArray($l);
}

// ---------------------------------------------------------

// set font
$pdf->SetFont('times', '', 10);

// add a page
//$pdf->AddPage(210, 297);
//Informação de como estruturar uma página ROLL PAPER
$pdf->AddPage('P', array(210, 80));
//$pdf->Cell(0, 0, 'A6 PORTRAIT', 1, 1, 'C');
// set cell padding
$pdf->setCellPaddings(1, 1, 1, 1);

// set cell margins
$pdf->setCellMargins(0, 1, 1, 0);
$bMargin = $pdf->getBreakMargin();
// get current auto-page-break mode
$auto_page_break = $pdf->getAutoPageBreak();
// disable auto-page-break
$pdf->SetAutoPageBreak(false, 0);

// set color for background
$pdf->SetFillColor(255, 255, 127);

// MultiCell($w, $h, $txt, $border=0, $align='J', $fill=0, $ln=1, $x='', $y='', $reseth=true, $stretch=0, $ishtml=false, $autopadding=true, $maxh=0)
// set some text to print

$base_url = 'assets/images/logo';
$logotipo = 'logoPNG2.png';

//IMAGEM DO ESTUDANTE
$pdf->Image($base_url . '/'.$logotipo ,17, 2, 45, 30, '', '', '', false, 300, '', false, false, 0, false, false, false);

$table1 ='<table  width="275" border="0" style="font-family:  sans-serif; font-size:10px">';

$table1 .='<tr>
                <th style=" width: 275px; text-align: center;">
                    <strong> 
                        SANGUNGA & FILHOS - COMERCIO E PRESTAÇÃO DE SERVIÇOS LDA
                    </strong>
                </th>                    
           </tr>';

$table1 .= '</table>';
$pdf->SetY(31);
$pdf->SetX(0);
$pdf->writeHTMLCell(0, 0, '', '', $table1, 0, 1, 0, true, 'L', true);

$cartela ='<h2 >Cartela Diária</h2>';

$pdf->SetY(42);
$pdf->SetX(26);
$pdf->writeHTMLCell(0, 0, '', '', $cartela, 0, 1, 0, true, 'L', true);


$figueira =
'<style>
    /* Estilos das cartelas */
    .bingo-card {
      background-color: #fff;
      border-radius: 10px;
      box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
    }
    
     table {
      width: 120%;
      border-collapse: collapse;
    }
    
     td {
      text-align: center;
      padding: 10px;
      border: 1px solid #000;
    }
    
     .number {
      font-size: 20px;
      font-weight: bold;
      color: #333;
    }
    
    /* Estilos para destacar os números selecionados */
    .selected {
      background-color: #ffcc00;
      color: #fff;
    }
  </style>';
$figueira .='<div class="bingo-card"><table>';
$lianhas = $OneFicha['linha1'].','.$OneFicha['linha2'].','.$OneFicha['linha3'];
$cod_vector = explode(',', $lianhas);
    for ($i = 0; $i < 3; $i++) {
        $figueira .= '<tr>';
        for ($j = 0; $j < 3; $j++) {
            $figueira .= '<td><span class="number">'.$cod_vector[$i * 3 + $j].'</span></td>';
        }
        $figueira .= '</tr>';
    }
$figueira .= '</table></div>';

$pdf->SetY(50);
$pdf->SetX(5);
$pdf->writeHTMLCell(0, 0, '', '', $figueira, 0, 1, 0, true, 'L', true);



if ($OneFicha['modo_pagamento'] === 'R') {
    $valor = 'REFERÊNCIA';
} else if ($OneFicha['modo_pagamento'] === 'V') {
    $valor = 'EXPRESS DIREITO';
}else if ($OneFicha['modo_pagamento'] === 'A') {
    $valor = 'PAGO NO AGENTE';
}else if ($OneFicha['modo_pagamento'] === 'S') {
    $valor = 'SALDO';
}else if ($OneFicha['modo_pagamento'] === 'M') {
    $valor = 'MENSAGEM';
}
if($OneFicha['reference_number'] == null){
    $reference = ' - - ';
}else{
    $reference = $OneFicha['reference_number'];
}

if($OneFicha['entidade'] == null){
    $entidade = ' - - ';
}else{
    $entidade = $OneFicha['entidade'];
}

$table ='<table  width="275" border="0" style="font-family:  sans-serif; font-size:10px">';

$table .= ' <tr>
 <th style="border:1px solid #000; width: 100px text-align: left; " ><strong>CAZOLA :</strong> </th>
 <td style="border:1px solid #000; width: 175px; text-align: center;" colspan="3">'.strtoupper($OneFicha['nomeSorteio']).'</td>
 </tr> 
  <tr><br>
 <th style="border:1px solid #000;  width: 100px; text-align: left" colspan="3"><strong> INVESTIMENTO : </strong></th>
 <td style="border:1px solid #000; width: 175px; text-align: center"><b>'.number_format($OneFicha['custo'], 2, ".", ","). ' KZ'.'</b></td>
 </tr>
 <tr><br>
 <th style="border:1px solid #000; width: 100px; text-align: left" colspan="3"><strong> MODO </strong></th>
 <td style="border:1px solid #000; width: 175px; text-align: center" >'.$valor.'</td>
 </tr>
 <tr><br>
 <th style="border:1px solid #000; width: 100px; text-align: left" colspan="3"><strong> DATA: </strong></th>
 <td style="border:1px solid #000; width: 175px; text-align: center; align-content: center; justify-content: center;">'. date('d-m-Y H:i:s', strtotime($OneFicha['created_at'])).'</td>
 </tr>
 <tr><br>
 <th style="border:1px solid #000; width: 100px; text-align: left" colspan=""><strong> PARTICIPANTE: </strong></th>
 <td style="border:1px solid #000; width: 175px; text-align: center" colspan="3">'.strtoupper($user_actual).'</td>
 </tr>
 
 <tr><br>
 <th style=" text-align: center; width: 275px;" colspan=""><strong> MÔ-JOGOS!<br> Obrigado por usar os nossos Serviços </strong></th>
 </tr>';

$table .= '</table>';



$pdf->SetY(78);
$pdf->SetX(0);
$table  .= '</table>';

$pdf->writeHTMLCell(0, 0, '', '', $table, 0, 1, 0, true, '', true);




// move pointer to last page
$pdf->lastPage();

// ---------------------------------------------------------
// force print dialog
//$js .= 'print(true);';

// set javascript
//$pdf->IncludeJS($js);
//Close and output PDF document
ob_clean();
$pdf->Output('factura.pdf', 'I');

//============================================================+
// END OF FILE
//============================================================+
