<?php

class Users_m extends CI_Model {

    public function __construct() {
        $this->load->database();
    }

    
    public function sorteios() { // Listar sorteios
            $estado='1';
            $this->db->select('*');
            $this->db->from('sorteio');
            $this->db->where('estado =', $estado);
            $this->db->where('data_fim >=', date('Y-m-d'));
            $this->db->order_by('id', 'desc');
            $query = $this->db->get();
            return $query->result_array();
    }
    public function listarUsers($id = false) { // Listar sorteios
        if ($id === false) {
            $this->db->select('U.*, P.name as Pais_name,Pr.name as Provi_name,M.name as Municipio_name');
            $this->db->from('user U');
            $this->db->join('paises P', 'P.id = U.pais_id');
            $this->db->join('provincias Pr', 'Pr.id = U.provincia_id');
            $this->db->join('municipios M', 'M.id = U.municipio_id');
            $query = $this->db->get();
            return $query->result_array();
        }

        $this->db->select('U.*, P.name as Pais_name,Pr.name as Provi_name,M.name as Municipio_name');
        $this->db->from('user U');
        $this->db->join('paises P', 'P.id = U.pais_id');
        $this->db->join('provincias Pr', 'Pr.id = U.provincia_id');
        $this->db->join('municipios M', 'M.id = U.municipio_id');
        $this->db->where('U.id', $id);
        $query = $this->db->get();
        return $query->row_array();
    }
    
    public function pegaLogin_byID($id){
        $this->db->select('*');
        $this->db->from('user');
        $this->db->where('id =', $id);
        $resultado = $this->db->get()->row();
//        if (count($resultado) == 1) {
        if ($resultado) {
            return $resultado;
        } else {
            return FALSE;
        }
    }
    
    public function Pegar_EstadoPerfil(){
        $this->db->select('*');
        $this->db->from('user');
        $this->db->where('id =', $this->session->userdata('user_session')['id']);
        $resultado = $this->db->get()->row()->concluido;
//        if (count($resultado) == 1) {
        if ($resultado) {
            return $resultado;
        } else {
            return FALSE;
        }
    }
    
    // Metodo para activar e desactivar utilizador
    public function activarDesactivarUserRole($id, $status) {
        
        $data = array(
            'role' => $status
        );
        $this->db->where('id', $id);
        return $this->db->update('user', $data);
    }
    
    public function listarSorteio($id = false) { // Listar sorteios
        if ($id === false) {
            $this->db->select('P.*');
            $this->db->from('sorteio P');
            $query = $this->db->get();
            return $query->result_array();
        }
        $this->db->select('P.*');
        $this->db->from('sorteio P');
        $this->db->where('P.id', $id);
        $query = $this->db->get();
        return $query->row_array();
    }
    public function listar_sorteios_premios($id = false) { // Listar sorteios_prémios
        $this->db->select('p.*, s.descricao');
        $this->db->from('premio p');
        $this->db->join('premio_mone s', 's.id = p.premio_nome_id');
        $this->db->where('P.sorteio_id', $id);
        $query = $this->db->get();
        return $query->result_array();
    }
    public function listarPaises() { // Listar sorteios_prémios
        $this->db->select('P.*');
        $this->db->from('paises P');
        $query = $this->db->get();
        return $query->result_array();
    }
    public function listarProvincias($idPais) { // Listar sorteios_prémios
        $this->db->select('P.*');
        $this->db->from('provincias P');
        $this->db->where('P.paise_id', $idPais);
        $query = $this->db->get();
        return $query->result_array();
    }
    
    
    public function listarMunicipio($idProvincia) { // Listar sorteios_prémios
        $this->db->select('M.*');
        $this->db->from('municipios M');
        $this->db->where('M.provincia_id', $idProvincia);
        $query = $this->db->get();
        return $query->result_array();
    }
    public function salvar() {
        
        if ($this->input->post('genero') === 'M') {
            $fotografia = 'homem.jpg';
        } else {
            $fotografia = 'mulher.jpg';
        }
        // Fortificar a password de formas a tornar ainda mais segura
        $email_separado = explode("@", $this->input->post('email'));
        $username=$email_separado[0];
        $password = strrev(sha1(strtoupper($this->input->post('password'))));
        $data = array(
            'username' => $username,
            'nome' => $this->input->post('nome'),
            'email' => $this->input->post('email'),
            'password' => $password,
            'telefone' => $this->input->post('telefone'),
            'photo'=> $fotografia,
            'genero'=> $this->input->post('genero'),
            'created_at' => date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s')
        );
        
        if ($this->db->insert('user', $data)) {
            $this->conta_user($this->db->insert_id());
        }
    }
    
    public function actualizar($fotografia = false) {
        $email_separado = explode("@", $this->input->post('email'));
        $username=$email_separado[0];
        $concluido = 1;
        if ($fotografia) {
            
            $data = array(
            'username' => $username,
            'nome' => $this->input->post('profilename'),
            'email' => $this->input->post('email'),
            'genero' => $this->input->post('genero'),
//            'telefone' => $this->input->post('telefone'),
            'bi' => strtoupper($this->input->post('bi')),
            'data_nasc' => $this->input->post('data_nasc'),
            'morada' => $this->input->post('morada'),
            'pais_id' => $this->input->post('pais_id'),
            'provincia_id' => $this->input->post('provincia_id'),
            'municipio_id' => $this->input->post('municipio_id'),
            'concluido' => $concluido,
            'photo'=> $fotografia,
            'updated_at' => date('Y-m-d H:i:s')
            );
        } else {
            $data = array(
                'username' => $username,
                'nome' => $this->input->post('profilename'),
                'email' => $this->input->post('email'),
                'genero' => $this->input->post('genero'),
//                'telefone' => $this->input->post('telefone'),
                'bi' => strtoupper($this->input->post('bi')),
                'data_nasc' => $this->input->post('data_nasc'),
                'morada' => $this->input->post('morada'),
                'pais_id' => $this->input->post('pais_id'),
                'provincia_id' => $this->input->post('provincia_id'),
                'municipio_id' => $this->input->post('municipio_id'),
                'concluido' => $concluido,
                'updated_at' => date('Y-m-d H:i:s')
            );
        }

        $this->db->where('id', $this->input->post('id_user'));
        return $this->db->update('user', $data);
    }

    public function conta_user($userID) {
        
        
        $data = array(
            'user_id' => $userID,
            'saldo' => 0.0,
            'created_at' => date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s')
        );
        
        return $this->db->insert('conta', $data);
    }

    public function eliminar($id) {
        $this->db->where('id', $id);
        $this->db->delete('user');
        return true;
    }

    

//     verifica se o nome de utilizador a ser informado já esta a ser usado por outro utilizador
    public function verificarEstadoSorteio($sorteioCOD) {
        $estado ='1';
        $query = $this->db->get_where('sorteio', array('id' => $sorteioCOD, 'estado !=' => $estado));
        $resultado = $query->row_array();
        // Se haver conteúdo, então este sorteio foi concluído ou inativado
//        if (count($resultado) > 0) {
        if ($resultado) {
            return TRUE;
        } else {
            return FALSE;
        }
    }

    public function verifica_email($email) { // Listar sorteios_prémios
        $this->db->select('M.*');
        $this->db->from('user M');
        $this->db->where('M.email', $email);
        $this->db->where('M.id !=', $this->session->userdata('user_session')['id']);
        $query = $this->db->get();
        $resultado = $query->row_array();
//        if (count($resultado) > 0) {
        if ($resultado) {
            return TRUE;
        } else {
            return FALSE;
        }
    }
    public function verifica_BILHETE($bilhete) { // Listar sorteios_prémios
        $this->db->select('M.*');
        $this->db->from('user M');
        $this->db->where('M.bi', $bilhete);
        $this->db->where('M.id !=', $this->session->userdata('user_session')['id']);
        $query = $this->db->get();
        $resultado = $query->row_array();
//        if (count($resultado) > 0) {
        if ($resultado) {
            return TRUE;
        } else {
            return FALSE;
        }
    }
//    public function verifica_BILHETE($bilhete) {
//        $query = $this->db->get_where('user', array('bi' => strtoupper($bilhete)));
//        $resultado = $query->row_array();
//        if (count($resultado) > 0) {
//            return TRUE;
//        } else {
//            return FALSE;
//        }
//    }

    // Verifica o número de identificação B.I ou Passaporte
    public function verifica_telefone($telefone) {
        $query = $this->db->get_where('user', array('telefone' => $telefone));
        $resultado = $query->row_array();
//        if (count($resultado) > 0) {
        if ($resultado) {
            return TRUE;
        } else {
            return FALSE;
        }
    }
    
    

    // Calcular a idade do estudante 26-07-2017
    public function calcular_idade($data_nascimento) {
        if (isset($data_nascimento)) {
            $data_separada = explode("/", $data_nascimento);
            $idade_estudante = date('Y') - $data_separada[0];
            if ($idade_estudante < 18) {
                return TRUE;
            } else {
                return FALSE;
            }
        }
    }

    // verificar a data
    public function verifica_datanascimento($data_nascimento) {
        if (isset($data_nascimento)) {
            if (strtotime($data_nascimento) >= strtotime(date("Y-m-d"))) {
                return true;
            } else {
                return false;
            }
        }
    }

    public function actualizarFotografia($fotografia, $id) {
        $data = array(
            'fotografia' => $fotografia
        );
        $this->db->where('id', $id);
        return $this->db->update('user', $data);
    }

    // Metodo para activar e desactivar utilizador
    public function activarDesactivarUser($id, $status) {
        if ($status == "S") {
            $status = "N"; // caso o status passado por paramatro já for S entao desativa caso contrario desativa
        } else {
            $status = "S";
        }
        $data = array(
            'status' => $status
        );
        $this->db->where('id', $id);
        return $this->db->update('user', $data);
    }

    public function buscar_password($id) {
        if (!is_null($id)) {
            $this->db->select('password');
            $this->db->from('users');
            $this->db->where('id', $id);
            return $this->db->get()->row()->password; // pegamos o a password do utilizador
        }
    }

    public function actualizarpassword($password_nova, $uti_codigo) {
        $password = strrev(sha1(strtoupper(trim($password_nova))));
        $data = array(
            'password' => $password
        );

        $this->db->where('id', $uti_codigo);
        return $this->db->update('user', $data);
    }
    public function actualizaEstadoReferencia($codPayment, $refenciaID) {
        
        $data = array(
            'estado' => '1'
        );

        $this->db->where('cod_payment', $codPayment);
        if($this->db->update('referencia', $data)){
            $this->actualizaEstadoUserSorteio($refenciaID);
        }
         
    }
    public function actualizaEstadoUserSorteio($refenciaID) {
        $data = array(
            'paymentState' => 1
        );

        $this->db->where('referencia_id', $refenciaID);
        return $this->db->update('user_sorteio', $data);
    }
    public function notificacoes($userID) { 
       $notifiStates = 0;
        $this->db->select('n.*, r.userCodeSecre, r.user_id, r.sorteio_id,r.nivel_premio,s.nome as nomeSorteio');
        $this->db->from('notificacao n');
        $this->db->join('resultados r', 'r.id = n.resultado_id');
        $this->db->join('sorteio s', 's.id = r.sorteio_id');
        $this->db->where('n.estado', $notifiStates);
        $this->db->where('r.user_id', $userID);
        $query = $this->db->get();
        return $query->result_array();
    }
    public function verifica_referenciaVPOS($id_reference_wiki) {
        $query = $this->db->get_where('referencia', array('cod_payment' => $id_reference_wiki));
        $resultado = $query->row_array();
//        if (count($resultado) > 0) {
        if ($resultado) {
            return TRUE;
        } else {
            return FALSE;
        }
    }
    public function Eliminar_ReferenciaTransation($id) {
        $this->db->where('id', $id);
        $this->db->delete('referencia');
        return true;
    }
    public function Eliminar_Participacao_user_sorteio($id) {
        $this->db->where('referencia_id', $id);
        $this->db->delete('user_sorteio');
        return true;
    }
    public function salvar_referenciaVPOS($estado,$modoPayment,$amount,$entity_id,$expiry_date,$id_reference_wiki,$number) {
        $data = array(
            'estado'=>$estado,
            'data_criacao' => date('Y-m-d H:i:s'),
            'data_vencimento' => $expiry_date,
            'cod_payment' => $id_reference_wiki,
            'valor' => $amount,
            'reference_number' => $number,
            'entidade' => $entity_id,
            'user_id'=> $this->session->userdata('user_session')['id'],
            'created_at' => date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s')
        );
        
        if ($this->db->insert('referencia', $data)) {
            $this->salvar_user_sorteioVPOS($modoPayment,$amount, $this->db->insert_id());
        }
    }
    public function ActualizarReferenciaTransation( $cod_transation) {
        $data = array(
            'estado' => '1',
        );
        $this->db->where('cod_payment', $cod_transation);
        if ($this->db->update('referencia', $data)){
            return TRUE;
        }else{
            return FALSE;
        }
    }
    public function Actualizar_Participacao_user_sorteio($cod_referencia) {
        $data = array(
            'paymentState' => 1,
        );
        $this->db->where('referencia_id', $cod_referencia);
        if ($this->db->update('user_sorteio', $data)){
            return TRUE;
        }else{
            return FALSE;
        }
    }
    public function buscar_COD_Referencia($cod_payment) {
        if (!is_null($cod_payment)) {
            $this->db->select('id');
            $this->db->from('referencia');
            $this->db->where('cod_payment', $cod_payment);
            return $this->db->get()->row()->id; // pegamos do pagamento
        }
    }
    
    public function buscar_Referencia_By_CODE($cod_payment) {
        if (!is_null($cod_payment)) {
            $this->db->select('cod_payment');
            $this->db->from('referencia');
            $this->db->where('id', $cod_payment);
            return $this->db->get()->row()->cod_payment; // pegamos do pagamento
        }
    }
    
    public function salvar_user_sorteioVPOS($modoPayment, $amount, $id_reference) {
        $data = array(
            'user_id' => $this->session->userdata('user_session')['id'],
            'sorteio_id' => $this->input->post('cod_sorteioID'),
//            'cod_sorteio' => $this->verifica_vezes_do_Sorteio($this->session->userdata('user_session')['id'], $this->input->post('codSecreto_sorteio'), $this->input->post('cod_sorteioID')),
            'cod_sorteio' => $this->NovoCodigoSecreto($this->session->userdata('user_session')['id'],$this->input->post('codSecreto_sorteio'),$this->input->post('cod_sorteioID')),
            'custo' => $amount,
            'referencia_id' => $id_reference,
            'modo_pagamento' => $modoPayment,
            'paymentState' => 0,
            'dia' => date('Y-m-d'),
            'mes' => date('m'),
            'ano' => date('Y'),
            'created_at' => date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s')
        );
        return $this->db->insert('user_sorteio', $data);
    }

    public function salvar_referencia($modoPayment,$amount,$entity_id,$expiry_date,$id_reference_wiki,$number) {
        $data = array(
            'data_criacao' => date('Y-m-d H:i:s'),
            'data_vencimento' => $expiry_date,
            'cod_payment' => $id_reference_wiki,
            'valor' => $amount,
            'reference_number' => $number,
            'entidade' => $entity_id,
            'user_id'=> $this->session->userdata('user_session')['id'],
            'created_at' => date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s')
        );
        
        
        if ($this->db->insert('referencia', $data)) {
            $this->salvar_user_sorteio($modoPayment,$amount, $this->db->insert_id());
        }
    }
    
    public function salvar_user_sorteio($modoPayment,$amount,$id_reference) {
        $data = array(
            'user_id'=> $this->session->userdata('user_session')['id'],
            'sorteio_id' => $this->input->post('cod_sorteioID'),
            'cod_sorteio' => $this->NovoCodigoSecreto($this->session->userdata('user_session')['id'],$this->input->post('codSecreto_sorteio'),$this->input->post('cod_sorteioID')),
            'custo' => $amount,
            'referencia_id' => $id_reference,
            'modo_pagamento' => $modoPayment,
            'dia' => date('Y-m-d'),
            'mes' => date('m'),
            'ano' => date('Y'),
            'created_at' => date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s')
        );
        return $this->db->insert('user_sorteio', $data);
    }
    
    public function NovoCodigoSecreto($userCod, $sorteioCodSecreto, $sorteioID) {
        $valor_inicial = 001;
        $this->db->select_max('C.id');
        $this->db->from('user_sorteio C');
        $this->db->where('C.user_id', $userCod);
        $this->db->where('C.sorteio_id', $sorteioID);
        $resultado = $this->db->get()->row()->id;
        

        if ($resultado == null) {
            return $sorteioCodSecreto . $userCod . $valor_inicial;
        } else {
            return $this->verifica_CriarCodigo_do_Sorteio($resultado) + 1;
        }
    }

    public function verifica_CriarCodigo_do_Sorteio($id) {
        $valor_inicial = 0;
        $this->db->select('C.cod_sorteio');
        $this->db->from('user_sorteio C');
        $this->db->where('C.id', $id);
        $resultado = $this->db->get()->row()->cod_sorteio;
        $rest = substr($resultado, -1);
        if($rest == 9){
            return $resultado.$valor_inicial;
        }else{
            return $resultado;
        }
    }

//    public function verifica_vezes_do_Sorteio($userCod,$sorteioCodSecreto, $sorteioID) {
//        $valor_inicial_novo = 0001;
//        $valor_inicial = 1;
//        $query = $this->db->get_where('user_sorteio', array('user_id' => $userCod, 'sorteio_id' => $sorteioID));
//        $resultado = $query->result_array();
//        $contador = count($resultado);
//        if ($contador > 0) {
//            $valor_final = $valor_inicial + $contador;
//            
//            return $sorteioCodSecreto.$userCod.$valor_final;
//        } else {
//            return $sorteioCodSecreto.$userCod.$valor_inicial_novo;
//        }
//    }
    
    public function listar_user_sorteio($userCod , $sorteioID) { 

//        $this->db->select('C.*,R.reference_number,R.entidade,R.data_vencimento,R.estado');
        $this->db->select('C.*');
        $this->db->from('user_sorteio C');
//        $this->db->join('referencia R', 'R.id = C.referencia_id');
        $this->db->where('C.user_id', $userCod);
        $this->db->where('C.sorteio_id', $sorteioID);
        $this->db->order_by('C.id', 'desc');
        $query = $this->db->get();
        return $query->result_array();
    }
    
     public function listar_ReferenciaUnica($cod_payment) { 

        $this->db->select('R.*');
        $this->db->from('referencia R');
        $this->db->where('R.cod_payment', $cod_payment);
        $query = $this->db->get();
        $resultado = $query->row_array();
        //if (count($resultado) > 0) {
        if ($resultado) {
            return $resultado;
        } else {
            return FALSE;
        }
    }
    public function buscar_ReferenciaWIKIPAY($userCod , $sorteioID) { 

        $this->db->select('C.*,R.reference_number,R.entidade,R.data_vencimento,R.estado, R.cod_payment');
        $this->db->from('user_sorteio C');
        $this->db->join('referencia R', 'R.id = C.referencia_id');
        $this->db->where('C.user_id', $userCod);
        $this->db->where('C.sorteio_id', $sorteioID);
        $this->db->where('C.modo_pagamento', 'R');
        $this->db->where('R.estado', '0');
//        $this->db->where('R.data_vencimento >', date('Y-m-d H:i:s'));
        $this->db->order_by('C.id', 'desc');
        $query = $this->db->get();
        return $query->result_array();
    }
    
    public function listar_one_user_sorteio($id) { 

        $this->db->select('C.*,R.reference_number,R.entidade,R.data_vencimento,R.estado, S.nome as nomeSorteio');
        $this->db->from('user_sorteio C');
        $this->db->join('referencia R', 'R.id = C.referencia_id');
        $this->db->join('sorteio S', 'S.id = C.sorteio_id');
        $this->db->where('C.id', $id);
        $query = $this->db->get();
        return $query->row_array();
    }


    
    
    public function NewVposForGetONE($url) {
//        $url = "https://vpos.ao/api/v1/transactions/1jHbXEbRTIbbwaoJ6w06nLcRG7X";

        $curl = curl_init($url);
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

        $headers = array(
           "Authorization: Bearer 8v73f7ds5jfntk16nfcct056sk0pfmvp",
        );
        curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
        //for debug only!
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);

        $resp = curl_exec($curl);
        curl_close($curl);
        return $resp;

    }
    
    public function newVposForPost($CURL_url,$arrayHeader) {
        
        $curl = curl_init($CURL_url);
        curl_setopt($curl, CURLOPT_URL, $CURL_url);
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_HEADER, true);

        $headers = array(
            "Content-Type: application/json",
            "Idempotency-Key: ",
            "Authorization: Bearer 8v73f7ds5jfntk16nfcct056sk0pfmvp",
        );
        curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($arrayHeader));

//for debug only!
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);

//        $resp = curl_exec($curl);

        curl_exec($curl);

        $resp = curl_multi_getcontent($curl);
        curl_close($curl);
        return $resp;
    }
    
    public function newCurlforPOST( $url, $data) {

        $curl = curl_init($url);
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

        $headers = array(
           "Authorization: 123871130a14c49f7d555305c3cc085c10f5f84d3f0",
           "Content-Type: application/json",
        );
        curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $data);

        //for debug only!
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);

        $resp = curl_exec($curl);
        curl_close($curl);
        
//        return json_decode($resp);
        return $resp;
//        var_dump($resp);
    }
    
    
    public function newCurlforDELETE($url) {

        $curl = curl_init($url);
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

        $headers = array(
           "Authorization: 123871130a14c49f7d555305c3cc085c10f5f84d3f0",
           "Content-Type: application/json",
        );
        curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
//        curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "DELETE");

        //for debug only!
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);

        $resp = curl_exec($curl);
        curl_close($curl);
        
//        return json_decode($resp);
        return $resp;
//        var_dump($resp);
    }
    
    public function GetAllPaymentCURL($url) {
         

        $curl = curl_init($url);
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

        $headers = array(
            "Authorization: 123871130a14c49f7d555305c3cc085c10f5f84d3f0",
            "Content-Type: application/json",
        );
        curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
//for debug only!
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);

        $resp = curl_exec($curl);
        curl_close($curl);
        return json_decode($resp) ;
    }
 

}
