<?php

class Sorteio_premio_m extends CI_Model {

    public function __construct() {
        $this->load->database();
    }

    

    public function guardar_pedidoPagamento($nivelPremio,$cod_Sorteio, $cod_premio, $quatidade, $premio_nome,$premio_foto){
        
        $data = array(
            
            'quantidade' => $quatidade,
            'sorteio_id' => $cod_Sorteio,
            'premio_nome_id' => $cod_premio,
            'nivel_premio' => $nivelPremio,
            'photo_premio' => $premio_foto,
            'nome_premio' => $premio_nome,
            'created_at' => date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s')
        );
        
        return $this->db->insert('premio', $data);
    }
    
    public function notificacoes($userID) { 
       $notifiStates = 0;
        $this->db->select('n.*, r.userCodeSecre, r.user_id, r.sorteio_id,r.nivel_premio,s.nome as nomeSorteio');
        $this->db->from('notificacao n');
        $this->db->join('resultados r', 'r.id = n.resultado_id');
        $this->db->join('sorteio s', 's.id = r.sorteio_id');
        $this->db->where('n.estado', $notifiStates);
        $this->db->where('r.user_id', $userID);
        $query = $this->db->get();
        return $query->result_array();
    }
    
    public function actualizar($fotografia = false) {
        // Fortificar a password de formas a tornar ainda mais segura
        if($fotografia){
            $data = array(
                'tipo_sorteio' => $this->input->post('tipo_sorteio'),
                'nome' => $this->input->post('nome_sorteio'),
                'data_inicio' => $this->input->post('data_inicio'),
                'data_fim' => $this->input->post('data_fim'),
                'custo_sorteio' => $this->input->post('custo_sorteio'),
                'num_participantes' => $this->input->post('num_participantes'),
                'photo' => $fotografia,
                'descricao' => $this->input->post('descricao'),
                'estado' => $this->input->post('estado'),
                'updated_at' => date('Y-m-d H:i:s')
            );
        } else {
            $data = array(
                'tipo_sorteio' => $this->input->post('tipo_sorteio'),
                'nome' => $this->input->post('nome_sorteio'),
                'data_inicio' => $this->input->post('data_inicio'),
                'data_fim' => $this->input->post('data_fim'),
                'custo_sorteio' => $this->input->post('custo_sorteio'),
                'num_participantes' => $this->input->post('num_participantes'),
                'descricao' => $this->input->post('descricao'),
                'estado' => $this->input->post('estado'),
                'updated_at' => date('Y-m-d H:i:s')
            );
        }
        
        $this->db->where('id', $this->input->post('id_sorteio'));
        return $this->db->update('sorteio', $data);
    }
    
    

    public function eliminar($id) {
        $this->db->where('id', $id);
        $this->db->delete('user');
        return true;
    }
    
    public function eliminar_one_premio($id) {
        $this->db->where('id', $id);
        $this->db->delete('premio');
        return true;
    }
    
    public function listar_sorteios_premios($id = false) { // Listar sorteios_prémios
        $this->db->select('P.*');
        $this->db->from('premio P');
        $this->db->where('P.sorteio_id', $id);
        $query = $this->db->get();
        return $query->result_array();
    }
    
    
    
    
    public function listarPremios($id = false) { // Listar sorteios
        if ($id === false) {
            $this->db->select('P.*');
            $this->db->from('premio_mone P');
            $query = $this->db->get();
            return $query->result_array();
        }

        $this->db->select('P.*');
        $this->db->from('premio_mone P');
        $this->db->where('P.id', $id);
        $query = $this->db->get();
        return $query->row_array();
    }
    public function listarSorteio($id = false) { // Listar sorteios
        if ($id === false) {
            $this->db->select('P.*');
            $this->db->from('sorteio P');
            $query = $this->db->get();
            return $query->result_array();
        }

        $this->db->select('P.*');
        $this->db->from('sorteio P');
        $this->db->where('P.id', $id);
        $query = $this->db->get();
        return $query->row_array();
    }
    
    public function verificarPremioInserido($cod_premio,$cod_Sorteio)
    {
        $query = $this->db->get_where('premio', array('sorteio_id' => $cod_Sorteio,'premio_nome_id'=>$cod_premio));
        $resultado = $query->row_array();
//        if (count($resultado) > 0) {
        if ($resultado) {
//            return TRUE;
            return 1;
        } else {
//            return FALSE;
            return 0;
        }
    }
    
    public function verificarClassificaPremio($cod_classificacao,$cod_Sorteio)
    {
        $query = $this->db->get_where('premio', array('sorteio_id' => $cod_Sorteio,'nivel_premio'=>$cod_classificacao));
        $resultado = $query->row_array();
//        if (count($resultado) > 0) {
        if ($resultado) {
            return TRUE;
//            return 1;
        } else {
            return FALSE;
//            return 0;
        }
    }
    
    

}
