<?php

class Relatorios_m extends CI_Model {

    public function __construct() {
        $this->load->database();
    }

    
    public function sorteios() { // Listar sorteios
            $estado='1';
            $this->db->select('*');
            $this->db->from('sorteio');
            $this->db->where('estado =', $estado);
            $this->db->where('data_fim >', date('Y-m-d'));
            $query = $this->db->get();
            return $query->result_array();
    }
    
    public function sorteiosByState($estado) { 
            $this->db->select('*');
            $this->db->from('sorteio');
            $this->db->where('estado =', $estado);
            $query = $this->db->get();
            return $query->result();
    }
    public function listarSorteio($id = false) { // Listar sorteios
        if ($id === false) {
            $this->db->select('P.*');
            $this->db->from('sorteio P');
            $query = $this->db->get();
            return $query->result_array();
        }

        $this->db->select('P.*');
        $this->db->from('sorteio P');
        $this->db->where('P.id', $id);
        $query = $this->db->get();
        return $query->row_array();
    }
    
    public function listarUserOnly($id) { // Listar sorteios
        $this->db->select('U.*');
        $this->db->from('user U');
        $this->db->where('U.id', $id);
        $query = $this->db->get();
        return $query->row_array();
    }
    
    
    public function listar_sorteios_premios($id_sorteio,$nivel_premio) { // Listar sorteios_prémios
        $this->db->select('P.*');
        $this->db->from('premio P');
        $this->db->where('P.sorteio_id', $id_sorteio);
        $this->db->where('P.nivel_premio', $nivel_premio);
        $query = $this->db->get();
        return $query->result_array();
    }
    

    public function eliminar($id) {
        $this->db->where('id', $id);
        $this->db->delete('user');
        return true;
    }

    
    public function notificacoes($userID) { 
       $notifiStates = 0;
        $this->db->select('n.*, r.userCodeSecre, r.user_id, r.sorteio_id,r.nivel_premio,s.nome as nomeSorteio');
        $this->db->from('notificacao n');
        $this->db->join('resultados r', 'r.id = n.resultado_id');
        $this->db->join('sorteio s', 's.id = r.sorteio_id');
        $this->db->where('n.estado', $notifiStates);
        $this->db->where('r.user_id', $userID);
        $query = $this->db->get();
        return $query->result_array();
    }
    
    public function listarNotificaByCode($userID) {
        $this->db->select('n.*, r.userCodeSecre, r.user_id, r.sorteio_id,r.nivel_premio,s.nome as nomeSorteio');
        $this->db->from('notificacao n');
        $this->db->join('resultados r', 'r.id = n.resultado_id');
        $this->db->join('sorteio s', 's.id = r.sorteio_id');
        $this->db->where('n.id', $userID);
        $query = $this->db->get();
        return $query->row_array();
    }
    
    public function totalDInscritos() {
        $this->db->select('count(*) as total_user');
        $this->db->from('user');
        $query = $this->db->get();
        return $query->row()->total_user;
    }
    
    public function totalDRemovidos() {
        $this->db->select('count(*) as total_remove');
        $this->db->from('user_remove');
        $query = $this->db->get();
        return $query->row()->total_remove;
    }
    
    public function BuscarSorteioEscolhidoPorNome($estado,$categoria,$Data,$nome) { 
            $this->db->select('p.*');
            $this->db->from('sorteio p');
            $this->db->where('p.estado ', $estado);
            $this->db->where('p.categoria ', $categoria);
            $this->db->where('p.data_inicio ', $Data);
            $this->db->like('p.nome ', $nome);
            $this->db->order_by('p.id', 'desc');
            $this->db->limit(3);
            $query = $this->db->get();
            return $query->result_array();
    }
    
    public function listarSorteiosPorDataD($codigoSorteio,$data_inicio,$data_fim) {
        if (empty($codigoSorteio) && empty($data_inicio) && empty($data_fim)) {
            return NULL;
        } else {
            $this->db->select('n.*, u.nome as NomeUser, u.telefone, s.nome as NomeSorteio, c.linha1,c.linha2,c.linha3');
            $this->db->from('user_sorteio n');
            $this->db->join('user u', 'u.id = n.user_id');
            $this->db->join('sorteio s', 's.id = n.sorteio_id');
            $this->db->join('cartela_diaria c', 'c.id = n.cod_sorteio');
            $this->db->where('n.paymentState', '1'); // SORTEIO COM ESTADO PAGO
            $this->db->where('n.sorteio_id', $codigoSorteio);
            $this->db->where('n.dia >= ', $data_inicio);
            $this->db->where('n.dia <= ', $data_fim);
            $this->db->order_by('n.id', 'desc');
            $this->db->limit(1000);
            $query = $this->db->get();
            return $query->result_array();
        }
    }
    
    public function listarSorteiosPorDataS($codigoSorteio,$data_inicio,$data_fim) {
        if (empty($codigoSorteio) && empty($data_inicio) && empty($data_fim)) {
            return NULL;
        } else {
            $this->db->select('n.*, u.nome as NomeUser, u.telefone, s.nome as NomeSorteio, c.linha1,c.linha2,c.linha3,c.linha4');
            $this->db->from('user_sorteio n');
            $this->db->join('user u', 'u.id = n.user_id');
            $this->db->join('sorteio s', 's.id = n.sorteio_id');
            $this->db->join('cartela_semanal c', 'c.id = n.cod_sorteio');
            $this->db->where('n.paymentState', '1'); // SORTEIO COM ESTADO PAGO
            $this->db->where('n.sorteio_id', $codigoSorteio);
            $this->db->where('n.dia >= ', $data_inicio);
            $this->db->where('n.dia <= ', $data_fim);
            $this->db->order_by('n.id', 'desc');
            $this->db->limit(1000);
            $query = $this->db->get();
            return $query->result_array();
        }
    }
    
    public function listarSorteiosPorDataM($codigoSorteio,$data_inicio,$data_fim) {
        if (empty($codigoSorteio) && empty($data_inicio) && empty($data_fim)) {
            return NULL;
        } else {
            $this->db->select('n.*, u.nome as NomeUser, u.telefone, s.nome as NomeSorteio, c.linha1,c.linha2,c.linha3,c.linha4,c.linha5');
            $this->db->from('user_sorteio n');
            $this->db->join('user u', 'u.id = n.user_id');
            $this->db->join('sorteio s', 's.id = n.sorteio_id');
            $this->db->join('cartela_mensal c', 'c.id = n.cod_sorteio');
            $this->db->where('n.paymentState', '1'); // SORTEIO COM ESTADO PAGO
            $this->db->where('n.sorteio_id', $codigoSorteio);
            $this->db->where('n.dia >= ', $data_inicio);
            $this->db->where('n.dia <= ', $data_fim);
            $this->db->order_by('n.id', 'desc');
            $this->db->limit(1000);
            $query = $this->db->get();
            return $query->result_array();
        }
    }
    
    
    
    
    public function listarSorteiosPorDataDulimited() {
        if (empty($this->input->post('sorteioID')) && empty($this->input->post('data_inicio')) && empty($this->input->post('data_fim'))) {
            return NULL;
        } else {
            $this->db->select('n.*, u.nome as NomeUser, u.telefone, s.nome as NomeSorteio, c.linha1,c.linha2,c.linha3');
            $this->db->from('user_sorteio n');
            $this->db->join('user u', 'u.id = n.user_id');
            $this->db->join('sorteio s', 's.id = n.sorteio_id');
            $this->db->join('cartela_diaria c', 'c.id = n.cod_sorteio');
            $this->db->where('n.paymentState', '1'); // SORTEIO COM ESTADO PAGO
            $this->db->where('n.sorteio_id', $this->input->post('sorteioID'));
            $this->db->where('n.dia >= ', $this->input->post('data_inicio'));
            $this->db->where('n.dia <= ', $this->input->post('data_fim'));
            $this->db->order_by('n.id', 'desc');
            $this->db->limit(1000);
            $query = $this->db->get();
            return $query->result_array();
        }
    }

    public function listarSorteiosPorDataSulimited() {
        if (empty($this->input->post('sorteioID')) && empty($this->input->post('data_inicio')) && empty($this->input->post('data_fim'))) {
            return NULL;
        } else {
            $this->db->select('n.*, u.nome as NomeUser, u.telefone, s.nome as NomeSorteio, c.linha1,c.linha2,c.linha3,c.linha4');
            $this->db->from('user_sorteio n');
            $this->db->join('user u', 'u.id = n.user_id');
            $this->db->join('sorteio s', 's.id = n.sorteio_id');
            $this->db->join('cartela_semanal c', 'c.id = n.cod_sorteio');
            $this->db->where('n.paymentState', '1'); // SORTEIO COM ESTADO PAGO
            $this->db->where('n.sorteio_id', $this->input->post('sorteioID'));
            $this->db->where('n.dia >= ', $this->input->post('data_inicio'));
            $this->db->where('n.dia <= ', $this->input->post('data_fim'));
            $this->db->order_by('n.id', 'desc');
            $this->db->limit(1000);
            $query = $this->db->get();
            return $query->result_array();
        }
    }

    public function listarSorteiosPorDataMulimited() {
        if (empty($this->input->post('sorteioID')) && empty($this->input->post('data_inicio')) && empty($this->input->post('data_fim'))) {
            return NULL;
        } else {
            $this->db->select('n.*, u.nome as NomeUser, u.telefone, s.nome as NomeSorteio, c.linha1,c.linha2,c.linha3,c.linha4,c.linha5');
            $this->db->from('user_sorteio n');
            $this->db->join('user u', 'u.id = n.user_id');
            $this->db->join('sorteio s', 's.id = n.sorteio_id');
            $this->db->join('cartela_mensal c', 'c.id = n.cod_sorteio');
            $this->db->where('n.paymentState', '1'); // SORTEIO COM ESTADO PAGO
            $this->db->where('n.sorteio_id', $this->input->post('sorteioID'));
            $this->db->where('n.dia >= ', $this->input->post('data_inicio'));
            $this->db->where('n.dia <= ', $this->input->post('data_fim'));
            $this->db->order_by('n.id', 'desc');
            $this->db->limit(1000);
            $query = $this->db->get();
            return $query->result_array();
        }
    }

}
