<?php

class Municipios_m extends CI_Model {

    public function __construct() {
        $this->load->database();
    }

    // SELECT * FROM municipios M, provincias P, paises PA WHERE PA.id=P.paise_id AND P.id=M.provincia_id  and PA.name='Angola'
    public function listar($id = false) { // Listar paises
        if ($id === false) {
            // $this->db->limit(60); 
            $pais = 'Angola';
            $this->db->select('M.id, M.name as municipio, M.created, M.modified, P.name as provincia');
            $this->db->from('municipios M');
            $this->db->join('provincias P', 'P.id=M.provincia_id');
            $this->db->join('paises PA', 'PA.id=P.paise_id');
            $this->db->where('PA.name', $pais);
            $query = $this->db->get();
            return $query->result_array();
        }

        $this->db->select('M.id, M.name as municipio, M.created, M.modified, P.id as cod, P.name as provincia'); // cod=codigo do da província
        $this->db->from('municipios M');
        $this->db->join('provincias P', 'P.id=M.provincia_id');
        $this->db->join('paises PA', 'PA.id=P.paise_id');
        $this->db->where('M.id', $id);
        $query = $this->db->get();
        return $query->row_array();
    }

    public function salvar() {
        $data = array(
            'name' => $this->input->post('name'),
            'provincia_id' => $this->input->post('provincia_id'),
            'created' => date('Y-m-d H:i:s'),
            'modified' => date('Y-m-d H:i:s')
        );
        return $this->db->insert('municipios', $data);
    }

    public function eliminar($id) {
        $this->db->where('id', $id);
        $this->db->delete('municipios');
        return true;
    }

    public function actualizar() {
        $data = array(
            'name' => $this->input->post('name'),
            'provincia_id' => $this->input->post('provincia_id'),
            'created' => date('Y-m-d H:i:s'),
            'modified' => date('Y-m-d H:i:s')
        );
        $this->db->where('id', $this->input->post('id'));
        return $this->db->update('municipios', $data);
    }

    // buscar pais
    public function buscar_pais() {
        $this->db->order_by('name');
        $query = $this->db->get('paises');
        return $query->result_array();
    }
    
    // buscar províncias
    public function buscar_municipios($id) {
        $query = $this->db->get_where('municipios', array('provincia_id' => $id));
        return $query->result();
    }

}
