<?php

class Home_m extends CI_Model {

    public function __construct() {
        $this->load->database();
    }

    public function listarResultadosPorData($categoria,$data = false) {
        $this->db->select('p.*');
        $this->db->from('cartela p');
        $this->db->join('sorteio s', 's.id = p.id_sorteio');
        $this->db->where('s.categoria', $categoria);
        $this->db->where('p.dia', date('Y-m-d', strtotime($data)));
        $query = $this->db->get();
        return $query->row_array();
    }
    
    public function listarCartela($categoria, $data = false) {
        if($data == false)
        {
            $this->db->select('p.*, s.nome');
            $this->db->from('cartela p');
            $this->db->join('sorteio s', 's.id = p.id_sorteio');
            $this->db->where('s.categoria', $categoria);
            $this->db->order_by('p.id', 'desc');
            $this->db->limit(3);
            $query = $this->db->get();
            $resultados = $query->result_array();
            if (count($resultados) == 3) {
                return $resultados;
            } else {
                return [];
            }
        }else{
            $this->db->select('p.*, s.nome');
            $this->db->from('cartela p');
            $this->db->join('sorteio s', 's.id = p.id_sorteio');
            $this->db->where('s.categoria', $categoria);
            $this->db->where('p.dia',  date('Y-m-d', strtotime($data)));
            $query = $this->db->get();
            $resultados = $query->result_array();
            if(count($resultados) == 3){
                return $resultados;
            } else {
                return [];
            }
        }
            
    }
}
