<?php

class Acesso_m extends CI_Model {

    public function __construct() {
        $this->load->database();
    }
    
    public function salvarAcessos() {
        // Fortificar a password de formas a tornar ainda mais segura
        $data = array(
            'nome' => $this->input->post('acessoNome'),
            'dia'=> date('Y-m-d'),
            'created_at' => date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s')
        );
        return $this->db->insert('acesso', $data);
    }
    
    public function salvarAcessosPrevilegios($id_acesso, $id_previlegio) {
        // Fortificar a password de formas a tornar ainda mais segura
        $data = array(
            'id_acesso' => $id_acesso,
            'id_previlegio'=> $id_previlegio
        );
        return $this->db->insert('acesso_previlegios', $data);
    }
    public function verifica_previlegios($id_acesso, $id_previlegio) {
        $query = $this->db->get_where('acesso_previlegios', array('id_acesso' => $id_acesso, 'id_previlegio'=>$id_previlegio));
        $resultado = $query->row_array();
        //if (count($resultado) > 0) {
        if ($resultado) {
            return TRUE;
        } else {
            return FALSE;
        }
    }
    public function ActualizarAcessosPrevilegios($id_acesso, $id_previlegio) {
        // Fortificar a password de formas a tornar ainda mais segura
        $data = array(
            'id_acesso' => $id_acesso,
            'id_previlegio'=> $id_previlegio
        );
        $this->db->where('id_acesso', $id_acesso);
        $this->db->where('id_previlegio', $id_previlegio);
        return $this->db->update('acesso_previlegios', $data);
    }
    
    
    public function anular_previlegios($id_acesso) {
        $this->db->where('id_acesso', $id_acesso);
        $this->db->delete('acesso_previlegios');
        return true;
    }

    public function actualizar() {

        $data = array(
            'nome' => $this->input->post('nome_acesso'),
            'updated_at' => date('Y-m-d H:i:s')
        );

        $this->db->where('id', $this->input->post('cod_acesso'));
        return $this->db->update('acesso', $data);
    }

    public function verifica_posicaoClassificar($posicao) {
        $query = $this->db->get_where('acesso', array('nome' => $posicao));
        $resultado = $query->row_array();
        if ($resultado) {
            return TRUE;
        } else {
            return FALSE;
        }
    }
    
    public function notificacoes($userID) { 
       $notifiStates = 0;
        $this->db->select('n.*, r.userCodeSecre, r.user_id, r.sorteio_id,r.nivel_premio,s.nome as nomeSorteio');
        $this->db->from('notificacao n');
        $this->db->join('resultados r', 'r.id = n.resultado_id');
        $this->db->join('sorteio s', 's.id = r.sorteio_id');
        $this->db->where('n.estado', $notifiStates);
        $this->db->where('r.user_id', $userID);
        $query = $this->db->get();
        return $query->result_array();
    }
    
    
    
    public function listarAcessos($id = false) { // Listar sorteios
        if ($id === false) {
            $this->db->select('c.*');
            $this->db->from('acesso c');
            $query = $this->db->get();
            return $query->result_array();
        }

        $this->db->select('c.*');
        $this->db->from('acesso c');
        $this->db->where('c.id', $id);
        $query = $this->db->get();
        return $query->row_array();
    }
    
    public function listarprevilegios() { 
        $this->db->select('c.*');
        $this->db->from('previlegios c');
        $query = $this->db->get();
        return $query->result_array();
    }
    
    public function listarprevilegiosAcessos($id_acesso) { 
        $this->db->select('c.id_previlegio as previlegio');
        $this->db->from('acesso_previlegios c');
        $this->db->where('c.id_acesso', $id_acesso);
        $query = $this->db->get();
        return $query->result_array();
    }

    public function eliminar($id) {
        $this->db->where('id', $id);
        $this->db->delete('user');
        return true;
    }
    

}
