<?php
class Utilizador extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('Utilizador_m', 'm');
        $this->load->model('Api_m', 'u');
        $this->load->model('Users_m', 's');
    }

    public function buscar() {
//        $data['sorteios'] = $this->m->sorteios();
        $cabecario['submenu'] = 'buscar';
        $cabecario['menu'] = 'utilizador';
        $cabecario['sidebar'] = '';
        $cabecario['notificacoes']= $this->m->notificacoes($this->session->userdata('user_session')['id']);
        $data['utilizador'] = $this->m->buscarUsers();
        
        $this->load->view('template/header',$cabecario);
        $this->load->view('utilizador/buscar',$data);
        $this->load->view('template/footer');
    }
    
    public function visualizar() {
//        $data['sorteios'] = $this->m->sorteios();$this->uri->segment(3)
        $codigo= urldecode(base64_decode(filter_input(INPUT_GET,'r')));
        $cabecario['submenu'] = 'buscar';
        $cabecario['menu'] = 'utilizador';
        $cabecario['sidebar'] = '';
        $cabecario['notificacoes']= $this->m->notificacoes($this->session->userdata('user_session')['id']);
        $data['paises']= $this->m->listarPaises();
        $data['acessos']= $this->m->listarAcessos();
        $data['CodeUserID']=$codigo;
        if($this->m->listarUsers($codigo)){
           $data['users']= $this->m->listarUsers($codigo); 
        } else {
            $data['users']= $this->m->listarUserOnly($codigo);
        }
        $this->load->view('template/header',$cabecario);
        $this->load->view('utilizador/visualizar',$data);
        $this->load->view('template/footer');
    }
    
    public function actualizar() {
        $email = $this->input->post('email');
        $codUser = $this->input->post('id_user');
        $bilhete = $this->input->post('bi');
        $data_nascimento = $this->input->post('data_nasc');
        
        $this->actulalizarSemImagem($email, $bilhete, $data_nascimento,$codUser);
    }
    
    public function actulalizarSemImagem($email,$bilhete,$data_nascimento,$codUser) {
        if ($this->m->verifica_email($email,$codUser)) {
            echo 'existe_email';
        } 
//        elseif ($this->m->verifica_telefone($telefone)) {
//            echo 'existe_telefone';
//        } 
        elseif ($this->m->verifica_BILHETE($bilhete,$codUser)) {
            echo 'existe_bilhete';
        } elseif ($this->m->verifica_datanascimento($data_nascimento)) {
            echo 'dataMaior';
        } elseif ($this->m->calcular_idade($data_nascimento)) {
            echo 'menor_idade';
        } else {
            $this->m->actualizar();
            echo 'actualizou';
        }
    }
    
    // Utilizador Users
    public function users_detalhes() {
        $id_user= urldecode(base64_decode(filter_input(INPUT_GET,'r')));
        $query = $this->u->listarONEUser($id_user);
        $participar = $this->u->sorteioPerUsers($id_user);
        if ($query != null || $participar != null) {
            $cabecario['user'] = $query;
            $cabecario['codUser'] = $id_user;
            $cabecario['participation'] = $participar;
            $cabecario['otherInformation'] = $this->u->listarInformationONEUser($id_user);
            $cabecario['DetalhesContaUser'] = $this->s->listar_DetalhesContaUserID($id_user);
        } else {
            $cabecario['user'] = [];
            $cabecario['participation'] = [];
            $cabecario['otherInformation'] = [];
            $cabecario['DetalhesContaUser'] = [];
        }

        $cabecario['submenu'] = 'buscar';
        $cabecario['menu'] = 'utilizador';
        $cabecario['sidebar'] = '';
         
        $this->load->view('utilizador/users_detalhes',$cabecario);
    }
    
    public function users() {
        $user = $this->input->post('userName') == ''? null:$this->input->post('userName');
        if($user == null){
//            $CURL_url = 'https://localhost/mojogos/Api' .'sorteioUsers';
            $cabecario['users'] = $this->u->listarUsers();
        } else {
            $user = $this->input->post('userName');
            $utilizadores = $this->u->sorteioUsersByUser($user);
            if($utilizadores == null ){
                $cabecario['users'] = $this->u->listarUsers();
            }else{
                $cabecario['users'] = $utilizadores;
            }
        }
        
        $cabecario['submenu'] = 'buscar';
        $cabecario['menu'] = 'utilizador';
        $cabecario['sidebar'] = '';
        $this->load->view('utilizador/buscar_users',$cabecario);
        //$this->load->view('template/footer');
    }
}
