<?php

class Provincias extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('provincias_m', 'm');
    }

    public function index() {
        $data['provincias'] = $this->m->listar();
        $this->load->view('templates/header');
        $this->load->view('provincias/index', $data);
        $this->load->view('templates/footer');
    }

    public function salvar() {
        $data['pais'] = $this->m->buscar_pais();
        $this->form_validation->set_rules('name', 'name', 'required');
        if ($this->form_validation->run() === false) {
            $this->load->view('templates/header');
            $this->load->view('provincias/salvar', $data);
            $this->load->view('templates/footer');
        } else {
            $this->m->salvar();
            redirect('provincias');
        }
    }

    public function eliminar($id) { // Eliminar províncias
        $this->m->eliminar($id);
        redirect('provincias');
    }

    public function editar($id) {
        $data['pais'] = $this->m->buscar_pais(); // ao editar a província pesisamos também do pais
        $data['provincias'] = $this->m->listar($id);
        if (empty($data['provincias'])) {
            show_404();
        }
        $this->load->view('templates/header');
        $this->load->view('provincias/actualizar', $data);
        $this->load->view('templates/footer');
    }

    public function actualizar() {
        $this->m->actualizar();
        redirect('provincias');
    }

    public function listarPaises() {
        $result = $this->m->mostrarPaises();
        //print_r($result);
        echo json_encode($result);
    }

    // metodo que buisca as províncias que estão associados ao pais que é passado pelo ajax
    public function getProvincia() {
        $paise_id = $this->input->post('paise_id');
        $provincias = $this->m->buscar_provincias($paise_id);
        if (count($provincias) > 0) {
            $pro_select_box = '';
            $pro_select_box .= '<option value="">Seleccione uma província</option>';
            foreach ($provincias as $provincia) {
                
                $pro_select_box .='<option value="' . $provincia->id . '">'.$provincia->name. '</option>';
            }
            echo json_encode($pro_select_box);
        }
    }

}
