<?php

class Classificacao extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('Classificacao_m', 'm');
        
    }

    public function novo() {
        $cabecario['submenu'] = 'ClassificarPremios';
        $cabecario['menu'] = 'configurarCazola';
        $cabecario['notificacoes']= $this->m->notificacoes($this->session->userdata('user_session')['id']);
        $cabecario['sidebar'] = '';
        $this->load->view('template/header',$cabecario);
        $this->load->view('classificacao/novo');
        $this->load->view('template/footer');
    }
    public function editar() {
        $id_classific= filter_input(INPUT_GET,'r');
        $codigo = base64_decode($id_classific);
        $cabecario['notificacoes']= $this->m->notificacoes($this->session->userdata('user_session')['id']);
        $data['classific'] = $this->m->listarClassificacao($codigo);
        $cabecario['menu'] = 'configurarCazola';
        $cabecario['submenu'] = 'ClassificarPremios';
        $cabecario['sidebar'] = '';
//        if (empty($data['sorteios'])) {
//            show_404();
//        }
        $this->load->view('template/header',$cabecario);
        $this->load->view('classificacao/editar',$data);
        $this->load->view('template/footer');
    }
    
    public function listar() {
        $cabecario['sidebar'] = '';
        $cabecario['submenu'] = 'ClassificarPremios';
        $cabecario['menu'] = 'configurarCazola';
        $data['Classifipremios'] = $this->m->listarClassificacao();
        $cabecario['notificacoes']= $this->m->notificacoes($this->session->userdata('user_session')['id']);
        $this->load->view('template/header',$cabecario);
        $this->load->view('classificacao/listar',$data);
        $this->load->view('template/footer');
    }
    
    
    public function actualizar() {
        
        if ($this->m->actualizar())
        {
            echo 'actualizou';
        } else {
            echo 'nao_actualizou';
        }
        
    }
    
    public function salvar() {
        if ($this->m->verifica_posicaoClassificar($this->input->post('posicao_premio')) == TRUE) {
            echo 'posicao_existe';
        }elseif($this->m->salvarClassificar()){
            echo 'cadastrou';
        } else {
            echo 'nao_cadastrou';
        }
    }
    

    

// Bloquear um utilizador ou seja activar e desactivar
    public function bloquear($id, $status) {
        $this->m->activarDesactivarUser($id, $status);
        redirect('users');
    }

    

}
