<?php

class Acesso extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('Acesso_m', 'm');
    }

    public function previlegio() {
        $cabecario['submenu'] = '';
        $cabecario['menu'] = 'acessoCazola';
        $prev = [];
        $cabecario['notificacoes']= $this->m->notificacoes($this->session->userdata('user_session')['id']);
        $cabecario['sidebar'] = '';
        $codigo= urldecode(base64_decode(filter_input(INPUT_GET,'r')));
        $data['Acesso'] = $this->m->listarAcessos($codigo);
        $data['previlegios'] = $this->m->listarprevilegios($codigo);
        $acessPrev = $this->m->listarprevilegiosAcessos($codigo);
        foreach ($acessPrev as $value) {
            $prev[] = $value['previlegio'];
        }
        $data['acessoPrevilegios'] = $prev;
        $this->load->view('template/header',$cabecario);
        $this->load->view('acesso/previlegio_acesso',$data);
        $this->load->view('template/footer');
    }
    public function editar() {
        $codigo= urldecode(base64_decode(filter_input(INPUT_GET,'r')));
        $cabecario['notificacoes']= $this->m->notificacoes($this->session->userdata('user_session')['id']);
        $cabecario['menu'] = 'acessoCazola';
        $cabecario['submenu'] = '';
        $cabecario['sidebar'] = '';
        $data['Acesso'] = $this->m->listarAcessos($codigo);
//        if (empty($data['sorteios'])) {
//            show_404();
//        }
        $this->load->view('template/header',$cabecario);
        $this->load->view('acesso/editar',$data);
        $this->load->view('template/footer');
    }
    
    public function listar() {
        $cabecario['sidebar'] = '';
        $cabecario['submenu'] = '';
        $cabecario['menu'] = 'acessoCazola';
        $data['listarAcessos'] = $this->m->listarAcessos();
        $cabecario['notificacoes']= $this->m->notificacoes($this->session->userdata('user_session')['id']);
        $this->load->view('template/header',$cabecario);
        $this->load->view('acesso/listar',$data);
        $this->load->view('template/footer');
    }
    
    
    public function actualizar() {
        
        if ($this->m->verifica_posicaoClassificar($this->input->post('nome_acesso')) == TRUE) {
            $this->session->set_flashdata('AcessoNomeIgual', 'ACESSO DE NOME IGUAL');
        }elseif($this->m->actualizar()){
            $this->session->set_flashdata('AcessoCriado', 'ACESSO ACTUALIZADO COM SUCESSO');
        } else {
            $this->session->set_flashdata('AcessoNomeIgual', 'ERRO EM ACTUALIZADO O ACESSO, TENTE DE NOVO');
        }
        redirect(base_url().'acesso');
        
    }
    
    public function guardar_previlegios() {
        
        // Primeiro remover
        // depois inserir
        $previlegios = $this->input->post('previlegios');
        $id_acesso = $this->input->post('acesso_id');
        // Verifica se algum checkbox foi selecionado
        if (!empty($previlegios)) {
            // Percorre os valores selecionados
            $this->m->anular_previlegios($id_acesso);
            foreach ($previlegios as $previlegio) {
                // Salva cada valor na base de dados (exemplo)
                $this->m->salvarAcessosPrevilegios($id_acesso, $previlegio);
//                if($this->m->verifica_previlegios($id_acesso, $previlegio) == true){
//                    $this->m->ActualizarAcessosPrevilegios($id_acesso, $previlegio);
//                }else{
//                    $this->m->salvarAcessosPrevilegios($id_acesso, $previlegio);
//                }
            }
            $this->session->set_flashdata('AcessoCriado', 'PREVILÉGIOS ADICIONADO COM SUCESSO');
        }elseif(empty($previlegios) && !empty($id_acesso)){
            $this->m->anular_previlegios($id_acesso);
            $this->session->set_flashdata('AcessoCriado', 'PREVILÉGIOS RETIRADOS COM SUCESSO');
        }else{
           
           $this->session->set_flashdata('AcessoNomeIgual', 'PRECISA MARCAR PELO MENOS UM PONTO'); 
        }
        redirect(base_url().'acesso');
    }
    
    public function salvar() {
        if ($this->m->verifica_posicaoClassificar($this->input->post('acessoNome')) == TRUE) {
            $this->session->set_flashdata('AcessoNomeIgual', 'ACESSO DE NOME IGUAL');
        }elseif($this->m->salvarAcessos()){
            $this->session->set_flashdata('AcessoCriado', 'NOVO ACESSO CRIADO COM SUCESSO');
        } else {
            $this->session->set_flashdata('AcessoNomeIgual', 'ERRO EM CRIAR O ACESSO, TENTE DE NOVO');
        }
        redirect(base_url().'acesso');
    }
    

    

}
