<?php

class Vencedor_m extends CI_Model {

    public function __construct() {
        $this->load->database();
    }

    
    public function sorteios() { // Listar sorteios
            $estado='1';
            $this->db->select('*');
            $this->db->from('sorteio');
            $this->db->where('estado =', $estado);
            $this->db->where('data_fim >', date('Y-m-d'));
            $query = $this->db->get();
            return $query->result_array();
    }
    public function listarSorteio($id = false) { // Listar sorteios
        if ($id === false) {
            $this->db->select('P.*');
            $this->db->from('sorteio P');
            $query = $this->db->get();
            return $query->result_array();
        }

        $this->db->select('P.*');
        $this->db->from('sorteio P');
        $this->db->where('P.id', $id);
        $query = $this->db->get();
        return $query->row_array();
    }
    
    public function listarUserOnly($id) { // Listar sorteios
        $this->db->select('U.*');
        $this->db->from('user U');
        $this->db->where('U.id', $id);
        $query = $this->db->get();
        return $query->row_array();
    }
    
    
    public function listar_sorteios_premios($id_sorteio,$nivel_premio) { // Listar sorteios_prémios
        $this->db->select('P.*');
        $this->db->from('premio P');
        $this->db->where('P.sorteio_id', $id_sorteio);
        $this->db->where('P.nivel_premio', $nivel_premio);
        $query = $this->db->get();
        return $query->result_array();
    }
    

    public function eliminar($id) {
        $this->db->where('id', $id);
        $this->db->delete('user');
        return true;
    }

    
    public function notificacoes($userID) { 
       $notifiStates = 0;
        $this->db->select('n.*, r.userCodeSecre, r.user_id, r.sorteio_id,r.nivel_premio,s.nome as nomeSorteio');
        $this->db->from('notificacao n');
        $this->db->join('resultados r', 'r.id = n.resultado_id');
        $this->db->join('sorteio s', 's.id = r.sorteio_id');
        $this->db->where('n.estado', $notifiStates);
        $this->db->where('r.user_id', $userID);
        $query = $this->db->get();
        return $query->result_array();
    }
    
    public function listarNotificaByCode($userID) {
        $this->db->select('n.*, r.userCodeSecre, r.user_id, r.sorteio_id,r.nivel_premio,s.nome as nomeSorteio');
        $this->db->from('notificacao n');
        $this->db->join('resultados r', 'r.id = n.resultado_id');
        $this->db->join('sorteio s', 's.id = r.sorteio_id');
        $this->db->where('n.id', $userID);
        $query = $this->db->get();
        return $query->row_array();
    }
    
    // Metodo para activar e desactivar utilizador
    public function DesactivarNotificacaoVencedor($id) {
        
        $data = array(
            'estado' => 1
        );
        $this->db->where('id', $id);
        return $this->db->update('notificacao', $data);
    }
    
    
    
 

}
