<?php

class Login extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('Login_m', 'm');
    }

    public function index() {
        $_SESSION['userRegister']='';
        $this->load->view('login/index');
    }
    
    public function registar() {
//        $_SESSION['userRegister']='';
        $this->load->view('login/registar');
    }
    
    public function sendMessageRegister($telefone, $message) {
//        $phone = '244931539318';
        $phone = '244'.$telefone;

        $baseurl = jasmin_url();
        $params = '?username=' . jasmin_user();
        $params .= '&password=' . jasmin_password();
        $params .= '&to=' . urlencode($phone);
        $params .= '&content=' . urlencode($message);

        $mensagemUser = file_get_contents($baseurl . $params);
        if ($mensagemUser) {
            return 1;
        }
    }
    public function devolverCodMassage() {
        $min = 100000;
        $max = 999999;
        
        $cod_secreto = random_int($min, $max);
        return $cod_secreto;
    }
    
    public function confirmarTelefone() {
        $data['success'] = 'nada';
        $telefone = $this->input->post('telefone');
        $tecto_extraid1 = $this->input->post('telefone');
        $retorno_telefone = $this->m->verifica_telefone($telefone);
        if ($retorno_telefone === true) {
            $data['success'] = 'telefone'; // Verifique a data de nascimento
        //}else if ($tecto_extraid1{0} != 9 || $tecto_extraid1{1} == 0) {
        } else if (substr($tecto_extraid1, 0, 1) != 9 || substr($tecto_extraid1, 1, 1) == 0) {
            $data['success'] = 'telefoneNumber';
        }else if ($retorno_telefone == false) {
            $cod_secreto = $this->devolverCodMassage();
            $message = "Codigo de acesso ".$cod_secreto;
            
            if($this->sendMessageRegister($telefone, $message)){
                $teste = array(
                    'nome' => $this->input->post('nome'),
                    'telefone' => $telefone,
                    'senha' => $this->input->post('password'),
                    'codigo' => $cod_secreto
                );
                $_SESSION['userRegister'] = $teste;
                $data['success'] = 'logado';
            }
            
        }
        echo json_encode($data);
    }
    
    public function ResetPassword() {
        $telefone = $this->input->post('TelefoneReset');
        $retorno_telefone = $this->m->verifica_telefone($telefone);
        if($retorno_telefone === false){
            $data['response'] = 'telefone';
        }else{
            $cod = substr(uniqid(), 0, 8);
            $codigo = strlen($cod) >= 8 ? $cod : uniqid();
            $message = "Nova senha ".$codigo;
            if($this->sendMessageRegister($telefone, $message)){
               $this->m->ResetPassword($telefone,$codigo);
               $data['response'] = 'senhaResetada'; 
            } else {
               $data['response'] = 'erroReset'; 
            }
        }
        echo json_encode($data);
    }
    
    public function salvar() {
        $codigo_phone = $this->input->post('codigo_phone');
        if ($_SESSION['userRegister']['codigo'] != $codigo_phone) {
            $data['success'] = 'cod_diferente'; // Verifique a data de nascimento
        }else if ($_SESSION['userRegister']['codigo'] == $codigo_phone) {
            $retorno_telefone = $this->m->verifica_telefone($_SESSION['userRegister']['telefone']);
            if($retorno_telefone === true){
                $data['success'] = 'phone_repetido';
            }else{
                $this->m->salvar($_SESSION['userRegister']['senha'], $_SESSION['userRegister']['nome'], $_SESSION['userRegister']['telefone']); // chamamos o metodo salvar para
                $data['success'] = 'logado';
            }
            
//            $data['details'] =$_SESSION['userRegister'];
        }
        echo json_encode($data);
    }
    
    
    
    public function reesendCod() {
//        $messageCod = $this->input->post('messageCod');
            $retorno_telefone = $this->m->verifica_telefone($_SESSION['userRegister']['telefone']);
            if($retorno_telefone === true){
                $data['response'] = 'phone_repetido';
            }else{
                $cod_secreto = $this->devolverCodMassage();
                $_SESSION['userRegister']['codigo'] = $cod_secreto;
                $message = "Novo codigo de acesso " . $cod_secreto;
                if($this->sendMessageRegister($_SESSION['userRegister']['telefone'], $message)){
                   $data['response'] = 'funcionou';
                   
                }
            }
            echo json_encode($data);
    }

    public function entrar() 
    {
        $data = array('success' => false, 'messages' => array());
        $password = strrev(sha1(strtoupper(trim($this->input->post('password')))));
        $utilizador = trim($this->input->post('email'));
        if(!preg_match("/^[a-z0-9_\.\-]+@[a-z0-9_\.\-]*[a-z0-9_\-]+\.[a-z]{2,4}$/i",$this->input->post('email'))){
            $dados = $this->m->pegaLogin_telefone($utilizador);
            $controle =$this->m->login_telefone($utilizador, $password);
            $this->criar_sessao($dados, $controle, $password, $data);
        } else {
            $dados = $this->m->pegaLogin_email($utilizador);
            $controle =$this->m->login_email($utilizador, $password);
            $this->criar_sessao($dados, $controle, $password, $data);
        }
        
    }
    
    public function criar_sessao($dados,$controle,$password,$data) {
        if ($controle) {
            if($dados->estado == "2"){
               $data['success'] = 'bloaqueado'; 
            } elseif ($dados->estado == "3") {
                $data['success'] = 'removido';
            }elseif($dados->estado == "1"){
                $data['success'] = 'entrou';
                $user_login = array(
                    'id' => $dados->id,
                    'nome' => $dados->nome,
                    'username' => $dados->username,
                    'email' => $dados->email,
                    'telefone' => $dados->telefone,
                    'genero' => $dados->genero,
                    'photo' => $dados->photo,
                    'role' => $dados->role,
                    'logado' => true
                );
                $this->session->set_userdata("user_session", $user_login);
                $this->m->actualizarLogin($dados->id);
            }
        } else {
            if (!$dados) {
                $data['success'] = 'naoexiste';
            } elseif ($dados->password != $password) {
                $data['success'] = 'diferente';
            }
        }
        echo json_encode($data);
    }
    
    public function logout(){   
        //Unset user data
        
//          $this->session->set_userdata("session_sorteio","");
          $this->session->set_userdata("user_session","");
        redirect('home');
    }
    

}