<?php

class Sorteio extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('Sorteio_m', 'm');
        if ($this->session->userdata('focus_session') == null) {
            redirect('login/index');
        }
    }

    public function index() {
        //$data = [];
        $cabecario['submenu'] = 'sorteiobegin';
        $cabecario['menu'] = 'sorteioPage';
        $cabecario['sidebar'] = '';
        $cabecario['cabecarioPage']='sorteio/headerPrincipal';
        $cabecario['menuPage']='sorteio/menuPrincipal';
        
        $this->load->view('sorteio/index',$cabecario);
        //$this->load->view('template/footer');
    }
    
    public function users_detalhes() {
        $dados= array(
            'id'=>$this->uri->segment(3)
        );
        $CURL_url = sorteioAPI_url() . 'sorteioONEUsers';
        $cabecario['utilizador'] = json_decode($this->m->POSTSorteioCURL($CURL_url, $dados));
        $cabecario['submenu'] = 'sorteioAllUsers';
        $cabecario['menu'] = 'sorteioUser';
        $cabecario['sidebar'] = '';
        $cabecario['cabecarioPage']='sorteio/headerPrincipal';
        $cabecario['menuPage']='sorteio/menuPrincipal';
         
        $this->load->view('sorteio/users/users_detalhes',$cabecario);
        //$this->load->view('template/footer');
    }
    
    public function users() {
        $user = $this->input->post('userName') == ''? null:$this->input->post('userName');
        if($user == null){
            $CURL_url = sorteioAPI_url() . 'sorteioUsers';
            $cabecario['users'] = json_decode($this->m->BuscarSoretiosUseresForGet($CURL_url));
        } else {
            $dados = array(
                'utilizador' => $this->input->post('userName')
            );
            $CURL_url = sorteioAPI_url() . 'sorteioUsersByUser';
            $utilizadores = json_decode($this->m->POSTSorteioCURL($CURL_url, $dados));
            if($utilizadores == null ){
                $cabecario['users'] = (object) [];
            }else{
                $cabecario['users'] = $utilizadores;
            }
            
        }
        
        $cabecario['submenu'] = 'sorteioAllUsers';
        $cabecario['menu'] = 'sorteioUser';
        $cabecario['sidebar'] = '';
        $cabecario['cabecarioPage']='sorteio/headerPrincipal';
        $cabecario['menuPage']='sorteio/menuPrincipal';
        $this->load->view('sorteio/users/buscar_users',$cabecario);
        //$this->load->view('template/footer');
    }
    
    public function Allsorteios() {
        
        $user = $this->input->post('sorteioName') == ''? FALSE:$this->input->post('sorteioName');
        if($user === FALSE){
            $CURL_url = sorteioAPI_url() . 'listarAllSorteios';
            $utilizadores = json_decode($this->m->BuscarSoretiosUseresForGet($CURL_url));
            if ($utilizadores == null) {
                $cabecario['allSorteios'] = (object) [];
            } else {
                $cabecario['allSorteios'] = $utilizadores;
            }
        } else {
            $dados = array(
                'utilizador' => $user
            );
            $CURL_url = sorteioAPI_url() . 'listarAllSorteios';
            $utilizadores = json_decode($this->m->POSTSorteioCURL($CURL_url, $dados));
            if($utilizadores == null ){
                $cabecario['allSorteios'] = (object) [];
            }else{
                $cabecario['allSorteios'] = $utilizadores;
            }
            
        }
        
        $cabecario['submenu'] = 'sorteioAllActives';
        $cabecario['menu'] = 'sorteioDouble';
        $cabecario['sidebar'] = '';
        $cabecario['cabecarioPage']='sorteio/headerPrincipal';
        $cabecario['menuPage']='sorteio/menuPrincipal';
        $this->load->view('sorteio/sorteios/buscar_sorteios',$cabecario);
        //$this->load->view('template/footer');
    }
    
    
    
    public function cashIN() {
        
          // Codigo para enviar mensagem Totalmente funcional
        
//        $baseurl = 'http://102.216.169.150:1401/send';
//
//        $params = '?username=sorteios';
//        $params .= '&password=Ang0l@21';
//        $params .= '&to='.urlencode('244931539318');
//        $params .= '&content='.urlencode('Hello world Adilson Figueira!');
//
//        $cabecario['responseJasmin'] = file_get_contents($baseurl . $params);




        $sorteioState = $this->input->post('sorteioState') == NULL ? '': $this->input->post('sorteioState');
        $inicioDate =   $this->input->post('data_inicio') == null  ? '': $this->input->post('data_inicio');
        $fimDate =      $this->input->post('data_fim') == null     ? '': $this->input->post('data_fim');
        if ( empty($sorteioState) && empty($inicioDate) && empty($fimDate)) {
            
        } else {
            $dados = array(
                'sorteioState' => $sorteioState,
                'data_inicio' => $inicioDate,
                'data_fim' => $fimDate
            );
            $CURL_url = sorteioAPI_url() . 'cashINFocus';
            $utilizadores = json_decode($this->m->POSTSorteioCURL($CURL_url, $dados));
            $cabecario['cashIN'] = $utilizadores;
            $cabecario['tableHead'] = array(
                'sorteioState' => $sorteioState,
                'DataInicio' => $inicioDate,
                'DataFim' => $fimDate
            );
        }

        $cabecario['submenu'] = 'consultarCash';
        $cabecario['menu'] = 'sorteioCashIN';
        $cabecario['sidebar'] = '';
        $cabecario['cabecarioPage'] = 'sorteio/headerPrincipal';
        $cabecario['menuPage'] = 'sorteio/menuPrincipal';
        $this->load->view('sorteio/cashIN/RelatorioEntradas', $cabecario);
        
    }

    public function Sdetalhes() {
        $dados= array(
            'id'=>$this->uri->segment(3)
        );
        $CURL_url = sorteioAPI_url() . 'listarONESorteioFocus';
        $cabecario['sorteioONE'] = json_decode($this->m->POSTSorteioCURL($CURL_url, $dados));
        $cabecario['submenu'] = 'sorteioAllActives';
        $cabecario['menu'] = 'sorteioDouble';
        $cabecario['sidebar'] = '';
        $cabecario['cabecarioPage']='sorteio/headerPrincipal';
        $cabecario['menuPage']='sorteio/menuPrincipal';
         
        $this->load->view('sorteio/sorteios/sorteio_detalhes',$cabecario);
        //$this->load->view('template/footer');
    }
    public function sorteioPerMostrarGrafico() {
        $ver = $this->input->post('mostrarYear');
        if($ver == 'show'){
            echo json_encode('mostrarGrafico') ;
        }
        
    }
    public function sorteioPerMonthYear() {
        
        $dados = array(
            'mes' => $this->input->post('dataMonth'),
            'ano' => date('Y')
        );
        $CURL_url = sorteioAPI_url() . 'sorteioMonth';
        $utilizadores = json_decode($this->m->POSTSorteioCURL($CURL_url, $dados));
        echo intval($utilizadores->sorteios);
    }
    
    public function sorteioPerDayWeek() {
        $dados = array(
            'data' => $this->input->post('dataDay')
        );
        $CURL_url = sorteioAPI_url() . 'sorteioDayWeek';
        $utilizadores = json_decode($this->m->POSTSorteioCURL($CURL_url, $dados));
        echo intval($utilizadores->sorteios);
    }
    
    public function ParticipacaoSemanalMes() {
        
        $dados = array(
            'diaInicio' => $this->input->post('diaInicio'),
            'diaFim' => $this->input->post('diaFim')
            );
        $CURL_url = sorteioAPI_url() . 'sorteioSemanalMes';
        $utilizadores = json_decode($this->m->POSTSorteioCURL($CURL_url, $dados));
        echo intval($utilizadores->sorteios);
    }

}