<?php

class Login extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('Login_m', 'm');
    }

    public function index() {
        if ($this->session->userdata('focus_session') !== null) {
            redirect('home');
        }
        $this->load->view('login/login');
    }
    
    
    public function entrar() 
    {
        $data = array('success' => false, 'messages' => array());
        $password = strrev(sha1(strtoupper(trim($this->input->post('password')))));
        $utilizador = trim($this->input->post('email'));
        if(!preg_match("/^[a-z0-9_\.\-]+@[a-z0-9_\.\-]*[a-z0-9_\-]+\.[a-z]{2,4}$/i",$this->input->post('email'))){
            $dados = $this->m->pegaLogin_telefone($utilizador);
            $controle =$this->m->login_telefone($utilizador, $password);
            $this->criar_sessao($dados, $controle, $password, $data);
        } else {
            $dados = $this->m->pegaLogin_email($utilizador);
            $controle =$this->m->login_email($utilizador, $password);
            $this->criar_sessao($dados, $controle, $password, $data);
        }
        
        
    }
    
    public function criar_sessao($dados,$controle,$password,$data) {
        if ($controle) {
            $data['success'] = 'entrou';
            $user_login = array(
                'id' => $dados->id,
                'nome' => $dados->nome,
                'username' => $dados->username,
                'email' => $dados->email,
                'telefone' => $dados->telefone,
                'genero' => $dados->genero,
                'photo' => $dados->photo,
                'role' => $dados->role,
                'logado' => true
            );
            $this->session->set_userdata("focus_session", $user_login);
        } else {
            if (!$dados) {
                $data['success'] = 'naoexiste';
            } elseif ($dados->password != $password) {
                $data['success'] = 'diferente';
            }
        }
        echo json_encode($data);
    }
    
    public function logout(){   
        //Unset user data
        
//          $this->session->set_userdata("session_sorteio","");
        $this->session->set_userdata("focus_session",null);
        redirect('home');
    }
    

}