<?php
//    MyDMS. Document Management System
//    Copyright (C) 2002-2005  Markus Westphal
//    Copyright (C) 2006-2008 Malcolm Cowe
//    Copyright (C) 2010 Matteo Lucarelli
//    Copyright (C) 2011-2013 Uwe Steinmann
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//    Translators: Admin (1175), jeromerobert (50), lonnnew (9), Oudiceval (1171)

$text = array(
'2_factor_auth' => 'Authentification forte',
'2_factor_auth_code' => '',
'2_factor_auth_current_secret' => 'Clé secrète actuelle',
'2_factor_auth_info' => 'Ce système requiert une authentification à deux facteurs. Cela nécessite l’installation de Google Authenticator sur votre téléphone mobile. Ci-dessous sont visibles deux QR codes. Celui de droite correspond à votre clé secrète actuelle. Celui de gauche permet de définir une nouvelle clé secrète. Lorsque vous définissez une nouvelle clé secrète, assurez-vous de la scanner avec Google Authenticator.',
'2_factor_auth_new_secret' => 'Nouvelle clé secrète',
'2_factor_auth_qrcode' => '',
'2_factor_auth_rm_secret_no_confirm' => '',
'2_factor_auth_secret' => 'Clé secrète',
'2_factor_auth_test_failed' => '',
'2_factor_auth_test_succeeded' => '',
'2_factor_rm_secret' => '',
'2_factor_rm_secret_confirm' => '',
'abbr_day' => 'j',
'abbr_hour' => 'h',
'abbr_minute' => 'min',
'abbr_month' => 'm.',
'abbr_second' => 's',
'abbr_week' => 'sem',
'abbr_year' => 'an.',
'accept' => 'Accepter',
'access_control' => 'Contrôle d’accès',
'access_control_is_off' => 'Le contrôle d’accès avancé est désactivé',
'access_denied' => 'Accès refusé.',
'access_inheritance' => 'Héritage d\'accès',
'access_mode' => 'Droits d\'accès',
'access_mode_all' => 'Contrôle total',
'access_mode_none' => 'Aucun accès',
'access_mode_read' => 'Lecture',
'access_mode_readwrite' => 'Lecture-écriture',
'according_settings' => 'Paramètres en fonction',
'action' => 'Action',
'actions' => 'Actions',
'action_approve' => 'Approuver',
'action_complete' => 'Compléter',
'action_is_complete' => 'Complet',
'action_is_not_complete' => 'Non complet',
'action_reject' => 'Rejeter',
'action_review' => 'Vérifier',
'action_revise' => 'Réviser',
'add' => 'Ajouter',
'add_approval' => 'Confirmer l’approbation',
'add_attrdefgroup' => 'Ajouter un nouveau groupe d’attributs',
'add_document' => 'Ajouter un document',
'add_document_link' => 'Ajouter un lien',
'add_document_notify' => 'Affecter les notifications',
'add_doc_reviewer_approver_warning' => 'N.B. Les documents sont automatiquement marqués comme publiés s’il n’y a pas d’examinateur ou d’approbateur désigné.',
'add_doc_workflow_warning' => 'N.B. Les documents sont automatiquement marqués comme publiés si aucun workflow est désigné.',
'add_event' => 'Ajouter un événement',
'add_group' => 'Ajouter un groupe',
'add_member' => 'Ajouter un membre',
'add_multiple_documents' => 'Ajouter plusieurs documents',
'add_multiple_files' => 'Ajouter plusieurs fichiers (le nom du fichier servira de nom de document)',
'add_receipt' => 'Confirmer la réception',
'add_review' => 'Confirmer la vérification',
'add_revision' => 'Confirmer l’approbation',
'add_role' => 'Ajouter un rôle',
'add_subfolder' => 'Ajouter un sous-dossier',
'add_task' => 'Ajouter une nouvelle tâche pour cette classe',
'add_to_clipboard' => 'Ajouter au presse-papier',
'add_to_transmittal' => 'Ajouter à la transmission',
'add_transmittal' => 'Ajouter une transmission',
'add_user' => 'Ajouter un utilisateur',
'add_user_to_group' => 'Ajouter un utilisateur au groupe',
'add_workflow' => 'Ajouter un workflow',
'add_workflow_action' => 'Ajouter une nouvelle action de workflow',
'add_workflow_state' => 'Ajouter un nouvel état de workflow',
'admin' => 'Administrateur',
'admin_tools' => 'Outils d\'administration',
'all' => 'Tous',
'all_categories' => 'Toutes les catégories',
'all_documents' => 'Tous les documents',
'all_pages' => 'Tous',
'all_users' => 'Tous les utilisateurs',
'already_subscribed' => 'Déjà abonné',
'and' => 'et',
'any_value_set' => '',
'apikey' => 'Clé API',
'apply' => 'Appliquer',
'approvals_accepted' => '[no_approvals] approbations déjà confirmées',
'approvals_accepted_latest' => '(dont [no_approvals] dans la dernière version)',
'approvals_and_reviews_accepted' => '[no_approvals] approbations et [no_reviews] vérifications déjà confirmées',
'approvals_and_reviews_not_touched' => '[no_approvals] approbations et [no_reviews] vérifications non amorcées',
'approvals_and_reviews_rejected' => '[no_approvals] approbations et [no_reviews] vérifications déjà rejetées',
'approvals_not_touched' => '[no_approvals] approbations non amorcées',
'approvals_not_touched_latest' => '(dont [no_approvals] dans la dernière version)',
'approvals_rejected' => '[no_approvals] approbations déjà rejetées',
'approvals_rejected_latest' => '(dont [no_approvals] dans la dernière version)',
'approvals_without_group' => 'Approbations sans groupe',
'approvals_without_user' => 'Approbations sans utilisateur',
'approval_deletion_email' => 'Demande d\'approbation supprimée',
'approval_deletion_email_body' => 'Demande d\'approbation supprimée
Document : [name]
Version : [version]
Dossier parent : [folder_path]
Utilisateur : [username]
URL : [url]',
'approval_deletion_email_body_html' => '<p>Demande d’approbation supprimée</p>

<p>Document : [name]<br />
Version : [version]<br />
Dossier parent : [folder_path]<br />
Utilisateur : [username]<br />
URL : [url]</p>',
'approval_deletion_email_subject' => '[sitename] : [name] - Requête d\'approbation supprimée',
'approval_file' => 'Fichier',
'approval_group' => 'Groupe d\'approbation',
'approval_log' => 'Journal des approbations',
'approval_request_email' => 'Demande d\'approbation',
'approval_request_email_body' => 'Demande d\'approbation
Document: [name]
Version: [version]
Dossier parent: [folder_path]
Utilisateur: [username]
URL: [url]',
'approval_request_email_body_html' => '',
'approval_request_email_subject' => '[sitename] : [name] - Demande d\'approbation',
'approval_status' => 'Statut d\'approbation',
'approval_submit_email' => 'Approbation d\'un document',
'approval_submit_email_body' => 'Approbation d\'un document
Document : [name]
Version : [version]
Dossier parent : [folder_path]
Statut : [status]
Commentaire : [comment]
Utilisateur : [username]
URL : [url]',
'approval_submit_email_body_html' => '<p>Approbation d’un document</p>

<p>Document : [name]<br />
Version : [version]<br />
Dossier parent : [folder_path]<br />
Statut : [status]<br />
Commentaire : [comment]<br />
Utilisateur : [username]<br />
URL : [url]</p>',
'approval_submit_email_subject' => '[sitename] : [name] - Approbation soumise',
'approval_summary' => 'Récapitulatif approbation',
'approval_update_failed' => 'Erreur de la mise à jour du statut d\'approbation. Echec de la mise à jour.',
'approvers' => 'Approbateurs',
'approver_already_assigned' => 'L’utilisateur est déjà affecté comme approbateur.',
'approver_already_removed' => 'L’approbateur a déjà été retiré du processus d’approbation ou a déjà soumis l’approbation.',
'april' => 'Avril',
'archive' => 'Archive',
'archive_creation' => 'Créer une archive',
'archive_creation_warning' => 'Avec cette fonction, vous pouvez créer une archive contenant les fichiers de tous les dossiers DMS. Après la création, l\'archive sera sauvegardée dans le dossier de données de votre serveur.<br> AVERTISSEMENT: Une archive créée ainsi sera inutilisable en tant que sauvegarde du serveur.',
'ar_EG' => 'Arabe – Égypte',
'assign_approvers' => 'Affecter les approbateurs',
'assign_recipients' => 'Affecter les destinataires',
'assign_reviewers' => 'Affecter les examinateurs',
'assign_user_property_to' => 'Transférer les propriétés de l\'utilisateur à',
'assumed_released' => 'Supposé publié',
'attrdefgroup_management' => 'Gestion des groupes d’attributs',
'attrdefgrp_show_detail' => 'Détails',
'attrdefgrp_show_list' => 'Liste',
'attrdefgrp_show_search' => 'Recherche',
'attrdefgrp_show_searchlist' => 'Résultats de recherche',
'attrdef_exists' => 'La définition d\'attribut existe déjà',
'attrdef_info' => 'Information',
'attrdef_invalid_regex' => 'L\'expression régulière n\'est pas valide',
'attrdef_in_use' => 'La définition d\'attribut est en cours d\'utilisation',
'attrdef_management' => 'Gestion des définitions d\'attributs',
'attrdef_maxvalues' => 'Nombre maximum de valeurs',
'attrdef_minvalues' => 'Nombre minimum de valeurs',
'attrdef_minvalues_help' => 'Nombre minimum de valeurs. Définir à 1 si l’attribut doit être défini.',
'attrdef_min_greater_max' => 'Le nombre minimum de valeurs est supérieur au maximum',
'attrdef_multiple' => 'Permettre des valeurs multiples',
'attrdef_multiple_but_doc_or_folder' => '',
'attrdef_multiple_needs_valueset' => 'Une définition d’attribut à valeurs multiples nécessite un ensemble de valeurs.',
'attrdef_must_be_multiple' => 'L\'attribut a plusieurs valeurs mais n\'est pas définit comme possédant des valeurs multiples',
'attrdef_name' => 'Nom',
'attrdef_noname' => 'Le nom d\'attribut est manquant',
'attrdef_objtype' => 'Type objet',
'attrdef_regex' => 'Expression régulière',
'attrdef_regex_help' => 'Expression régulière qui doit correspondre avec la valeur de l’attribut de type chaîne.',
'attrdef_type' => 'Type',
'attrdef_type_boolean' => 'Valeur booléenne',
'attrdef_type_date' => 'Date',
'attrdef_type_document' => 'Document',
'attrdef_type_email' => 'E-mail',
'attrdef_type_float' => 'Décimal',
'attrdef_type_folder' => 'Dossier',
'attrdef_type_group' => 'Groupe',
'attrdef_type_int' => 'Entier',
'attrdef_type_string' => 'Chaîne',
'attrdef_type_url' => 'URL',
'attrdef_type_user' => 'Utilisateur',
'attrdef_valueset' => 'Ensemble de valeurs',
'attrdef_valueset_help' => 'Liste de valeurs séparées par un caractère arbitraire, qui doit également être le premier et le dernier caractère de la chaîne. Ex : #un#deux#trois#',
'attributes' => 'Attributs',
'attribute_changed_email_body' => 'Attribut modifié

Document : [name]
Version : [version]
Attribut : [attribute_name]
Ancienne valeur : [attribute_old_value]
Nouvelle valeur : [attribute_new_value]
Dossier parent : [folder_path]
Utilisateur : [username]
URL : [url]',
'attribute_changed_email_body_html' => '<p>Attribut modifié</p>

<p>Document : [name]<br />
Version : [version]<br />
Attribut : [attribute_name]<br />
Ancienne valeur : [attribute_old_value]<br />
Nouvelle valeur: [attribute_new_value]<br />
Dossier parent : [folder_path]<br />
Utilisateur : [username]<br />
URL : [url]</p>',
'attribute_changed_email_subject' => '[sitename] : [name] - Attribut modifié',
'attribute_count' => 'Nombre d\'utilisations',
'attribute_value' => 'Valeur de l\'attribut',
'attribute_value_not_in_valueset' => 'Valeur en dehors de l’ensemble',
'attr_malformed_boolean' => 'La valeur « [value] » de l’attribut « [attrname] » n’est pas un booléen valide.',
'attr_malformed_date' => 'La valeur « [value] » de l’attribut « [attrname] » n’est pas une date valide.',
'attr_malformed_email' => 'La valeur « [value] » de l’attribut « [attrname] » n’est pas une adresse e-mail valide.',
'attr_malformed_float' => 'La valeur « [value] » de l’attribut « [attrname] » n’est pas un nombre valide.',
'attr_malformed_int' => 'La valeur « [value] » de l’attribut « [attrname] » n’est pas un nombre entier.',
'attr_malformed_url' => 'La valeur « [value] » de l’attribut « [attrname] » n’est pas une URL valide.',
'attr_max_values' => 'Le nombre maximum de valeurs pour l\'attribut [attrname]  est dépassé',
'attr_min_values' => 'Le nombre minimum de valeurs pour l\'attribut [attrname]  n\'est pas atteint',
'attr_not_in_valueset' => 'La valeur « [value] » de l’attribut « [attrname] » ne fait pas partie des valeurs définies.',
'attr_no_regex_match' => 'La valeur de l\'attribut ne correspond pas à l\'expression régulière.',
'attr_validation_error' => 'La valeur « [value] » de l’attribut « [attrname] » est invalide.',
'at_least_n_users_of_group' => 'Au moins [number_of_users] utilisateurs de [group]',
'august' => 'Août',
'authentication' => 'Authentification',
'authentication_failed' => 'Échec de l’authentification',
'author' => 'Auteur',
'automatic_status_update' => 'Changement de statut automatique',
'back' => 'Retour',
'backup_list' => 'Liste de sauvegardes existantes',
'backup_log_management' => 'Sauvegarde/Log',
'backup_remove' => 'Supprimer le fichier de sauvegarde',
'backup_tools' => 'Outils de sauvegarde',
'batch_add_approver' => '',
'batch_add_approver_msg' => '',
'batch_add_category_msg' => '',
'batch_add_reviewer' => '',
'batch_add_reviewer_msg' => '',
'batch_change_category' => '',
'batch_change_owner' => '',
'batch_export' => '',
'batch_new_owner_msg' => '',
'batch_operation' => '',
'batch_operation_result' => '',
'batch_remove_category' => '',
'batch_remove_category_msg' => '',
'between' => 'entre',
'bg_BG' => 'Bulgare',
'browse' => 'Parcourir',
'calendar' => 'Agenda',
'calendar_events_mail_subject' => '',
'calendar_week' => 'Semaine',
'cancel' => 'Annuler',
'cancel_checkout' => 'Annuler la vérification',
'cancel_checkout_document' => '',
'cancel_checkout_warning' => 'La vérification peut être annulée même si des modifications ont été apportées au fichier. Dans ce cas, le fichier sera supprimé de l\'espace de vérification et votre modification sera perdue.',
'cannot_assign_invalid_state' => 'Impossible de modifier un document obsolète ou rejeté',
'cannot_change_final_states' => 'Attention : Vous ne pouvez pas modifier l’état d\'un document rejeté, expiré ou en attente de vérification ou d’approbation.',
'cannot_delete_user' => 'Impossible de supprimer l’utilisateur',
'cannot_delete_yourself' => 'Vous ne pouvez pas vous supprimer',
'cannot_move_root' => 'Erreur : Impossible de déplacer le dossier racine.',
'cannot_retrieve_approval_snapshot' => 'Impossible de retrouver l\'instantané de statut d\'approbation pour cette version de document.',
'cannot_retrieve_review_snapshot' => 'Impossible de récupérer l’instantané du statut de vérification pour cette version du document.',
'cannot_revapp_expired_docs' => 'Le document ne peut plus être vérifié ou approuvé car il a expiré.',
'cannot_rm_root' => 'Erreur : Dossier racine ineffaçable.',
'cannot_transfer_your_objects' => 'Vous ne pouvez pas transférer vos propres objets.',
'categories' => 'Catégories',
'categories_loading' => 'Veuillez patienter pendant le chargement de la liste des catégories…',
'category' => 'Catégorie',
'category_exists' => 'Catégorie déjà existante.',
'category_filter' => 'Uniquement les catégories',
'category_info' => 'Information',
'category_in_use' => 'Cette catégorie est en cours d\'utilisation par des documents.',
'category_noname' => 'Aucun nom de catégorie fourni.',
'ca_ES' => 'Catalan',
'changelog_loading' => 'Veuillez patienter pendant le chargement du journal des modifications…',
'change_assignments' => 'Changer les affectations',
'change_password' => 'Changer de mot de passe',
'change_password_message' => 'Votre mot de passe a été changé.',
'change_recipients' => 'Définir les destinataires',
'change_revisors' => 'Définir les réviseurs',
'change_status' => 'Modifier le statut',
'charts' => 'Graphiques',
'chart_docsaccumulated_title' => 'Nombre de documents',
'chart_docspercategory_title' => 'Documents par catégorie',
'chart_docspermimetype_title' => 'Documents par type',
'chart_docspermonth_title' => 'Nouveaux documents par mois',
'chart_docsperstatus_title' => 'Documents par statut',
'chart_docsperuser_title' => 'Documents par utilisateur',
'chart_foldersperuser_title' => 'Dossiers par utilisateur',
'chart_selection' => 'Sélectionner un graphique',
'chart_sizepermonth_title' => '',
'chart_sizeperuser_title' => 'Volume par utilisateur',
'checkedout_file_has_different_version' => 'La version bloquée n’est pas identique à la version actuelle. Le déblocage ne modifiera pas le document.',
'checkedout_file_has_disappeared' => 'Le fichier du document bloqué n’existe plus. Le déblocage est impossible.',
'checkedout_file_is_unchanged' => 'Le fichier du document bloqué est inchangé. Le déblocage n’est pas possible. Si vous ne souhaitez pas apporter de modifications, désactivez le blocage.',
'checkin_document' => 'Débloquer (check-in)',
'checkoutpath_does_not_exist' => 'Le chemin de vérification n’existe pas',
'checkout_cancel_confirm' => 'Veuillez confirmer l’annulation de la vérification.',
'checkout_document' => 'Bloquer (check-out)',
'checkout_is_disabled' => 'Le blocage (check-out) de documents est désactivé dans la configuration.',
'check_directory_layout' => '',
'check_failed' => '',
'check_notification_filter' => '',
'check_passed' => '',
'check_secure_installation' => '',
'choose_attrdef' => 'Choisissez une définition d\'attribut',
'choose_attrdefgroup' => 'Choisir un groupe d’attributs',
'choose_category' => 'Sélectionnez une catégorie',
'choose_group' => 'Choisir un groupe',
'choose_link_type' => '',
'choose_role' => 'Choisir un rôle',
'choose_target_category' => 'Choisir une catégorie',
'choose_target_document' => 'Choisir un document',
'choose_target_file' => 'Choisir un fichier',
'choose_target_folder' => 'Choisir un dossier cible',
'choose_user' => 'Choisir un utilisateur',
'choose_workflow' => 'Choisir un workflow',
'choose_workflow_action' => 'Choisir une action de workflow',
'choose_workflow_state' => 'Choisir un état de workflow',
'class_finfo_missing' => 'La classe finfo est requise lors du dépôt de nouveaux fichiers pour déterminer le type MIME.',
'class_name' => 'Nom de classe',
'clear_cache' => 'Vider le cache',
'clear_clipboard' => 'Vider le presse-papier',
'clear_password' => 'Sans mot de passe',
'click_to_expand_filter_results' => '',
'clipboard' => 'Presse-papier',
'close' => 'Fermer',
'color' => 'Couleur',
'command' => 'Commande',
'comment' => 'Commentaire',
'comment_changed_email' => 'Commentaire lors du changement d\'adresse mail',
'comment_for_current_version' => 'Commentaires pour la version actuelle',
'configure_extension' => 'Configurer l’extension',
'confirm_add_approver' => '',
'confirm_add_reviewer' => '',
'confirm_change_category' => '',
'confirm_change_owner' => '',
'confirm_clear_cache' => 'Voulez-vous vraiment vider le cache ? Cela va effacer toutes les miniatures.',
'confirm_create_fulltext_index' => 'Oui, je souhaite recréer l\'index de recherche plein texte !',
'confirm_move_document' => 'Veuillez confirmer le déplacement du document.',
'confirm_move_folder' => 'Veuillez confirmer le déplacement du dossier.',
'confirm_pwd' => 'Confirmer le mot de passe',
'confirm_rm_attr_value' => 'Voulez-vous vraiment supprimer la valeur d’attribut ?',
'confirm_rm_backup' => 'Voulez-vous vraiment supprimer le fichier « [arkname] » ?<br>Attention : Cette action est irréversible.',
'confirm_rm_document' => 'Voulez-vous vraiment supprimer le document « [documentname] » ?<br>Attention : cette action est irréversible.',
'confirm_rm_dump' => 'Voulez-vous vraiment supprimer le fichier « [dumpname] » ?<br>Attention : Cette action est irréversible.',
'confirm_rm_event' => 'Voulez-vous vraiment supprimer l’événement « [name] » ?<br>Attention : Cette action est irréversible.',
'confirm_rm_file' => 'Voulez-vous vraiment supprimer le fichier « [name] » du document « [documentname] » ?<br>Attention : Cette action est irréversible.',
'confirm_rm_folder' => 'Voulez-vous vraiment supprimer « [foldername] » et son contenu ?<br>Attention : Cette action est irréversible.',
'confirm_rm_folder_files' => 'Voulez-vous vraiment supprimer tous les fichiers du dossier « [foldername] » et ses sous-dossiers ?<br>Attention : Cette action est irréversible.',
'confirm_rm_group' => 'Voulez-vous vraiment supprimer le groupe « [groupname] » ?<br>Attention : Cette action est irréversible.',
'confirm_rm_log' => 'Voulez-vous vraiment supprimer le fichier journal « [logname] » ?<br>Attention : Cette action est irréversible.',
'confirm_rm_task' => 'Veuillez confirmer la suppression de cette tâche.',
'confirm_rm_transmittal' => 'Veuillez confirmer la suppression de la transmission.',
'confirm_rm_transmittalitem' => 'Confirmer la suppression',
'confirm_rm_user' => 'Voulez-vous vraiment supprimer l’utilisateur « [username] » ?<br>Attention : Cette action est irréversible.',
'confirm_rm_user_from_processes' => 'Voulez-vous vraiment retirer l’utilisateur « [username] » de tous les processus ?<br>Attention : Cette action peut entrainer la publication des documents si l’utilisateur était le seul (ou dernier) approbateur.',
'confirm_rm_version' => 'Voulez-vous vraiment supprimer la version [version] du document « [documentname] » ?<br>Attention : Cette action est irréversible.',
'confirm_transfer_link_document' => 'Sélectionnez si vous souhaitez lier le document glissé ou transférer son contenu au document cible en tant que nouvelle version. Seuls les documents avec une seule version peuvent être transférés. Le document glissé sera supprimé par la suite.',
'confirm_transfer_objects' => 'Voulez-vous vraiment transférer les documents, dossiers, etc. de l’utilisateur « [username] » ?<br>Attention : Cette action est irréversible.',
'confirm_update_transmittalitem' => 'Confirmer la mise à jour',
'content' => 'Contenu',
'continue' => 'Continuer',
'converter_new_cmd' => 'Commande',
'converter_new_mimetype' => 'Nouveau type MIME',
'copied_to_checkout_as' => 'Fichier copié dans l’espace de blocage en tant que « [filename] » ([date])',
'created' => '',
'createSubFolderForImportedFiles' => '',
'createSubFolderForImportedFiles_desc' => '',
'create_download_link' => 'Créer un lien de téléchargement',
'create_fulltext_index' => 'Créer un index de recherche plein texte',
'create_fulltext_index_warning' => 'Vous allez recréer l\'index de recherche plein texte. Cela peut prendre un temps considérable et réduire les performances de votre système dans son ensemble. Si vous voulez vraiment recréer l\'index, merci de confirmer votre opération.',
'creation_date' => 'Créé le',
'cs_CZ' => 'Tchèque',
'current_filter' => '',
'current_password' => 'Mot de passe actuel',
'current_quota' => 'Le quota global actuel est de [quota]',
'current_state' => 'État actuel',
'current_version' => 'Version actuelle',
'daily' => 'Journalier',
'dashboard' => 'Tableau de bord',
'databasesearch' => 'Recherche dans la base de données',
'database_schema_version' => 'Version du schéma de base de données',
'data_loading' => 'Veuillez patienter, jusqu\'à ce que les données soient chargées',
'date' => 'Date',
'days' => 'jours',
'days_ago' => '',
'days_from_now' => '',
'day_ago' => '',
'day_from_now' => '',
'debug' => 'Débogage',
'december' => 'Décembre',
'default_access' => 'Droits d\'accès par défaut',
'default_keywords' => 'Mots-clés disponibles',
'definitions' => 'Définitions',
'delete' => 'Supprimer',
'details' => 'Détails',
'details_version' => 'Détails de la version: [version]',
'de_DE' => 'Allemand',
'directory_check' => '',
'directory_check_cache_exists' => '',
'directory_check_cache_writable' => '',
'directory_check_conf_writable' => '',
'directory_check_data_below_root' => '',
'directory_check_data_exists' => '',
'directory_check_data_writable' => '',
'directory_check_ext_below_docroot' => '',
'directory_check_ext_exists' => '',
'directory_check_ext_writable' => '',
'directory_check_index_exists' => '',
'directory_check_index_writable' => '',
'directory_check_result' => '',
'disable_extension' => 'Désactiver l’extension',
'disclaimer' => 'Cet espace est protégé. Son accès est strictement réservé aux utilisateurs autorisés.<br/>Tout accès non autorisé est punissable par les lois internationales.',
'discspace' => 'Espace disque',
'docs_in_reception_disabled' => '',
'docs_in_reception_no_access' => 'Documents en attente de réception sans accès du destinataire',
'docs_in_revision_disabled' => '',
'docs_in_revision_no_access' => 'Documents en révision sans accès du réviseur',
'docs_with_link_to_itself' => '',
'docs_with_missing_revision_date' => '',
'document' => 'Document',
'documentcontent' => 'Version de document',
'documents' => 'Documents',
'documents_checked_out_by_you' => 'Documents bloqués par vous',
'documents_expired' => 'Documents expirés',
'documents_in_process' => 'Documents en cours',
'documents_locked' => 'Documents verrouillés',
'documents_locked_by_you' => 'Documents verrouillés',
'documents_only' => 'Documents uniquement',
'documents_rejected' => 'Rejeté',
'documents_to_approve' => 'Documents en attente d\'approbation',
'documents_to_correct' => 'Documents à corriger',
'documents_to_process' => 'Documents à traiter',
'documents_to_receipt' => 'Documents en attente de confirmation de réception',
'documents_to_review' => 'Documents en attente de vérification',
'documents_to_revise' => 'Documents en attente de votre révision',
'documents_to_trigger_workflow' => 'Documents en Workflow',
'documents_user_draft' => 'Ébauches',
'documents_user_expiration' => 'Documents expirés',
'documents_user_needs_correction' => 'Documents nécessitant une correction',
'documents_user_no_reception' => 'Documents sans réception',
'documents_user_obsolete' => 'Documents obsolètes',
'documents_user_reception' => 'Documents en attente de réception',
'documents_user_rejected' => 'Documents rejetés',
'documents_user_requiring_attention' => 'Documents à surveiller',
'documents_with_notification' => 'Documents avec notification',
'document_access_permission_changed_email' => 'Permission modifiée',
'document_access_permission_changed_email_body' => 'Permission modifiée
Document : [name]
Dossier parent : [folder_path]
Utilisateur : [username]
URL : [url]',
'document_access_permission_changed_email_body_html' => '<p>Permission modifiée</p>

<p>Document : [name]<br />
Dossier parent : [folder_path]<br />
Utilisateur : [username]<br />
URL : [url]</p>',
'document_access_permission_changed_email_subject' => '[sitename] : [name] - Permission modifiée',
'document_already_checkedout' => 'Ce document est déjà débloqué',
'document_already_locked' => 'Ce document est déjà verrouillé',
'document_attribute_added_email_body' => '',
'document_attribute_added_email_body_html' => '',
'document_attribute_added_email_subject' => '',
'document_attribute_changed_email_body' => 'Attribut modifié
Document : [name]
Attribut : [attribute_name]
Ancienne valeur : [attribute_old_value]
Nouvelle valeur : [attribute_new_value]
Dossier parent : [folder_path]
Utilisateur : [username]
URL : [url]',
'document_attribute_changed_email_body_html' => '<p>Attribut modifié</p>

<p>Document : [name]<br />
Attribut : [attribute_name]<br />
Ancienne valeur : [attribute_old_value]<br />
Nouvelle valeur : [attribute_new_value]<br />
Dossier parent : [folder_path]<br />
Utilisateur : [username]<br />
URL : [url]</p>',
'document_attribute_changed_email_subject' => '[sitename] : [name] - Attribut modifié',
'document_comment_changed_email' => 'Commentaire modifié',
'document_comment_changed_email_body' => 'Commentaire modifié

Document : [name]
Ancien commentaire : [old_comment]
Nouveau commentaire : [new_comment]
Dossier parent : [folder_path]
Utilisateur : [username]
URL : [url]',
'document_comment_changed_email_body_html' => '<p>Commentaire modifié</p>

<p>Document : [name]<br />
Ancien commentaire: [old_comment]<br />
Nouveau commentaire : [new_comment]<br />
Dossier parent : [folder_path]<br />
Utilisateur : [username]<br />
URL : [url]</p>',
'document_comment_changed_email_subject' => '[sitename] : [name] - Commentaire modifié',
'document_content_missing' => 'Contenu du document manquant',
'document_count' => 'Nombre de documents',
'document_deleted' => 'Document supprimé',
'document_deleted_email' => 'Document supprimé',
'document_deleted_email_body' => 'Document supprimé

Document : [name]
Dossier parent : [folder_path]
Utilisateur : [username]',
'document_deleted_email_body_html' => '<p>Document supprimé</p>

<p>Document : [name]<br />
Dossier parent : [folder_path]<br />
Utilisateur : [username]</p>',
'document_deleted_email_subject' => '[sitename] : [name] - Document supprimé',
'document_duplicate_name' => 'Un document porte déjà ce nom !',
'document_files' => 'Fichiers attachés',
'document_has_no_workflow' => 'Le document n\'a pas de workflow',
'document_infos' => 'Informations sur le document',
'document_in_revision_no_date' => '',
'document_is_checked_out' => 'Ce document est vérifié',
'document_is_checked_out_remove' => 'Le document est actuellement vérifié. Si vous supprimez le document, la version vérifiée ne pourra plus être ajoutée et restera dans la zone de vérification.',
'document_is_checked_out_update' => 'Le document est actuellement vérifié. Si vous ajoutez une nouvelle version, la version vérifiée ne pourra plus être vérifiée à nouveau.',
'document_is_not_locked' => 'Ce document n\'est pas verrouillé',
'document_links' => 'Liens du document',
'document_link_by' => 'Lié par',
'document_link_public' => 'Public',
'document_moved_email' => 'Document déplacé',
'document_moved_email_body' => 'Document déplacé

Document : [name]
Ancien dossier : [old_folder_path]
Nouveau dossier : [new_folder_path]
Utilisateur : [username]
URL : [url]',
'document_moved_email_body_html' => '<p>Document déplacé</p>

<p>Document : [name]<br />
Ancien dossier : [old_folder_path]<br />
Nouveau dossier : [new_folder_path]<br />
Utilisateur : [username]<br />
URL : [url]</p>',
'document_moved_email_subject' => '[sitename] : [name] - Document déplacé',
'document_notify_added_email' => 'Vous avez été ajouté à la liste des notifications.',
'document_notify_added_email_body' => 'Ajouté à la liste des notifications

Nom : [name]
Dossier parent : [folder_path]
Utilisateur : [username]
URL : [url]',
'document_notify_added_email_body_html' => '<p>Ajouté à la liste des notifications</p>
<p>Nom : [name]<br />
Dossier parent : [folder_path]<br />
Utilisateur : [username]<br />
URL : [url]</p>',
'document_notify_added_email_subject' => '[sitename] : [name] - Ajouté à la liste des notifications',
'document_notify_deleted_email' => 'Vous avez été supprimé de la liste des notifications.',
'document_notify_deleted_email_body' => 'Supprimé de la liste des notifications

Nom : [name]
Dossier parent : [folder_path]
Utilisateur : [username]
URL : [url]',
'document_notify_deleted_email_body_html' => '<p>Supprimé de la liste des notifications</p>
<p>Nom : [name]<br />
Dossier parent : [folder_path]<br />
Utilisateur : [username]<br />
URL : [url]</p>',
'document_notify_deleted_email_subject' => '[sitename] : [name] - Supprimé de la liste des notifications',
'document_not_checkedout' => 'Le document n’a pas été vérifié.',
'document_ownership_changed_email' => 'Propriétaire modifié',
'document_ownership_changed_email_body' => 'Propriétaire modifié

Document : [name]
Dossier parent : [folder_path]
Ancien propriétaire : [old_owner]
Nouveau propriétaire : [new_owner]
Utilisateur : [username]
URL : [url]',
'document_ownership_changed_email_body_html' => '<p>Propriétaire modifié</p>

<p>Document : [name]<br />
Dossier parent : [folder_path]<br />
Ancien propriétaire : [old_owner]<br />
Nouveau propriétaire : [new_owner]<br />
Utilisateur : [username]<br />
URL : [url]</p>',
'document_ownership_changed_email_subject' => '[sitename] : [name] - Propriétaire modifié',
'document_renamed_email' => 'Document renommé',
'document_renamed_email_body' => 'Document renommé

Document : [name]
Dossier parent : [folder_path]
Ancien nom : [old_name]
Utilisateur : [username]
URL : [url]',
'document_renamed_email_body_html' => '<p>Document renommé</p>

<p>Document : [name]<br />
Dossier parent : [folder_path]<br />
Ancien nom : [old_name]<br />
Utilisateur : [username]<br />
URL : [url]</p>',
'document_renamed_email_subject' => '[sitename] : [name] - Document renommé',
'document_status_changed_email' => 'Statut du document modifié',
'document_status_changed_email_body' => 'Statut du document modifié

Document : [name]
Statut : [status]
Dossier parent : [folder_path]
Utilisateur : [username]
URL : [url]',
'document_status_changed_email_body_html' => '<p>Statut du document modifié</p>

<p>Document : [name]<br />
Statut : [status]<br />
Dossier parent : [folder_path]<br />
Utilisateur : [username]<br />
URL : [url]</p>',
'document_status_changed_email_subject' => '[sitename] : [name] - Statut du document modifié',
'document_title' => 'Document \'[documentname]\'',
'document_transfered_email_body' => 'Transfert d’un document à un autre utilisateur
Document : [name]
Nouveau propriétaire : [newuser]
Dossier parent : [folder_path]
Utilisateur : [username]
URL : [url]',
'document_transfered_email_body_html' => '<p>Transfert d’un document à un autre utilisateur</p>

<p>Document : [name]<br />
Nouveau propriétaire : [newuser]<br />
Ancien propriétaire : [olduser]<br />
Dossier parent : [folder_path]<br />
Utilisateur : [username]<br />
URL : [url]</p>',
'document_transfered_email_subject' => '[sitename] : [name] - Transfert d’un document',
'document_updated_email' => 'Document mis à jour',
'document_updated_email_body' => 'Document mis à jour

Document : [name]
Dossier parent : [folder_path]
Commentaire : [comment]
Commentaire de version : [version_comment]
Utilisateur : [username]
URL : [url]',
'document_updated_email_body_html' => '<p>Document mis à jour</p>

<p>Document : [name]<br />
Version : [version]<br />
Dossier parent : [folder_path]<br />
Utilisateur : [username]<br />
Commentaire : [comment]<br />
Commentaire de la version : [version_comment]<br />
URL : [url]</p>',
'document_updated_email_subject' => '[sitename] : [name] - Document mis à jour',
'document_versions' => 'Versions du document',
'does_not_expire' => 'N\'expire jamais',
'does_not_inherit_access_msg' => 'Accès hérité',
'download' => 'Téléchargement',
'download_extension' => 'Télécharger l’extension en tant que fichier zip',
'download_header_approval_comment' => 'Commentaire d’approbation',
'download_header_approval_date' => 'Date d’approbation',
'download_header_approval_state' => 'Statut d’approbation',
'download_header_approver' => 'Approbateur',
'download_header_document_name' => 'Nom du document',
'download_header_document_no' => 'N° du document',
'download_header_filename' => 'Nom du fichier',
'download_header_folder_name' => '',
'download_header_folder_no' => '',
'download_header_internal_version' => 'Version interne',
'download_header_reviewer' => 'Examinateur',
'download_header_review_comment' => 'Commentaire de vérification',
'download_header_review_date' => 'Date de vérification',
'download_header_review_state' => 'Statut de vérification',
'download_header_state' => 'Statut',
'download_links' => 'Liens de téléchargement',
'download_link_email_body' => '',
'download_link_email_subject' => '',
'do_no_transfer_to_user' => 'Ne pas transférer les processus à l’utilisateur',
'do_object_repair' => 'Réparer tous les dossiers et documents.',
'do_object_setchecksum' => 'Définir checksum',
'do_object_setfilesize' => 'Définir la taille du fichier',
'do_object_setfiletype' => 'Définir le type de fichier',
'do_object_unlink' => 'Supprimer la version du document',
'draft' => 'Ébauche',
'draft_pending_approval' => 'Ébauche - en attente d’approbation',
'draft_pending_review' => 'Ébauche - en attente de vérification',
'drag_icon_here' => 'Glisser-déposer le dossier ou document ici !',
'dropfolderdir_missing' => 'Votre dossier de dépôt personnel n\'existe pas sur le serveur ! Veuillez faire une demande à l\'administrateur.',
'dropfolder_file' => 'Fichier du dossier de dépôt',
'dropfolder_folder' => 'Répertoire du dossier de dépôt',
'dropfolder_metadata' => 'Métadonnées du dossier de dépôt',
'dropupload' => 'Téléchargement rapide',
'drop_files_here' => 'Glissez les fichiers ici !',
'drop_files_here_or_click' => 'Glissez les fichiers ici ou cliquez !',
'dump_creation' => 'Sauvegarder la base de données',
'dump_creation_warning' => 'Avec cette opération, vous pouvez créer une sauvegarde du contenu de votre base de données. Après la création, le fichier de sauvegarde sera sauvegardé dans le dossier de données de votre serveur.',
'dump_list' => 'Fichiers de sauvegarde existants',
'dump_remove' => 'Supprimer fichier de sauvegarde',
'duplicates' => 'Doublons',
'duplicate_content' => 'Contenu en double',
'duplicate_sequences' => '',
'edit' => 'Modifier',
'edit_attributes' => 'Modifier les attributs',
'edit_comment' => 'Modifier le commentaire',
'edit_default_keywords' => 'Modifier les mots-clés',
'edit_document_access' => 'Modifier les droits d\'accès',
'edit_document_notify' => 'Notification de document',
'edit_document_props' => 'Modifier le document',
'edit_event' => 'Modifier l\'événement',
'edit_existing_access' => 'Modifier la liste des droits d\'accès',
'edit_existing_attribute_groups' => 'Modifier les groupes d’attributs',
'edit_existing_notify' => 'Modifier les notifications',
'edit_folder_access' => 'Modifier les droits d\'accès',
'edit_folder_attrdefgrp' => 'Modifier les groupes d’attributs',
'edit_folder_notify' => 'Notification de dossier',
'edit_folder_props' => 'Modifier le dossier',
'edit_group' => 'Modifier un groupe',
'edit_online' => 'Modification en ligne',
'edit_online_not_allowed' => 'Vous n’êtes pas autorisé à modifier ce fichier car vous n’avez pas créé la dernière version. Déposez simplement une nouvelle version du document.',
'edit_online_warning' => 'L’enregistrement de vos modifications écrasera le contenu de la version actuelle au lieu de créer une nouvelle version.',
'edit_task' => 'Modifier la tâche',
'edit_transmittal_props' => 'Modifier les propriétés de la transmission',
'edit_user' => 'Modifier un utilisateur',
'edit_user_details' => 'Modifier les détails d\'utilisateur',
'edit_version' => 'Modifier le fichier',
'el_GR' => 'Grec',
'email' => 'E-mail',
'email_error_title' => 'Aucun e-mail indiqué',
'email_footer' => 'Vous pouvez modifier vos notifications via « Mon compte ».',
'email_footer_html' => '<p>Vous pouvez modifier vos préférences e-mail à tout moment via \'Mon compte\'</p>',
'email_header' => 'Ceci est un message automatique généré par le serveur DMS.',
'email_header_html' => '<p>Ceci est un message automatique du serveur DMS.</p>',
'email_not_given' => 'Veuillez entrer une adresse e-mail valide.',
'empty_attribute_group_list' => 'Aucun groupe d’attributs',
'empty_folder_list' => 'Pas de documents ou de dossier',
'empty_list' => 'Aucune entrée',
'empty_notify_list' => 'Aucune entrée',
'enable_extension' => 'Activer l’extension',
'enddate' => '',
'en_GB' => 'Anglais (RU)',
'equal_transition_states' => 'États de début et de fin identiques',
'error' => 'Erreur',
'error_add_aro' => 'Erreur lors de l’ajout de l’objet de demande d’accès',
'error_add_permission' => 'Erreur lors de l’ajout de permission',
'error_cleared_cache' => 'Erreur lors du vidage du cache',
'error_document_indexed' => 'Erreur d’indexation du document',
'error_edit_task' => 'Erreur lors de la modification de la tâche',
'error_extension_getlist' => 'Erreur lors de l’obtention de la liste des extensions depuis le dépôt',
'error_importfs' => 'Erreur lors de l’import depuis le système de fichiers',
'error_no_document_selected' => 'Aucun document sélectionné',
'error_no_folder_selected' => 'Aucun dossier sélectionné',
'error_occured' => 'Une erreur s\'est produite',
'error_remove_document' => 'Erreur lors de la suppression du document',
'error_remove_folder' => 'Erreur lors de la suppression du dossier',
'error_remove_permission' => 'Erreur lors de la suppression de permission',
'error_rm_user_processes' => '',
'error_rm_user_processes_no_docs' => '',
'error_rm_workflow' => 'Erreur lors de la suppression du workflow',
'error_rm_workflow_action' => 'Erreur lors de la suppression de l’action de workflow',
'error_rm_workflow_state' => 'Erreur lors de la suppression de l’état de workflow',
'error_toogle_permission' => 'Erreur lors de la modification de permission',
'error_transfer_document' => 'Erreur lors du transfert du document',
'error_trigger_workflow' => 'Erreur lors du déclenchement de la transition du workflow',
'error_update_document' => 'Erreur lors de la mise à jour du document',
'error_uploading_reviewer_only' => 'Erreur lors de la création du document. Le document a un examinateur, mais pas d’approbateur.',
'es_ES' => 'Espagnol',
'event' => 'Évenement',
'event_details' => 'Détails de l\'événement',
'exclude_items' => 'Exclure des élements',
'expired' => 'Expiré',
'expired_at_date' => 'Expiré le [datetime]',
'expired_docs_mail_subject' => 'Documents expirés',
'expired_documents' => 'Documents expirés',
'expires' => 'Expiration',
'expire_by_date' => 'Expire à une date',
'expire_in_1d' => 'Expire dans 1 jour',
'expire_in_1h' => 'Expire dans 1 heure',
'expire_in_1m' => 'Expire dans 1 mois',
'expire_in_1w' => 'Expire dans 1 semaine',
'expire_in_1y' => 'Expire dans 1 an',
'expire_in_24h' => '',
'expire_in_2h' => 'Expire dans 2 heures',
'expire_in_2y' => 'Expire dans 2 ans',
'expire_in_3y' => 'Expire dans 3 ans',
'expire_today' => 'Expire aujourd’hui',
'expire_tomorrow' => 'Expire demain',
'expiry_changed_email' => 'Date d\'expiration modifiée',
'expiry_changed_email_body' => 'Date d\'expiration modifiée

Document : [name]
Dossier parent : [folder_path]
Utilisateur : [username]
URL : [url]',
'expiry_changed_email_body_html' => '<p>Date d’expiration modifiée</p>

<p>Document : [name]<br />
Dossier parent : [folder_path]<br />
Utilisateur : [username]<br />
URL : [url]</p>',
'expiry_changed_email_subject' => '[sitename] : [name] - Date d’expiration modifiée',
'export' => 'Exporter',
'export_user_list_csv' => 'Exporter les utilisateurs en CSV',
'extension_archive' => 'Extension',
'extension_changelog' => 'Journal des modifications',
'extension_config' => '',
'extension_info' => '',
'extension_is_off_now' => 'L’extension est désactivée',
'extension_is_on_now' => 'L’extension est activée',
'extension_loading' => 'Chargement des extensions…',
'extension_manager' => 'Gestionnaire d\'extensions',
'extension_mgr_error_upload' => 'Erreur lors du chargement de l’extension',
'extension_mgr_installed' => 'Installées',
'extension_mgr_no_toggle' => 'Les extensions ne peuvent pas être activées/désactivées car le fichier de configuration n\'est pas accessible en écriture.',
'extension_mgr_no_upload' => 'L’ajout de nouvelles extensions n’est pas possible car le répertoire des extensions n’est pas accessible en écriture.',
'extension_mgr_no_zipfile' => 'L’extension chargée n’est pas un dossier zip',
'extension_mgr_repository' => 'Disponibles',
'extension_mgr_upload_disabled' => 'Le chargement d\'extension n\'est pas activé',
'extension_missing_name' => 'Nom d’extension manquant',
'extension_readme' => '',
'extension_toggle_error' => 'Impossible d’activer/désactiver l’extension',
'extension_version_list' => 'Versions',
'facetfullsearch' => '',
'february' => 'Février',
'file' => 'Fichier',
'files' => 'Fichiers',
'filesize' => 'Taille',
'files_deletion' => 'Suppression de fichiers',
'files_deletion_warning' => 'Avec cette option, vous pouvez supprimer tous les fichiers d\'un dossier DMS. Les informations de version resteront visibles.',
'files_loading' => 'Veuillez patienter pendant le chargement de la liste des fichiers…',
'filetype' => 'Type de fichier',
'filter_for_documents' => 'Filtre additionnel pour les documents',
'filter_for_documents_and_folders' => '',
'filter_for_folders' => 'Filtre additionnel pour les dossiers',
'finished_workflow_log' => '',
'folder' => 'Dossier',
'folders' => 'Dossiers',
'folders_and_documents_statistic' => 'Aperçu du contenu',
'folders_with_notification' => 'Dossiers avec notification',
'folder_access_permission_changed_email_body' => 'Permission modifiée
Document : [name]
Dossier parent : [folder_path]
Utilisateur : [username]
URL : [url]',
'folder_access_permission_changed_email_body_html' => '<p>Permission modifiée</p>

<p>Document : [name]<br />
Dossier parent : [folder_path]<br />
Utilisateur : [username]<br />
URL : [url]</p>',
'folder_access_permission_changed_email_subject' => '[sitename] : [name] - Permission modifiée',
'folder_attribute_added_email_body' => '',
'folder_attribute_added_email_body_html' => '',
'folder_attribute_added_email_subject' => '',
'folder_attribute_changed_email_body' => 'Attribut modifié

Dossier : [name]
Attribut : [attribute_name]
Ancienne valeur : [attribute_old_value]
Nouvelle valeur : [attribute_new_value]
Dossier parent : [folder_path]
Utilisateur : [username]
URL : [url]',
'folder_attribute_changed_email_body_html' => '<p>Attribut modifié</p>

<p>Dossier : [name]<br />
Attribut : [attribute_name]<br />
Ancienne valeur : [attribute_old_value]<br />
Nouvelle valeur : [attribute_new_value]<br />
Dossier parent : [folder_path]<br />
Utilisateur : [username]<br />
URL : [url]</p>',
'folder_attribute_changed_email_subject' => '[sitename] : [name] - Attribut modifié',
'folder_comment_changed_email' => 'Commentaire changé',
'folder_comment_changed_email_body' => 'Commentaire modifié

Dossier : [name]
Ancien commentaire : [old_comment]
Commentaire : [new_comment]
Dossier parent : [folder_path]
Utilisateur : [username]
URL : [url]',
'folder_comment_changed_email_body_html' => '<p>Commentaire modifié</p>

<p>Dossier : [name]<br />
Ancien commentaire : [old_comment]<br />
Nouveau commentaire : [new_comment]<br />
Dossier parent : [folder_path]<br />
Utilisateur : [username]<br />
URL : [url]</p>',
'folder_comment_changed_email_subject' => '[sitename] : [name] - Commentaire modifié',
'folder_contents' => 'Dossiers',
'folder_deleted_email' => 'Dossier supprimé',
'folder_deleted_email_body' => 'Dossier supprimé

Dossier : [name]
Dossier parent : [folder_path]
Utilisateur : [username]
URL : [url]',
'folder_deleted_email_body_html' => '<p>Dossier supprimé</p>

<p>Dossier : [name]<br />
Dossier parent : [folder_path]<br />
Utilisateur : [username]<br />
URL : [url]</p>',
'folder_deleted_email_subject' => '[sitename] : [name] - Dossier supprimé',
'folder_infos' => 'Informations sur le dossier',
'folder_moved_email' => 'Dossier déplacé',
'folder_moved_email_body' => 'Dossier déplacé

Dossier : [name]
Ancien dossier : [old_folder_path]
Nouveau dossier : [new_folder_path]
Utilisateur : [username]
URL : [url]',
'folder_moved_email_body_html' => '<p>Dossier déplacé</p>

<p>Dossier : [name]<br />
Ancien dossier : [old_folder_path]<br />
Nouveau dossier : [new_folder_path]<br />
Utilisateur : [username]<br />
URL : [url]</p>',
'folder_moved_email_subject' => '[sitename] : [name] - Dossier déplacé',
'folder_notify_added_email' => '',
'folder_notify_added_email_body' => 'Ajouté à la liste des notifications

Nom : [name]
Dossier parent : [folder_path]
Utilisateur : [username]
URL : [url]',
'folder_notify_added_email_body_html' => '<p>Ajouté à la liste des notifications</p>
<p>Nom : [name]<br />
Dossier parent : [folder_path]<br />
Utilisateur : [username]<br />
URL : [url]</p>',
'folder_notify_added_email_subject' => '[sitename] : [name] - Ajouté à la liste des notifications',
'folder_notify_deleted_email_body' => 'Supprimé de la liste des notifications

Nom : [name]
Dossier parent : [folder_path]
Utilisateur : [username]
URL : [url]',
'folder_notify_deleted_email_body_html' => '<p>Supprimé de la liste des notifications</p>
<p>Nom : [name]<br />
Dossier parent : [folder_path]<br />
Utilisateur : [username]<br />
URL : [url]</p>',
'folder_notify_deleted_email_subject' => '[sitename] : [name] - Supprimé de la liste des notifications',
'folder_ownership_changed_email_body' => 'Propriétaire modifié

Dossier : [name]
Dossier parent : [folder_path]
Ancien propriétaire : [old_owner]
Nouveau propriétaire : [new_owner]
Utilisateur : [username]
URL : [url]',
'folder_ownership_changed_email_body_html' => '<p>Propriétaire modifié</p>

<p>Dossier : [name]<br />
Dossier parent : [folder_path]<br />
Ancien propriétaire : [old_owner]<br />
Nouveau propriétaire : [new_owner]<br />
Utilisateur : [username]<br />
URL : [url]</p>',
'folder_ownership_changed_email_subject' => '[sitename] : [name] - Propriétaire modifié',
'folder_renamed_email' => 'Dossier renommé',
'folder_renamed_email_body' => 'Dossier renommé

Dossier : [name]
Dossier parent : [folder_path]
Ancien nom : [old_name]
Utilisateur : [username]
URL : [url]',
'folder_renamed_email_body_html' => '<p>Dossier renommé</p>

<p>Dossier : [name]<br />
Dossier parent : [folder_path]<br />
Ancien nom : [old_name]<br />
Utilisateur : [username]<br />
URL : [url]</p>',
'folder_renamed_email_subject' => '[sitename] : [name] - Dossier renommé',
'folder_title' => 'Dossier \'[foldername]\'',
'foot_note' => 'Note de pied de page',
'force_update' => 'Mettre à jour',
'friday' => 'Vendredi',
'friday_abbr' => 'Ven.',
'from' => 'Du',
'fr_FR' => 'Français',
'fullsearch' => 'Recherche dans le contenu',
'fullsearch_hint' => 'Utiliser la recherche plein texte',
'fulltextsearch_disabled' => 'La recherche plein texte est désactivée.',
'fulltext_converters' => 'Conversion des documents pour indexation',
'fulltext_info' => 'Information sur l\'index plein texte',
'func_proc_open_missing' => 'proc_open est nécessaire pour indexer le contenu des documents. Sans cette fonction, seules les métadonnées seront indexées.',
'global_attributedefinitiongroups' => 'Groupes d’attributs',
'global_attributedefinitions' => 'Définitions d\'attributs',
'global_default_keywords' => 'Mots-clés globaux',
'global_document_categories' => 'Catégories',
'global_link_types' => '',
'global_workflows' => 'Workflows',
'global_workflow_actions' => 'Actions de Workflow',
'global_workflow_states' => 'États de Workflow',
'group' => 'Groupe',
'groups' => 'Groupes',
'group_approval_summary' => 'Récapitulatif groupe approbation',
'group_exists' => 'Ce groupe existe déjà.',
'group_info' => 'Informations du groupe',
'group_is_mandatory_approver' => '',
'group_is_mandatory_reviewer' => '',
'group_management' => 'Gestion des groupes',
'group_members' => 'Membres du groupe',
'group_previously_removed_from_approvers' => '',
'group_previously_removed_from_recipients' => '',
'group_previously_removed_from_reviewers' => '',
'group_previously_removed_from_revisors' => '',
'group_receipt_summary' => 'Récapitulatif groupe réception',
'group_review_removed' => 'Changement de statut car la vérification du groupe [name] a été supprimée.',
'group_review_summary' => 'Récapitulatif groupe vérification',
'group_revision_summary' => 'Récapitulatif groupe révision',
'guest_login' => 'Se connecter comme invité',
'guest_login_disabled' => 'Connexion d\'invité désactivée.',
'hash' => 'Hash',
'help' => 'Aide',
'home_folder' => 'Dossier personnel',
'hook_name' => 'Nom de l’appel',
'hourly' => 'Une fois par heure',
'hours' => 'heures',
'hours_ago' => '',
'hours_from_now' => '',
'hour_ago' => '',
'hour_from_now' => '',
'hr_HR' => 'Croate',
'human_readable' => 'Archive au format lisible',
'hu_HU' => 'Hongrois',
'id' => 'ID',
'identical_version' => 'Nouvelle version identique à l\'actuelle.',
'id_ID' => 'Indonésien',
'import' => 'Importer',
'importfs' => 'Importer depuis le système de fichiers',
'import_extension' => 'Importer l’extension',
'import_fs' => 'Importer depuis le système de fichiers',
'import_fs_warning' => 'L’importation peut se faire à partir du dossier de dépôt personnel uniquement. Tous les sous-dossiers et fichiers seront importés. Les fichiers seront immédiatement publiés.',
'import_users' => 'Importer des utilisateurs',
'import_users_addnew' => 'Ajouter de nouveaux utilisateurs',
'import_users_no_column_mapping' => '',
'import_users_update' => 'Mettre à jour des utilisateurs existants',
'include_content' => 'Inclure le contenu',
'include_documents' => 'Inclure les documents',
'include_subdirectories' => 'Inclure les sous-dossiers',
'indexing_tasks_in_queue' => 'Opérations d’indexation en attente',
'index_converters' => '',
'index_document_added' => 'Document ajouté',
'index_document_unchanged' => 'Document inchangé',
'index_document_updated' => 'Document mis à jour',
'index_done' => 'Terminé',
'index_error' => 'Erreur',
'index_folder' => 'Dossier Index',
'index_folder_added' => 'Dossier ajouté',
'index_folder_unchanged' => 'Dossier inchangé',
'index_folder_updated' => 'Dossier mis à jour',
'index_no_content' => 'Contenu non indexé',
'index_pending' => 'En attente',
'index_processing' => '',
'index_waiting' => 'Chargement…',
'individuals' => 'Individuels',
'individuals_in_groups' => 'Membres d’un groupe',
'ind_review_removed' => 'Changement de statut car la vérification de l’utilisateur [name] a été supprimée.',
'info_recipients_tab_not_released' => 'L’accusé de réception pour cette version du document n’est pas possible car la version n’est pas en état « publié ».',
'info_rm_user_from_processes_none' => '',
'info_rm_user_from_processes_user' => 'Seules les tâches non traitées peuvent être transférées à un autre utilisateur. Pour les tâches déjà traitées, une entrée sera ajoutée dans l’historique, comme si l’utilisateur lui-même avait été supprimé.',
'inherited' => 'hérité',
'inherits_access_copy_msg' => 'Recopier la liste des accès hérités',
'inherits_access_empty_msg' => 'Commencer avec une liste d\'accès vide',
'inherits_access_msg' => 'L\'accès est hérité.',
'insecure_installation' => '',
'installed_apache_extensions' => 'Extensions Apache installées',
'installed_php_extensions' => 'Extensions PHP installées',
'internal_error' => 'Erreur interne',
'internal_error_exit' => 'Erreur interne. Impossible d\'achever la demande.',
'invalid_access_mode' => 'Droits d\'accès invalides',
'invalid_action' => 'Action invalide',
'invalid_approval_status' => 'Statut d\'approbation invalide',
'invalid_create_date_end' => 'Date de fin invalide pour la plage de dates de création.',
'invalid_create_date_start' => 'Date de début invalide pour la plage de dates de création.',
'invalid_doc_id' => 'Identifiant de document invalide',
'invalid_dropfolder_folder' => 'Répertoire du dossier de dépôt invalide',
'invalid_expiration_date' => '',
'invalid_expiration_date_end' => 'Date de fin invalide pour la plage de dates d’expiration.',
'invalid_expiration_date_start' => 'Date de début invalide pour la plage de dates d’expiration.',
'invalid_file_id' => 'Identifiant de fichier invalide',
'invalid_folder_id' => 'Identifiant de dossier invalide',
'invalid_group_id' => 'Identifiant de groupe invalide',
'invalid_link_id' => 'Identifiant de lien invalide',
'invalid_request_token' => 'Jeton de demande incorrect',
'invalid_review_status' => 'Statut de vérification invalide',
'invalid_sequence' => 'Position invalide',
'invalid_status' => 'Statut de document invalide',
'invalid_target_doc_id' => 'Identifiant de document cible invalide',
'invalid_target_folder' => 'Identifiant de dossier cible invalide',
'invalid_user_id' => 'Identifiant utilisateur invalide',
'invalid_version' => 'Version de document invalide',
'in_folder' => 'Dans',
'in_revision' => 'En révision',
'in_workflow' => 'Dans le workflow',
'iptc_metadata' => '',
'is_disabled' => 'Compte désactivé',
'is_hidden' => 'Cacher de la liste utilisateur',
'it_IT' => 'Italien',
'january' => 'Janvier',
'js_confirm_cancel_checkout' => '',
'js_form_error' => 'Le formulaire contient encore # erreur.',
'js_form_errors' => 'Le formulaire contient encore # erreurs.',
'js_invalid_email' => 'L\'adresse e-mail est invalide',
'js_no_approval_group' => 'Veuillez sélectionner un groupe d’approbation',
'js_no_approval_status' => 'Veuillez sélectionner le statut d’approbation',
'js_no_comment' => 'Il n’y a pas de commentaire',
'js_no_currentpwd' => 'Veuillez entrer votre mot de passe actuel',
'js_no_document' => 'Veuillez sélectionner un document',
'js_no_email' => 'Saisissez votre adresse e-mail',
'js_no_file' => 'Veuillez sélectionner un fichier',
'js_no_folder' => 'Veuillez sélectionner un dossier',
'js_no_keywords' => 'Spécifiez quelques mots-clés',
'js_no_login' => 'Veuillez saisir un identifiant',
'js_no_name' => 'Veuillez saisir un nom',
'js_no_override_status' => 'Veuillez sélectionner le nouveau statut',
'js_no_pwd' => 'Vous devez saisir votre mot de passe',
'js_no_query' => 'Saisir une requête',
'js_no_review_group' => 'Veuillez sélectionner un groupe d’examinateurs',
'js_no_review_status' => 'Veuillez sélectionner le statut de vérification',
'js_pwd_not_conf' => 'Mot de passe et confirmation de mot de passe non identiques',
'js_select_user' => 'Veuillez sélectionner un utilisateur',
'js_select_user_or_group' => 'Sélectionner au moins un utilisateur ou un groupe',
'js_unequal_passwords' => 'Les mots de passe ne sont pas identiques',
'july' => 'Juillet',
'june' => 'Juin',
'keep' => 'Ne pas modifier',
'keep_doc_status' => 'Garder le statut du document',
'keywords' => 'Mots-clés',
'keywords_loading' => 'Veuillez patienter pendant le chargement de la liste des mots-clés…',
'keyword_exists' => 'Mot-clé déjà existant',
'ko_KR' => 'Korean',
'language' => 'Langue',
'lastaccess' => 'Dernière connexion',
'last_update' => 'Dernière modification',
'latest_newdocuments' => '',
'latest_statuschange' => '',
'latest_updateddocuments' => '',
'legend' => 'Légende',
'librarydoc' => 'Document de la bibliothèque',
'linked_document' => '',
'linked_documents' => 'Documents liés',
'linked_files' => 'Fichiers attachés',
'linked_to_current_version' => 'Lié à la version actuelle',
'linked_to_document' => 'Lié au document',
'linked_to_this_version' => 'Lié à cette version',
'link_alt_updatedocument' => 'Pour déposer des fichiers de taille supérieure, utilisez la <a href="%s">page d\'ajout multiple</a>.',
'link_document' => 'Lien vers le document',
'link_to' => '',
'link_to_version' => 'Version',
'list_access_rights' => 'Liste des droits d’accès…',
'list_contains_no_access_docs' => 'La liste contient des documents auxquels vous n’avez pas accès et qui ne sont donc pas affichés.',
'list_conversion_overview' => '',
'list_conversion_services' => '',
'list_hooks' => 'Liste des appels internes',
'list_notification_services' => '',
'list_of_recipients_has_disabled_users' => '',
'list_tasks' => 'Liste des tâches',
'local_file' => 'Fichier local',
'locked_by' => 'Verrouillé par',
'lock_document' => 'Verrouiller',
'lock_message' => 'Ce document a été verrouillé par [username]. Seuls les utilisateurs autorisés peuvent déverrouiller ce document.',
'lock_status' => 'Statut',
'logfile' => 'Fichier journal',
'logfile_loading' => 'Veuillez patienter pendant le chargement du fichier journal…',
'login' => 'Identification',
'login_disabled_text' => 'Votre compte est désactivé, sans doute à cause de trop nombreuses connexions qui ont échoué.',
'login_disabled_title' => 'Compte désactivé',
'login_error_text' => 'Erreur à la connexion. Identifiant ou mot de passe incorrect.',
'login_error_title' => 'Erreur de connexion',
'login_not_given' => 'Nom utilisateur non fourni',
'login_ok' => 'Connexion établie',
'login_restrictions_apply' => 'Échec de la connexion en raison de restrictions',
'logout' => 'Déconnexion',
'log_management' => 'Gestion des fichiers journaux',
'lo_LA' => 'Laotien',
'malformed_expiration_date' => 'Format de date d’expiration invalide',
'manager' => 'Responsable',
'manager_of_group' => 'Vous êtes le gestionnaire de ce groupe',
'mandatory_approvergroups' => 'Obligatoire : groupes de valideurs',
'mandatory_approvergroup_no_access' => 'Groupe requis d\'approbateurs \'[group]\' ne dispose pas des droits suffisants',
'mandatory_approvers' => 'Affecter les approbateurs',
'mandatory_approver_no_access' => 'L\'approbateur désigné \'[user]\' ne dispose pas des droits d\'accès suffisants.',
'mandatory_reviewergroups' => 'Groupe obligatoire d’examinateurs',
'mandatory_reviewergroup_no_access' => 'Groupe d\'examinateurs \'[group]\' ne dispose pas des droits suffisants',
'mandatory_reviewers' => 'Examinateurs',
'mandatory_reviewer_no_access' => 'Examinateur \'[user]\' ne dispose pas des droits suffisants',
'march' => 'Mars',
'mark_document' => '',
'mark_folder' => '',
'max_upload_size' => 'Taille maximum de fichier déposé',
'may' => 'Mai',
'menu_dropfolder' => 'Dossier de dépôt',
'menu_upload_from_dropfolder' => 'Importer ce fichier',
'message' => 'Message',
'mimetype' => 'Type MIME',
'minutes' => 'minutes',
'minutes_ago' => '',
'minutes_from_now' => '',
'minute_ago' => '',
'minute_from_now' => '',
'misc' => 'Divers',
'missing_checksum' => 'Checksum manquante',
'missing_file' => 'Fichier manquant',
'missing_filesize' => 'Taille de fichier manquante',
'missing_func_class_note' => 'Note',
'missing_php_class' => '',
'missing_php_extension' => '',
'missing_php_extensions' => 'Extensions PHP manquantes',
'missing_php_function' => '',
'missing_php_functions_and_classes' => 'Fonctions et classes PHP manquantes',
'missing_reception' => 'Réception manquante',
'missing_request_object' => 'Demande d’objet manquante',
'missing_transition_user_group' => 'Utilisateur/groupe manquant pour transition',
'modification_date' => '',
'modified' => '',
'monday' => 'Lundi',
'monday_abbr' => 'Lun.',
'monthly' => 'Mensuel',
'months_ago' => '',
'months_from_now' => '',
'month_ago' => '',
'month_from_now' => '',
'month_view' => 'Vue par mois',
'more_objects_loading' => 'Chargement d’éléments supplémentaires…',
'move' => 'Déplacer',
'move_clipboard' => 'Déplacer le contenu du presse-papier',
'move_document' => 'Déplacer le document',
'move_folder' => 'Déplacer le dossier',
'move_into_rootfolder' => '',
'must_drop_one_file' => '',
'my_account' => 'Mon compte',
'my_documents' => 'Mes documents',
'my_transmittals' => 'Mes transmissions',
'name' => 'Nom',
'nav_brand_admin_tools' => 'Outils d\'administration',
'nav_brand_calendar' => 'Agenda',
'nav_brand_my_account' => 'Mon compte',
'nav_brand_my_documents' => 'Mes documents',
'nav_brand_view_document' => 'Document',
'nav_brand_view_folder' => 'Dossier',
'nb_NO' => 'Norvégien bokmål',
'needs_correction' => 'Nécessite une correction',
'needs_workflow_action' => 'Ce document requiert votre attention. Consultez l\'onglet workflow.',
'network_drive' => 'Lecteur réseau',
'never' => 'Jamais',
'new' => 'Nouveau',
'new_attrdef' => 'Ajouter une définition d\'attribut',
'new_default_keywords' => 'Ajouter des mots-clés',
'new_default_keyword_category' => 'Ajouter une catégorie',
'new_documents' => '',
'new_documents_today' => '',
'new_documents_yesterday' => '',
'new_document_category' => 'Ajouter une catégorie',
'new_document_email' => 'Nouveau document',
'new_document_email_body' => 'Nouveau document

Nom : [name]
Dossier parent : [folder_path]
Commentaire : [comment]
Commentaire de version : [version_comment]
Utilisateur : [username]
URL : [url]',
'new_document_email_body_html' => '<p>Nouveau document</p>

<p>Nom : [name]<br />
Dossier parent : [folder_path]<br />
Commentaire : [comment]<br />
Commentaire de version : [version_comment]<br />
Utilisateur : [username]<br />
URL : [url]</p>',
'new_document_email_subject' => '[sitename] : [folder_name] - Nouveau document',
'new_file_email' => 'Nouvel attachement',
'new_file_email_body' => 'Nouveau fichier attaché

Nom : [name]
Document : [document]
Commentaire : [comment]
Utilisateur : [username]
URL : [url]',
'new_file_email_body_html' => '<p>Nouveau fichier attaché</p>

<p>Nom : [name]<br />
Document : [document]<br />
Commentaire : [comment]<br />
Utilisateur : [username]<br />
URL : [url]</p>',
'new_file_email_subject' => '[sitename] : [document] - Nouveau fichier attaché',
'new_folder' => 'Nouveau dossier',
'new_link_type' => '',
'new_password' => 'Nouveau mot de passe',
'new_subfolder_email' => 'Nouveau dossier',
'new_subfolder_email_body' => 'Nouveau dossier

Nom : [name]
Dossier parent : [folder_path]
Commentaire : [comment]
Utilisateur : [username]
URL : [url]',
'new_subfolder_email_body_html' => '<p>Nouveau dossier</p>

<p>Nom : [name]<br />
Dossier parent : [folder_path]<br />
Commentaire : [comment]<br />
Utilisateur : [username]<br />
URL : [url]</p>',
'new_subfolder_email_subject' => '[sitename] : [name] - Nouveau dossier',
'new_user_image' => 'Nouvelle image',
'next_revision_abbr' => 'Prochaine rév.',
'next_state' => 'Nouvel état',
'nl_NL' => 'Danois',
'no' => 'Non',
'notification' => 'Notification',
'notification_msg_tmpl' => '',
'notification_recvtype' => '',
'notification_recv_any' => '',
'notification_recv_approver' => '',
'notification_recv_notification' => '',
'notification_recv_owner' => '',
'notification_recv_reviewer' => '',
'notification_recv_uploader' => '',
'notification_recv_workflow' => '',
'notification_service_no_filter' => '',
'notification_tmpl' => '',
'not_subscribed' => 'Non inscrit',
'november' => 'Novembre',
'now' => 'Maintenant',
'no_action' => 'Aucune action n\'est nécessaire',
'no_approval_needed' => 'Aucune approbation en attente',
'no_attached_files' => 'Aucun fichier attaché',
'no_attributes_defined' => 'Vous n’avez créé aucun attribut personnalisé.',
'no_attribute_definitions' => 'Aucune définition d’attribut',
'no_backup_dir' => 'Le répertoire de sauvegarde n’est pas défini.',
'no_current_version' => 'Vous utilisez une ancienne version de SeedDMS. La dernière version disponible est la [latestversion].',
'no_default_keywords' => 'Aucun mot-clé disponible',
'no_docs_checked_out' => 'Aucun document vérifié',
'no_docs_draft' => '',
'no_docs_expired' => 'Aucun document expiré',
'no_docs_locked' => 'Aucun document verrouillé',
'no_docs_needs_correction' => 'Aucun document ne nécessite de correction',
'no_docs_obsolete' => '',
'no_docs_rejected' => 'Aucun document rejeté.',
'no_docs_to_approve' => 'Aucun document ne nécessite actuellement une approbation',
'no_docs_to_look_at' => 'Aucun document à surveiller',
'no_docs_to_receipt' => 'Aucune confirmation de réception de document n’est requise',
'no_docs_to_review' => 'Aucun document en attente de vérification',
'no_docs_to_revise' => 'Il n’y a actuellement aucun document nécessitant d’être révisé.',
'no_email_or_login' => 'L’identifiant et l’e-mail doivent être saisis.',
'no_fulltextindex' => 'Aucun fichier d\'index disponibles',
'no_groups' => 'Aucun groupe',
'no_group_members' => 'Ce groupe ne contient aucun membre',
'no_linked_files' => 'Aucun fichier lié',
'no_mimetype' => '',
'no_previous_versions' => 'Aucune autre version trouvée',
'no_receipt_needed' => 'Il n’y a actuellement aucun document nécessitant une confirmation de réception.',
'no_review_needed' => 'Aucune vérification en attente',
'no_revision_date' => '',
'no_revision_needed' => 'Aucune révision en attente',
'no_revision_planed' => 'Aucune révision de document prévue',
'no_update_cause_locked' => 'Vous ne pouvez actuellement pas mettre à jour ce document. Contactez l\'utilisateur qui l\'a verrouillé.',
'no_user_image' => 'Aucune image trouvée',
'no_value_set' => '',
'no_version_check' => 'La vérification de l\'existence d\'une nouvelle version de SeedDMS a échoué ! Cela peut être causé par le paramètre allow_url_fopen défini à 0 dans votre configuration PHP.',
'no_version_modification' => 'Pas de modification de version',
'no_workflows' => 'Vous n’avez pas encore créé de workflow',
'no_workflow_available' => 'Aucun workflow disponible',
'number_count' => '',
'n_of_m_approved' => '',
'n_of_m_reviewed' => '',
'n_of_m_revised' => '',
'objectcheck' => 'Vérification des dossiers et documents',
'objects_without_attribute' => '',
'object_check_critical' => 'Erreurs critiques',
'object_check_warning' => 'Avertissements',
'objtype_unknown' => '',
'obsolete' => 'Obsolète',
'october' => 'Octobre',
'old' => 'Ancien',
'only_jpg_user_images' => 'Images d\'utilisateur au format .jpg seulement',
'operation_disallowed' => 'Opération non autorisée',
'orderby' => 'Trier par',
'orderby_date_asc' => 'Trier par date croissante',
'orderby_date_desc' => 'Trier par date décroissante',
'orderby_id_asc' => 'Trier par ID croissant',
'orderby_id_desc' => 'Trier par ID décroissant',
'orderby_name_asc' => 'Trier par nom croissant',
'orderby_name_desc' => 'Trier par nom décroissant',
'orderby_relevance' => '',
'orderby_unsorted' => 'Non trié',
'order_by_sequence_off' => 'Le tri par position est désactivé dans les préférences. Si vous souhaitez que ce paramètre prenne effet, vous devez l’activer.',
'original_filename' => 'Nom de fichier original',
'overall_indexing_progress' => 'Progression globale de l’indexation',
'owner' => 'Propriétaire',
'parent_folder' => '',
'password' => 'Mot de passe',
'password_already_used' => 'Mot de passe déjà utilisé',
'password_expiration' => 'Expiration du mot de passe',
'password_expiration_text' => 'Votre mot de passe a expiré. Veuillez en choisir un nouveau afin de pouvoir accéder à SeedDMS.',
'password_expired' => 'Mot de passe expiré',
'password_expires_in_days' => 'Le mot de passe expire dans %s jours.',
'password_forgotten' => 'Mot de passe oublié ?',
'password_forgotten_email_body' => 'Cher utilisateur, nous avons reçu une demande de modification de votre mot de passe.

Pour ce faire, cliquez sur le lien suivant:

[url_prefix]out/out.ChangePassword.php?hash=[hash]

En cas de problème persistant, veuillez contacter votre administrateur.',
'password_forgotten_email_body_html' => '<p>Cher utilisateur de SeedDMS,</p>

<p>Nous avons reçu une demande pour modifier votre mot de passe.</p>

<p>Pour ce faire, veuillez cliquer sur le lien suivant :</p>

<p>[url_prefix]out/out.ChangePassword.php?hash=[hash]</p>

<p>Si vous rencontrez toujours des problèmes pour vous connecter, veuillez contacter votre administrateur.</p>',
'password_forgotten_email_subject' => '[sitename] : Mot de passe oublié',
'password_forgotten_invalid_hash' => '',
'password_forgotten_invalid_hash_title' => '',
'password_forgotten_send_hash' => 'La procédure à suivre a bien été envoyée à l\'adresse indiquée',
'password_forgotten_text' => 'Remplissez le formulaire ci-dessous et suivez les instructions dans le courrier électronique qui vous sera envoyé.',
'password_forgotten_title' => 'Mot de passe envoyé',
'password_mismatch_error' => 'Les mots de passe ne correspondent pas',
'password_mismatch_error_title' => 'Les mots de passe ne correspondent pas',
'password_never_expires' => '',
'password_repeat' => 'Répétez le mot de passe',
'password_send' => 'Envoi du mot de passe',
'password_send_text' => 'Votre nouveau mot de passe a été envoyé à l\'adresse fournie (si l\'identifiant et l\'adresse e-mail correspondent à un utilisateur existant). Si vous ne recevez rien dans les minutes qui suivent, assurez-vous que l\'identifiant et l\'adresse e-mail sont corrects puis relancez le processus.',
'password_strength' => 'Fiabilité du mot de passe',
'password_strength_insuffient' => 'Mot de passe trop faible',
'password_wrong' => 'Mauvais mot de passe',
'pdf_converters' => 'Convertisseurs PDF',
'pending_approvals' => 'Approbations en attente',
'pending_receipt' => 'Réceptions en attente',
'pending_reviews' => 'Vérifications en attente',
'pending_revision' => 'Révisions en attente',
'pending_workflows' => 'Workflows en attente',
'personal_default_keywords' => 'Mots-clés personnels',
'php_info' => 'Informations PHP',
'pl_PL' => 'Polonais',
'possible_substitutes' => 'Substituts',
'preset_expires' => 'Expiration prédéfinie',
'preview' => 'Aperçu',
'preview_converters' => 'Conversion des documents pour prévisualisation',
'preview_images_text' => '',
'preview_markdown' => 'Prévisualisation',
'preview_pdf' => 'Prévisualisation en PDF',
'preview_plain' => 'Texte',
'preview_png' => 'Miniatures',
'preview_txt' => '',
'previous_state' => 'État précédent',
'previous_versions' => 'Versions précédentes',
'problematic_filename' => '',
'process' => 'Processus',
'process_without_user_group' => 'Processus sans utilisateur/groupe',
'pt_BR' => 'Portuguais (BR)',
'quota' => 'Quota',
'quota_exceeded' => 'Votre quota de disque est dépassé de [bytes].',
'quota_is_disabled' => 'La prise en charge des quotas est actuellement désactivée dans les réglages. Affecter un quota utilisateur n’aura pas d’effet jusqu’à ce qu’il soit de nouveau activé.',
'quota_warning' => 'Votre quota d’espace disque est dépassé de [bytes]. Veuillez supprimer des documents ou d\'anciennes versions.',
'readme_loading' => '',
'receipts_accepted' => '[no_receipts] réceptions déjà confirmées',
'receipts_accepted_latest' => '(dont [no_receipts] dans la dernière version)',
'receipts_not_touched' => '[no_receipts] réceptions non amorcées',
'receipts_not_touched_latest' => '(dont [no_receipts] dans la dernière version)',
'receipts_rejected' => '[no_receipts] réceptions déjà rejetées',
'receipts_rejected_latest' => '(dont [no_receipts] dans la dernière version)',
'receipts_without_group' => 'Réceptions sans groupe',
'receipts_without_user' => 'Réceptions sans utilisateur',
'receipt_deletion_email_body' => 'L’utilisateur a été retiré de la liste des destinataires

Document : [name]
Version : [version]
Dossier parent : [folder_path]
Destinataire : [recipient]
Utilisateur : [username]
URL : [url]',
'receipt_deletion_email_body_html' => '<p>L’utilisateur a été retiré de la liste des destinataires</p>

<p>Document : [name]<br />
Version : [version]<br />
Dossier parent : [folder_path]<br />
Destinataire : [recipient]<br />
Utilisateur : [username]<br />
URL : [url]</p>',
'receipt_deletion_email_subject' => '[sitename] : [name] - Destinataire supprimé',
'receipt_log' => 'Journal des réceptions',
'receipt_request_email_body' => 'Demande de réception

Document : [name]
Version : [version]
Dossier parent : [folder_path]
Utilisateur : [username]
URL : [url]',
'receipt_request_email_body_html' => '<p>Demande de réception</p>

<p>Document : [name]<br />
Version : [version]<br />
Dossier parent : [folder_path]<br />
Utilisateur : [username]<br />
URL : [url]</p>',
'receipt_request_email_subject' => '[sitename] : [name] - Demande de réception',
'receipt_status' => 'Statut',
'receipt_submit_email_body' => 'Réception faite

Document : [name]
Version : [version]
Statut : [status]
Commentaire : [comment]
Dossier parent : [folder_path]
Utilisateur : [username]
URL : [url]',
'receipt_submit_email_body_html' => '<p>Réception faite</p>

<p>Document : [name]<br />
Version : [version]<br />
Statut : [status]<br />
Commentaire : [comment]<br />
Dossier parent : [folder_path]<br />
Utilisateur : [username]<br />
URL : [url]</p>',
'receipt_submit_email_subject' => '',
'receipt_summary' => 'Récapitulatif réception',
'receipt_update_failed' => 'La confirmation de réception a échoué',
'recentchanges_mail_subject' => '',
'recent_uploads' => 'Téléchargements récents',
'reception' => 'Réception',
'reception_acknowleged' => 'Réception confirmée',
'reception_noaction' => 'Aucune action',
'reception_rejected' => 'Réception rejetée',
'recipients' => 'Destinataires',
'recipient_already_removed' => 'Le destinataire a déjà été supprimé ou a accusé réception.',
'record_type' => '',
'redraw' => 'Redessiner',
'refresh' => 'Actualiser',
'rejected' => 'Rejeté',
'released' => 'Publié',
'removed_approver' => 'a été retiré de la liste des approbateurs.',
'removed_file_email' => 'Attachement supprimé',
'removed_file_email_body' => 'Fichier attaché supprimé

Document : [document]
Utilisateur : [username]
URL : [url]',
'removed_file_email_body_html' => '<p>Fichier attaché supprimé</p>

<p>Document : [document]<br />
Utilisateur : [username]<br />
URL : [url]</p>',
'removed_file_email_subject' => '[sitename] : [document] - Fichier attaché supprimé',
'removed_recipient' => 'a été supprimé de la liste des destinataires.',
'removed_reviewer' => 'a été retiré de la liste des examinateurs.',
'removed_revisor' => 'a été supprimé de la liste des réviseurs.',
'removed_workflow_email_body' => 'Workflow du document supprimé

Document : [name]
Version : [version]
Workflow : [workflow]
Dossier parent : [folder_path]
Utilisateur : [username]
URL : [url]',
'removed_workflow_email_body_html' => '<p>Workflow du document supprimé</p>

<p>Document : [name]<br />
Version : [version]<br />
Workflow : [workflow]<br />
Dossier parent : [folder_path]<br />
Utilisateur : [username]<br />
URL : [url]</p>',
'removed_workflow_email_subject' => '[sitename] : [name] - Workflow retiré de la version du doument',
'removeFolderFromDropFolder' => 'Suppression du dossier après importation',
'removeFolderFromDropFolder_desc' => '',
'remove_approval_log' => 'Approbation retirée',
'remove_from_clipboard' => '',
'remove_marked_files' => 'Supprimer les fichiers sélectionnés',
'remove_review_log' => 'Vérification retirée',
'remove_task' => '',
'reorder' => '',
'reorder_documents_in_folder' => '',
'repaired' => 'réparé',
'repairing_objects' => 'Réparation des documents et des dossiers.',
'replace_content_email_body' => 'La dernière version du document a été remplacée.

Document : [name]
Version : [version]
Dossier parent : [folder_path]
Utilisateur : [username]
URL : [url]',
'replace_content_email_body_html' => '<p>La dernière version du document a été remplacée.</p>

<p>Document : [name]<br />
Version : [version]<br />
Dossier parent : [folder_path]<br />
Utilisateur : [username]<br />
URL : [url]</p>',
'replace_content_email_subject' => '[sitename] : [name] - Contenu du document remplacé',
'request_workflow_action_email_body' => 'Le workflow a atteint un état nécessitant une action de votre part.

Document : [name]
Version : [version]
Workflow : [workflow]
État actuel : [current_state]
Dossier parent : [folder_path]
Utilisateur : [username]
URL : [url]',
'request_workflow_action_email_body_html' => '<p>Le workflow a atteint un état nécessitant une action de votre part.</p>

<p>Document : [name]<br />
Version : [version]<br />
Workflow : [workflow]<br />
État actuel : [current_state]<br />
Dossier parent : [folder_path]<br />
Utilisateur : [username]<br />
URL : [url]</p>',
'request_workflow_action_email_subject' => '[sitename] : [name] - Action de Workflow requise',
'reset_checkout' => 'Terminer la vérification',
'restrict_access' => 'Pas d\'accès',
'results_page' => 'Page de résultats',
'return_from_subworkflow' => 'Revenir du sous-workflow',
'return_from_subworkflow_email_body' => 'Retour du sous-workflow

Document : [name]
Version : [version]
Workflow : [workflow]
Sous-workflow : [subworkflow]
Dossier parent : [folder_path]
Utilisateur : [username]
URL : [url]',
'return_from_subworkflow_email_body_html' => '<p>Retour du sous-workflow</p>

<p>Document : [name]<br />
Version : [version]<br />
Workflow : [workflow]<br />
Sous-workflow: [subworkflow]<br />
Dossier parent : [folder_path]<br />
Utilisateur : [username]<br />
URL : [url]</p>',
'return_from_subworkflow_email_subject' => 'Retour du sous-workflow',
'reverse_links' => 'Documents liés au document actuel',
'reviewers' => 'Examinateurs',
'reviewer_already_assigned' => 'est déjà déclaré en tant qu’examinateur',
'reviewer_already_removed' => 'L’examinateur a déjà été retiré du processus de vérification ou a déjà soumis la vérification.',
'reviews_accepted' => '[no_reviews] vérifications déjà confirmées',
'reviews_accepted_latest' => '(dont [no_reviews] dans la dernière version)',
'reviews_not_touched' => '[no_reviews] vérifications non amorcées',
'reviews_not_touched_latest' => '(dont [no_reviews] dans la dernière version)',
'reviews_rejected' => '[no_reviews] vérifications déjà rejetées',
'reviews_rejected_latest' => '(dont [no_reviews] dans la dernière version)',
'reviews_without_group' => 'Vérifications sans groupe',
'reviews_without_user' => 'Vérifications sans utilisateur',
'review_deletion_email' => 'Demande de vérification supprimée',
'review_deletion_email_body' => 'Demande de vérification supprimée

Document : [name]
Version : [version]
Dossier parent : [folder_path]
Utilisateur : [username]
URL : [url]',
'review_deletion_email_body_html' => '<p>Demande de vérification supprimée</p>

<p>Document : [name]<br />
Version : [version]<br />
Dossier parent : [folder_path]<br />
Utilisateur : [username]<br />
URL : [url]</p>',
'review_deletion_email_subject' => '[sitename] : [name] - Demande de vérification supprimée',
'review_file' => 'Fichier',
'review_group' => 'Groupe de vérification',
'review_log' => 'Journal des vérifications',
'review_request_email' => 'Demande de vérification',
'review_request_email_body' => 'Demande de vérification

Document : [name]
Version : [version]
Dossier parent : [folder_path]
Utilisateur : [username]
URL : [url]',
'review_request_email_body_html' => '<p>Demande de vérification</p>

<p>Document : [name]<br />
Version : [version]<br />
Dossier parent : [folder_path]<br />
Utilisateur : [username]<br />
URL : [url]</p>',
'review_request_email_subject' => '[sitename] : [name] - Demande de vérification',
'review_status' => 'Statut de vérification',
'review_submit_email' => 'Vérification faite',
'review_submit_email_body' => 'Vérification faite

Document : [name]
Version : [version]
Statut : [status]
Commentaire : [comment]
Dossier parent : [folder_path]
Utilisateur : [username]
URL : [url]',
'review_submit_email_body_html' => '<p>Vérification faite</p>

<p>Document : [name]<br />
Version : [version]<br />
Statut : [status]<br />
Commentaire : [comment]<br />
Dossier parent : [folder_path]<br />
Utilisateur : [username]<br />
URL : [url]</p>',
'review_submit_email_subject' => '[sitename] : [name] - Vérification faite',
'review_summary' => 'Récapitulatif vérification',
'review_update_failed' => 'Erreur lors de la mise à jour du statut de vérification. Échec de la mise à jour.',
'revise_document' => 'Réviser le document',
'revise_document_on' => 'Prochaine révision de la version du document le [date]',
'revision' => 'Révision',
'revisions_accepted' => '[no_revisions] révisions déjà confirmées',
'revisions_accepted_latest' => '(dont [no_revisions] dans la dernière version)',
'revisions_not_touched' => '[no_revisions] révisions non amorcées',
'revisions_not_touched_latest' => '(dont [no_revisions] dans la dernière version)',
'revisions_pending' => '[no_revisions] révisions à venir en attente',
'revisions_pending_latest' => '(dont [no_revisions] dans la dernière version)',
'revisions_rejected' => '[no_revisions] révisions déjà rejetées',
'revisions_rejected_latest' => '(dont [no_revisions] dans la dernière version)',
'revisions_without_group' => 'Révisions sans groupe',
'revisions_without_user' => 'Révisions sans utilisateur',
'revision_date' => 'Date de révision',
'revision_deletion_email_body' => '',
'revision_deletion_email_subject' => '',
'revision_log' => 'Journal des révisions',
'revision_request_email_body' => 'Demande de révision

Document : [name]
Version : [version]
Dossier parent : [folder_path]
Utilisateur : [username]
URL : [url]',
'revision_request_email_body_html' => '<p>Demande de révision</p>

<p>Document : [name]<br />
Version : [version]<br />
Dossier parent : [folder_path]<br />
Utilisateur : [username]<br />
URL : [url]</p>',
'revision_request_email_subject' => '[sitename] : [name] - Demande de révision',
'revision_status' => 'État',
'revision_submit_email_body' => 'Révision faite

Document : [name]
Version : [version]
Dossier parent : [folder_path]
Statut : [status]
Commentaire : [comment]
Utilisateur : [username]
URL : [url]',
'revision_submit_email_body_html' => '<p>Révision faite</p>

<p>Document : [name]<br />
Version : [version]<br />
Statut : [status]<br />
Commentaire : [comment]<br />
Dossier parent : [folder_path]<br />
Utilisateur : [username]<br />
URL : [url]</p>',
'revision_submit_email_subject' => '[sitename]: [name] - Publié à nouveau',
'revision_summary' => 'Récapitulatif révision',
'revisors' => 'Réviseurs',
'revisor_already_assigned' => 'L’utilisateur est déjà attribué en tant que réviseur.',
'revisor_already_removed' => 'Le réviseur a déjà été retiré du processus de révision ou a déjà révisé le document.',
'rewind_workflow' => 'Reculer le workflow',
'rewind_workflow_email_body' => 'Le workflow a été reculé

Document : [name]
Version : [version]
Workflow : [workflow]
Dossier parent : [folder_path]
Utilisateur : [username]
URL : [url]',
'rewind_workflow_email_body_html' => '<p>Le workflow a été reculé</p>

<p>Document : [name]<br />
Version : [version]<br />
Workflow : [workflow]<br />
Dossier parent : [folder_path]<br />
Utilisateur : [username]<br />
URL : [url]</p>',
'rewind_workflow_email_subject' => '[sitename] : [name] - Le workflow a été reculé',
'rewind_workflow_warning' => 'Si vous retournez à l’état initial du workflow, l’historique de workflow de ce document sera supprimé et ne pourra pas être restauré.',
'rm_attrdef' => 'Supprimer la définition d’attribut',
'rm_attrdefgroup' => 'Supprimer ce groupe d’attributs',
'rm_attr_value' => 'Supprimer la valeur',
'rm_default_keyword_category' => 'Supprimer la catégorie',
'rm_document' => 'Supprimer le document',
'rm_document_category' => 'Supprimer la catégorie',
'rm_event' => 'Supprimer l’événement',
'rm_file' => 'Supprimer le fichier',
'rm_folder' => 'Supprimer le dossier',
'rm_from_clipboard' => 'Supprimer du presse-papier',
'rm_group' => 'Supprimer ce groupe',
'rm_role' => 'Supprimer ce rôle',
'rm_task' => 'Supprimer la tâche',
'rm_transmittal' => 'Supprimer la transmission',
'rm_transmittalitem' => 'Supprimer l’élément',
'rm_user' => 'Supprimer cet utilisateur',
'rm_user_from_processes' => 'Retirer l’utilisateur des processus',
'rm_version' => 'Supprimer la version',
'rm_workflow' => 'Supprimer le Workflow',
'rm_workflow_action' => 'Supprimer l\'action du Workflow',
'rm_workflow_state' => 'Supprimer l\'état du Workflow',
'rm_workflow_warning' => 'Vous allez supprimer le workflow de ce document. Cette action ne pourra être annulée.',
'role' => 'Rôle',
'role_admin' => 'Administrateur',
'role_guest' => 'Invité',
'role_info' => 'Information',
'role_management' => 'Gestion des rôles',
'role_name' => 'Nom',
'role_type' => 'Type de rôle',
'role_user' => 'Utilisateur',
'ro_RO' => 'Roumain',
'run_subworkflow' => 'Lancer le sous-workflow',
'run_subworkflow_email_body' => 'Sous-workflow démarré

Document : [name]
Version : [version]
Workflow : [workflow]
Sous-workflow : [subworkflow]
Dossier parent : [folder_path]
Utilisateur : [username]
URL : [url]',
'run_subworkflow_email_body_html' => '<p>Sous-workflow démarré</p>

<p>Document : [name]<br />
Version : [version]<br />
Workflow : [workflow]<br />
Sous-workflow : [subworkflow]<br />
Dossier parent : [folder_path]<br />
Utilisateur : [username]<br />
URL : [url]</p>',
'run_subworkflow_email_subject' => '[sitename] : [name] - Sous-workflow initialisé',
'ru_RU' => 'Russe',
'saturday' => 'Samedi',
'saturday_abbr' => 'Sam.',
'save' => 'Enregistrer',
'scheduler_class' => 'Classe',
'scheduler_class_description' => 'Description',
'scheduler_class_parameter' => 'Paramètre',
'scheduler_class_tasks' => 'Tâches de la classe',
'scheduler_task_mgr' => 'Planificateur',
'search' => 'Recherche',
'search_fulltext' => 'Rechercher dans le texte',
'search_in' => 'Rechercher dans',
'search_mode' => 'Mode de recherche',
'search_mode_and' => 'tous les mots',
'search_mode_documents' => 'Seulement les documents',
'search_mode_folders' => 'Seulement les dossiers',
'search_mode_or' => 'au moins un mot',
'search_no_results' => 'Aucun document ne correspond à la recherche',
'search_query' => 'Rechercher',
'search_query_placeholder' => '',
'search_report' => '[doccount] documents trouvé(s) et [foldercount] dossiers en [searchtime] sec.',
'search_report_fulltext' => '[doccount] documents trouvé(s)',
'search_resultmode' => 'Résultat de la recherche',
'search_resultmode_both' => 'Documents et dossiers',
'search_results' => 'Résultats de recherche',
'search_results_access_filtered' => 'L\'accès à certains résultats de la recherche pourrait être refusé.',
'search_time' => 'Temps écoulé: [time] sec.',
'seconds' => 'secondes',
'seconds_ago' => '',
'seconds_from_now' => '',
'second_ago' => '',
'second_from_now' => '',
'seeddms_info' => 'Informations sur SeedDMS',
'seeddms_version' => 'Version de SeedDMS',
'selection' => 'Sélection',
'select_attrdef' => 'Sélectionner une définition d’attribut',
'select_attrdefgrp_show' => 'Sélectionner quand afficher',
'select_attribute_value' => 'Sélectionner la valeur de l’attribut',
'select_category' => 'Cliquer pour choisir une catégorie',
'select_created' => '',
'select_documents_for_process' => '',
'select_folder' => '',
'select_group' => 'Sélectionner un groupe',
'select_groups' => 'Cliquer pour choisir un groupe',
'select_grp_approvers' => 'Cliquer pour choisir un groupe d\'approbateur',
'select_grp_ind_approvers' => 'Cliquer pour choisir un groupe',
'select_grp_ind_notification' => 'Cliquer pour choisir un groupe',
'select_grp_ind_recipients' => 'Cliquer pour choisir un groupe',
'select_grp_ind_reviewers' => 'Cliquer pour choisir un groupe d’examinateurs',
'select_grp_ind_revisors' => 'Cliquer pour choisir un groupe',
'select_grp_notification' => 'Cliquer pour sélectionner une notification de groupe',
'select_grp_recipients' => 'Cliquer pour choisir un groupe de destinataires',
'select_grp_reviewers' => 'Cliquer pour choisir un groupe d’examinateurs',
'select_grp_revisors' => 'Cliquer pour choisir un groupe de réviseurs',
'select_ind_approvers' => 'Cliquer pour choisir un approbateur individuel',
'select_ind_notification' => 'Cliquer pour sélectionner une notification individuelle',
'select_ind_recipients' => 'Cliquer pour choisir un destinataire individuel',
'select_ind_reviewers' => 'Cliquer pour choisir un examinateur individuel',
'select_ind_revisors' => 'Cliquer pour choisir un réviseur individuel',
'select_mimetype' => 'Sélectionner un type MIME',
'select_modified' => '',
'select_one' => 'Selectionner',
'select_option' => '',
'select_owner' => 'Sélectionner un propriétaire',
'select_record_type' => '',
'select_status' => 'Cliquer pour sélectionner un statut',
'select_user' => 'Sélectionner un utilisateur',
'select_users' => 'Cliquer pour choisir un utilisateur',
'select_value' => 'Sélectionner une valeur',
'select_workflow' => 'Sélectionner un workflow',
'send_email' => 'Envoyer un e-mail',
'send_login_data' => 'Envoyer les informations de connexion',
'send_login_data_body' => 'Informations de connexion

Identifiant : [login]
Nom : [username]

[comment]',
'send_login_data_subject' => '[sitename] : [login] - Vos informations de connexion',
'send_notification' => '',
'send_test_mail' => 'Envoyer un e-mail test',
'september' => 'Septembre',
'sequence' => 'Position dans le dossier',
'seq_after' => 'Après "[prevname]"',
'seq_end' => 'À la fin',
'seq_keep' => 'Conserver la position',
'seq_start' => 'Première position',
'service_has_filter' => '',
'service_list_from' => '',
'service_list_info' => '',
'service_list_to' => '',
'service_name' => '',
'sessions' => 'Utilisateurs en ligne',
'setDateFromFile' => 'Reprendre la date du fichier importé',
'setDateFromFile_desc' => '',
'setDateFromFolder' => 'Reprendre la date du dossier importé',
'setDateFromFolder_desc' => '',
'settings' => 'Configuration',
'settings_activate_module' => 'Activez le module',
'settings_activate_php_extension' => 'Activez l\'extension PHP',
'settings_addManagerAsApprover' => '',
'settings_addManagerAsApprover_desc' => '',
'settings_addManagerAsReviewer' => '',
'settings_addManagerAsReviewer_desc' => '',
'settings_adminIP' => 'Admin IP',
'settings_adminIP_desc' => 'Si activé l\'administrateur ne peut se connecter que par l\'adresse IP spécifiées, laisser vide pour éviter le contrôle. NOTE: fonctionne uniquement avec autentication locale (sans LDAP)',
'settings_Advanced' => 'Avancé',
'settings_advancedAcl' => 'Contrôle d’accès avancé',
'settings_advancedAcl_desc' => 'Le contrôle d’accès avancé permet d’activer/désactiver certains modules du logiciel. Il ne peut pas être utilisé pour les droits d’accès sur les documents et dossiers.',
'settings_allowChangeRevAppInProcess' => 'Autoriser le changement de réviseurs / approbateurs après le début du processus',
'settings_allowChangeRevAppInProcess_desc' => 'Par défaut, les réviseurs et les approbateurs ne peuvent plus être modifiés une fois la soumission d’un examen ou d’une approbation. Cette option permettra aux administrateurs de le faire tant que le document n’est pas publié ou rejeté.',
'settings_allowReviewerOnly' => 'Permettre d’affecter l’examinateur uniquement',
'settings_allowReviewerOnly_desc' => 'Activer cette option pour permettre d’affecter un examinateur mais pas d’approbateur dans le mode de Workflow traditionnel.',
'settings_alwaysShowClipboard' => '',
'settings_alwaysShowClipboard_desc' => '',
'settings_alwaysShowMenuTasks' => '',
'settings_alwaysShowMenuTasks_desc' => '',
'settings_apache_mod_rewrite' => 'Apache - Module Rewrite',
'settings_apiKey' => 'Clé d’authentification pour l’API REST',
'settings_apiKey_desc' => 'Cette clé est utilisée pour l’authentification alternative via l\'API REST. Utilisez une chaîne de 32 caractères.',
'settings_apiOrigin' => 'Origines autorisées pour les appels à l’API',
'settings_apiOrigin_desc' => 'Liste d’adresses séparées par des points-virgules qui sont autorisées à accéder à l’API REST. Chaque adresse doit être spécifiée sous la forme <protocole>://<domaine>[:<port>]. Le port est facultatif. Si ce champ reste vide, l’accès est libre.',
'settings_apiUserId' => 'Utilisateur de l’API REST',
'settings_apiUserId_desc' => 'Cet utilisateur sera utilisé par l\'API REST, à condition que l’authentification par clé API soit configurée.',
'settings_Authentication' => 'Paramètres d\'authentification',
'settings_autoLoginUser' => 'Connexion automatique',
'settings_autoLoginUser_desc' => 'Utiliser l’ID de cet utilisateur pour se connecter automatiquement. Ce type d’accès ne permet pas la création de nouveaux comptes.',
'settings_available_languages' => 'Langues disponibles',
'settings_available_languages_desc' => 'Seules les langues sélectionnées seront chargées et proposées dans le sélecteur de langue. La langue par défaut est systématiquement chargée.',
'settings_backupDir' => 'Répertoire de sauvegarde',
'settings_backupDir_desc' => 'Répertoire dans lequel l’outil de sauvegarde stocke les sauvegardes. Si aucune valeur n’est définie ou si le répertoire n’est pas accessible, les sauvegardes seront stockées dans le répertoire de contenu.',
'settings_baseUrl' => '',
'settings_baseUrl_desc' => '',
'settings_batchOperations' => '',
'settings_batchOperations_desc' => '',
'settings_cacheDir' => 'Répertoire Cache',
'settings_cacheDir_desc' => 'Lieu de stockage des images de prévisualisation (choisir de préférence un dossier non accessible à travers le web-server)',
'settings_Calendar' => 'Paramètres de l\'agenda',
'settings_calendarDefaultView' => 'Vue par défaut de l\'agenda',
'settings_calendarDefaultView_desc' => 'Vue par défaut de l\'agenda',
'settings_cannot_disable' => 'Le fichier ENABLE_INSTALL_TOOL ne peut pas être supprimé',
'settings_checkOutDir' => 'Répertoire pour les documents vérifiés',
'settings_checkOutDir_desc' => 'Il s’agit du répertoire dans lequel le dernier contenu d’un document est copié si le document est vérifié. Si vous rendez ce répertoire accessible aux utilisateurs, ils peuvent modifier le fichier et le refaire vérifier une fois terminé.',
'settings_cmdTimeout' => 'Délai d\'expiration pour les commandes externes',
'settings_cmdTimeout_desc' => 'Cette durée en secondes détermine quand une commande externe (par exemple pour la création de l\'index de texte intégral) sera terminée.',
'settings_conf_field_not_editable' => 'Cette valeur n’est pas modifiable',
'settings_contentDir' => 'Répertoire du contenu',
'settings_contentDir_desc' => 'Endroit ou les fichiers téléchargés sont stockés (il est préférable de choisir un répertoire qui n\'est pas accessible par votre serveur web)',
'settings_contentOffsetDir' => 'Content Offset Directory',
'settings_contentOffsetDir_desc' => 'To work around limitations in the underlying file system, a new directory structure has been devised that exists within the content directory (Content Directory). This requires a base directory from which to begin. Usually leave this to the default setting, 1048576, but can be any number or string that does not already exist within (Content Directory)',
'settings_convertToPdf' => 'Convertir en PDF le document pour prévisualisation',
'settings_convertToPdf_desc' => 'Si le document ne peut pas être lu nativement par le navigateur, une version convertie en PDF sera affichée.',
'settings_cookieLifetime' => 'Durée de vie des Cookies',
'settings_cookieLifetime_desc' => 'Durée de vie d’un cookie en secondes. Si cette valeur est définie à 0, le cookie sera supprimé à la fermeture du navigateur.',
'settings_coreDir' => 'Répertoire Core SeedDMS',
'settings_coreDir_desc' => 'Chemin vers SeedDMS_Core (optionnel)',
'settings_createCheckOutDir' => 'Dossier de blocage',
'settings_createCheckOutDir_desc' => 'Les versions du document seront copiées dans ce dossier lorsqu’un document est bloqué (check-out).',
'settings_createdatabase' => 'Créer tables de la base de données',
'settings_createdirectory' => 'Créer répertoire',
'settings_currentvalue' => 'Valeur actuelle',
'settings_Database' => 'Paramètres base de données',
'settings_dateformat' => 'Format de date',
'settings_dateformat_desc' => 'Ce format de date utilise la syntaxe de la fonction PHP date()',
'settings_datetimeformat' => 'Format de date/heure',
'settings_datetimeformat_desc' => 'Ce format de date utilise la syntaxe de la fonction PHP date()',
'settings_daysPastDashboard' => '',
'settings_daysPastDashboard_desc' => '',
'settings_dbDatabase' => 'Base de données',
'settings_dbDatabase_desc' => 'Le nom de votre base de données entré pendant le processus d\'installation. Ne pas modifier le champ sauf si absolument nécessaire, par exemple si la base de données a été déplacé.',
'settings_dbDriver' => 'Type base de données',
'settings_dbDriver_desc' => 'Le type de base de données en cours d\'utilisation entré pendant le processus d\'installation. Ne pas modifier ce champ sauf si vous voulez migrer vers un autre type de base de données peut-être en raison de changement d’hébergement. Type de driver BD utilisé par adodb (voir adodb-readme)',
'settings_dbHostname' => 'Nom du serveur',
'settings_dbHostname_desc' => 'Le nom d\'hôte de votre base de données entré pendant le processus d\'installation. Ne pas modifier le champ sauf si vraiment nécessaire, par exemple pour le transfert de la base de données vers un nouvel hébergement.',
'settings_dbPass' => 'Mot de passe',
'settings_dbPass_desc' => 'Le mot de passe pour accéder à votre base de données entré pendant le processus d\'installation.',
'settings_dbUser' => 'Nom d\'utilisateur',
'settings_dbUser_desc' => 'Le nom d\'utilisateur pour l\'accès à votre base de données entré pendant le processus d\'installation. Ne pas modifier le champ sauf si vraiment nécessaire, par exemple pour le transfert de la base de données vers un nouvel hébergement.',
'settings_dbVersion' => 'Schéma de base de données trop ancien',
'settings_defaultAccessDocs' => 'Accès par défaut des nouveaux documents',
'settings_defaultAccessDocs_desc' => 'Lors de la création d’un nouveau document, ce droit d’accès sera appliqué par défaut.',
'settings_defaultDocPosition' => 'Position du document à sa création',
'settings_defaultDocPosition_desc' => 'Position par défaut lors de la création d\'un document dans un dossier.',
'settings_defaultDocPosition_val_end' => 'fin',
'settings_defaultDocPosition_val_start' => 'début',
'settings_defaultFolderPosition' => 'Position du dossier à sa création',
'settings_defaultFolderPosition_desc' => 'Position par défaut lors de la création d\'un dossier.',
'settings_defaultSearchMethod' => 'Méthode de recherche par défaut',
'settings_defaultSearchMethod_desc' => 'Méthode de recherche par défaut, lorsque la recherche est exécutée depuis le moteur de recherche du menu principal',
'settings_defaultSearchMethod_valdatabase' => 'base de données',
'settings_defaultSearchMethod_valfulltext' => 'Plein texte (contenu)',
'settings_defaultThumbnailClick' => '',
'settings_defaultThumbnailClick_desc' => '',
'settings_defaultThumbnailClick_valdownload' => '',
'settings_defaultThumbnailClick_valviewonline' => '',
'settings_delete_install_folder' => 'Pour utiliser SeedDMS, vous devez supprimer le fichier ENABLE_INSTALL_TOOL dans le répertoire de configuration',
'settings_disableChangePassword' => '',
'settings_disableChangePassword_desc' => '',
'settings_disableReceiptComment' => '',
'settings_disableReceiptComment_desc' => '',
'settings_disableSelfEdit' => 'Désactiver auto modification',
'settings_disableSelfEdit_desc' => 'Si coché, l\'utilisateur ne peut pas éditer son profil',
'settings_disable_install' => 'Si possible, supprimer le fichier ENABLE_INSTALL_TOOL',
'settings_Display' => 'Paramètres d\'affichage',
'settings_dropFolderDir' => 'Répertoire de dépôt de fichier sur le serveur',
'settings_dropFolderDir_desc' => 'Ce répertoire peut être utilisé pour déposer des fichiers sur le serveur et les importer à partir d\'ici au lieu de les charger à partir du navigateur. Le répertoire doit avoir un sous-répertoire pour chaque utilisateur autorisé à importer des fichiers de cette manière.',
'settings_Edition' => 'Paramètres d’édition',
'settings_editOnlineFileTypes' => 'Types de fichiers éditables',
'settings_editOnlineFileTypes_desc' => 'Le contenu des fichiers portant les extensions ou types MIME précisés pourra être modifié en ligne (utiliser des lettres minuscules)',
'settings_enable2FactorAuthentication' => 'Activer l’authentification forte',
'settings_enable2FactorAuthentication_desc' => 'Active/désactive l\'authentification forte à 2 facteurs. Les utilisateurs devront installer Google Authenticator sur leur téléphone mobile.',
'settings_enableAcknowledgeWorkflow' => '',
'settings_enableAcknowledgeWorkflow_desc' => '',
'settings_enableAdminReceipt' => 'Réception de document autorisée par l’administrateur',
'settings_enableAdminReceipt_desc' => 'Activer cette option pour permettre aux administrateurs d’être listés en tant que destinataires.',
'settings_enableAdminRevApp' => 'Autoriser vérification/approbation par les administrateurs',
'settings_enableAdminRevApp_desc' => 'Activer cette option pour ajouter les administrateurs à la liste des examinateurs/approbateurs et pour les transitions de workflow.',
'settings_enableCalendar' => 'Activer l\'agenda',
'settings_enableCalendar_desc' => 'Active/désactive l\'agenda',
'settings_enableCancelCheckout' => 'Autoriser l’annulation des vérifications',
'settings_enableCancelCheckout_desc' => 'Si coché, un document vérifié qui a déjà été modifié pourra être abandonné.',
'settings_enableClipboard' => 'Activer le presse-papier',
'settings_enableClipboard_desc' => 'Active/désactive le presse-papier',
'settings_enableConverting' => 'Activer conversion des fichiers',
'settings_enableConverting_desc' => 'Active/désactive la conversion des fichiers',
'settings_enableDebugMode' => 'Mode débogage',
'settings_enableDebugMode_desc' => 'Permet d’activer le mode débogage en ajoutant un nouveau menu dans les outils d’administration',
'settings_enableDropFolderList' => 'Activer la liste des fichiers du dossier de dépôt',
'settings_enableDropFolderList_desc' => 'Affiche un menu avec la liste des fichiers qui se trouvent dans le dossier de dépôt.',
'settings_enableDropUpload' => 'Activer la publication rapide de documents',
'settings_enableDropUpload_desc' => 'Active/désactive la zone de glisser-déposer sur la page d’un dossier afin d’y déposer des fichiers.',
'settings_enableDuplicateDocNames' => 'Autoriser plusieurs documents de même nom',
'settings_enableDuplicateDocNames_desc' => 'Autorise plusieurs documents de même nom dans un même dossier.',
'settings_enableDuplicateSubFolderNames' => 'Autoriser les sous-dossiers de même nom',
'settings_enableDuplicateSubFolderNames_desc' => 'Autorise plusieurs sous-dossiers de même nom dans un dossier.',
'settings_enableEmail' => 'E-mails',
'settings_enableEmail_desc' => 'Active/désactive la notification automatique par e-mail',
'settings_enableExtensionDownload' => 'Autoriser le téléchargement d\'extensions',
'settings_enableExtensionDownload_desc' => 'Activez cette option pour autoriser le téléchargement des extensions.',
'settings_enableExtensionImport' => 'Autoriser l\'import d\'extensions',
'settings_enableExtensionImportFromRepository' => 'Autoriser l\'import d\'extensions depuis le dépôt',
'settings_enableExtensionImportFromRepository_desc' => 'Activez cette option pour autoriser l\'importation des extensions depuis le dépôt.',
'settings_enableExtensionImport_desc' => 'Activez cette option pour autoriser l\'importation des extensions.',
'settings_enableFilterReceipt' => 'Éliminer des propriétaires, examinateurs… d’une liste de destinataires',
'settings_enableFilterReceipt_desc' => 'Activez cette option pour éliminer certains destinataires d’une liste s’ils sont entrés en tant que membres d’un groupe.',
'settings_enableFolderTree' => 'Activer l\'arborescence des dossiers',
'settings_enableFolderTree_desc' => 'Active/désactive l’arborescence des dossiers sur la page de consultation d’un dossier',
'settings_enableFullSearch' => 'Activer la recherche plein texte',
'settings_enableFullSearch_desc' => 'Activer la recherche plein texte (dans le contenu des fichiers).',
'settings_enableGuestAutoLogin' => 'Activer la connexion automatique pour le compte invité',
'settings_enableGuestAutoLogin_desc' => 'Si le compte invité et la connexion automatique sont activés alors le compte invité sera connecté automatiquement.',
'settings_enableGuestLogin' => 'Activer la connexion Invité',
'settings_enableGuestLogin_desc' => 'Si vous voulez vous connecter en tant qu\'invité, cochez cette option. Remarque: l\'utilisateur invité ne doit être utilisé que dans un environnement de confiance',
'settings_enableHelp' => 'Activer l\'aide',
'settings_enableHelp_desc' => 'Active/désactive le lien vers les écrans d’aide dans le menu',
'settings_enableHiddenReceipt' => '',
'settings_enableHiddenReceipt_desc' => '',
'settings_enableHiddenRevApp' => '',
'settings_enableHiddenRevApp_desc' => '',
'settings_enableLanguageSelector' => 'Activer la sélection de langue',
'settings_enableLanguageSelector_desc' => 'Montrer le sélecteur de langue d\'interface après connexion de l\'utilisateur.',
'settings_enableLargeFileUpload' => 'Activer le dépôt de fichiers très volumineux',
'settings_enableLargeFileUpload_desc' => 'Si défini, le téléchargement de fichier est également disponible via un applet java appelé jumploader sans limite de taille définie par le navigateur. Il permet également de télécharger plusieurs fichiers en une seule fois.',
'settings_enableLoginByEmail' => '',
'settings_enableLoginByEmail_desc' => '',
'settings_enableMemcached' => '',
'settings_enableMemcached_desc' => '',
'settings_enableMenuTasks' => 'Activer le menu des tâches',
'settings_enableMenuTasks_desc' => 'Affiche un menu avec la liste des tâches. Cette liste contient les documents en attente d’une action par l’utilisateur.',
'settings_enableMenuTransmittals' => '',
'settings_enableMenuTransmittals_desc' => '',
'settings_enableMultiUpload' => 'Autoriser le dépôt de plusieurs fichiers',
'settings_enableMultiUpload_desc' => 'Lors de la création d’un document, autoriser le dépôt de plusieurs fichiers à la fois. Un nouveau document sera créé pour chaque fichier.',
'settings_enableNotificationAppRev' => 'Notification examinateur/approbateur',
'settings_enableNotificationAppRev_desc' => 'Cocher pour envoyer une notification à l’examinateur/approbateur quand une nouvelle version du document est ajoutée.',
'settings_enableNotificationWorkflow' => 'Envoyer les notifications aux utilisateurs dans le prochain workflow',
'settings_enableNotificationWorkflow_desc' => 'Si cette option est activée, les utilisateurs et les groupes qui doivent intervenir dans la prochaine transition du workflow seront notifiés. Même s\'ils n\'ont pas demandé de notification pour le document.',
'settings_enableOwnerNotification' => 'Activer la notification du propriétaire par défaut',
'settings_enableOwnerNotification_desc' => 'Cocher pour ajouter une notification pour le propriétaire si un document quand il est ajouté.',
'settings_enableOwnerReceipt' => 'Réception de document autorisée par le propriétaire',
'settings_enableOwnerReceipt_desc' => 'Activer cette option pour permettre au propriétaire du document d’être listé en tant que destinataire.',
'settings_enableOwnerRevApp' => 'Autoriser vérification/approbation par le propriétaire',
'settings_enableOwnerRevApp_desc' => 'Activer cette option pour ajouter le propriétaire du document à la liste des examinateurs/approbateurs et pour les transitions de workflow.',
'settings_enablePasswordForgotten' => 'Activer Mot de passe oublié',
'settings_enablePasswordForgotten_desc' => 'Si vous voulez permettre à l\'utilisateur de définir un nouveau mot de passe et l\'envoyer par mail, cochez cette option.',
'settings_enableReceiptReject' => 'Activer le rejet de réceptions',
'settings_enableReceiptReject_desc' => 'Activer cette option pour permettre de rejeter des réceptions.',
'settings_enableReceiptWorkflow' => 'Activer la réception de document',
'settings_enableReceiptWorkflow_desc' => 'Activer cette option pour permettre de confirmer la réception de document dans le workflow.',
'settings_enableRecursiveCount' => 'Décompte récursif des documents/dossiers',
'settings_enableRecursiveCount_desc' => 'Si activé, le nombre de documents et répertoires dans un répertoire est calculé en comptant récursivement le contenu des sous-répertoires auxquels l\'utilisateur a accès.',
'settings_enableRemoveRevApp' => 'Autoriser la suppression d’une vérification/approbation existante',
'settings_enableRemoveRevApp_desc' => 'Activer cette option si les administrateurs peuvent retirer une vérification/approbation. Ceci ne supprimera pas la vérification/approbation de la base de données mais ajoutera une nouvelle entrée dans le journal des vérifications/approbations à son statut initial.',
'settings_enableRevisionOneVoteReject' => 'Rejet par un réviseur',
'settings_enableRevisionOneVoteReject_desc' => 'Si cette option est activée, le statut du document sera défini sur « nécessite une correction » une fois que le premier réviseur a rejeté le document. Si elle est désactivée, le statut du document ne changera pas jusqu’à ce que tous les réviseurs aient terminé leur révision.',
'settings_enableRevisionOnVoteReject' => '',
'settings_enableRevisionOnVoteReject_desc' => '',
'settings_enableRevisionWorkflow' => 'Activer la révision des documents',
'settings_enableRevisionWorkflow_desc' => 'Activer afin de pouvoir lancer un flux de travail pour réviser un document après une période donnée.',
'settings_enableSelfReceipt' => 'Permettre la réception de documents par l’utilisateur connecté',
'settings_enableSelfReceipt_desc' => 'Activez cette option si vous souhaitez que l’utilisateur actuellement connecté puisse être sélectionné comme destinataire du document.',
'settings_enableSelfRevApp' => 'Autoriser vérification/approbation par l’utilisateur actuel',
'settings_enableSelfRevApp_desc' => 'Activer cette option pour ajouter l’utilisateur actuel à la liste des examinateurs/approbateurs et pour les transitions de workflow.',
'settings_enableSessionList' => 'Activer la liste des utilisateurs en ligne',
'settings_enableSessionList_desc' => 'Affiche un menu avec la liste des utilisateurs connectés.',
'settings_enableThemeSelector' => 'Sélection du thème',
'settings_enableThemeSelector_desc' => 'Active/désactive le sélecteur de thème sur la page de connexion.',
'settings_enableUpdateReceipt' => 'Réception de document modifiable',
'settings_enableUpdateReceipt_desc' => 'Activer cette option pour permettre à l’utilisateur qui a accusé une réception de modifier sa décision.',
'settings_enableUpdateRevApp' => 'Autoriser la modification des vérifications/approbations existantes',
'settings_enableUpdateRevApp_desc' => 'A activer si l\'utilisateur qui a fait la révision/approbations peut changer sa position alors que l\'étape actuelle du processus n\'est pas terminée',
'settings_enableUserImage' => 'Activer images utilisateurs',
'settings_enableUserImage_desc' => 'Active/désactive les images des utilisateurs',
'settings_enableUsersView' => 'Activer Vue des Utilisateurs',
'settings_enableUsersView_desc' => 'Active/désactive la liste des groupes et utilisateurs pour tous les utilisateurs',
'settings_enableVersionDeletion' => 'Suppression des versions précédentes',
'settings_enableVersionDeletion_desc' => 'Active/désactive la suppression des versions antérieures de documents par les utilisateurs normaux. L’administrateur peut toujours supprimer les anciennes versions.',
'settings_enableVersionModification' => 'Modification des versions',
'settings_enableVersionModification_desc' => 'Active/désactive la modification de version d’un document par les utilisateurs normaux après le dépôt. L’administrateur peut toujours modifier la version après le dépôt.',
'settings_enableWebdavReplaceDoc' => 'Remplacer le document lors de l’enregistrement',
'settings_enableWebdavReplaceDoc_desc' => 'Si activé, l’enregistrement d’une nouvelle version d’un document remplacera l’ancien document plutôt que de créer une nouvelle version. Cela s’appliquera uniquement si l’utilisateur, le type MIME et le nom du fichier sont identiques à la dernière version. Cela peut être utile quand les applications enregistrent automatiquement un document à intervalles fixes.',
'settings_enableXsendfile' => 'Utiliser le module apache xsendfile',
'settings_enableXsendfile_desc' => 'Si cette option est définie et que le module apache xsendfile est installé, il sera utilisé pour la livraison des images.',
'settings_encryptionKey' => 'Clé de cryptage',
'settings_encryptionKey_desc' => 'Cette chaîne est utilisée pour créer un identifiant unique étant ajouté comme champ masqué à un formulaire afin de prévenir des attaques CSRF.',
'settings_error' => 'Erreur',
'settings_excludeFoldersDashboard' => '',
'settings_excludeFoldersDashboard_desc' => '',
'settings_expandFolderTree' => 'Dérouler l\'arborescence des dossiers',
'settings_expandFolderTree_desc' => 'Dérouler l\'arborescence des dossiers',
'settings_expandFolderTree_val0' => 'Démarrer avec l\'arborescence cachée',
'settings_expandFolderTree_val1' => 'Démarrer avec le premier niveau déroulé',
'settings_expandFolderTree_val2' => 'Démarrer avec l\'arborescence déroulée',
'settings_ExtensionMgr' => 'Paramètres des extensions',
'settings_Extensions' => 'Extensions',
'settings_extraPath' => 'Chemin d’inclusion supplémentaire PHP',
'settings_extraPath_desc' => 'Chemin vers des logiciels supplémentaires. Il s’agit du répertoire contenant par exemple le répertoire ADOdb ou des paquets PEAR supplémentaires.',
'settings_firstDayOfWeek' => 'Premier jour de la semaine',
'settings_firstDayOfWeek_desc' => 'Premier jour de la semaine',
'settings_footNote' => 'Note de bas de page',
'settings_footNote_desc' => 'Message à afficher au bas de chaque page',
'settings_fullSearchEngine' => 'Moteur de recherche plein texte',
'settings_fullSearchEngine_desc' => 'Définissez la méthode utilisée pour la recherche complète de texte.',
'settings_fullSearchEngine_vallucene' => 'Zend Lucene',
'settings_fullSearchEngine_valsqlitefts' => 'SQLiteFTS',
'settings_globalApprover' => '',
'settings_globalApprover_desc' => '',
'settings_globalGroupApprover' => '',
'settings_globalGroupApprover_desc' => '',
'settings_globalGroupReviewer' => '',
'settings_globalGroupReviewer_desc' => '',
'settings_globalReviewer' => '',
'settings_globalReviewer_desc' => '',
'settings_global_approver_is_admin' => '',
'settings_global_reviewer_is_admin' => '',
'settings_guestID' => 'ID invité',
'settings_guestID_desc' => 'ID de l\'invité utilisé lorsque vous êtes connecté en tant qu\'invité (la plupart du temps pas besoin de changer)',
'settings_guestid_is_admin' => 'L’utilisateur invité est administrateur',
'settings_guestid_is_disabled' => 'L’utilisateur invité est désactivé',
'settings_httpRoot' => 'Racine HTTP',
'settings_httpRoot_desc' => 'Le chemin relatif dans l\'URL, après le nom de domaine. Ne pas inclure le préfixe http:// ou le nom d\'hôte Internet. Par exemple Si l\'URL complète est http://www.example.com/letodms/, mettez \'/letodms/\'. Si l\'URL est http://www.example.com/, mettez \'/\'',
'settings_incItemsPerPage' => 'Nombre d\'entrées chargées à la fin de la page',
'settings_incItemsPerPage_desc' => 'Si le nombre de dossiers et de documents est limité, le nombre d\'objets supplémentaires chargés sera défini lors du défilement vers le bas de la page du dossier d\'affichage. Mettre à 0, chargera le même nombre d\'objets qu\'a été initialement chargé.',
'settings_initialDocumentStatus' => 'État initial d’un document',
'settings_initialDocumentStatus_desc' => 'État du document défini lors de l’ajout',
'settings_initialDocumentStatus_draft' => 'ébauche',
'settings_initialDocumentStatus_released' => 'publié',
'settings_inlineEditing' => 'Édition en ligne',
'settings_inlineEditing_desc' => 'Permet d’éditer le nom du document directement depuis la page des détails.',
'settings_installADOdb' => 'Installer ADOdb',
'settings_install_disabled' => 'Le fichier ENABLE_INSTALL_TOOL a été supprimé. Vous pouvez maintenant vous connecter à SeedDMS et poursuivre la configuration.',
'settings_install_pear_package_log' => 'Installer le paquet Pear \'Log\'',
'settings_install_pear_package_webdav' => 'Installer le paquet Pear \'HTTP_WebDAV_Server\', si vous avez l\'intention d\'utiliser l\'interface webdav',
'settings_install_success' => 'L\'installation est terminée avec succès',
'settings_install_welcome_text' => '<p>Avant de commencer l\'installation de SeedDMS, assurez-vous d\'avoir créé un fichier \'ENABLE_INSTALL_TOOL\' dans votre répertoire de configuration, sinon l\'installation ne fonctionnera pas. Sur des systèmes Unix, cela peut se faire simplement avec \'touch / ENABLE_INSTALL_TOOL\'. Une fois l\'installation terminée, supprimez le fichier.</p><p>SeedDMS a des exigences très minimes. Vous aurez besoin d\'une base de données MySQL ou SQLite et d\'un serveur web PHP. Le package Pear "Log" doit également être installé. Pour la recherche via Lucene, vous devez également installer le framework Zend sur le disque à un emplacement accessible par PHP. Pour le serveur WebDAV, vous aurez besoin d\'installer HTTP_WebDAV_Server. Le chemin d’accès peut être défini ultérieurement pendant l’installation.</p><p>Si vous préférez créer la base de données avant de commencer l\'installation, créez la manuellement avec votre outil favori, créez éventuellement un utilisateur de base de données avec accès sur la base et importez un export de base du répertoire de configuration. Le script d\'installation peut le faire pour vous, mais il requiert un accès à la base de données avec les droits suffisants pour créer des bases de données.</p>',
'settings_install_welcome_title' => 'Bienvenue dans l\'installation de SeedDMS',
'settings_install_zendframework' => 'Installez Zend Framework si vous avez l’intention d’utiliser le moteur de recherche plein texte basé sur Zend. Sinon, continuez l’installation en ignorant ce message.',
'settings_invalid_guestid' => 'Utilisateur invité invalide',
'settings_language' => 'Langue par défaut',
'settings_language_desc' => 'Langue par défaut (nom d\'un sous-dossier dans le dossier "languages")',
'settings_libraryFolder' => 'Dossier bibliothèque',
'settings_libraryFolder_desc' => 'Dossier dans lequel les documents peuvent être copiés pour en créer de nouveaux.',
'settings_logFileEnable' => 'Fichier journal activé',
'settings_logFileEnable_desc' => 'Active/désactive le fichier journal',
'settings_logFileMaxLevel' => '',
'settings_logFileMaxLevel_desc' => '',
'settings_logFileRestApiMaxLevel' => '',
'settings_logFileRestApiMaxLevel_desc' => '',
'settings_logFileRotation' => 'Rotation fichier journal',
'settings_logFileRotation_desc' => 'Rotation fichier journal',
'settings_loginFailure' => 'Max. échecs de connexion',
'settings_loginFailure_desc' => 'Désactiver le compte après n échecs de connexion.',
'settings_logLevelAlert' => '',
'settings_logLevelCritical' => '',
'settings_logLevelDebug' => '',
'settings_logLevelEmergency' => '',
'settings_logLevelError' => '',
'settings_logLevelInfo' => '',
'settings_logLevelNotice' => '',
'settings_logLevelWarning' => '',
'settings_luceneClassDir' => 'Répertoire Lucene SeedDMS',
'settings_luceneClassDir_desc' => 'Chemin vers SeedDMS_Lucene (optionnel)',
'settings_luceneDir' => 'Répertoire index Lucene',
'settings_luceneDir_desc' => 'Chemin vers index Lucene',
'settings_manager_approver_is_admin' => '',
'settings_manager_reviewer_is_admin' => '',
'settings_markdownComments' => '',
'settings_markdownComments_desc' => '',
'settings_maxDirID' => 'Nombre max. de sous-dossiers',
'settings_maxDirID_desc' => 'Nombre maximum de sous-répertoires par le répertoire parent. Par défaut: 0.',
'settings_maxExecutionTime' => 'Temps d\'exécution max (s)',
'settings_maxExecutionTime_desc' => 'Ceci définit la durée maximale, en secondes, pendant laquelle un script est autorisé à s’exécuter avant d’être interrompu.',
'settings_maxItemsPerPage' => 'Nombre d’éléments max. sur une page',
'settings_maxItemsPerPage_desc' => 'Limite le nombre de dossiers et de documents affichés sur la page du dossier de visualisation. D\'autres objets seront chargés lors du défilement jusqu\'à la fin de la page. Réglez sur 0 pour toujours afficher tous les objets.',
'settings_maxRecursiveCount' => 'Nombre maximal de document/dossier récursif',
'settings_maxRecursiveCount_desc' => 'Nombre maximum de documents et répertoires dont l\'accès sera vérifié, lors d\'un décompte récursif. Si ce nombre est dépassé, le nombre de documents et répertoires affichés sera approximé.',
'settings_maxSizeForFullText' => 'Taille maximum pour l\'indexation instantanée',
'settings_maxSizeForFullText_desc' => 'Toute nouvelle version d\'un document plus petite que la taille configurée sera intégralement indexée juste après l\'upload. Dans tous les autres cas, seulement les métadonnées seront indexées.',
'settings_maxUploadSize' => 'Taille max. des fichiers',
'settings_maxUploadSize_desc' => 'Taille maximale (en octets) pour les fichiers téléversés. Concerne les versions d’un document et les fichiers attachés.',
'settings_memcachedHost' => '',
'settings_memcachedHost_desc' => '',
'settings_memcachedPort' => '',
'settings_memcachedPort_desc' => '',
'settings_more_settings' => 'Configurer d\'autres paramètres. Connexion par défaut: admin/admin',
'settings_noDocumentFormFields' => 'Ne pas afficher ces champs (documents)',
'settings_noDocumentFormFields_desc' => 'Ces champs ne seront pas visibles à l’ajout et à la modification d’un document. Les valeurs existantes seront conservées.',
'settings_noFolderFormFields' => 'Ne pas afficher ces champs (dossiers)',
'settings_noFolderFormFields_desc' => 'Ces champs ne seront pas visibles à l\'ajout et à la modification d\'un dossier. Les valeurs existantes seront conservées.',
'settings_notfound' => 'Introuvable',
'settings_Notification' => 'Notifications',
'settings_notwritable' => 'La configuration ne peut pas être enregistrée car le fichier de configuration n’est pas accessible en écriture.',
'settings_no_content_dir' => 'Répertoire de contenu',
'settings_onePageMode' => 'Mode une page',
'settings_onePageMode_desc' => 'Le mode Page unique activera le code javascript dans la page AfficherDossier, qui va mettre à jour la liste Dossier/Document, navigation, etc quand vous cliquez sur un dossier ou vous changer le parametre de l\'ordre d\'affichage.',
'settings_overrideMimeType' => 'Passer outre le type MIME',
'settings_overrideMimeType_desc' => 'Ne pas tenir compte du type MIME envoyé par le navigateur quand un fichier est téléversé. Le type MIME sera déterminé par SeedDMS.',
'settings_overrideTheme' => 'Forcer le thème',
'settings_overrideTheme_desc' => 'Activer pour remplacer le paramètre du thème dans le compte utilisateur par le paramètre de la configuration.',
'settings_partitionSize' => 'Taille des fichiers partiels téléchargées par jumploader',
'settings_partitionSize_desc' => 'Taille des fichiers partiels en octets, téléchargées par jumploader. Ne pas fixer une valeur plus grande que la taille de transfert maximale définie par le serveur.',
'settings_passwordExpiration' => 'Expiration du mot de passe',
'settings_passwordExpiration_desc' => 'Le nombre de jours après lequel un mot de passe expire et doit être remis à zéro. 0 désactive l\'expiration du mot de passe.',
'settings_passwordHistory' => 'Historique mot de passe',
'settings_passwordHistory_desc' => 'Nombre de mots de passe qu’un utilisateur doit avoir utilisé avant d’être réutilisé. 0 désactive l’historique du mot de passe.',
'settings_passwordStrength' => 'Min. résistance mot de passe',
'settings_passwordStrengthAlgorithm' => 'Algorithme pour les mots de passe',
'settings_passwordStrengthAlgorithm_desc' => 'L\'algorithme utilisé pour le calcul de robustesse du mot de passe. L\'algorithme \'simple\' vérifie juste pour au moins huit caractères, une lettre minuscule, une lettre majuscule, un chiffre et un caractère spécial. Si ces conditions sont remplies, le résultat retourné est de 100, sinon 0.',
'settings_passwordStrengthAlgorithm_valadvanced' => 'avancé',
'settings_passwordStrengthAlgorithm_valsimple' => 'simple',
'settings_passwordStrength_desc' => 'La résistance minimale du mot est une valeur entière de 0 à 100. Un réglage à 0 désactive la vérification de la force minimale du mot de passe.',
'settings_pear_log' => 'Pear package : Log',
'settings_pear_webdav' => 'Pear package : HTTP_WebDAV_Server',
'settings_perms' => 'Permissions',
'settings_php_dbDriver' => 'PHP extension : php_\'see current value\'',
'settings_php_gd2' => 'PHP extension : php_gd2',
'settings_php_mbstring' => 'PHP extension : php_mbstring',
'settings_php_version' => 'Version de PHP',
'settings_presetExpirationDate' => 'Date d\'expiration prédéfinie',
'settings_presetExpirationDate_desc' => 'La date d\'expiration de tous les nouveaux documents sera égale à cette valeur. La date peut être renseignée au format PHP strtotime(), par exemple +5 weeks',
'settings_previewWidthDetail' => 'Largeur des vignettes (vue détaillée)',
'settings_previewWidthDetail_desc' => 'Largeur des vignettes affichées sur la vue détaillée',
'settings_previewWidthDropFolderList' => 'Largeur des vignettes (liste du dossier de dépôt)',
'settings_previewWidthDropFolderList_desc' => 'Largeur des vignettes affichées dans la liste lors de la sélection d’un fichier du dossier de dépôt.',
'settings_previewWidthList' => 'Largeur des vignettes (vue liste)',
'settings_previewWidthList_desc' => 'Largeur des vignettes affichées dans les listes',
'settings_previewWidthMenuList' => 'Largeur des vignettes (menu Dossier de dépôt)',
'settings_previewWidthMenuList_desc' => 'Largeur des vignettes affichées dans le menu déroulant « Dossier de dépôt ».',
'settings_printDisclaimer' => 'Afficher la clause de non-responsabilité',
'settings_printDisclaimer_desc' => 'Si activé, le message d’avertissement sera affiché en bas de chaque page.',
'settings_proxyUPassword' => 'Mot de passe du proxy',
'settings_proxyUPassword_desc' => 'Mot de passe pour l’authentification via le proxy',
'settings_proxyUrl' => 'URL du proxy',
'settings_proxyUrl_desc' => 'URL du proxy utilisé pour accéder au dépôt des extensions',
'settings_proxyUser' => 'Nom d’utilisateur du proxy',
'settings_proxyUser_desc' => 'Nom d’utilisateur utilisé pour l’authentification via le proxy',
'settings_quota' => 'Quota de l\'utilisateur',
'settings_quota_desc' => 'Espace maximum (en octets) qu’un utilisateur peut occuper sur le disque. Définir à 0 pour un espace illimité. Une valeur spécifique peut être définie par utilisateur depuis son profil.',
'settings_removeFromDropFolder' => 'Supprimer le fichier du dossier de dépôt après un chargement réussi',
'settings_removeFromDropFolder_desc' => 'Activez ceci si un fichier pris du dossier de dépôt doit être supprimé après un upload réussi.',
'settings_repositoryUrl' => 'URL du référentiel',
'settings_repositoryUrl_desc' => 'URL du référentiel pour les extensions',
'settings_restricted' => 'Accès restreint',
'settings_restricted_desc' => 'Autoriser les utilisateurs à se connecter seulement s\'ils ont une entrée dans la BD locale (independamment d\'une authentification réussie avec LDAP)',
'settings_rootDir' => 'Répertoire racine',
'settings_rootDir_desc' => 'Chemin où se trouve SeedDMS',
'settings_rootFolderID' => 'ID du répertoire racine',
'settings_rootFolderID_desc' => 'ID du répertoire racine (la plupart du temps pas besoin de changer)',
'settings_SaveError' => 'Erreur de sauvegarde du fichier de configuration',
'settings_Server' => 'Paramètres serveur',
'settings_showFullPreview' => 'Visualisation complète du document',
'settings_showFullPreview_desc' => 'Active/désactive la prévisualisation du document sur la page des détails (si le navigateur le permet).',
'settings_showMissingTranslations' => 'Afficher les traductions manquantes',
'settings_showMissingTranslations_desc' => 'Lister toutes les traductions manquantes de la page dans le bas de la page. L\'utilisateur connecté pourra proposer une traduction manquante qui sera sauvegardée dans un fichier CSV. Ne pas activer cette fonction en production.',
'settings_showSingleSearchHit' => 'Aller au document en cas de résultat unique',
'settings_showSingleSearchHit_desc' => 'Quand une recherche retourne un seul résultat, afficher celui-ci directement à la place de la page des résultats.',
'settings_Site' => 'Site',
'settings_siteDefaultPage' => 'Page par défaut du site',
'settings_siteDefaultPage_desc' => 'Page par défaut lors de la connexion. Si vide, valeur par défaut à out/out.ViewFolder.php',
'settings_siteName' => 'Nom du site',
'settings_siteName_desc' => 'Nom du site utilisé pour les titres de pages. Par défaut : SeedDMS',
'settings_SMTP' => 'Paramètres du serveur SMTP',
'settings_smtpForceFrom' => '',
'settings_smtpForceFrom_desc' => '',
'settings_smtpLazySSL' => '',
'settings_smtpLazySSL_desc' => '',
'settings_smtpPassword' => 'Mot de passe du serveur SMTP',
'settings_smtpPassword_desc' => 'Mot de passe du serveur SMTP',
'settings_smtpPort' => 'Port serveur SMTP',
'settings_smtpPort_desc' => 'Port serveur SMTP, par défaut 25',
'settings_smtpSendFrom' => 'Envoyé par',
'settings_smtpSendFrom_desc' => 'Envoyé par',
'settings_smtpSendTestMail' => 'Envoyer un e-mail test',
'settings_smtpSendTestMail_desc' => 'Envoie un message test pour vérifier la configuration e-mail actuelle.',
'settings_smtpServer' => 'Nom du serveur SMTP',
'settings_smtpServer_desc' => 'Nom du serveur SMTP',
'settings_smtpUser' => 'Utilisateur pour le serveur SMTP',
'settings_smtpUser_desc' => 'Utilisateur pour le serveur SMTP',
'settings_sortFoldersDefault' => 'Méthode de tri par défaut des dossiers',
'settings_sortFoldersDefault_desc' => 'Ceci définit les méthodes de tri pour les dossiers et documents dans la vue du dossier.',
'settings_sortFoldersDefault_val_name' => 'Par nom',
'settings_sortFoldersDefault_val_sequence' => 'Par position',
'settings_sortFoldersDefault_val_unsorted' => 'Non trié',
'settings_sortUsersInList' => 'Tri des utilisateurs',
'settings_sortUsersInList_desc' => 'Définit si les utilisateurs dans les menus de sélection sont triés par identifiant ou par nom complet',
'settings_sortUsersInList_val_fullname' => 'Tri par nom complet',
'settings_sortUsersInList_val_login' => 'Tri par identifiant',
'settings_stagingDir' => 'Répertoire pour les téléchargements partiels',
'settings_stagingDir_desc' => 'Le répertoire où jumploader mets les parts d\'un fichier chargé avant de le reconstituer.',
'settings_start_install' => 'Démarrer l\'installation',
'settings_stopWordsFile' => 'Fichier des mots à exclure',
'settings_stopWordsFile_desc' => 'Si la recherche plein texte est activée, ce fichier contient la liste des mots à ne pas indexer.',
'settings_strictFormCheck' => 'Formulaires stricts',
'settings_strictFormCheck_desc' => 'Contrôle strict des formulaires. Si cette option est activée, tous les champs du formulaire doivent être saisis. Sinon, la plupart des champs (commentaires et mots-clés) sont facultatifs. Les commentaires sont toujours obligatoires lors de la soumission d\'une vérification ou du changement de statut ​​d’un document.',
'settings_suggestionvalue' => 'Valeur suggérée',
'settings_suggestTerms' => '',
'settings_suggestTerms_desc' => '',
'settings_System' => 'Système',
'settings_tasksInMenu' => 'Tâches sélectionnées',
'settings_tasksInMenu_approval' => 'Approbations',
'settings_tasksInMenu_checkedout' => 'Vérifié',
'settings_tasksInMenu_desc' => 'Sélectionnez les tâches à comptabiliser. Si aucune n’est sélectionnée, toutes les tâches seront comptabilisées.',
'settings_tasksInMenu_needscorrection' => 'Nécessitant une correction',
'settings_tasksInMenu_receipt' => 'Réceptions',
'settings_tasksInMenu_rejected' => 'Rejeté',
'settings_tasksInMenu_review' => 'Vérifications',
'settings_tasksInMenu_revision' => 'Révisions',
'settings_tasksInMenu_workflow' => 'Workflow',
'settings_theme' => 'Thème par défaut',
'settings_theme_desc' => 'Thème par défaut(nom d\'un sous-répertoire du répertoire "styles")',
'settings_titleDisplayHack' => 'Title Display Hack',
'settings_titleDisplayHack_desc' => 'Solution pour les titres des pages qui dépassent 2 lignes.',
'settings_undelUserIds' => 'ID Utilisateurs Non Effaçables',
'settings_undelUserIds_desc' => 'Liste des identifiants des utilisateurs qui ne peuvent pas être supprimés. Séparer les identifiants par des virgules.',
'settings_updateDatabase' => 'Exécuter les scripts de mise à jour du schéma de la base',
'settings_updateNotifyTime' => 'Délai de notification des modifications',
'settings_updateNotifyTime_desc' => 'Les utilisateurs sont informés des modifications apportées aux documents qui ont eu lieu durant le délai précisé (en secondes).',
'settings_upgrade_php' => 'Mettez à jour PHP vers une version au moins égale à 5.6.38',
'settings_uploadedAttachmentIsPublic' => '',
'settings_uploadedAttachmentIsPublic_desc' => '',
'settings_useHomeAsRootFolder' => 'Utiliser le dossier de départ comme dossier racine',
'settings_useHomeAsRootFolder_desc' => 'Activer pour que le dossier de départ de l’utilisateur (non admin) soit utilisé comme dossier racine (expérimental).',
'settings_versioningFileName' => 'Nom des fichiers de versionnage',
'settings_versioningFileName_desc' => 'Nom des fichiers textes d’information créés depuis les outils de sauvegarde',
'settings_versiontolow' => 'Version trop ancienne',
'settings_viewOnlineFileTypes' => 'Aperçu en ligne des fichiers',
'settings_viewOnlineFileTypes_desc' => 'Extensions des fichiers pouvant être visionnés en ligne (en lettres minuscules uniquement).',
'settings_webdav' => 'WebDAV',
'settings_workflowMode' => 'Mode workflow',
'settings_workflowMode_desc' => 'Le workflow avancé permet de définir son propre workflow de parution pour les versions de documents.',
'settings_workflowMode_valadvanced' => 'avancé',
'settings_workflowMode_valnone' => 'aucun',
'settings_workflowMode_valtraditional' => 'traditionnel',
'settings_workflowMode_valtraditional_only_approval' => 'traditionnel (sans revue)',
'settings_zendframework' => 'Zend Framework',
'set_expiration_date_help' => '',
'set_expiry' => 'Modifier la date d\'expiration',
'set_owner' => 'Définir le propriétaire',
'set_owner_error' => 'Erreur lors de la définition du propriétaire',
'set_password' => 'Définir mot de passe',
'set_workflow' => 'Définir le Workflow',
'show_extension_changelog' => 'Afficher le journal des modifications',
'show_extension_readme' => '',
'show_extension_version_list' => 'Afficher la liste des versions',
'signed_in_as' => 'Connecté en tant que',
'sign_in' => 'Connexion',
'sign_out' => 'Déconnexion',
'sign_out_user' => 'Déconnecter l\'utilisateur',
'site_brand' => '',
'skip_default_export_cols' => '',
'sk_SK' => 'Slovaque',
'sort_by_date' => 'Trier par date',
'sort_by_expiration_date' => 'Trier par date d’expiration',
'sort_by_name' => 'Trier par nom',
'sort_by_sequence' => 'Trier par position',
'space_used_on_data_folder' => 'Espace utilisé dans le répertoire de données',
'splash_access_added' => 'Droits d’accès ajoutés',
'splash_access_deleted' => 'Droits d’accès supprimés',
'splash_access_edited' => 'Droits d’accès modifiés',
'splash_added_to_clipboard' => 'Ajouté au presse-papier',
'splash_add_attribute' => 'Attribut ajouté',
'splash_add_category' => '',
'splash_add_group' => 'Nouveau groupe ajouté',
'splash_add_group_member' => 'Nouveau membre ajouté au groupe',
'splash_add_keyword' => '',
'splash_add_keyword_category' => '',
'splash_add_notify' => 'Nouvelle notification ajoutée',
'splash_add_role' => 'Nouveau rôle ajouté',
'splash_add_task' => 'Nouvelle tâche ajoutée',
'splash_add_to_transmittal' => 'Ajouté à la transmission',
'splash_add_transmittal' => 'Ajouté à la transmission',
'splash_add_user' => 'Nouvel utilisateur ajouté',
'splash_cancel_checkout' => 'Vérification annulée',
'splash_checked_in' => '',
'splash_cleared_cache' => 'Cache vidé',
'splash_cleared_clipboard' => 'Presse-papier vidé',
'splash_content_transfered' => 'Contenu transféré',
'splash_document_added' => 'Document ajouté',
'splash_document_checkedout' => 'Document bloqué',
'splash_document_deleted' => 'Document supprimé',
'splash_document_edited' => 'Document sauvegardé',
'splash_document_indexed' => 'Document « [name] » indexé.',
'splash_document_locked' => 'Document verrouillé',
'splash_document_moved' => 'Document déplacé',
'splash_document_name_changed' => 'Nom du document modifié',
'splash_document_transfered' => 'Document transféré',
'splash_document_unlocked' => 'Document déverrouillé',
'splash_document_updated' => '',
'splash_edit_attribute' => 'Attribut modifié',
'splash_edit_category' => '',
'splash_edit_event' => 'Événement modifié',
'splash_edit_group' => 'Groupe modifié',
'splash_edit_keyword' => '',
'splash_edit_keyword_category' => '',
'splash_edit_role' => 'Rôle modifié',
'splash_edit_task' => 'Tâche modifiée',
'splash_edit_transmittal' => 'Transmission enregistrée',
'splash_edit_user' => 'Utilisateur modifié',
'splash_error_add_to_transmittal' => 'Erreur lors de l’ajout du document à la transmission',
'splash_error_checkin_ended' => '',
'splash_error_rm_download_link' => 'Erreur lors de la suppression du lien de téléchargement',
'splash_error_saving_file' => 'Erreur lors de l’enregistrement du fichier',
'splash_error_send_download_link' => 'Erreur lors de l’envoi du lien de téléchargement',
'splash_expiration_date_cleared' => 'Date d’expiration retirée',
'splash_expiration_date_set' => 'Date d’expiration définie au [date]',
'splash_extension_getlist' => 'Liste des extensions du dépôt actualisée',
'splash_extension_import' => 'Extension installée',
'splash_extension_refresh' => 'Liste des extensions actualisée',
'splash_extension_upload' => 'Extension installée',
'splash_folder_added' => '',
'splash_folder_deleted' => 'Dossier supprimé',
'splash_folder_edited' => 'Dossier modifié',
'splash_folder_moved' => 'Dossier déplacé',
'splash_importfs' => '[docs] documents et [folders] dossiers importés',
'splash_inherit_access' => 'Droits d’accès hérités',
'splash_invalid_folder_id' => 'Identifiant de répertoire invalide',
'splash_invalid_searchterm' => 'Recherche invalide',
'splash_invalid_search_service' => '',
'splash_link_document' => 'Lien ajouté',
'splash_mimetype_changed' => '',
'splash_moved_clipboard' => 'Contenu du presse-papier déplacé vers le dossier en cours',
'splash_notinherit_access' => 'Les droits d’accès ne sont plus hérités',
'splash_objects_transfered' => 'Objets transférés',
'splash_orig_filename_changed' => '',
'splash_owner_set' => 'Nouveau propriétaire défini',
'splash_receipt_update_success' => 'Réception ajoutée avec succès',
'splash_removed_from_clipboard' => 'Supprimé du presse-papier',
'splash_rm_attribute' => 'Attribut supprimé',
'splash_rm_attr_value' => 'Valeur d’attribut retirée',
'splash_rm_category' => '',
'splash_rm_document' => 'Document supprimé',
'splash_rm_download_link' => 'Lien de téléchargement supprimé',
'splash_rm_folder' => 'Dossier supprimé',
'splash_rm_group' => 'Groupe supprimé',
'splash_rm_group_member' => 'Membre retiré du groupe',
'splash_rm_keyword' => '',
'splash_rm_keyword_category' => '',
'splash_rm_notify' => 'Notification supprimée',
'splash_rm_role' => 'Rôle supprimé',
'splash_rm_transmittal' => 'Transmission supprimée',
'splash_rm_user' => 'Utilisateur supprimé',
'splash_rm_user_processes' => 'Utilisateur retiré de tous les processus',
'splash_rm_workflow' => 'Workflow supprimé',
'splash_rm_workflow_action' => 'Action de workflow supprimée',
'splash_rm_workflow_state' => 'État de workflow supprimé',
'splash_saved_file' => 'Version enregistrée',
'splash_save_user_data' => 'Données utilisateur enregistrées',
'splash_send_download_link' => 'Lien de téléchargement envoyé par e-mail',
'splash_send_login_data' => 'Informations de connexion envoyées',
'splash_settings_saved' => 'Configuration sauvegardée',
'splash_set_default_access' => 'Droits d’accès par défaut définis',
'splash_substituted_user' => 'Utilisateur de substitution',
'splash_switched_back_user' => 'Revenu à l\'utilisateur initial',
'splash_toogle_group_manager' => 'Responsable de groupe changé',
'splash_trigger_workflow' => 'Transition de workflow déclenchée',
'startdate' => '',
'state_and_next_state' => 'État initial/suivant',
'statistic' => 'Statistiques',
'statistics_mail_subject' => '',
'status' => 'Statut',
'status_approval_rejected' => 'Ébauche rejetée',
'status_approved' => 'Approuvé',
'status_approver_removed' => 'Approbateur retiré du processus',
'status_change' => 'Statut modifié',
'status_needs_correction' => 'Nécessite une correction',
'status_not_approved' => 'Non approuvé',
'status_not_receipted' => 'Pas encore réceptionné',
'status_not_reviewed' => 'Non vérifié',
'status_not_revised' => 'Non révisé',
'status_receipted' => 'Réceptionné',
'status_receipt_rejected' => 'Rejeté',
'status_recipient_removed' => 'Destinataire retiré de la liste',
'status_reviewed' => 'Vérifié',
'status_reviewer_rejected' => 'Ébauche rejetée',
'status_reviewer_removed' => 'Examinateur retiré du processus',
'status_revised' => 'Révisé',
'status_revision_rejected' => 'Rejeté',
'status_revision_sleeping' => 'en attente',
'status_revisor_removed' => 'Réviseur retiré de la liste',
'status_unknown' => 'Inconnu',
'storage' => '',
'storage_size' => 'Taille occupée',
'subfolder_duplicate_name' => 'Un sous-dossier porte déjà ce nom !',
'submit_2_factor_auth' => 'Enregistrer la clé secrète',
'submit_2_factor_auth_test' => '',
'submit_approval' => 'Soumettre approbation',
'submit_login' => 'Connexion',
'submit_password' => 'Définir le nouveau mot de passe',
'submit_password_forgotten' => 'Envoyer',
'submit_receipt' => 'Confirmer la réception',
'submit_review' => 'Soumettre la vérification',
'submit_revision' => 'Soumettre la révision',
'submit_userinfo' => 'Soumettre info',
'submit_webauthn_login' => 'Identification',
'submit_webauthn_register' => 'Inscription',
'subsribe_timelinefeed' => 'S’abonner au flux RSS',
'substitute_to_user' => 'Basculer sur \'[username]\'',
'substitute_user' => 'Utilisateur de substitution',
'success_add_aro' => 'Objet de demande d’accès ajouté',
'success_add_permission' => 'Permission ajoutée',
'success_remove_permission' => 'Permission supprimée',
'success_toogle_permission' => 'Permission modifiée',
'sunday' => 'Dimanche',
'sunday_abbr' => 'Dim.',
'sv_SE' => 'Suédois',
'switched_to' => 'Connexion provisoire sous',
'takeOverAttributeValue' => 'Récupérer la valeur de la dernière version',
'takeOverGrpApprover' => 'Récupérer le groupe d\'approbateurs de la dernière version.',
'takeOverGrpApprovers' => 'Récupérer le groupe d’approbateurs',
'takeOverGrpReviewer' => 'Récupérer le groupe d\'examinateurs de la dernière version.',
'takeOverGrpReviewers' => 'Récupérer le groupe d’examinateurs',
'takeOverIndApprover' => 'Récupérer les approbateurs de la dernière version.',
'takeOverIndApprovers' => 'Récupérer les approbateurs individuels',
'takeOverIndReviewer' => 'Récupérer les examinateurs de la dernière version.',
'takeOverIndReviewers' => 'Récupérer les examinateurs individuels',
'target_equals_source_folder' => 'Le dossier de destination est identique au dossier source',
'tasks' => 'Tâches',
'task_core_expireddocs_days' => 'jours',
'task_core_expireddocs_dryrun' => '',
'task_core_expireddocs_email' => 'E-mail',
'task_core_expireddocs_peruser' => 'Par utilisateur',
'task_core_importdropfolder_dryrun' => '',
'task_core_importdropfolder_dryrun_desc' => '',
'task_core_importdropfolder_keepfile' => '',
'task_core_importdropfolder_keepfile_desc' => '',
'task_core_importdropfolder_recursive' => '',
'task_core_importdropfolder_targetfolder' => '',
'task_core_importdropfolder_targetfolder_desc' => '',
'task_core_importdropfolder_users' => '',
'task_core_indexingdocs_recreate' => 'Régénérer l’index',
'task_core_recentchanges_days' => '',
'task_core_recentchanges_lists' => '',
'task_core_recentchanges_users' => '',
'task_core_statistic_users' => '',
'task_description' => 'Description',
'task_disabled' => 'Désactivée',
'task_failures' => '',
'task_frequency' => 'Fréquence',
'task_frequency_placeholder' => 'min h j m jsem',
'task_last_run' => 'Dernière exécution',
'task_name' => 'Nom',
'task_next_run' => 'Prochaine exécution',
'temp_jscode' => 'Code javascript temporaire',
'testmail_body' => 'Ce message est un test pour vérifier la configuration mail de SeedDMS.',
'testmail_subject' => 'E-mail test',
'theme' => 'Thème',
'thursday' => 'Jeudi',
'thursday_abbr' => 'Jeu.',
'timeline' => 'Chronologie',
'timeline_add_file' => 'Nouveau fichier attaché',
'timeline_add_version' => 'Nouvelle version ([version])',
'timeline_full_add_file' => '[document]<br />Nouveau fichier attaché',
'timeline_full_add_version' => '[document]<br />Nouvelle version ([version])',
'timeline_full_scheduled_revision' => '[document]<br />Révision de la version [version]',
'timeline_full_status_change' => '[document]<br />Version [version] : [status]',
'timeline_scheduled_revision' => 'Révision de la version [version]',
'timeline_selected_item' => 'Document sélectionné',
'timeline_skip_add_file' => 'avec fichiers attachés',
'timeline_skip_scheduled_revision' => 'Révision planifiée',
'timeline_skip_status_change_-1' => 'rejetés',
'timeline_skip_status_change_-2' => 'obsolètes',
'timeline_skip_status_change_-3' => 'expirés',
'timeline_skip_status_change_0' => 'en attente de revue',
'timeline_skip_status_change_1' => 'en attente d\'approbation',
'timeline_skip_status_change_2' => 'publiés',
'timeline_skip_status_change_3' => 'encore dans un workflow',
'timeline_skip_status_change_4' => 'en révision',
'timeline_skip_status_change_5' => 'ébauches',
'timeline_status_change' => 'Version [version] : [status]',
'title' => '',
'to' => 'Au',
'toggle_manager' => 'Basculer \'Responsable\'',
'toggle_qrcode' => 'Afficher/masquer le QR code',
'total' => 'Total',
'to_before_from' => 'La date de fin ne peut pas être avant la date de début.',
'transfer_content' => 'Transférer le contenu',
'transfer_document' => 'Transférer le document',
'transfer_no_read_access' => 'L’utilisateur n’a pas le droit de lecture dans ce dossier',
'transfer_no_users' => 'Il n’y a actuellement aucun utilisateur auquel le document peut être transféré.',
'transfer_no_write_access' => 'L’utilisateur n’a pas le droit d’écriture dans ce dossier',
'transfer_objects' => 'Transférer les objets',
'transfer_objects_to_user' => 'Nouveau propriétaire',
'transfer_processes_to_user' => '',
'transfer_process_to_user' => 'Transférer le processus à l’utilisateur',
'transfer_to_user' => 'Transférer à l’utilisateur',
'transition_triggered_email' => 'Transition de workflow activé',
'transition_triggered_email_body' => 'Transition de workflow déclenchée

Document : [name]
Version : [version]
Commentaires : [comment]
Workflow : [workflow]
État précédent : [previous_state]
État actuel : [current_state]
Dossier parent : [folder_path]
Utilisateur : [username]
URL : [url]',
'transition_triggered_email_body_html' => '<p>Transition de workflow déclenchée</p>

<p>Document : [name]<br />
Version : [version]<br />
Commentaire : [comment]<br />
Workflow : [workflow]<br />
État précédent : [previous_state]<br />
État actuel : [current_state]<br />
Dossier parent : [folder_path]<br />
Utilisateur : [username]<br />
URL : [url]</p>',
'transition_triggered_email_subject' => '[sitename] : [name] - Transition de workflow déclenchée',
'transmittal' => 'Transmission',
'transmittalitem_removed' => 'Élément de la transmission supprimé',
'transmittalitem_updated' => 'Élément de la transmission mis à jour',
'transmittals' => '',
'transmittal_comment' => 'Commentaire',
'transmittal_name' => 'Nom',
'transmittal_size' => 'Taille',
'tree_loading' => 'Veuillez patienter pendant le chargement de l’arborescence des documents…',
'trigger_workflow' => 'Workflow',
'tr_TR' => 'Turc',
'tuesday' => 'Mardi',
'tuesday_abbr' => 'Mar.',
'types_generic' => 'Types génériques',
'type_of_hook' => 'Type',
'type_to_filter' => 'Filtrer dans la liste',
'type_to_search' => 'Effectuer une recherche',
'uk_UA' => 'Ukrénien',
'undefined' => 'indéfini',
'under_folder' => 'Dans le dossier',
'unknown_attrdef' => 'Définition d’attribut inconnue',
'unknown_command' => 'Commande non reconnue.',
'unknown_document_category' => 'Catégorie inconnue',
'unknown_group' => 'Identifiant de groupe inconnu',
'unknown_id' => 'ID inconnu',
'unknown_keyword_category' => 'Catégorie inconnue',
'unknown_owner' => 'Identifiant de propriétaire inconnu',
'unknown_status' => 'Statut inconnu',
'unknown_user' => 'Identifiant d\'utilisateur inconnu',
'unlinked_content' => 'Contenu non lié',
'unlinked_documents' => 'Documents non liés',
'unlinked_folders' => 'Dossiers non liés',
'unlinking_objects' => 'Déliage du contenu',
'unlock_cause_access_mode_all' => 'Vous pouvez encore le mettre à jour, car vous avez les droits d\'accès "tout". Le verrouillage sera automatiquement annulé.',
'unlock_cause_locking_user' => 'Vous pouvez encore le mettre à jour, car vous êtes le seul à l\'avoir verrouillé. Le verrouillage sera automatiquement annulé.',
'unlock_document' => 'Déverrouiller',
'update' => 'Mettre à jour',
'updated' => 'mis à jour',
'updated_documents' => '',
'update_approvers' => 'Mettre à jour la liste des approbateurs',
'update_document' => 'Mettre à jour',
'update_fulltext_index' => 'Mettre à jour l\'index de recherche plein texte',
'update_fulltext_messages' => 'Messages',
'update_info' => 'Informations de mise à jour',
'update_locked_msg' => 'Ce document est verrouillé.',
'update_recipients' => 'Mettre à jour la liste des destinataires',
'update_reviewers' => 'Mettre à jour la liste des examinateurs',
'update_revisors' => 'Mettre à jour la liste des réviseurs',
'update_transmittalitem' => 'Mettre à jour l’élément',
'uploaded_by' => 'Déposé par',
'uploading_failed' => 'Dépôt d\'un des documents échoué. Veuillez vérifier la taille d\'envoi maximale autorisée.',
'uploading_maxsize' => 'La taille du fichier dépasse la limite maximale autorisée.',
'uploading_postmaxsize' => '',
'uploading_zerosize' => 'Chargement d\'un fichier vide. Chargement annulé.',
'used_discspace' => 'Espace disque utilisé',
'user' => 'Utilisateur',
'userdata_file' => 'Données utilisateur',
'userid_groupid' => 'ID utilisateur/ID groupe',
'users' => 'Utilisateurs',
'users_and_groups' => 'Utilisateurs/groupes',
'users_done_work' => 'Actions des utilisateurs',
'user_exists' => 'Cet utilisateur existe déjà',
'user_group' => 'Utilisateur/Groupe',
'user_group_management' => 'Gestion des utilisateurs/groupes',
'user_image' => 'Image',
'user_info' => 'Informations utilisateur',
'user_is_mandatory_approver' => '',
'user_is_mandatory_reviewer' => '',
'user_list' => 'Liste des utilisateurs',
'user_login' => 'Identifiant',
'user_management' => 'Gestion des utilisateurs',
'user_name' => 'Nom d’affichage',
'user_previously_removed_from_approvers' => '',
'user_previously_removed_from_recipients' => '',
'user_previously_removed_from_reviewers' => '',
'user_previously_removed_from_revisors' => '',
'use_comment_of_document' => 'Utiliser le commentaire du document',
'use_default_categories' => 'Use predefined categories',
'use_default_keywords' => 'Utiliser les mots-clés prédéfinis',
'valid_till' => 'Valide jusqu’au',
'version' => 'Version',
'versioning_file_creation' => 'Créer les fichiers de versionnage',
'versioning_file_creation_warning' => 'Cette opération permet de créer, pour chaque document, un fichier texte contenant les informations générales et l’historique des versions du document. Chaque fichier sera enregistré dans le répertoire du document. Ces fichiers ne sont pas nécessaires au bon fonctionnement de SeedDMS, mais ils peuvent être utiles en cas de transfert des fichiers vers un autre système.',
'versioning_info' => 'Versions',
'versiontolow' => 'Version antérieure',
'version_comment' => 'Commentaire de la version',
'version_comment_changed_email_body' => '',
'version_comment_changed_email_body_html' => '',
'version_comment_changed_email_subject' => '',
'version_deleted_email' => 'Version supprimée',
'version_deleted_email_body' => 'Version supprimée

Document : [name]
Version : [version]
Dossier parent : [folder_path]
Utilisateur : [username]
URL : [url]',
'version_deleted_email_body_html' => '<p>Version supprimée</p>

<p>Document : [name]<br />
Version : [version]<br />
Dossier parent : [folder_path]<br />
Utilisateur : [username]<br />
URL : [url]</p>',
'version_deleted_email_subject' => '[sitename] : [name] - Version supprimée',
'version_info' => 'Informations de version',
'view' => 'Aperçu',
'view_document' => 'Voir le document',
'view_folder' => 'Voir les détails du dossier',
'view_online' => 'Aperçu en ligne',
'warning' => 'Avertissement',
'warning_remove_approval_log' => 'Le retrait d’une approbation individuelle ne peut être annulé et ne sera pas rapporté. Le vérificateur devra refaire la vérification.',
'warning_remove_review_log' => 'Le retrait d’une vérification individuelle ne peut être annulé et ne sera pas rapporté. Le vérificateur devra refaire la vérification.',
'webauthn' => '',
'webauthn_auth' => 'Authentification WebAuthn',
'webauthn_crossplatform_info' => 'Choisissez « Oui » lorsque vous avez un périphérique amovible, comme une clé Yubico, que vous souhaitez utiliser pour vous connecter sur différents ordinateurs ; choisissez « Non » lorsque votre appareil est connecté à l\'ordinateur. Le choix affecte le ou les appareils proposés par le navigateur et / ou le système de sécurité informatique.',
'webauthn_info' => 'WebAuthn est une authentification sans mot de passe utilisant la cryptographie à clé publique. Une paire de clés privée-publique (connue sous le nom de certificat) est créée pour un site Web. La clé privée est stockée en toute sécurité sur l’appareil de l’utilisateur ; une clé publique et un identifiant généré de manière aléatoire sont envoyés au serveur pour stockage. Le serveur peut ensuite utiliser cette clé publique pour prouver l’identité de l’utilisateur. La clé privée est généralement stockée sur un jeton matériel. Le jeton doit être enregistré avant de pouvoir être utilisé pour l’authentification.',
'webauthn_login_test' => '',
'webauthn_registration' => '',
'webauth_crossplatform' => 'Multiplateforme',
'wednesday' => 'Mercredi',
'wednesday_abbr' => 'Mer.',
'weeks' => 'semaines',
'weeks_ago' => '',
'weeks_from_now' => '',
'week_ago' => '',
'week_from_now' => '',
'week_view' => 'Vue par semaine',
'workflow' => 'Workflow',
'workflows_involded' => 'Impliqué dans un Workflow',
'workflow_actions_management' => 'Gestion des actions de workflow',
'workflow_action_in_use' => 'Cette action est actuellement utilisée par des workflows.',
'workflow_action_name' => 'Nom',
'workflow_editor' => 'Éditeur de Workflow',
'workflow_group_summary' => 'Récapitulatif groupe workflow',
'workflow_has_cycle' => 'Le workflow a une boucle',
'workflow_initstate' => 'État initial',
'workflow_in_use' => 'Ce workflow est actuellement utilisé par des documents.',
'workflow_layoutdata_saved' => 'Données de mise en page enregistrées',
'workflow_log' => '',
'workflow_management' => 'Gestion des workflows',
'workflow_name' => 'Nom',
'workflow_no_doc_rejected_state' => 'L’état « rejeté » n’a été défini sur aucune action !',
'workflow_no_doc_released_state' => 'L’état « publié » n’a été défini sur aucune action !',
'workflow_no_initial_state' => 'Aucune transition ne débute par l’état initial défini pour ce workflow !',
'workflow_no_states' => 'Vous devez d\'abord définir des états de workflow avant d\'ajouter un workflow.',
'workflow_save_layout' => 'Enregistrer la mise en page',
'workflow_state' => 'État de workflow',
'workflow_states_management' => 'Gestion des états de workflow',
'workflow_state_docstatus' => 'État du document',
'workflow_state_in_use' => 'Cet état est actuellement utilisé par des workflows.',
'workflow_state_name' => 'Nom',
'workflow_summary' => 'Récapitulatif workflow',
'workflow_title' => '',
'workflow_transition_without_user_group' => 'Au moins une transition a ni utilisateur, ni groupe !',
'workflow_user_summary' => 'Récapitulatif utilisateur',
'wrong_checksum' => 'Mauvaise somme de contrôle',
'wrong_filetype' => 'Mauvais type de fichier',
'x_more_objects' => '[number] objets supplémentaires',
'years_ago' => '',
'years_from_now' => '',
'year_ago' => '',
'year_from_now' => '',
'year_view' => 'Vue annuelle',
'yes' => 'Oui',
'zh_CN' => 'Chinois (CN)',
'zh_TW' => 'Chinois (TW)',
);
?>
