Adding authentication failure check for fail2ban
=================================================

Fail2ban is a very mature and sophisticated program to detect attacks on
a service by checking its log file. If such an attack was detected an
action will be executed, which will mostly ban the IP of the attacker
for a configurable amount of time.

You will have to use at least SeedDMS 5.1.10 for this to work.

Add a filter `/etc/fail2ban/filter.d/seeddms.conf` with the content

```
[Definition]

failregex = \[error\] -- \(<HOST>\) op.Login login failed
```

This will tell fail2ban which lines in the log file are considered
to be an incident. Here it is a failed login.

Than configure a new jail in `/etc/fail2ban/jail.d/seeddms.conf`

```
[seeddms]
enabled = yes
port = http,https
filter  = seeddms
logpath = /home/www-data/seeddms-demo/data/log/*.log
```

It tells fail2ban which log files shall be analysed, and which filter
has to be applied.
