/*
Template Name: Color Admin - Responsive Admin Dashboard Template build with Bootstrap 5
Version: 5.1.5
Author: Sean Ngu
Website: http://www.seantheme.com/color-admin/
	----------------------------
	     APPS CONTENT TABLE
	----------------------------

	<!-- ======== GLOBAL SCRIPT SETTING ======== -->
	01. Handle Home Content Height
	02. Handle Header Navigation State
	03. Handle Commas to Number
	04. Handle Page Container Show
	05. Handle Page Scroll Content Animation
	06. Handle Header Scroll To Action
	07. Handle Tooltip Activation
	08. Handle Theme Panel Expand
	09. Handle Theme Page Control
	10. Handle Paroller
	11. Handle Get Css Variable

	<!-- ======== APPLICATION SETTING ======== -->
	Application Controller
*/

var app = {
	font: {
	
	},
	color: {
	
	}
}


/* 01. Handle Home Content Height
------------------------------------------------ */
var handleHomeContentHeight = function() {
	$('#home').height($(window).height());
};


/* 02. Handle Header Navigation State
------------------------------------------------ */
var handleHeaderNavigationState = function() {
	$(window).on('scroll', function() {
		var totalScrollTop = $(window).scrollTop();
		if (totalScrollTop >= 50){
			$('#header').addClass('navbar-sm');
		} else {
			$('#header').removeClass('navbar-sm');
		}
	});
};


/* 03. Handle Commas to Number
------------------------------------------------ */
var handleAddCommasToNumber = function(value) {
	return value.toString().replace(/(\d)(?=(\d\d\d)+(?!\d))/g, "$1,");
};


/* 04. Handle Page Container Show
------------------------------------------------ */
var handlePageContainerShow = function() {
	$('#page-container').addClass('in');
};


/* 05. Handle Page Scroll Content Animation
------------------------------------------------ */
var handlePageScrollContentAnimation = function() {
	$('[data-scrollview="true"]').each(function() {
		var myElement = $(this);
		var elementWatcher = scrollMonitor.create( myElement, 60 );

		elementWatcher.enterViewport(function() {
			$(myElement).find('[data-animation=true]').each(function() {
				var targetAnimation = $(this).attr('data-animation-type');
				var targetElement = $(this);
				if (!$(targetElement).hasClass('contentAnimated')) {
					if (targetAnimation == 'number') {
						var finalNumber = parseInt($(targetElement).attr('data-final-number'));
						$({animateNumber: 0}).animate({animateNumber: finalNumber}, {
							duration: 1000,
							easing:'swing',
							step: function() {
								var displayNumber = handleAddCommasToNumber(Math.ceil(this.animateNumber));
								$(targetElement).text(displayNumber).addClass('contentAnimated');
							}
						});
					} else {
						$(this).addClass(targetAnimation + ' contentAnimated');
					}
				}
			});
		});
	});
};


/* 06. Handle Header Scroll To Action
------------------------------------------------ */
var handleHeaderScrollToAction = function() {
	$('[data-click=scroll-to-target]').on('click', function(e) {
		e.preventDefault();
		e.stopPropagation();
		var target = $(this).attr('href');
		var headerHeight = 50;
		
		$('html, body').animate({
			scrollTop: $(target).offset().top - headerHeight
		}, 500);

		if ($(this).attr('data-toggle') == 'dropdown') {
			var targetLi = $(this).closest('li.dropdown');
			if ($(targetLi).hasClass('open')) {
				$(targetLi).removeClass('open');
			} else {
				$(targetLi).addClass('open');
			}
		}
	});
	$(document).click(function(e) {
		if (!e.isPropagationStopped()) {
			$('.dropdown.open').removeClass('open'); 
		}
	});
};


/* 07. Handle Tooltip Activation
------------------------------------------------ */
var handleTooltipActivation = function() {
	if ($('[data-bs-toggle=tooltip]').length !== 0) {
		$('[data-bs-toggle=tooltip]').tooltip();
	}
};


/* 08. Handle Theme Panel Expand
------------------------------------------------ */
var handleThemePanelExpand = function() {
	$(document).on('click', '[data-click="theme-panel-expand"]', function() {
		var targetContainer = '.theme-panel';
		var targetClass = 'active';
		if ($(targetContainer).hasClass(targetClass)) {
			$(targetContainer).removeClass(targetClass);
		} else {
			$(targetContainer).addClass(targetClass);
		}
	});
};


/* 09. Handle Theme Page Control
------------------------------------------------ */
var handleThemePageControl = function() {
	if (typeof Cookies !== 'undefined') {
		$(document).on('click', '.theme-list [data-theme]', function(e) {	
			e.preventDefault();
			var targetThemeClass = $(this).attr('data-theme');
		
			for (var x = 0; x < document.body.classList.length; x++) {
				var targetClass = document.body.classList[x];
				if (targetClass.search('theme-') > -1) {
					$('body').removeClass(targetClass);
				}
			}
		
			$('body').addClass(targetThemeClass);
			$('.theme-list [data-theme]').not(this).closest('li').removeClass('active');
			$(this).closest('li').addClass('active');
		
			if (Cookies) {
				Cookies.set('theme', $(this).attr('data-theme'));
				$(document).trigger('theme-change');
			}
		});
		
		$(document).on('change', '.theme-panel [name="app-theme-dark-mode"]', function() {
			var targetCookie = '';
		
			if ($(this).is(':checked')) {
				$('html').addClass('dark-mode');
				targetCookie = 'dark-mode';
			} else {
				$('html').removeClass('dark-mode');
			}
		
			if (Cookies) {
				App.initVariable();
				Cookies.set('app-theme-dark-mode', targetCookie);
				$(document).trigger('theme-change');
			}
		});
		
		if (Cookies.get('theme') && $('.theme-list').length !== 0) {
			var targetElm = '.theme-list [data-theme="'+ Cookies.get('theme') +'"]';
			$(targetElm).trigger('click');
		}
		if (Cookies.get('app-theme-dark-mode') && $('.theme-panel [name="app-theme-dark-mode"]').length !== 0) {
			$('.theme-panel [name="app-theme-dark-mode"]').prop('checked', true).trigger('change');
		}
	}
};


/* 10. Handle Paroller
------------------------------------------------ */
var handleParoller = function() {
	if (typeof $.fn.paroller !== 'undefined') {
		if ($('[data-paroller="true"]').length !== 0) {
			$('[data-paroller="true"]').paroller();
		}
	}
};


/* 11. Handle Get Css Variable
------------------------------------------------ */
var getCssVariable = function(variable) {
	return window.getComputedStyle(document.body).getPropertyValue(variable).trim();
};


/* Application Controller
------------------------------------------------ */
var App = function () {
	"use strict";
	
	return {
		//main function
		init: function () {
			handleHomeContentHeight();
			handleHeaderNavigationState();
			handlePageContainerShow();
			handlePageScrollContentAnimation();
			handleHeaderScrollToAction();
			handleTooltipActivation();
			handleThemePanelExpand();
			handleThemePageControl();
			handleParoller();
			
			this.initVariable();
		},
		initVariable: function() {
			app.color.theme          = getCssVariable('--app-theme');
			app.font.family          = getCssVariable('--bs-body-font-family');
			app.font.size            = getCssVariable('--bs-body-font-size');
			app.font.weight          = getCssVariable('--bs-body-font-weight');
			app.color.componentColor = getCssVariable('--app-component-color');
			app.color.componentBg    = getCssVariable('--app-component-bg');
			app.color.dark           = getCssVariable('--bs-dark');
			app.color.light          = getCssVariable('--bs-light');
			app.color.blue           = getCssVariable('--bs-blue');
			app.color.indigo         = getCssVariable('--bs-indigo');
			app.color.purple         = getCssVariable('--bs-purple');
			app.color.pink           = getCssVariable('--bs-pink');
			app.color.red            = getCssVariable('--bs-red');
			app.color.orange         = getCssVariable('--bs-orange');
			app.color.yellow         = getCssVariable('--bs-yellow');
			app.color.green          = getCssVariable('--bs-green');
			app.color.success        = getCssVariable('--bs-success');
			app.color.teal           = getCssVariable('--bs-teal');
			app.color.cyan           = getCssVariable('--bs-cyan');
			app.color.white          = getCssVariable('--bs-white');
			app.color.gray           = getCssVariable('--bs-gray');
			app.color.lime           = getCssVariable('--bs-lime');
			app.color.gray100        = getCssVariable('--bs-gray-100');
			app.color.gray200        = getCssVariable('--bs-gray-200');
			app.color.gray300        = getCssVariable('--bs-gray-300');
			app.color.gray400        = getCssVariable('--bs-gray-400');
			app.color.gray500        = getCssVariable('--bs-gray-500');
			app.color.gray600        = getCssVariable('--bs-gray-600');
			app.color.gray700        = getCssVariable('--bs-gray-700');
			app.color.gray800        = getCssVariable('--bs-gray-800');
			app.color.gray900        = getCssVariable('--bs-gray-900');
			app.color.black          = getCssVariable('--bs-black');
			
			app.color.themeRgb          = getCssVariable('--app-theme-rgb');
			app.font.familyRgb          = getCssVariable('--bs-body-font-family-rgb');
			app.font.sizeRgb            = getCssVariable('--bs-body-font-size-rgb');
			app.font.weightRgb          = getCssVariable('--bs-body-font-weight-rgb');
			app.color.componentColorRgb = getCssVariable('--app-component-color-rgb');
			app.color.componentBgRgb    = getCssVariable('--app-component-bg-rgb');
			app.color.darkRgb           = getCssVariable('--bs-dark-rgb');
			app.color.lightRgb          = getCssVariable('--bs-light-rgb');
			app.color.blueRgb           = getCssVariable('--bs-blue-rgb');
			app.color.indigoRgb         = getCssVariable('--bs-indigo-rgb');
			app.color.purpleRgb         = getCssVariable('--bs-purple-rgb');
			app.color.pinkRgb           = getCssVariable('--bs-pink-rgb');
			app.color.redRgb            = getCssVariable('--bs-red-rgb');
			app.color.orangeRgb         = getCssVariable('--bs-orange-rgb');
			app.color.yellowRgb         = getCssVariable('--bs-yellow-rgb');
			app.color.greenRgb          = getCssVariable('--bs-green-rgb');
			app.color.successRgb        = getCssVariable('--bs-success-rgb');
			app.color.tealRgb           = getCssVariable('--bs-teal-rgb');
			app.color.cyanRgb           = getCssVariable('--bs-cyan-rgb');
			app.color.whiteRgb          = getCssVariable('--bs-white-rgb');
			app.color.grayRgb           = getCssVariable('--bs-gray-rgb');
			app.color.limeRgb           = getCssVariable('--bs-lime-rgb');
			app.color.gray100Rgb        = getCssVariable('--bs-gray-100-rgb');
			app.color.gray200Rgb        = getCssVariable('--bs-gray-200-rgb');
			app.color.gray300Rgb        = getCssVariable('--bs-gray-300-rgb');
			app.color.gray400Rgb        = getCssVariable('--bs-gray-400-rgb');
			app.color.gray500Rgb        = getCssVariable('--bs-gray-500-rgb');
			app.color.gray600Rgb        = getCssVariable('--bs-gray-600-rgb');
			app.color.gray700Rgb        = getCssVariable('--bs-gray-700-rgb');
			app.color.gray800Rgb        = getCssVariable('--bs-gray-800-rgb');
			app.color.gray900Rgb        = getCssVariable('--bs-gray-900-rgb');
			app.color.blackRgb          = getCssVariable('--bs-black-rgb');
		}
	};
}();

$(document).ready(function() {
	App.init();
});
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
