<?php
//============================================================+
// File name   : example_005.php
// Begin       : 2008-03-04
// Last Update : 2013-05-14
//
// Description : Example 005 for TCPDF class
//               Multicell
//
// Author: Nicola Asuni
//
// (c) Copyright:
//               Adilson Dinis Figueira
//               Tecnick.com LTD
//               www.tecnick.com
//               info@tecnick.com
//============================================================+

/**
 * Creates an example PDF TEST document using TCPDF
 * @package com.tecnick.tcpdf
 * @abstract TCPDF - Example: Multicell
 * @author Nicola Asuni
 * @since 2008-03-04
 */

// Include the main TCPDF library (search for installation path). Bonastaff
//require_once('tcpdf_include.php');

// create new PDF document
$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

// set document information
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Adilson Figueira');
$pdf->SetTitle('Ficha Vencedora');
$pdf->SetSubject('TCPDF Tutorial');
$pdf->SetKeywords('TCPDF, PDF, example, test, guide');

// set default header data
$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE.'Mô Jogos', PDF_HEADER_STRING);

// set header and footer fonts
$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

// set default monospaced font
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

// set margins
$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
$pdf->setPrintHeader(FALSE);
$pdf->setPrintFooter(FALSE);
$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

// set auto page breaks
$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

// set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

// set some language-dependent strings (optional)
if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
	require_once(dirname(__FILE__).'/lang/eng.php');
	$pdf->setLanguageArray($l);
}

// ---------------------------------------------------------

// set font
$pdf->SetFont('times', '', 10);

// add a page
$pdf->AddPage();

// set cell padding
$pdf->setCellPaddings(1, 1, 1, 1);

// set cell margins
$pdf->setCellMargins(1, 1, 1, 1);

// set color for background
$pdf->SetFillColor(255, 255, 127);
// set a barcode on the page footer

$base_url = 'assets/images/logo';
$logotipo = 'logoPNG2.png';

//IMAGEM DO ESTUDANTE
$pdf->Image($base_url . '/'.$logotipo ,80, 5, 45, 30, '', '', '', false, 300, '', false, false, 0, false, false, false);

$table1 = '<table border="0"style="padding: 6px; font-family:  sans-serif; font-size: 8;"><tr>
 <th style="text-align: center" colspan="4"><b> SANGUNGA & FILHOS - COMERCIO E PRESTAÇÃO DE SERVIÇOS LDA </b><br> <b>Mô-JOGOS</b></th>
</tr>';
$table1  .= '</table>';
$pdf->SetY(38);
//$pdf->SetX(60);
$pdf->writeHTMLCell(0, 0, '', '', $table1, 0, 1, 0, true, 'C', true);
if ($sorteios['categoria'] == 'D') {
    $lianhas = $notificaCode['linha1'] . ',' . $notificaCode['linha2'] . ',' . $notificaCode['linha3'];
} elseif ($sorteios['categoria'] == 'S') {
    $lianhas = $notificaCode['linha1'] . ',' . $notificaCode['linha2'] . ',' . $notificaCode['linha3'] . ',' . $notificaCode['linha4'];
} elseif ($sorteios['categoria'] == 'S') {
    $lianhas = $notificaCode['linha1'] . ',' . $notificaCode['linha2'] . ',' . $notificaCode['linha3'] . ',' . $notificaCode['linha4'] . ',' . $notificaCode['linha5'];
}
$adilson ='<h2>O Vencedor</h2>';
$adilson .='<br><br><br>';
$adilson .='<table class="table table-invoice" border="0"  width="100%">
    <tr >
        <th  style="text-align: left;" width="40%"><strong>Nome </strong></th>
        <th  width="30%"><strong>Nº de Telefone </strong></th>
        <th  style="text-align: right;" width="30%"><strong>Código Vencedor</strong></th>
    </tr>';

     $adilson .='<tr >
                <td class="text-left"><br>'.$utilizador['nome'].'
                </td>
                <td class="text-center" ><br> '.$utilizador['telefone'].'</td>
                <td  style="text-align: right"><br> '.$lianhas.' </td>
            </tr>';
$adilson .='</table>';
$pdf->writeHTML($adilson, true, false, true, false, '');

$adilson ='<br><br><h2>Cazola - '.$sorteios['nome'].'</h2>';
$adilson .='<br><br><br>';
$adilson .='<table class="table table-invoice" border="0" bgcolor="#f1f1f1"  width="100%">
    <tr >
        <th  style="text-align: right;" width="40%"></th>
        <th  width="30%"><strong>Nome Cazola </strong></th>
        <th  style="text-align: right;" width="30%"><strong>Descrição</strong></th>
    </tr>';

     $adilson .='<tr >
                <td class="text-left"><br><br>
                    <img src="'.base_url().'assets/images/sorteio/'. $sorteios['photo'].'" height="50" width="70" class="img-rounded height-50" alt="" />

                </td>
                <td class="text-center" ><br><br>'. $sorteios['nome'].'º Lugar </td>
                <td  style="text-align: right"><br><br>'. $sorteios['descricao'].' </td>
            </tr>';
$adilson .='</table>';
                        $adilson .='<br><br>';
                        $adilson .='<h2>Premios por Recebder</h2>';
                        $adilson .='<table class="table table-invoice" border="0"  width="100%">
                            <tr >
                                <th  style="text-align: right; border-bottom: 0;" width="40%"></th>
                                <th  style=" border-bottom: 0;" width="30%"><strong>Classificação</strong></th>
                                <th  style="text-align: right; border-bottom: 0;" width="30%"><strong>Nome</strong></th>
                            </tr>';
                        foreach ($premios_sorteios as $premio):
                            if($premio['nivel_premio'] == '0'){
                                $nivelPremio = 'Única';
                            } else {
                                $nivelPremio = $premio['nivel_premio'].'º Lugar';
                            }
                         $adilson .='<tr >
                                    <td class="text-left"><br><br>
                                        <img src="'.base_url().'assets/images/premio/'. $premio['photo_premio'].'" height="50" width="70" class="img-rounded height-50" alt="" />

                                    </td>
                                    <td class="text-center" ><br><br>'. $nivelPremio.' </td>
                                    <td  style="text-align: right"><br><br>'. $premio['nome_premio'].' </td>
                                </tr>';

                        endforeach;
                        $adilson .='</table>';
            $adilson .='<br><br><br><br>';
            $adilson .='<div style="text-align:left;">* Resumo do Cazola<br />
                * Para Retirar a Ficha Vencedora, Terá de ter todo o Perfil Completamnete Preenchido<br />
                * Estamos em Talatona, Belas Business"s Spark, Edifício Cuando Cubango, 1º Andar, Apart. 102 - apresentar a Ficha Vencedora.
                </div>';
            $adilson .='<hr />';
            $adilson .='<div class="invoice-footer" style="text-align:center;">
                    <span class="text-center m-b-5 f-w-600">
                        OBRIGADO POR USAR OS NOSSOS SERVIÇOS
                    </span><br>
                    <span class="text-center">
                        <span class="m-r-10"><i class="fa fa-fw fa-lg fa-globe"></i> www.mojogos.ao</span>
                        <span class="m-r-10"><i class="fa fa-fw fa-lg fa-phone-volume"></i> T:+244 225 400 320</span>
                        <span class="m-r-10"><i class="fa fa-fw fa-lg fa-envelope"></i>info@mojogos.ao</span>
                    </span>
                </div>
            </div>';


$pdf->writeHTML($adilson, true, false, true, false, '');
 


$pdf->lastPage();

// ---------------------------------------------------------

//Close and output PDF document
ob_clean();
$pdf->Output('fichaVencodora.pdf', 'I');

//============================================================+
// END OF FILE
//============================================================+


