<?php
//============================================================+
// File name   : example_005.php
// Begin       : 2008-03-04
// Last Update : 2013-05-14
//
// Description : Example 005 for TCPDF class
//               Multicell
//
// Author: Nicola Asuni
//
// (c) Copyright:
//               Adilson Dinis Figueira
//               mojogos.com LTD
//               www.mojogos.com
//               info@tecnick.com
//============================================================+



// Include the main TCPDF library (search for installation path). Bonastaff
//require_once('tcpdf_include.php');

// create new PDF document
//$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, 'ROLL_PAPER', true, 'UTF-8', false); // para imprimir nas termicas
$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false); // para imprimir em A4

// set document information
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Adilson Figueira');
$pdf->SetTitle('HISTÓRICO');
$pdf->SetSubject('TCPDF Tutorial');
$pdf->SetKeywords('TCPDF, PDF, example, test, guide');

// set default header data
$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE.'Mô Jogos', PDF_HEADER_STRING);

// set header and footer fonts
$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

// remove default header/footer
$pdf->setPrintHeader(false);
$pdf->setPrintFooter(false);

// set default monospaced font
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

// set margins
$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
//$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

// set auto page breaks
$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

// set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

// set some language-dependent strings (optional)
if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
	require_once(dirname(__FILE__).'/lang/eng.php');
	$pdf->setLanguageArray($l);
}

// ---------------------------------------------------------

// set font
$pdf->SetFont('times', '', 10);

// add a page
$pdf->AddPage();

// set cell padding
$pdf->setCellPaddings(1, 1, 1, 1);

// set cell margins
$pdf->setCellMargins(1, 1, 1, 1);

// set color for background
$pdf->SetFillColor(255, 255, 127);




$base_url = 'assets/images/logo';
$logotipo = 'logoPNG2.png';

//IMAGEM DO ESTUDANTE
$pdf->Image($base_url . '/'.$logotipo ,80, 5, 45, 30, '', '', '', false, 300, '', false, false, 0, false, false, false);

$table1 = '<table border="0"style="padding: 6px; font-family:  sans-serif; font-size: 8;"><tr>
 <th style="text-align: center" colspan="4"><b> SANGUNGA & FILHOS - COMERCIO E PRESTAÇÃO DE SERVIÇOS LDA </b><br> <b>MÔ-JOGOS</b></th>
</tr>';
$table1  .= '</table>';
$pdf->SetY(38);
//$pdf->SetX(60);
$pdf->writeHTMLCell(0, 0, '', '', $table1, 0, 1, 0, true, 'C', true);

// 

// MultiCell($w, $h, $txt, $border=0, $align='J', $fill=0, $ln=1, $x='', $y='', $reseth=true, $stretch=0, $ishtml=false, $autopadding=true, $maxh=0)

$adilson ='<table style="border:1px solid #000; padding: 6px; font-family:  sans-serif;">';
$adilson .='<tr style="background-color: #6C7F92; color: #FFF;">
 <th style="border:1px solid #000; text-align: center;  width: 320px" colspan="4" ><strong>HISTÓRICO DE PARTICIPAÇÕES:</strong></th>
 <td style="border:1px solid #000; width: 150px; "><strong>DATA DO INÍCIO </strong></td>
 <td style="border:1px solid #000; width: 150px; "><strong>DATA DO FIM </strong></td>
 </tr> 
 
 <tr>
 <th style="border:1px solid #000; text-align: center" colspan="4">Participações desde </th>
 <td style="border:1px solid #000;">'. implode('-',array_reverse(explode('/',$tableHead['DataInicio']))).'</td>
 <td style="border:1px solid #000;">'.implode('-',array_reverse(explode('/',$tableHead['DataFim']))).'</td>
 </tr>';
$adilson .='</table>';
$pdf->writeHTMLCell(0, 0,'','',$adilson,0,1,0,true,'C', true);

$contador=0;
$total=0;
 
$table ='<table style="border:1px solid #000; padding: 5px; font-family:  sans-serif; font-size: 10px;">';
$table .='<tr style="background-color: #6C7F92; color: #FFF;">
                <th style="border:1px solid #000; width: 40px;">#</th>
                <th style="border:1px solid #000; width: 110px;">CAZOLA</th>
                <th style="border:1px solid #000; width: 150px;">PARTICIPANTE</th>
                <th style="border:1px solid #000; width: 90px;">CÓDIGO</th>
                <th style="border:1px solid #000; width: 80px;">TELEFONE</th>
                <th style="border:1px solid #000; width: 60px;">CUSTO</th>
                <th style="border:1px solid #000; width: 90px;">FORMA</th>
           </tr>';
foreach ($relatorio as $value){
    $contador++;
    $total= $total + $value['custo']; 
    
    if ($value['modo_pagamento'] == 'V') {
         $pagamento = 'EXPRESS';
    } elseif ($value['modo_pagamento'] == 'R') {
        $pagamento = 'REFERÊNCIA';
    } elseif ($value['modo_pagamento'] == 'A') {
        $pagamento = 'PAGO NO AGENTE';
    } elseif ($value['modo_pagamento'] == 'S') {
        $pagamento = 'PAGO COM SALDO';
    }elseif ($value['modo_pagamento'] == 'M') {
        $pagamento = 'MENSAGEM';
    }
    
    if ($sorteios['categoria'] == 'D'):
         $todasLinhas =  $value['linha1'] . "," . $value['linha2'] . "," . $value['linha3']; 
    elseif ($sorteios['categoria'] == 'S'): 
         $todasLinhas = $value['linha1'] . "," . $value['linha2'] . "," . $value['linha3'] . "," . $value['linha4']; 
    elseif ($sorteios['categoria'] == 'M'): 
         $todasLinhas = $value['linha1'] . "," . $value['linha2'] . "," . $value['linha3'] . "," . $value['linha4'] . "," . $value['linha5']; 
    endif;

    $table .='<tr>
                <td style="border:1px solid #000;  width: 40px;">'.$contador.'</td>
                <td style="border:1px solid #000;  text-align: left; width: 110px;">'.$value['NomeSorteio'].'</td>
                <td style="border:1px solid #000;  text-align: center; width: 150px; ">'.$value['NomeUser'].'</td>
                <td style="border:1px solid #000;  text-align: center; width: 90px; ">'.$todasLinhas.'</td>
                <td style="border:1px solid #000;  text-align: center; width: 80px; ">'.$value['telefone'].'</td>
                <td style="border:1px solid #000;  text-align: center; width: 60px;"><strong>'.number_format($value['custo'], 2, ".", ","). ' AOA'.'</strong></td>
                <td style="border:1px solid #000;  text-align: center; width: 90px;">'.$pagamento.'</td>
           </tr>';
    
}
$table .='</table>';
$pdf->writeHTMLCell(0, 0,'','',$table,0,1,0,true,'C', true);


$table2 ='<table style="float: right; font-family:  sans-serif;font-size: 10px; padding: 6px;" >
    <tr style="background-color: #6C7F92; color: #FFF;">
        <td style="border:0px solid #000; width: 250px;" colspan="2" ><b>Resumo</b></td>
    </tr>
    <tr>
        <td style="border:0px solid #000; width: 100px; "><b>Participantes:</b></td>
        <td style="border:0px solid #000; width: 150px; ">'.$contador.'</td>
    </tr>
    <tr>
        <td style="border:0px solid #000; width: 100px; "><b>Pagamentos:</b></td>
        <td style="border:0px solid #000; width: 150px; ">'.number_format($total, 2, ",", ".") .' AOA</td>
    </tr>
</table>';
$pdf->writeHTMLCell(0, 20,'','',$table2,0,1,0,true,'L', true);

$table = '<table style=" padding: 6px; font-family:  sans-serif; font-size: 8px;">';

$table .= ' <tr>
 <td style=" text-align: left; width: 100px"><strong>DATA:</strong> </td>
 <td style="  width: 100px ">'.date('d-m-Y').'</td>
 </tr> 
 
 <tr>
 <td style=" text-align: left; width: 100px"><strong>OPERADOR: </strong></td>
 <td style=" text-align: left; width: 300px">'. strtoupper($user_actual).'</td>
 </tr>';

$table .= '</table>';

$pdf->writeHTMLCell(0, 20, '', '', $table, 0, 1, 0, true, 'L', true);


$table3 = '<table border="0"style="padding: 6px; font-family:  sans-serif; font-size: 8;"><tr>
 <th style="text-align: center" colspan="4"><strong> **Processado por computador** </strong></th>
</tr>';
$table3  .= '</table>';
$pdf->writeHTMLCell(0, 0, '', '', $table3, 0, 1, 0, true, 'C', true);
// move pointer to last page
$pdf->lastPage();

// ---------------------------------------------------------

//Close and output PDF document
ob_clean();
$pdf->Output('Relatorio_do_Sorteio.pdf', 'I');

//============================================================+
// END OF FILE
//============================================================+


