<?php

class Utilizador_m extends CI_Model {

    public function __construct() {
        $this->load->database();
    }

    
    public function sorteios() { // Listar sorteios
            $estado='1';
            $this->db->select('*');
            $this->db->from('sorteio');
            $this->db->where('estado =', $estado);
            $this->db->where('data_fim >', date('Y-m-d'));
            $query = $this->db->get();
            return $query->result_array();
    }
    public function buscarUsers() { 
        $procurar_p = $this->input->post('userName');
        if (empty($procurar_p)) {
            return NULL;
        } else {
            $this->db->select('U.*');
            $this->db->from('user U');
            $this->db->or_like('U.nome', $procurar_p);
            $query = $this->db->get();
            return $query->result_array();
        }
    }
    
     public function listarUsers($id = false) { // Listar sorteios
        if ($id === false) {
            $this->db->select('U.*, P.name as Pais_name,Pr.name as Provi_name,M.name as Municipio_name, A.nome as nomeAcesso');
            $this->db->from('user U');
            $this->db->join('paises P', 'P.id = U.pais_id');
            $this->db->join('provincias Pr', 'Pr.id = U.provincia_id');
            $this->db->join('municipios M', 'M.id = U.municipio_id');
            $this->db->join('acesso A', 'A.id = U.acesso_id');
            $query = $this->db->get();
            return $query->result_array();
        }

        $this->db->select('U.*, P.name as Pais_name,Pr.name as Provi_name,M.name as Municipio_name, A.nome as nomeAcesso');
        $this->db->from('user U');
        $this->db->join('paises P', 'P.id = U.pais_id');
        $this->db->join('provincias Pr', 'Pr.id = U.provincia_id');
        $this->db->join('municipios M', 'M.id = U.municipio_id');
        $this->db->join('acesso A', 'A.id = U.acesso_id');
        $this->db->where('U.id', $id);
        $query = $this->db->get();
        return $query->row_array();
    }
    
    
    
    public function listarUserOnly($id) { // Listar sorteios
        $this->db->select('U.*');
        $this->db->from('user U');
        $this->db->where('U.id', $id);
        $query = $this->db->get();
        return $query->row_array();
    }
    
    public function pegaLogin_byID($id){
        $this->db->select('*');
        $this->db->from('user');
        $this->db->where('id =', $id);
        $resultado = $this->db->get()->row();
//        if (count($resultado) == 1) {
        if ($resultado) {
            return $resultado;
        } else {
            return FALSE;
        }
    }
    
    
    public function listarPaises() { 
        $this->db->select('P.*');
        $this->db->from('paises P');
        $query = $this->db->get();
        return $query->result_array();
    }
    public function listarAcessos() { 
        $this->db->select('A.*');
        $this->db->from('acesso A');
        $query = $this->db->get();
        return $query->result_array();
    }
    public function listarProvincias($idPais) { // Listar sorteios_prémios
        $this->db->select('P.*');
        $this->db->from('provincias P');
        $this->db->where('P.paise_id', $idPais);
        $query = $this->db->get();
        return $query->result_array();
    }
    
    
    public function listarMunicipio($idProvincia) { // Listar sorteios_prémios
        $this->db->select('M.*');
        $this->db->from('municipios M');
        $this->db->where('M.provincia_id', $idProvincia);
        $query = $this->db->get();
        return $query->result_array();
    }
    public function salvar() {
        
        if ($this->input->post('genero') === 'M') {
            $fotografia = 'homem.jpg';
        } else {
            $fotografia = 'mulher.jpg';
        }
        // Fortificar a password de formas a tornar ainda mais segura
        $email_separado = explode("@", $this->input->post('email'));
        $username=$email_separado[0];
        $password = strrev(sha1(strtoupper($this->input->post('password'))));
        $data = array(
            'username' => $username,
            'nome' => $this->input->post('nome'),
            'email' => $this->input->post('email'),
            'password' => $password,
            'telefone' => $this->input->post('telefone'),
            'photo'=> $fotografia,
            'genero'=> $this->input->post('genero'),
            'created_at' => date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s')
        );
        
        if ($this->db->insert('user', $data)) {
            $this->conta_user($this->db->insert_id());
        }
    }
    
    public function actualizar($fotografia = false) {
        $email_separado = explode("@", $this->input->post('email'));
        $username=$email_separado[0];
        $concluido = 1;
        if ($fotografia) {
            
            $data = array(
            'username' => $username,
            'nome' => $this->input->post('profilename'),
            'email' => $this->input->post('email'),
            'genero' => $this->input->post('genero'),
//            'telefone' => $this->input->post('telefone'),
            'bi' => strtoupper($this->input->post('bi')),
            'data_nasc' => $this->input->post('data_nasc'),
            'morada' => $this->input->post('morada'),
            'pais_id' => $this->input->post('pais_id'),
            'provincia_id' => $this->input->post('provincia_id'),
            'municipio_id' => $this->input->post('municipio_id'),
            'acesso_id' => $this->input->post('acesso_cod'),
            'concluido' => $concluido,
            'photo'=> $fotografia,
            'updated_at' => date('Y-m-d H:i:s')
            );
        } else {
            $data = array(
                'username' => $username,
                'nome' => $this->input->post('profilename'),
                'email' => $this->input->post('email'),
                'genero' => $this->input->post('genero'),
//                'telefone' => $this->input->post('telefone'),
                'bi' => strtoupper($this->input->post('bi')),
                'data_nasc' => $this->input->post('data_nasc'),
                'morada' => $this->input->post('morada'),
                'pais_id' => $this->input->post('pais_id'),
                'provincia_id' => $this->input->post('provincia_id'),
                'municipio_id' => $this->input->post('municipio_id'),
                'acesso_id' => $this->input->post('acesso_cod'),
                'concluido' => $concluido,
                'updated_at' => date('Y-m-d H:i:s')
            );
        }

        $this->db->where('id', $this->input->post('id_user'));
        return $this->db->update('user', $data);
    }

    public function conta_user($userID) {
        
        
        $data = array(
            'user_id' => $userID,
            'saldo' => 0.0,
            'created_at' => date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s')
        );
        
        return $this->db->insert('conta', $data);
    }

    public function eliminar($id) {
        $this->db->where('id', $id);
        $this->db->delete('user');
        return true;
    }

    


    public function verifica_email($email,$codUser) { // Listar sorteios_prémios
        $this->db->select('M.*');
        $this->db->from('user M');
        $this->db->where('M.email', $email);
        $this->db->where('M.id !=', $codUser);
        $query = $this->db->get();
        $resultado = $query->row_array();
        //if (count($resultado) > 0) {
        if ($resultado) {
            return TRUE;
        } else {
            return FALSE;
        }
    }
    public function verifica_BILHETE($bilhete,$codUser) { // Listar sorteios_prémios
        $this->db->select('M.*');
        $this->db->from('user M');
        $this->db->where('M.bi', $bilhete);
        $this->db->where('M.id !=', $codUser);
        $query = $this->db->get();
        $resultado = $query->row_array();
        //if (count($resultado) > 0) {
        if ($resultado) {
            return TRUE;
        } else {
            return FALSE;
        }
    }


    // Verifica o número de identificação B.I ou Passaporte
    public function verifica_telefone($telefone) {
        $query = $this->db->get_where('user', array('telefone' => $telefone));
        $resultado = $query->row_array();
        //if (count($resultado) > 0) {
        if ($resultado) {
            return TRUE;
        } else {
            return FALSE;
        }
    }
    
    

    // Calcular a idade do estudante 26-07-2017
    public function calcular_idade($data_nascimento) {
        if (isset($data_nascimento)) {
            $data_separada = explode("/", $data_nascimento);
            $idade_estudante = date('Y') - $data_separada[0];
            if ($idade_estudante < 18) {
                return TRUE;
            } else {
                return FALSE;
            }
        }
    }

    // verificar a data
    public function verifica_datanascimento($data_nascimento) {
        if (isset($data_nascimento)) {
            if (strtotime($data_nascimento) >= strtotime(date("Y-m-d"))) {
                return true;
            } else {
                return false;
            }
        }
    }

    public function actualizarFotografia($fotografia, $id) {
        $data = array(
            'fotografia' => $fotografia
        );
        $this->db->where('id', $id);
        return $this->db->update('user', $data);
    }

    // Metodo para activar e desactivar utilizador
    public function activarDesactivarUser($id, $status) {
        if ($status == "S") {
            $status = "N"; // caso o status passado por paramatro já for S entao desativa caso contrario desativa
        } else {
            $status = "S";
        }
        $data = array(
            'status' => $status
        );
        $this->db->where('id', $id);
        return $this->db->update('user', $data);
    }


    public function actualizarpassword($password_nova, $uti_codigo) {
        $password = strrev(sha1(strtoupper(trim($password_nova))));
        $data = array(
            'password' => $password
        );

        $this->db->where('id', $uti_codigo);
        return $this->db->update('user', $data);
    }
    public function actualizaEstadoReferencia($codPayment) {
        
        $data = array(
            'estado' => '1'
        );

        $this->db->where('cod_payment', $codPayment);
        return $this->db->update('referencia', $data);
    }
    public function notificacoes($userID) { 
       $notifiStates = 0;
        $this->db->select('n.*, r.userCodeSecre, r.user_id, r.sorteio_id,r.nivel_premio,s.nome as nomeSorteio');
        $this->db->from('notificacao n');
        $this->db->join('resultados r', 'r.id = n.resultado_id');
        $this->db->join('sorteio s', 's.id = r.sorteio_id');
        $this->db->where('n.estado', $notifiStates);
        $this->db->where('r.user_id', $userID);
        $query = $this->db->get();
        return $query->result_array();
    }
    
    
    public function BuscarSoretiosUseresForGet($url) {

        $curl = curl_init($url);
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

        $resp = curl_exec($curl);
        curl_close($curl);
        return $resp;

    }
    
    public function POSTSorteioCURL($url, $data) {

        $curl = curl_init($url);
        //curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

        $resp = curl_exec($curl);
        curl_close($curl);

//        return json_decode($resp);
        return $resp;
//        var_dump($resp);
    }
}
