<?php

class Users_m extends CI_Model {

    public function __construct() {
        $this->load->database();
    }

    
    public function sorteios($categoria) { // Listar sorteios
            $estado='1';
            $this->db->select('*');
            $this->db->from('sorteio');
            $this->db->where('estado =', $estado);
            $this->db->where('categoria =', $categoria);
            $this->db->where('apresentacao =', '1');
            $this->db->where('data_fim >=', date('Y-m-d'));
            $this->db->order_by('id', 'desc');
            $query = $this->db->get();
            return $query->result_array();
    }
    
  
    
    public function listarUsers($id = false) { // Listar sorteios
        if ($id === false) {
            $this->db->select('U.*, P.name as Pais_name,Pr.name as Provi_name,M.name as Municipio_name');
            $this->db->from('user U');
            $this->db->join('paises P', 'P.id = U.pais_id');
            $this->db->join('provincias Pr', 'Pr.id = U.provincia_id');
            $this->db->join('municipios M', 'M.id = U.municipio_id');
            $query = $this->db->get();
            return $query->result_array();
        }

        $this->db->select('U.*, P.name as Pais_name,Pr.name as Provi_name,M.name as Municipio_name');
        $this->db->from('user U');
        $this->db->join('paises P', 'P.id = U.pais_id');
        $this->db->join('provincias Pr', 'Pr.id = U.provincia_id');
        $this->db->join('municipios M', 'M.id = U.municipio_id');
        $this->db->where('U.id', $id);
        $query = $this->db->get();
        return $query->row_array();
    }
    
    
    public function listarPorParticipacoesPorCazolas($sorteioID, $categoria) {
        if($categoria == 'D'){
            $this->db->select ('n.*, u.nome as NomeUser, u.telefone, s.nome as NomeSorteio, c.linha1, c.linha2, c.linha3');
            $this->db->from ('user_sorteio n');
            $this->db->join ('user u', 'u.id = n.user_id');
            $this->db->join ('sorteio s', 's.id = n.sorteio_id');
            $this->db->join ('cartela_diaria c', 'c.id = n.cod_sorteio');
            $this->db->where ('n.paymentState', '1'); // SORTEIO COM ESTADO PAGO
            $this->db->where ('n.sorteio_id', $sorteioID);
            $this->db->where ('n.user_id =', $this->session->userdata ('user_session')['id']);
            $query = $this->db->get ();
            return $query->result_array ();
        }elseif($categoria == 'S'){
        $this->db->select('n.*, u.nome as NomeUser, u.telefone, s.nome as NomeSorteio, c.linha1, c.linha2, c.linha3, c.linha4');
            $this->db->from('user_sorteio n');
            $this->db->join('user u', 'u.id = n.user_id');
            $this->db->join('sorteio s', 's.id = n.sorteio_id');
            $this->db->join ('cartela_semanal c', 'c.id = n.cod_sorteio');
            $this->db->where('n.paymentState', '1'); // SORTEIO COM ESTADO PAGO
            $this->db->where('n.sorteio_id', $sorteioID);
            $this->db->where('n.user_id =', $this->session->userdata('user_session')['id']);
            $query = $this->db->get();
            return $query->result_array();
        }else{
            $this->db->select('n.*, u.nome as NomeUser, u.telefone, s.nome as NomeSorteio, c.linha1, c.linha2, c.linha3, c.linha4, c.linha5');
            $this->db->from('user_sorteio n');
            $this->db->join('user u', 'u.id = n.user_id');
            $this->db->join('sorteio s', 's.id = n.sorteio_id');
            $this->db->join ('cartela_mensal c', 'c.id = n.cod_sorteio');
            $this->db->where('n.paymentState', '1'); // SORTEIO COM ESTADO PAGO
            $this->db->where('n.sorteio_id', $sorteioID);
            $this->db->where('n.user_id =', $this->session->userdata('user_session')['id']);
            $query = $this->db->get();
            return $query->result_array();
        }
            
    }

    public function pegaConta_byID($id){
        $this->db->select('*');
        $this->db->from('conta');
        $this->db->where('user_id =', $id);
        $resultado = $this->db->get()->row();
//        if (count($resultado) == 1) {
        if ($resultado) {
            return $resultado;
        } else {
            return FALSE;
        }
    }
    
    public function pegaLogin_byID($id){
        $this->db->select('*');
        $this->db->from('user');
        $this->db->where('id =', $id);
        $resultado = $this->db->get()->row();
//        if (count($resultado) == 1) {
        if ($resultado) {
            return $resultado;
        } else {
            return FALSE;
        }
    }
    
    public function Pegar_EstadoPerfil(){
        $this->db->select('*');
        $this->db->from('user');
        $this->db->where('id =', $this->session->userdata('user_session')['id']);
        $resultado = $this->db->get()->row()->concluido;
//        if (count($resultado) == 1) {
        if ($resultado) {
            return $resultado;
        } else {
            return FALSE;
        }
    }
    
    // Metodo para activar e desactivar utilizador
    public function activarDesactivarUserRole($id, $status) {
        
        $data = array(
            'role' => $status
        );
        $this->db->where('id', $id);
        return $this->db->update('user', $data);
    }
    
    // Metodo para activar e desactivar utilizador
    public function BloaquearDesbloquearUser($id, $status) {
        
        $data = array(
            'estado' => $status
        );
        $this->db->where('id', $id);
        return $this->db->update('user', $data);
    }
    
    public function listarSorteio($id = false) { // Listar sorteios
        if ($id === false) {
            $this->db->select('P.*');
            $this->db->from('sorteio P');
            $query = $this->db->get();
            return $query->result_array();
        }
        $this->db->select('P.*');
        $this->db->from('sorteio P');
        $this->db->where('P.id', $id);
        $query = $this->db->get();
        return $query->row_array();
    }
    public function listar_sorteios_premios($id = false) { // Listar sorteios_prémios
        $this->db->select('r.*, s.descricao');
        $this->db->from('premio r');
        $this->db->join('premio_mone s', 's.id = r.premio_nome_id');
        $this->db->where('r.sorteio_id', $id);
        $query = $this->db->get();
        return $query->result_array();
    }
    public function listarPaises() { // Listar sorteios_prémios 
        $this->db->select('P.*');
        $this->db->from('paises P');
        $query = $this->db->get();
        return $query->result_array();
    }
    public function listarProvincias($idPais) { // Listar sorteios_prémios
        $this->db->select('P.*');
        $this->db->from('provincias P');
        $this->db->where('P.paise_id', $idPais);
        $query = $this->db->get();
        return $query->result_array();
    }
    
    public function guardarDadosRemocao($motivoRemocao,$userCod) {
        $data = array(
            'user_id' => $userCod,
            'motivo' => $motivoRemocao,
            'created_at' => date('Y-m-d H:i:s')
        );
        
        return $this->db->insert('user_remove', $data);
    }
    public function actualizarParaRemocao($userCod) {
            $data = array(
                'estado' => '3',
                'removed_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            );
        $this->db->where('id', $userCod);
        return $this->db->update('user', $data);
    }
    public function listarMunicipio($idProvincia) { // Listar sorteios_prémios
        $this->db->select('M.*');
        $this->db->from('municipios M');
        $this->db->where('M.provincia_id', $idProvincia);
        $query = $this->db->get();
        return $query->result_array();
    }
    public function salvar() {
        
        if ($this->input->post('genero') === 'M') {
            $fotografia = 'homem.jpg';
        } else {
            $fotografia = 'mulher.jpg';
        }
        // Fortificar a password de formas a tornar ainda mais segura
        $email_separado = explode("@", $this->input->post('email'));
        $username=$email_separado[0];
        $password = strrev(sha1(strtoupper($this->input->post('password'))));
        $data = array(
            'username' => $username,
            'nome' => ucfirst($this->input->post('nome')),
            'email' => $this->input->post('email'),
            'password' => $password,
            'telefone' => $this->input->post('telefone'),
            'photo'=> $fotografia,
            'genero'=> $this->input->post('genero'),
            'dia' => date('Y-m-d'),
            'created_at' => date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s')
        );
        
        if ($this->db->insert('user', $data)) {
            $this->conta_user($this->db->insert_id());
        }
    }
    
    public function actualizar($fotografia = false) {
        $email_separado = explode("@", $this->input->post('email'));
        $username=$email_separado[0];
        $concluido = 1;
        if ($fotografia) {
            
            $data = array(
            'username' => $username,
            'nome' => ucfirst($this->input->post('profilename')),
            'email' => $this->input->post('email'),
            'genero' => $this->input->post('genero'),
//            'telefone' => $this->input->post('telefone'),
            'bi' => strtoupper($this->input->post('bi')),
            'data_nasc' => $this->input->post('data_nasc'),
            'morada' => $this->input->post('morada'),
            'pais_id' => $this->input->post('pais_id'),
            'provincia_id' => $this->input->post('provincia_id'),
            'municipio_id' => $this->input->post('municipio_id'),
            'concluido' => $concluido,
            'photo'=> $fotografia,
            'updated_at' => date('Y-m-d H:i:s')
            );
        } else {
            $data = array(
                'username' => $username,
                'nome' => ucfirst($this->input->post('profilename')),
                'email' => $this->input->post('email'),
                'genero' => $this->input->post('genero'),
//                'telefone' => $this->input->post('telefone'),
                'bi' => strtoupper($this->input->post('bi')),
                'data_nasc' => $this->input->post('data_nasc'),
                'morada' => $this->input->post('morada'),
                'pais_id' => $this->input->post('pais_id'),
                'provincia_id' => $this->input->post('provincia_id'),
                'municipio_id' => $this->input->post('municipio_id'),
                'concluido' => $concluido,
                'updated_at' => date('Y-m-d H:i:s')
            );
        }

        $this->db->where('id', $this->input->post('id_user'));
        return $this->db->update('user', $data);
    }

    public function conta_user($userID) {
        
        
        $data = array(
            'user_id' => $userID,
            'saldo' => 0.0,
            'dia' => date('Y-m-d'),
            'created_at' => date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s')
        );
        
        return $this->db->insert('conta', $data);
    }

    public function eliminar($id) {
        $this->db->where('id', $id);
        $this->db->delete('user');
        return true;
    }

    

//     verifica se o nome de utilizador a ser informado já esta a ser usado por outro utilizador
    public function verificarEstadoSorteio($sorteioCOD) {
        $estado ='1';
        $query = $this->db->get_where('sorteio', array('id' => $sorteioCOD, 'estado !=' => $estado));
        $resultado = $query->row_array();
        // Se haver conteúdo, então este sorteio foi concluído ou inativado
//        if (count($resultado) > 0) {
        if ($resultado) {
            return TRUE;
        } else {
            return FALSE;
        }
    }

    public function verifica_email($email) { // Listar sorteios_prémios
        $this->db->select('M.*');
        $this->db->from('user M');
        $this->db->where('M.email', $email);
        $this->db->where('M.id !=', $this->session->userdata('user_session')['id']);
        $query = $this->db->get();
        $resultado = $query->row_array();
//        if (count($resultado) > 0) {
        if ($resultado) {
            return TRUE;
        } else {
            return FALSE;
        }
    }
    public function verifica_BILHETE($bilhete) { // Listar sorteios_prémios
        $this->db->select('M.*');
        $this->db->from('user M');
        $this->db->where('M.bi', $bilhete);
        $this->db->where('M.id !=', $this->session->userdata('user_session')['id']);
        $query = $this->db->get();
        $resultado = $query->row_array();
//        if (count($resultado) > 0) {
        if ($resultado) {
            return TRUE;
        } else {
            return FALSE;
        }
    }
//    public function verifica_BILHETE($bilhete) {
//        $query = $this->db->get_where('user', array('bi' => strtoupper($bilhete)));
//        $resultado = $query->row_array();
//        if (count($resultado) > 0) {
//            return TRUE;
//        } else {
//            return FALSE;
//        }
//    }

    // Verifica o número de identificação B.I ou Passaporte
    public function verifica_telefone($telefone) {
        $query = $this->db->get_where('user', array('telefone' => $telefone));
        $resultado = $query->row_array();
//        if (count($resultado) > 0) {
        if ($resultado) {
            return TRUE;
        } else {
            return FALSE;
        }
    }
    
    

    // Calcular a idade do estudante 26-07-2017
    public function calcular_idade($data_nascimento) {
        if (isset($data_nascimento)) {
            $data_separada = explode("/", $data_nascimento);
            $idade_estudante = date('Y') - $data_separada[0];
            if ($idade_estudante < 18) {
                return TRUE;
            } else {
                return FALSE;
            }
        }
    }

    // verificar a data
    public function verifica_datanascimento($data_nascimento) {
        if (isset($data_nascimento)) {
            if (strtotime($data_nascimento) >= strtotime(date("Y-m-d"))) {
                return true;
            } else {
                return false;
            }
        }
    }

    public function actualizarFotografia($fotografia, $id) {
        $data = array(
            'fotografia' => $fotografia
        );
        $this->db->where('id', $id);
        return $this->db->update('user', $data);
    }

    // Metodo para activar e desactivar utilizador
    public function activarDesactivarUser($id, $status) {
        if ($status == "S") {
            $status = "N"; // caso o status passado por paramatro já for S entao desativa caso contrario desativa
        } else {
            $status = "S";
        }
        $data = array(
            'status' => $status
        );
        $this->db->where('id', $id);
        return $this->db->update('user', $data);
    }

    public function buscar_password($id) {
        if (!is_null($id)) {
            $this->db->select('password');
            $this->db->from('users');
            $this->db->where('id', $id);
            return $this->db->get()->row()->password; // pegamos o a password do utilizador
        }
    }

    public function actualizarpassword($password_nova, $uti_codigo) {
        $password = strrev(sha1(strtoupper(trim($password_nova))));
        $data = array(
            'password' => $password
        );

        $this->db->where('id', $uti_codigo);
        return $this->db->update('user', $data);
    }
    public function actualizaEstadoReferencia($codPayment, $refenciaID) {
        
        $data = array(
            'estado' => '1'
        );

        $this->db->where('cod_payment', $codPayment);
        if($this->db->update('referencia', $data)){
            $this->actualizaEstadoUserSorteio($refenciaID);
        }
         
    }
    public function actualizaEstadoUserSorteio($refenciaID) {
        $data = array(
            'paymentState' => 1
        );

        $this->db->where('referencia_id', $refenciaID);
        return $this->db->update('user_sorteio', $data);
    }
    public function notificacoes($userID) { 
       $notifiStates = 0;
        $this->db->select('n.*, r.userCodeSecre, r.user_id, r.sorteio_id,r.nivel_premio,s.nome as nomeSorteio');
        $this->db->from('notificacao n');
        $this->db->join('resultados r', 'r.id = n.resultado_id');
        $this->db->join('sorteio s', 's.id = r.sorteio_id');
        $this->db->where('n.estado', $notifiStates);
        $this->db->where('r.user_id', $userID);
        $query = $this->db->get();
        return $query->result_array();
    }
    public function verifica_referenciaVPOS($id_reference_wiki) {
        $query = $this->db->get_where('referencia', array('cod_payment' => $id_reference_wiki));
        $resultado = $query->row_array();
//        if (count($resultado) > 0) {
        if ($resultado) {
            return TRUE;
        } else {
            return FALSE;
        }
    }
    public function Eliminar_ReferenciaTransation($id) {
        $this->db->where('id', $id);
        $this->db->delete('referencia');
        return true;
    }
    public function Eliminar_Participacao_user_sorteio($id) {
        $this->db->where('referencia_id', $id);
        $this->db->delete('user_sorteio');
        return true;
    }
    public function salvar_referenciaVPOS($estado,$modoPayment,$amount,$entity_id,$expiry_date,$id_reference_wiki,$number,$total_numeros) {
        $data = array(
            'estado'=>$estado,
            'data_criacao' => date('Y-m-d H:i:s'),
            'data_vencimento' => $expiry_date,
            'cod_payment' => $id_reference_wiki,
            'valor' => $amount,
            'reference_number' => $number,
            'entidade' => $entity_id,
            'user_id'=> $this->session->userdata('user_session')['id'],
            'created_at' => date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s')
        );
        
        if ($this->db->insert('referencia', $data)) {
            $this->salvar_user_sorteioVPOS($modoPayment,$amount, $this->db->insert_id(),$total_numeros);
        }
    }
    
    public function salvar_referenciaKYAMI($estado,$modoPayment,$amount,$entity_id,$expiry_date,$id_reference_wiki,$number) {
        date_default_timezone_set('Africa/Luanda');
        $data = array(
            'estado'=>$estado,
            'data_criacao' => date('Y-m-d H:i:s'),
            'data_vencimento' => $expiry_date,
            'cod_payment' => $id_reference_wiki,
            'valor' => $amount,
            'reference_number' => $number,
            'entidade' => $entity_id,
            'user_id'=> $this->session->userdata('user_session')['id'],
            'created_at' => date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s')
        );
        
        if ($this->db->insert('referencia', $data)) {
            $this->salvar_contaPayment_KYAMI($modoPayment,$amount, $this->db->insert_id(),$estado);
        }
    }
    
    public function salvar_contaPayment_KYAMI($modoPayment, $amount, $id_reference,$estado) {
        $dadosConta = $this->m->pegaConta_byID($this->session->userdata('user_session')['id']);
        $data = array(
            'contaUser_id' => $dadosConta->id,
            'user_id' => $this->session->userdata('user_session')['id'],
            'estado' => $estado,
            'valor' => $amount,
            'id_reference' => $id_reference,
            'operacao' => 'C',
            'paymentMod' => $modoPayment,
            'dia' => date('Y-m-d'),
            'mes' => date('m'),
            'ano' => date('Y'),
            'created_at' => date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s')
        );
        return $this->db->insert('carrecarconta_user', $data);
    }
    
    public function salvar_DebitarConta_USER($modoPayment, $amount,$estado,$total_numeros) {
        $dadosConta = $this->m->pegaConta_byID($this->session->userdata('user_session')['id']);
        $data = array(
            'contaUser_id' => $dadosConta->id,
            'user_id' => $this->session->userdata('user_session')['id'],
            'estado' => $estado,
            'valor' => $amount,
            'operacao' => 'D',
            'dia' => date('Y-m-d'),
            'mes' => date('m'),
            'ano' => date('Y'),
            'created_at' => date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s')
        );
        
        if ($this->db->insert('carrecarconta_user', $data)) {
            $this->salvar_user_sorteioPelaConta($modoPayment, $amount, $this->db->insert_id(),$estado,$total_numeros);
        }
    }
    public function salvar_user_sorteioPelaConta($modoPayment, $amount, $id_DebitarContaUser,$estado,$total_numeros) {
//        'cod_sorteio' => $this->NovoCodigoSecreto($this->session->userdata('user_session')['id'], $this->input->post('codSecreto_sorteio'), $this->input->post('cod_sorteioID')),
        $data = array(
            'user_id' => $this->session->userdata('user_session')['id'],
            'sorteio_id' => $this->input->post('cod_sorteioID'),
            'cod_sorteio' => $this->criarBingo($total_numeros),
            'custo' => $amount,
            'modo_pagamento' => $modoPayment,
            'paymentState' => $estado,
            'id_carregamtUser' => $id_DebitarContaUser,
            'dia' => date('Y-m-d'),
            'mes' => date('m'),
            'ano' => date('Y'),
            'created_at' => date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s')
        );
        return $this->db->insert('user_sorteio', $data);
    }
    public function limeteIntervaloBingo($total_numeros) {
        if ($total_numeros == 9) {
            $total_intervalo = 60;
        } elseif ($total_numeros == 16) {
            $total_intervalo = 75;
        } elseif ($total_numeros == 25) {
            $total_intervalo = 90;
        }
        return $total_intervalo;
    }
    
    public function criarBingo($total_numeros) {
        $numeros = array();
        $intervalo = $this->limeteIntervaloBingo($total_numeros);

        while (count($numeros) < $total_numeros) {
            $numero = mt_rand(1, $intervalo);
            if (!in_array($numero, $numeros)) {
                $numeros[] = $numero;
            }
        }
        if ($total_numeros == 9) {
            return $this->devolverDiaria($numeros);
        } elseif ($total_numeros == 16) {
            return $this->devolverSemanal($numeros);
        } elseif ($total_numeros == 25) {
            return $this->devolverMensal($numeros);
        }
         
    }
    
    public function devolverDiaria($numeros) {
        $linha1 =[];
        $linha2 =[];
        $linha3 =[];
        for ($i = 0; $i < 3; $i++) {
            for ($j = 0; $j < 3; $j++) {
                $concat []=  $numeros[$i * 3 + $j];
            }
            if($i == 0){ $linha1 = $concat;}
            if($i == 1){ $linha2 = $concat;}
            if($i == 2){ $linha3 = $concat;}
            $concat = [];
        }
        return $this->salvar_cartelaDiaria( $linha1, $linha2, $linha3);
    }
    public function devolverSemanal($numeros) {
        $linha1 =[];
        $linha2 =[];
        $linha3 =[];
        $linha4 =[];
        for ($i = 0; $i < 4; $i++) {
            for ($j = 0; $j < 4; $j++) {
                $concat []=  $numeros[$i * 4 + $j];
            }
            if($i == 0){ $linha1 = $concat;}
            if($i == 1){ $linha2 = $concat;}
            if($i == 2){ $linha3 = $concat;}
            if($i == 3){ $linha4 = $concat;}
            $concat = [];
        }
        return $this->salvar_cartelaSemanal( $linha1, $linha2, $linha3,$linha4);
    }
    public function devolverMensal($numeros) {
        $linha1 =[];
        $linha2 =[];
        $linha3 =[];
        $linha4 =[];
        $linha5 =[];
        for ($i = 0; $i < 5; $i++) {
            for ($j = 0; $j < 5; $j++) {
                $concat []=  $numeros[$i * 5 + $j];
            }
            if($i == 0){ $linha1 = $concat;}
            if($i == 1){ $linha2 = $concat;}
            if($i == 2){ $linha3 = $concat;}
            if($i == 3){ $linha4 = $concat;}
            if($i == 4){ $linha5 = $concat;}
            $concat = [];
        }
        return $this->salvar_cartelaMensal( $linha1, $linha2, $linha3,$linha4,$linha5);
    }
    
    
    public function salvar_cartelaDiaria( $linha1, $linha2, $linha3) {
        
        $data = array(
            'linha1' => implode(',', $linha1),
            'linha2' => implode(',', $linha2),
            'linha3' => implode(',', $linha3),
            'dia' => date('Y-m-d'),
            'created_at' => date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s')
        );

        if ($this->db->insert('cartela_diaria', $data)) {
            return $this->db->insert_id();
        }
    }
    public function salvar_cartelaSemanal( $linha1, $linha2, $linha3,$linha4) {
        $data = array(
            'linha1' => implode(',', $linha1),
            'linha2' => implode(',', $linha2),
            'linha3' => implode(',', $linha3),
            'linha4' => implode(',', $linha4),
            'dia' => date('Y-m-d'),
            'created_at' => date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s')
        );

        if ($this->db->insert('cartela_semanal', $data)) {
            return $this->db->insert_id();
        }
    }
    
    public function salvar_cartelaMensal( $linha1, $linha2, $linha3,$linha4,$linha5) {
        $data = array(
            'linha1' => implode(',', $linha1),
            'linha2' => implode(',', $linha2),
            'linha3' => implode(',', $linha3),
            'linha4' => implode(',', $linha4),
            'linha5' => implode(',', $linha5),
            'dia' => date('Y-m-d'),
            'created_at' => date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s')
        );

        if ($this->db->insert('cartela_mensal', $data)) {
            return $this->db->insert_id();
        }
    }

    public function ActualizarReferenciaTransation( $cod_transation) {
        $data = array(
            'estado' => '1',
        );
        $this->db->where('cod_payment', $cod_transation);
        if ($this->db->update('referencia', $data)){
            return TRUE;
        }else{
            return FALSE;
        }
    }
    public function Actualizar_Carregar_user_conta($cod_referencia) {
        $data = array(
            'estado' => 1,
        );
        $this->db->where('id_reference', $cod_referencia);
        if ($this->db->update('carrecarconta_user', $data)){
            return TRUE;
        }else{
            return FALSE;
        }
    }
    public function Actualizar_Participacao_user_sorteio($cod_referencia) {
        $data = array(
            'paymentState' => 1,
        );
        $this->db->where('referencia_id', $cod_referencia);
        if ($this->db->update('user_sorteio', $data)){
            return TRUE;
        }else{
            return FALSE;
        }
    }
    public function buscar_COD_Referencia($cod_payment) {
        if (!is_null($cod_payment)) {
            $this->db->select('id');
            $this->db->from('referencia');
            $this->db->where('cod_payment', $cod_payment);
            return $this->db->get()->row()->id; // pegamos do pagamento
        }
    }
    
    public function buscar_Referencia_By_CODE($cod_payment) {
        if (!is_null($cod_payment)) {
            $this->db->select('cod_payment');
            $this->db->from('referencia');
            $this->db->where('id', $cod_payment);
            return $this->db->get()->row()->cod_payment; // pegamos do pagamento
        }
    }
    
    public function salvar_user_sorteioVPOS($modoPayment, $amount, $id_reference,$total_numeros) {
//        'cod_sorteio' => $this->NovoCodigoSecreto($this->session->userdata('user_session')['id'],$this->input->post('codSecreto_sorteio'),$this->input->post('cod_sorteioID')),
        $data = array(
            'user_id' => $this->session->userdata('user_session')['id'],
            'sorteio_id' => $this->input->post('cod_sorteioID'),
            'cod_sorteio' => $this->criarBingo($total_numeros),
            'custo' => $amount,
            'referencia_id' => $id_reference,
            'modo_pagamento' => $modoPayment,
            'paymentState' => 1,
            'dia' => date('Y-m-d'),
            'mes' => date('m'),
            'ano' => date('Y'),
            'created_at' => date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s')
        );
        return $this->db->insert('user_sorteio', $data);
    }

    public function salvar_referencia($modoPayment,$amount,$entity_id,$expiry_date,$id_reference_kyamipay,$number,$total_numeros) {
        $data = array(
            'data_criacao' => date('Y-m-d H:i:s'),
            'data_vencimento' => $expiry_date,
            'cod_payment' => $id_reference_kyamipay,
            'valor' => $amount,
            'reference_number' => $number,
            'entidade' => $entity_id,
            'user_id'=> $this->session->userdata('user_session')['id'],
            'created_at' => date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s')
        );
        
        
        if ($this->db->insert('referencia', $data)) {
            $this->salvar_user_sorteio($modoPayment,$amount, $this->db->insert_id(),$total_numeros);
        }
    }
    
    public function salvar_user_sorteio($modoPayment,$amount,$id_reference,$total_numeros) {
//        $codSorteioSecreto = intval($this->input->post('codSecreto_sorteio')) ;
//        $ID_Sorteio = intval($this->input->post('cod_sorteioID'));
//        'cod_sorteio' => $this->NovoCodigoSecreto($this->session->userdata('user_session')['id'],$codSorteioSecreto,$ID_Sorteio),
        $data = array(
            'user_id'=> $this->session->userdata('user_session')['id'],
            'sorteio_id' => $this->input->post('cod_sorteioID'),
            'cod_sorteio' => $this->criarBingo($total_numeros),
            'custo' => $amount,
            'referencia_id' => $id_reference,
            'modo_pagamento' => $modoPayment,
            'dia' => date('Y-m-d'),
            'mes' => date('m'),
            'ano' => date('Y'),
            'created_at' => date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s')
        );
        return $this->db->insert('user_sorteio', $data);
    }
    
    
    
    public function NovoCodigoSecreto($userCod, $sorteioCodSecreto, $sorteioID) {
        $valor_inicial = 001;
        $this->db->select_max('C.id');
        $this->db->from('user_sorteio C');
        $this->db->where('C.user_id', $userCod);
        $this->db->where('C.sorteio_id', $sorteioID);
        $resultado = $this->db->get()->row()->id;
//        return $resultado;

        if ($resultado == null) {
            return $sorteioCodSecreto . $userCod . $valor_inicial;
        } else {
            return $this->verifica_CriarCodigo_do_Sorteio($resultado) + 1;
        }
    }
    
    public function verifica_CriarCodigo_do_Sorteio($id) {
        $valor_inicial = 0;
        $this->db->select('C.cod_sorteio');
        $this->db->from('user_sorteio C');
        $this->db->where('C.id', $id);
        $resultado = $this->db->get()->row()->cod_sorteio;
        $rest = substr($resultado, -1);
        if($rest == 9){
            return $resultado.$valor_inicial;
        }else{
            return $resultado;
        }
    }
    
    public function somaCreditosClubeCazola($userID) {
        $this->db->select_sum('c.valor');
        $this->db->from('carrecarconta_user c');
        $this->db->join('referencia R', 'R.id = c.id_reference');
        $this->db->where('c.estado', 1);
        $this->db->where('c.operacao', 'C');
        $this->db->where('c.user_id', $userID);
        $query = $this->db->get();
        if ($query->row()->valor == null) {
            return 0;
        } else {
            return $query->row()->valor;
        }
    }

    public function somaDebitosClubeCazola($userID) {
        $this->db->select_sum('c.valor');
        $this->db->from('carrecarconta_user c');
        $this->db->where('c.operacao', 'D');
        $this->db->where('c.user_id', $userID);
        $query = $this->db->get();
        if ($query->row()->valor == null) {
            return 0;
        } else {
            return $query->row()->valor;
        }
    }

    public function CalcularSaldoClubeCazola($userID) {
        $creditos = $this->somaCreditosClubeCazola($userID);
        $debitos = $this->somaDebitosClubeCazola($userID);
        return $creditos - $debitos;
    }
    
    public function listar_DetalhesContaUserID($id) { 

        $this->db->select('c.*');
        $this->db->from('carrecarconta_user c');
        $this->db->where('c.user_id', $id);
        $this->db->order_by('c.id', 'desc');
        $this->db->limit(30);
        $query = $this->db->get();
        $resultado = $query->result_array();
        //if (count($resultado) > 0) {
        if ($resultado) {
            return $resultado;
        } else {
            return [];
        }
    }

    public function listarSorteiosHistorico($data = false) {
        if($data === FALSE){
            $this->db->group_by('p.id');
            $this->db->select('p.*');
            $this->db->from('sorteio p');
            $this->db->join('user_sorteio r', 'r.sorteio_id = p.id');
            $this->db->where('r.user_id', $this->session->userdata('user_session')['id']);
            $this->db->order_by('p.id', 'desc');
            $this->db->limit(10);
            $query = $this->db->get();
            return $query->result_array();
        }else{
            $this->db->group_by('p.id');
            $this->db->select('p.*');
            $this->db->from('sorteio p');
            $this->db->join('user_sorteio r', 'r.sorteio_id = p.id');
            $this->db->where('r.user_id', $this->session->userdata('user_session')['id']);
            $this->db->like('p.nome', $data);
//            $this->db->or_where('P.cod_sorteio', $data);
            $this->db->order_by('p.id', 'desc');
            
            $query = $this->db->get();
            return $query->result_array();
        }
    }
    
    public function listar_user_sorteioDiaria($userCod , $sorteioID) { 

        $this->db->select('C.*, r.linha1, r.linha2,r.linha3');
        $this->db->from('user_sorteio C');
        $this->db->join('cartela_diaria r', 'r.id = C.cod_sorteio');
        $this->db->where('C.user_id', $userCod);
        $this->db->where('C.sorteio_id', $sorteioID);
        $this->db->order_by('C.id', 'desc');
        $query = $this->db->get();
        return $query->result_array();
    }
    
    public function listar_user_sorteioSemanal($userCod , $sorteioID) { 

        $this->db->select('C.*, r.linha1, r.linha2,r.linha3,r.linha4');
        $this->db->from('user_sorteio C');
        $this->db->join('cartela_semanal r', 'r.id = C.cod_sorteio');
        $this->db->where('C.user_id', $userCod);
        $this->db->where('C.sorteio_id', $sorteioID);
        $this->db->order_by('C.id', 'desc');
        $query = $this->db->get();
        return $query->result_array();
    }
    
    public function listar_user_sorteioMensal($userCod , $sorteioID) { 

        $this->db->select('C.*, r.linha1, r.linha2,r.linha3, r.linha4, r.linha5');
        $this->db->from('user_sorteio C');
        $this->db->join('cartela_mensal r', 'r.id = C.cod_sorteio');
        $this->db->where('C.user_id', $userCod);
        $this->db->where('C.sorteio_id', $sorteioID);
        $this->db->order_by('C.id', 'desc');
        $query = $this->db->get();
        return $query->result_array();
    }
    public function listar_user_sorteioBY_Reference($userCod , $sorteioID) { 
        $this->db->select('C.*');
        $this->db->from('user_sorteio C');
//        $this->db->join('referencia R', 'R.id = C.referencia_id');
        $this->db->where('C.user_id', $userCod);
        $this->db->where('C.sorteio_id', $sorteioID);
        $this->db->where('C.modo_pagamento', 'R');
        $this->db->where('C.paymentState', 0);
        $this->db->order_by('C.id', 'desc');
        $query = $this->db->get();
        $resultado = $query->result_array();
        if($resultado){
            return $resultado;
        }else{
            return null;
        }
    }
    
    
    
     public function listar_ReferenciaUnica($cod_payment) { 

        $this->db->select('R.*');
        $this->db->from('referencia R');
        $this->db->where('R.cod_payment', $cod_payment);
        $query = $this->db->get();
        $resultado = $query->row_array();
        //if (count($resultado) > 0) {
        if ($resultado) {
            return $resultado;
        } else {
            return FALSE;
        }
    }
    public function listar_ReferenciaUnicaPorID($id) { 

        $this->db->select('R.*');
        $this->db->from('referencia R');
        $this->db->where('R.id', $id);
        $query = $this->db->get();
        $resultado = $query->row_array();
        //if (count($resultado) > 0) {
        if ($resultado) {
            return $resultado;
        } else {
            return FALSE;
        }
    }
    public function buscar_ReferenciaWIKIPAY($userCod , $sorteioID) { 

        $this->db->select('C.*,R.reference_number,R.entidade,R.data_vencimento,R.estado, R.cod_payment');
        $this->db->from('user_sorteio C');
        $this->db->join('referencia R', 'R.id = C.referencia_id');
        $this->db->where('C.user_id', $userCod);
        $this->db->where('C.sorteio_id', $sorteioID);
        $this->db->where('C.modo_pagamento', 'R');
        $this->db->where('R.estado', '0');
//        $this->db->where('R.data_vencimento >', date('Y-m-d H:i:s'));
        $this->db->order_by('C.id', 'desc');
        $query = $this->db->get();
        return $query->result_array();
    }
    
    public function listar_one_user_sorteio($id) { 

        $this->db->select('C.*,R.reference_number,R.entidade,R.data_vencimento,R.estado, S.nome as nomeSorteio');
        $this->db->from('user_sorteio C');
        $this->db->join('referencia R', 'R.id = C.referencia_id');
        $this->db->join('sorteio S', 'S.id = C.sorteio_id');
        $this->db->where('C.id', $id);
        $query = $this->db->get();
        return $query->row_array();
    }
    
    
    
    
    public function newVposForPostKyami($CURL_url,$body) {
        $curl = curl_init($CURL_url);
        curl_setopt($curl, CURLOPT_URL, $CURL_url);
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_HEADER, FALSE);

        $headers = array(
            
            'Content-Type: application/json',
            'Sys-Marc-Zone: '. kyami_hash(),
            'Sys-Factory-Bag: Application/kapp',
            'Authorization: Bearer '. kyami_token()
        );
        curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($body));

        $resp = curl_exec($curl);
	$dados['resp'] = json_decode($resp);
        $dados['httpcode'] = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        curl_close($curl);

        return $dados;
    }
    
//    public function newVposForPostKyami() {
//        $body = "244931539318] [to:46594] [content:'Cazola D 2']";
//        $CURL_url = "https://cazola.mojogos.ao/Api/MassageParticipation";
//        $curl = curl_init($CURL_url);
//        curl_setopt($curl, CURLOPT_URL, $CURL_url);
//        curl_setopt($curl, CURLOPT_POST, true);
//        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
//        curl_setopt($curl, CURLOPT_HEADER, FALSE);
//
//        $headers = array(
//            'Content-Type: application/json'
//        );
//        curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
//        curl_setopt($curl, CURLOPT_POSTFIELDS, $body);
//
//        $resp = curl_exec($curl);
//	$dados['resp'] = $resp;
//        $dados['httpcode'] = curl_getinfo($curl, CURLINFO_HTTP_CODE);
//        curl_close($curl);
//
//        return $dados;
//    }
    

}
