<?php

class Sorteios_m extends CI_Model {

    public function __construct() {
        $this->load->database();
    }

    public function salvar($fotografia) {
        
        $min =1000;
        $max=100000000;
        
        $aletario = random_int($min, $max);
        $data = array(
            
            'tipo_sorteio' => $this->input->post('tipo_sorteio'),
            'categoria' => $this->input->post('categoriaSorteio'),
            'cod_sorteio' => $aletario,
            'nome' => $this->input->post('nome_sorteio'),
            'data_inicio' => $this->input->post('data_inicio'),
            'data_fim' => $this->input->post('data_fim'),
            'custo_sorteio'=> $this->input->post('custo_sorteio'),
            'photo'=> $fotografia,
            'descricao'=> $this->input->post('descricao'),
            'estado'=> $this->input->post('estado'),
            'apresentacao'=> $this->input->post('apresentarSorteio'),
            'classificacao'=> $this->input->post('classificacao'),
            
            'mes'=> date('m'),
            'ano'=> date('Y'),
            'created_at' => date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s')
        );
        
        return $this->db->insert('sorteio', $data);
    }
    public function verifica_custo_sorteioEditar($custoSorteio,$categoria,$codigo) {
        $query = $this->db->get_where('sorteio', array('categoria =' => $categoria,'custo_sorteio =' => $custoSorteio,'estado !=' => '2','id !=' => $codigo));
        $resultado = $query->row_array();
        //if (count($resultado) > 0) {
        if ($resultado) {
//            return TRUE;
            return 'tem';
        } else {
//            return FALSE;
            return 'Nao_tem';
        }
    }
    
    public function verifica_custo_sorteio($custoSorteio,$categoria) {
        $query = $this->db->get_where('sorteio', array('categoria =' => $categoria,'custo_sorteio =' => $custoSorteio,'estado !=' => '2'));
        $resultado = $query->row_array();
        //if (count($resultado) > 0) {
        if ($resultado) {
//            return TRUE;
            return 'tem';
        } else {
//            return FALSE;
            return 'Nao_tem';
        }
    }

    public function notificacoes($userID) { 
       $notifiStates = 0;
        $this->db->select('n.*, r.userCodeSecre, r.user_id, r.sorteio_id,r.nivel_premio,s.nome as nomeSorteio');
        $this->db->from('notificacao n');
        $this->db->join('resultados r', 'r.id = n.resultado_id');
        $this->db->join('sorteio s', 's.id = r.sorteio_id');
        $this->db->where('n.estado', $notifiStates);
        $this->db->where('r.user_id', $userID);
        $query = $this->db->get();
        return $query->result_array();
    }
    
    public function actualizar($fotografia = false) {
        if($fotografia){
            $data = array(
                'tipo_sorteio' => $this->input->post('tipo_sorteio'),
                'categoria' => $this->input->post('categoriaSorteio'),
                'nome' => $this->input->post('nome_sorteio'),
                'data_inicio' => $this->input->post('data_inicio'),
                'data_fim' => $this->input->post('data_fim'),
                'custo_sorteio' => $this->input->post('custo_sorteio'),
                'photo' => $fotografia,
                'descricao' => $this->input->post('descricao'),
                'estado' => $this->input->post('estado'),
                'apresentacao'=> $this->input->post('apresentarSorteio'),
                'classificacao'=> $this->input->post('classificacao'),
                'updated_at' => date('Y-m-d H:i:s')
            );
        } else {
            $data = array(
                'tipo_sorteio' => $this->input->post('tipo_sorteio'),
                'categoria' => $this->input->post('categoriaSorteio'),
                'nome' => $this->input->post('nome_sorteio'),
                'data_inicio' => $this->input->post('data_inicio'),
                'data_fim' => $this->input->post('data_fim'),
                'custo_sorteio' => $this->input->post('custo_sorteio'),
                'descricao' => $this->input->post('descricao'),
                'estado' => $this->input->post('estado'),
                'apresentacao'=> $this->input->post('apresentarSorteio'),
                'classificacao'=> $this->input->post('classificacao'),
                'updated_at' => date('Y-m-d H:i:s')
            );
        }
        
        $this->db->where('id', $this->input->post('id_sorteio'));
        return $this->db->update('sorteio', $data);
    }
    
    // Metodo para activar e desactivar utilizador
    public function activarDesactivarSorteio($id, $status) {
        
        $data = array(
            'estado' => $status
        );
        $this->db->where('id', $id);
        return $this->db->update('sorteio', $data);
    }

    public function eliminar($id) {
        $this->db->where('id', $id);
        $this->db->delete('user');
        return true;
    }
    public function listarPremios($id = false) { // Listar sorteios
        if ($id === false) {
            $this->db->select('P.*');
            $this->db->from('premio_mone P');
            $this->db->order_by('P.id', 'desc');
            $query = $this->db->get();
            return $query->result_array();
        }

        $this->db->select('P.*');
        $this->db->from('premio_mone P');
        $this->db->where('P.id', $id);
        $query = $this->db->get();
        return $query->row_array();
    }
    public function listar($id = false) { 
        if ($id === false) {
            $this->db->select('P.*');
            $this->db->from('sorteio P');
            $this->db->order_by('P.id', 'desc');
            $query = $this->db->get();
            return $query->result_array();
        }

        $this->db->select('P.*');
        $this->db->from('sorteio P');
        $this->db->where('P.id', $id);
        $query = $this->db->get();
        return $query->row_array();
    }
    
    public function listarNew() { 
        $this->db->select('P.*');
        $this->db->from('sorteio P');
        $this->db->where('P.estado !=', 3);
        $this->db->order_by('P.id', 'desc');
        $query = $this->db->get();
        return $query->result_array();
    }
    
    public function buscar_password($id) {
        if (!is_null($id)) {
            $this->db->select('password');
            $this->db->from('users');
            $this->db->where('id', $id);
            return $this->db->get()->row()->password; // pegamos o a password do utilizador
        }
    }

    public function actualizarpassword($password_nova, $uti_codigo) {
        $password = strrev(sha1(strtoupper($password_nova)));
        $data = array(
            'password' => $password
        );

        $this->db->where('id', $uti_codigo);
        return $this->db->update('user', $data);
    }

}
