<?php

class Resultados_m extends CI_Model {

    public function __construct() {
        $this->load->database();
    }

    public function listarPremios($id = false) { // Listar sorteios
        if ($id === false) {
            $this->db->select('P.*');
            $this->db->from('premio_mone P');
            $query = $this->db->get();
            return $query->result_array();
        }

        $this->db->select('P.*');
        $this->db->from('premio_mone P');
        $this->db->where('P.id', $id);
        $query = $this->db->get();
        return $query->row_array();
    }
    
    public function listar_sorteios_premios($id = false) { // Listar sorteios_prémios
        $this->db->select('P.*');
        $this->db->from('premio P');
        $this->db->where('P.sorteio_id', $id);
        $query = $this->db->get();
        return $query->result_array();
    }
    
    
    public function pegarParticipacaoUser($sorteioID) {
        $this->db->select('P.*');
        $this->db->from('user_sorteio P');
        $this->db->where('P.paymentState =', '1');
        $this->db->where('P.sorteio_id', $sorteioID);
        $query = $this->db->get();
        return $query->result_array();
    }
    
    public function loopSequenciaBINGO($lenthCateg, $cartela,$seqVenc) {
        $vencedor = 'nao_venceu';
        $varGlue = '';
        for ($i = 0; $i < $lenthCateg; $i++) {
            for ($j = 0; $j < $lenthCateg; $j++) {
                $varGlue .= $cartela[$i * $lenthCateg + $j];
            }
            if ($varGlue == $seqVenc) {
                // Aqui é onde vou fazer a maravilha
                $vencedor = 'venceu' ;
            } 
            $varGlue = '';
        }
        
        return $vencedor;
    }
    
    // Função para Fazer match das cartelas para definir os vencedores
    public function ValidarSequenciaCartelaBINGO($seqVencedora, $categoria, $cartelaArrayUser) {
        $cartela = explode(',', $cartelaArrayUser);
        $seqVenc = implode('', explode(',', $seqVencedora));
        if ($categoria == 'D') {
            $lenthCateg = 3;
            $resposta = $this->loopSequenciaBINGO($lenthCateg, $cartela, $seqVenc);
        } else if ($categoria == 'S') {
            $lenthCateg = 4;
            $resposta = $this->loopSequenciaBINGO($lenthCateg, $cartela, $seqVenc);
        } else if ($categoria == 'M') {
            $lenthCateg = 5;
            $resposta = $this->loopSequenciaBINGO($lenthCateg, $cartela, $seqVenc);
        }
        
        return $resposta;
    }
    
    
    public function buscarCodigosSorteioUserD($codSorteio,$seqVencedora) { // Listar Buscar Sorteio
        // Listar Sorteio
//            $winner = $this->ResultadosPorSorteio($codSorteio);    
//            $resul = [];
//            $i=0;
//            foreach ($winner as $value) {
//                $resul[$i] = $value['user_id'];
//                $i++;
//            }
//            if(empty($resul)){
//                $resul = [];
//            }
            
            $this->db->select('R.*, U.telefone');
            $this->db->from('user_sorteio R');
            $this->db->join('user U', 'U.id = R.user_id');
            $this->db->join('cartela_diaria c', 'c.id = R.cod_sorteio');
            $this->db->where('R.sorteio_id', $codSorteio);
            $this->db->where('R.paymentState =', '1');
            $this->db->where('c.linha1 =',trim($seqVencedora));
//            $this->db->where_not_in('R.user_id',$resul);
            $query = $this->db->get();
            return $query->result_array();
    }
    
    public function buscarCodigosSorteioUserS($codSorteio,$seqVencedora) { // Listar Buscar Sorteio
        // Listar Sorteio
//        $winner = $this->ResultadosPorSorteio($codSorteio);    
//            $i=0;
//            foreach ($winner as $value) {
//                $resul[$i] = $value['user_id'];
//                $i++;
//            }
//            if(empty($resul)){
//                $resul = [];
//            }
            
            $this->db->select('R.*, U.telefone');
            $this->db->from('user_sorteio R');
            $this->db->join('user U', 'U.id = R.user_id');
            $this->db->join('cartela_semanal c', 'c.id = R.cod_sorteio');
            $this->db->where('R.sorteio_id', $codSorteio);
            $this->db->where('R.paymentState =', '1');
            $this->db->where('c.linha1',trim($seqVencedora));
//            $this->db->where_not_in('R.user_id',$resul);
            $query = $this->db->get();
            return $query->result_array();
    }
    
    public function buscarCodigosSorteioUserM($codSorteio,$seqVencedora) { // Listar Buscar Sorteio
        // Listar Sorteio   
            
            
            $this->db->select('R.*, U.telefone');
            $this->db->from('user_sorteio R');
            $this->db->join('user U', 'U.id = R.user_id');
            $this->db->join('cartela_mensal c', 'c.id = R.cod_sorteio');
            $this->db->where('R.sorteio_id', $codSorteio);
            $this->db->where('R.paymentState =', '1');
            $this->db->where('c.linha1', trim($seqVencedora));
            $query = $this->db->get();
            return $query->result_array();
    }
    
    public function buscarSorteioUserParaBingo($codSorteio) { // Listar Buscar Sorteio
        
            $this->db->select('R.id');
            $this->db->from('user_sorteio R');
            $this->db->where('R.sorteio_id', $codSorteio);
            $this->db->where('R.paymentState =', '1');
            $query = $this->db->get();
            return $query->result_array();
    }    
    
    
    public function limeteIntervaloBingoResultado($categoriaSorteio) {
        if ($categoriaSorteio == 'D') {
            $total_intervalo = 60;
        } elseif ($categoriaSorteio == 'S') {
            $total_intervalo = 75;
        } elseif ($categoriaSorteio == 'M') {
            $total_intervalo = 90;
        }
        return $total_intervalo;
    }
    public function mjctrl() { 
            $this->db->select('*');
            $this->db->from('mojogos');
            $query = $this->db->get();
            $resultados = $query->row()->acesso;
            if($resultados == 1){
                return true;
            }elseif($resultados == 0){
                return false;
            }
    }
    public function criarBingoResultadoNovo($categoriaSorteio) {
        if($categoriaSorteio == 'D'){
            $intervalo_loop = 3;
        }elseif($categoriaSorteio == 'S'){
            $intervalo_loop = 4;
        }elseif($categoriaSorteio == 'M'){
            $intervalo_loop = 5;
        }
        $numeros = array();
        $intervalo = $this->limeteIntervaloBingoResultado($categoriaSorteio);
        
        while (count($numeros) < $intervalo_loop) {
            $numero = mt_rand(1, $intervalo);
            if (!in_array($numero, $numeros)) {
                $numeros[] = $numero;
            }
        }
        
        return implode(',', $numeros);
    }
    
    public function salvarCartelaVencedora($seq_vencedora) {
        $data = array(
            'id_sorteio' => $this->input->post('CODEsorteioID'),
            'geradoPor' => $this->session->userdata('user_session')['id'],
            'seq_vencedora' => $seq_vencedora,
            'dia' => date('Y-m-d'),
            'mes' => date('m'),
            'ano' => date('Y'),
            'created_at' => date('Y-m-d H:i:s')
        );
        if ($this->db->insert('cartela', $data)) {
            return $this->db->insert_id();
        }
    }
    
    
    public function BuscardataCodeWinner($codWinner) { // Listar Buscar Sorteio
             
            $this->db->select('R.*, U.nome as NomeUser, U.telefone');
            $this->db->from('user_sorteio R');
//            $this->db->join('referencia Q', 'Q.id = R.referencia_id');
            $this->db->join('user U', 'U.id = R.user_id');
//            $this->db->join('resultados T', 'T.userSorteioID = R.id');
            $this->db->where('R.id', $codWinner);
            $query = $this->db->get();
            return $query->row_array();
    }
    public function SequenciaAletoriaD($aletario,$codSorteio) {
        if($aletario == 1){$coluna = 'linha1';}
        elseif($aletario == 2){$coluna = 'linha2';}
        elseif($aletario == 3){$coluna = 'linha3';}
        $this->db->order_by('RAND()');
        $this->db->select("c.$coluna as resultado");
        $this->db->from('cartela_diaria c');
        $this->db->join('user_sorteio u', 'u.cod_sorteio = c.id');
        $this->db->where('u.paymentState =', '1');
        $this->db->where('u.sorteio_id =', $codSorteio);
        $this->db->group_by("c.$coluna");
        $this->db->having("COUNT(c.$coluna) <=", 3);
        $this->db->limit(1);
        $query = $this->db->get();
        $result = $query->row()->resultado;
        return $result;
    }
    public function SequenciaAletoriaS($aletario,$codSorteio) {
        if($aletario == 1){$coluna = 'linha1';}
        elseif($aletario == 2){$coluna = 'linha2';}
        elseif($aletario == 3){$coluna = 'linha3';}
        elseif($aletario == 4){$coluna = 'linha4';}
        $this->db->order_by('RAND()');
        $this->db->select("c.$coluna as resultado");
        $this->db->from('cartela_semanal c');
        $this->db->join('user_sorteio u', 'u.cod_sorteio = c.id');
        $this->db->where('u.paymentState =', '1');
        $this->db->where('u.sorteio_id =', $codSorteio);
        $this->db->group_by("c.$coluna");
        $this->db->having("COUNT(c.$coluna) <=", 3);
        $this->db->limit(1);
        $query = $this->db->get();
        $result = $query->row()->resultado;
        return $result;
    }
    public function SequenciaAletoriaM($aletario,$codSorteio) {
        if($aletario == 1){$coluna = 'linha1';}
        elseif($aletario == 2){$coluna = 'linha2';}
        elseif($aletario == 3){$coluna = 'linha3';}
        elseif($aletario == 4){$coluna = 'linha4';}
        elseif($aletario == 5){$coluna = 'linha5';}
        $this->db->order_by('RAND()');
        $this->db->select("c.$coluna as resultado");
        $this->db->from('cartela_mensal c');
        $this->db->join('user_sorteio u', 'u.cod_sorteio = c.id');
        $this->db->where('u.paymentState =', '1');
        $this->db->where('u.sorteio_id =', $codSorteio);
        $this->db->group_by("c.$coluna");
        $this->db->having("COUNT(c.$coluna) <=", 3);
        $this->db->limit(1);
        $query = $this->db->get();
        $result = $query->row()->resultado;
        return $result;
    }
    public function listar() { 
            $this->db->select('p.*');
            $this->db->from('sorteio p');
            $this->db->order_by('p.id', 'desc');
            $this->db->limit(3);
            $query = $this->db->get();
            return $query->result_array();
    }
    
    public function BuscarSorteioEscolhido($estado,$categoria,$Data) { 
            $this->db->select('p.*');
            $this->db->from('sorteio p');
            $this->db->where('p.estado ', $estado);
            $this->db->where('p.categoria ', $categoria);
            $this->db->where('p.data_inicio ', $Data);
            $this->db->order_by('p.id', 'desc');
            $this->db->limit(3);
            $query = $this->db->get();
            return $query->result_array();
    }
    
    // Metodo para activar e desactivar utilizador
    public function ConcluirSorteio($id) {
        
        $data = array(
            'estado' => '2'
        );
        $this->db->where('id', $id);
        return $this->db->update('sorteio', $data);
    }
    
    public function verifica_Participacao_sorteio($sorteio) {
        $query = $this->db->get_where('user_sorteio', array('sorteio_id' => $sorteio,'paymentState' => 1));
        $resultado = $query->row_array();
//        if (count($resultado) > 0) {
        if ($resultado) {
            return TRUE;
        } else {
            return FALSE;
        }
    }
    
    public function verifica_resultados($sorteio,$classificacao) {
        $query = $this->db->get_where('resultados', array('sorteio_id' => $sorteio,'nivel_premio' => $classificacao));
        $resultado = $query->result_array();
//        if (count($resultado) > 0) {
        if ($resultado) {
            return TRUE;
        } else {
            return FALSE;
        }
    }
    
    public function verifica_premios($sorteio,$classificacao) {
        $query = $this->db->get_where('premio', array('sorteio_id' => $sorteio,'nivel_premio' => $classificacao));
        $resultado = $query->row_array();
//        if (count($resultado) > 0) {
        if ($resultado) {
            return TRUE;
        } else {
            return FALSE;
        }
    }
    
    public function salvar($classificar,$codeSecreto,$user_id,$sorteio_id,$userSorteioID,$cartelaID) {
        
        $data = array(
            'userCodeSecre' => $codeSecreto,
            'user_id' => $user_id,
            'sorteio_id' => $sorteio_id,
            'userSorteioID' => $userSorteioID,
            'nivel_premio' => $classificar,
            'cartela_id'=> $cartelaID,
            'data'=> date('Y-m-d'),
            'mes'=> date('m'),
            'ano'=> date('Y'),
            'created_at' => date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s')
            
            
        );
        if($this->db->insert('resultados', $data)){
            return $this->db->insert_id();
        }
        
    }
    
    public function GerarNotificacao($resultadoCODE,$message) {
        
        $data = array(
            'resultado_id' => $resultadoCODE,
            'message' => $message,
            'estado' => 0,
            'created_at' => date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s')
        );
        
        return $this->db->insert('notificacao', $data);
    }
    
    
    public function listarSorteios($id = false) { // Listar sorteios
        if ($id === false) {
            $this->db->select('P.*');
            $this->db->from('sorteio P');
            $query = $this->db->get();
            return $query->result_array();
        }

        $this->db->select('P.*');
        $this->db->from('sorteio P');
        $this->db->where('P.id', $id);
        $query = $this->db->get();
        return $query->row_array();
    }
    public function ResultadosPorSorteioD($id ) { 
        
        $this->db->select('R.*, U.nome as NomeUser, U.telefone, Q.cod_sorteio as cod_Secreto, c.linha1, c.linha2, c.linha3');
        $this->db->from('resultados R');
        $this->db->join('user_sorteio Q', 'Q.id = R.userSorteioID');
        $this->db->join('cartela_diaria c', 'c.id = Q.cod_sorteio');
        $this->db->join('user U', 'U.id = R.user_id');
        $this->db->where('R.sorteio_id', $id);
        $query = $this->db->get();
        return $query->result_array();
    }
    public function ResultadosPorSorteioS($id ) { 
        
        $this->db->select('R.*, U.nome as NomeUser, U.telefone, Q.cod_sorteio as cod_Secreto,c.linha1, c.linha2, c.linha3,c.linha4');
        $this->db->from('resultados R');
        $this->db->join('user_sorteio Q', 'Q.id = R.userSorteioID');
        $this->db->join('cartela_semanal c', 'c.id = Q.cod_sorteio');
        $this->db->join('user U', 'U.id = R.user_id');
        $this->db->where('R.sorteio_id', $id);
        $query = $this->db->get();
        return $query->result_array();
    }
    public function ResultadosPorSorteioM($id ) { 
        
        $this->db->select('R.*, U.nome as NomeUser, U.telefone, Q.cod_sorteio as cod_Secreto,c.linha1, c.linha2, c.linha3,c.linha4,c.linha5');
        $this->db->from('resultados R');
        $this->db->join('user_sorteio Q', 'Q.id = R.userSorteioID');
        $this->db->join('cartela_mensal c', 'c.id = Q.cod_sorteio');
        $this->db->join('user U', 'U.id = R.user_id');
        $this->db->where('R.sorteio_id', $id);
        $query = $this->db->get();
        return $query->result_array();
    }
    
    public function ResultadosPorSorteio($id ) { 
        
        $this->db->select('R.*, U.nome as NomeUser, U.telefone, Q.cod_sorteio as cod_Secreto');
        $this->db->from('resultados R');
        $this->db->join('user_sorteio Q', 'Q.id = R.userSorteioID');
        $this->db->join('user U', 'U.id = R.user_id');
        $this->db->where('R.sorteio_id', $id);
        $query = $this->db->get();
        return $query->result_array();
    }
    
    public function ControlaraVencedorResultadosPorSorteio($id ) { 
        
        $this->db->select('R.*, U.nome as NomeUser, U.telefone, Q.cod_sorteio as cod_Secreto');
        $this->db->from('resultados R');
        $this->db->join('user_sorteio Q', 'Q.id = R.userSorteioID');
        $this->db->join('user U', 'U.id = R.user_id');
        $this->db->where('R.sorteio_id', $id);
        $query = $this->db->get();
        $resultados = $query->row_array();
        if($resultados){
            return true;
        }else{
            return false;
        }
    }
    
    public function CartelaResultadosPorSorteio($id) { 
        $this->db->select('c.seq_vencedora');
        $this->db->from('cartela c');
        $this->db->where('c.id_sorteio', $id);
        $query = $this->db->get();
        $resultado = $query->row_array();
        if($resultado == null ){
            return [];
        }else{
            return $resultado;
        }
    }
    
    public function notificacoes($userID) { 
       $notifiStates = 0;
        $this->db->select('n.*, r.userCodeSecre, r.user_id, r.sorteio_id,r.nivel_premio,s.nome as nomeSorteio');
        $this->db->from('notificacao n');
        $this->db->join('resultados r', 'r.id = n.resultado_id');
        $this->db->join('sorteio s', 's.id = r.sorteio_id');
        $this->db->where('n.estado', $notifiStates);
        $this->db->where('r.user_id', $userID);
        $query = $this->db->get();
        return $query->result_array();
    }

}
