<?php

class Classificacao_m extends CI_Model {

    public function __construct() {
        $this->load->database();
    }

    

    public function salvarClassificar() {
        // Fortificar a password de formas a tornar ainda mais segura
        $data = array(
            
            'posicao' => $this->input->post('posicao_premio'),
            'nome'=> $this->input->post('nome_classificar'),
            'created_at' => date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s')
        );
        return $this->db->insert('classificacao', $data);
    }
    
    public function actualizar() {

        $data = array(
            'posicao' => $this->input->post('posicao_premio'),
            'nome' => $this->input->post('nome_classificar'),
            'updated_at' => date('Y-m-d H:i:s')
        );

        $this->db->where('id', $this->input->post('id_classificar'));
        return $this->db->update('classificacao', $data);
    }

    public function verifica_posicaoClassificar($posicao) {
        $query = $this->db->get_where('classificacao', array('posicao' => $posicao));
        $resultado = $query->row_array();
        if ($resultado) {
            return TRUE;
        } else {
            return FALSE;
        }
    }
    
    public function notificacoes($userID) { 
       $notifiStates = 0;
        $this->db->select('n.*, r.userCodeSecre, r.user_id, r.sorteio_id,r.nivel_premio,s.nome as nomeSorteio');
        $this->db->from('notificacao n');
        $this->db->join('resultados r', 'r.id = n.resultado_id');
        $this->db->join('sorteio s', 's.id = r.sorteio_id');
        $this->db->where('n.estado', $notifiStates);
        $this->db->where('r.user_id', $userID);
        $query = $this->db->get();
        return $query->result_array();
    }
    
    
    
    public function listarClassificacao($id = false) { // Listar sorteios
        if ($id === false) {
            $this->db->select('c.*');
            $this->db->from('classificacao c');
            $query = $this->db->get();
            return $query->result_array();
        }

        $this->db->select('c.*');
        $this->db->from('classificacao c');
        $this->db->where('c.id', $id);
        $query = $this->db->get();
        return $query->row_array();
    }
    
    

    public function eliminar($id) {
        $this->db->where('id', $id);
        $this->db->delete('user');
        return true;
    }
    
    

    public function buscar_password($id) {
        if (!is_null($id)) {
            $this->db->select('password');
            $this->db->from('users');
            $this->db->where('id', $id);
            return $this->db->get()->row()->password; // pegamos o a password do utilizador
        }
    }

    public function actualizarpassword($password_nova, $uti_codigo) {
        $password = strrev(sha1(strtoupper($password_nova)));
        $data = array(
            'password' => $password
        );

        $this->db->where('id', $uti_codigo);
        return $this->db->update('user', $data);
    }

}
