<?php

class Api_m extends CI_Model {
    
    public function __construct() {
        $this->load->database();
    }
    
    public function listar($id = false) { // Listar sorteios
        if ($id === false) {
            $this->db->select('P.*');
            $this->db->from('sorteio P');
            $this->db->where('estado =', '1');
            $this->db->where('data_fim >=', date('Y-m-d'));
            $query = $this->db->get();
            return $query->result_array();
        }

        $this->db->select('P.*');
        $this->db->from('sorteio P');
        $this->db->where('P.id', $id);
        $query = $this->db->get();
        return $query->row_array();
    }
    
    public function listarByCategory($categoria) { 
            $this->db->select('P.*');
            $this->db->from('sorteio P');
            $this->db->where('estado =', '1');
            $this->db->where('categoria =', $categoria);
            $this->db->where('data_fim >=', date('Y-m-d'));
            $query = $this->db->get();
            $resultado = $query->result_array();
            if($resultado){
                return $resultado;
            }else{
                return [];
            }
    }
    
    public function listarSorteios($data = false) {
        if($data === FALSE){
            $this->db->select('P.*');
            $this->db->from('sorteio P');
//        $this->db->where('P.ano', $data);
            $this->db->order_by('P.id', 'desc');
            $this->db->limit(10);
            $query = $this->db->get();
            return $query->result_array();
        }else{
            $this->db->select('P.*');
            $this->db->from('sorteio P');
            $this->db->like('P.nome', $data);
            $this->db->or_where('P.cod_sorteio', $data);
            $query = $this->db->get();
            return $query->result_array();
        }
    }
    
    public function listarONESorteioFocus($id) {
        $this->db->select('P.*');
        $this->db->from('sorteio P');
        $this->db->where('P.id', $id);
        $query = $this->db->get();
        return $query->row_array();
    }
    
    public function listarUsers() { // Listar sorteios
//            $this->db->select('U.id,U.username, U.nome, U.bi, U.data_nasc, U.email, U.telefone, '
//                    . 'U.photo,U.genero,U.morada, U.estado, U.concluido, U.created_at,U.updated_at, '
//                    . 'P.name as Pais_name,Pr.name as Provi_name,M.name as Municipio_name');
//            $this->db->from('user U');
//            $this->db->join('paises P', 'P.id = U.pais_id');
//            $this->db->join('provincias Pr', 'Pr.id = U.provincia_id');
//            $this->db->join('municipios M', 'M.id = U.municipio_id');
//            $this->db->order_by('U.id DESC');
//            $this->db->limit(10);
//            $query = $this->db->get();
//            return $query->result_array();
            
            
            
             $this->db->select('U.id,U.username, U.nome, U.bi, U.data_nasc, U.email, U.telefone, '
                    . 'U.photo,U.genero,U.morada, U.estado, U.concluido, U.created_at,U.updated_at');
            $this->db->from('user U');
            $this->db->order_by('U.id DESC');
            $this->db->limit(10);
            $query = $this->db->get();
            return $query->result_array();
    }
    
    public function listarSorteiosPorParticipantes($sorteioID) {
            $this->db->select('n.*, u.nome as NomeUser, u.telefone, s.nome as NomeSorteio');
            $this->db->from('user_sorteio n');
            $this->db->join('user u', 'u.id = n.user_id');
            $this->db->join('sorteio s', 's.id = n.sorteio_id');
            $this->db->where('n.paymentState', '1'); // SORTEIO COM ESTADO PAGO
            $this->db->where('n.sorteio_id', $sorteioID);
            $query = $this->db->get();
            return $query->result_array();
    }
    public function listar_premiosDosSorteios($id_sorteio) { // Listar sorteios_prémios
        $this->db->select('P.*');
        $this->db->from('premio P');
        $this->db->where('P.sorteio_id', $id_sorteio);
        $query = $this->db->get();
        return $query->result_array();
    }
    
    public function ResultadosDoSorteio($id ) { 
        
        $this->db->select('R.*, U.nome as NomeUser, U.telefone, Q.cod_sorteio as cod_Secreto');
        $this->db->from('resultados R');
        $this->db->join('user_sorteio Q', 'Q.id = R.userSorteioID');
        $this->db->join('user U', 'U.id = R.user_id');
        $this->db->where('R.sorteio_id', $id);
        $query = $this->db->get();
        return $query->result_array();
    }
    
    public function listarONEUser($id ) { 
        $this->db->select('U.*');
        $this->db->from('user U');
        $this->db->where('U.id', $id);
        $query = $this->db->get();
        return $query->row_array();
    }
    
    public function listarInformationONEUser($id ) { 
        $this->db->select('P.name as Pais_name,Pr.name as Provi_name,M.name as Municipio_name');
        $this->db->from('user U');
        $this->db->join('paises P', 'P.id = U.pais_id');
        $this->db->join('provincias Pr', 'Pr.id = U.provincia_id');
        $this->db->join('municipios M', 'M.id = U.municipio_id');
        $this->db->where('U.id', $id);
        $query = $this->db->get();
        return $query->row_array();
    }
    public function sorteioPerUsers($id) {
        $this->db->select('n.*, u.nome as NomeUser, u.telefone, s.nome as NomeSorteio');
        $this->db->from('user_sorteio n');
        $this->db->join('user u', 'u.id = n.user_id');
        $this->db->join('sorteio s', 's.id = n.sorteio_id');
        $this->db->where('n.paymentState', '1'); // SORTEIO COM ESTADO PAGO
        $this->db->where('n.user_id', $id);
        $this->db->order_by('n.id DESC');
        $query = $this->db->get();
        return $query->result_array();
    }
    
    public function sorteioUsersByUser($id) { 
//        $this->db->select('U.id,U.username, U.nome, U.bi, U.data_nasc, U.email, U.telefone, '
//                    . 'U.photo,U.genero,U.morada, U.estado, U.concluido, U.created_at,U.updated_at, '
//                    . 'P.name as Pais_name,Pr.name as Provi_name,M.name as Municipio_name');
//        $this->db->from('user U');
//        $this->db->join('paises P', 'P.id = U.pais_id');
//        $this->db->join('provincias Pr', 'Pr.id = U.provincia_id');
//        $this->db->join('municipios M', 'M.id = U.municipio_id');
//        $this->db->like('U.nome', $id);
//        $this->db->or_where('U.telefone', $id);
//        $this->db->or_where('U.email', $id);
//        $query = $this->db->get();
//        return $query->result_array();
        
        
        
        
        $this->db->select('U.id,U.username, U.nome, U.bi, U.data_nasc, U.email, U.telefone, '
                    . 'U.photo,U.genero,U.morada, U.estado, U.concluido, U.created_at,U.updated_at');
        $this->db->from('user U');
        $this->db->like('U.nome', $id);
        $this->db->or_where('U.telefone', $id);
        $this->db->or_where('U.email', $id);
        $query = $this->db->get();
        return $query->result_array();
    }
    
    public function listarONE($id) { 
        $this->db->select('P.*');
        $this->db->from('sorteio P');
        $this->db->where('P.id', $id);
        $query = $this->db->get();
        return $query->row_array();
    }
    
    public function verifica_telefoneAPI($telefone) {
        $query = $this->db->get_where('user', array('telefone' => $telefone));
        $resultado = $query->row_array();
        //if (count($resultado) > 0) {
        if ($resultado) {
            return TRUE;
        } else {
            return FALSE;
        }
    }
    
    public function listarReferenciaPTelefone($cod_payment) {
        $this->db->select('s.modo_pagamento, u.telefone');
        $this->db->from('user_sorteio s');
        $this->db->join('referencia r', 'r.id = s.referencia_id');
        $this->db->join('user u', 'u.id = r.user_id');
        $this->db->where('r.cod_payment', $cod_payment);
        $query = $this->db->get();
        $resultado = $query->row_array();
        if ($resultado) {
            return $resultado;
        } else {
            return false;
        }
    }
    public function verificarReferenciaUserSorteio($referencia_id) {
        $query = $this->db->get_where('user_sorteio', array('referencia_id =' => $referencia_id));
        $resultado = $query->row_array();
        //if (count($resultado) > 0) {
        if ($resultado) {
//            return TRUE;
            return $resultado;
        } else {
            return FALSE;
        }
    }
    public function verificarReferenciaUserConta($referencia_id) {
        $query = $this->db->get_where('carrecarconta_user', array('id_reference =' => $referencia_id));
        $resultado = $query->row_array();
        //if (count($resultado) > 0) {
        if ($resultado) {
//            return TRUE;
            return $resultado;
        } else {
            return FALSE;
        }
    }
    public function listarReferenciaUnicaWHook($cod_payment) {

        $this->db->select('R.*');
        $this->db->from('referencia R');
        $this->db->where('R.cod_payment', $cod_payment);
        $query = $this->db->get();
        $resultado = $query->row_array();
        //if (count($resultado) > 0) {
        if ($resultado) {
            return $resultado;
        } else {
            return FALSE;
        }
    }
    
    public function ActualizarReferenciaTransationAPI($cod_transation) {
        $data = array(
            'estado' => '1',
        );
        $this->db->where('cod_payment', $cod_transation);
        if ($this->db->update('referencia', $data)) {
            return TRUE;
        } else {
            return FALSE;
        }
    }
    
    public function Actualizar_Participacao_userSorteioAPI($cod_referencia) {
        $data = array(
            'paymentState' => 1,
        );
        $this->db->where('referencia_id', $cod_referencia);
        if ($this->db->update('user_sorteio', $data)){
            return TRUE;
        }else{
            return FALSE;
        }
    }

    public function guardarNewUser($telefone,$nomeUser) {
        
        $password = strrev(sha1(strtoupper(uniqid())));
        $data = array(
//            'username' => $username,
            'nome' => ucfirst($nomeUser),
            
//            'email' => $this->input->post('email'),
            'password' => $password,
            'telefone' => $telefone,
//            'photo'=> $fotografia,
//            'genero'=> $this->input->post('genero'),
            'dia' => date('Y-m-d H:i:s'),
            'created_at' => date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s')
        );
        
        if ($this->db->insert('user', $data)) {
            return $this->db->insert_id();
        }
    }
    
    public function conta_userAPI($userID) {
        $data = array(
            'user_id' => $userID,
            'dia' => date('Y-m-d'),
            'created_at' => date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s')
        );
        
        return $this->db->insert('conta', $data);
    }
    
    public function salvar_user_sorteio($custo, $userID, $cod_sorteio, $sorteioCod,$referencia_id,$modo_pagamento,$paymentState) {
        $data = array(
            'user_id'=> $userID,
            'sorteio_id' => $sorteioCod,
            'cod_sorteio' => $cod_sorteio,
            'custo' => $custo,
            'referencia_id' => $referencia_id,
            'modo_pagamento' => $modo_pagamento,
            'paymentState' => $paymentState,
            'dia' => date('Y-m-d'),
            'mes' => date('m'),
            'ano' => date('Y'),
            'created_at' => date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s')
        );
        if ($this->db->insert('user_sorteio', $data)) {
            return $this->db->insert_id();
        }
    }
    public function NovoCodigoSecreto($userCod,$sorteioCodSecreto,$sorteioID) {
        $valor_inicial = 001;
        $this->db->select_max('C.id');
        $this->db->from('user_sorteio C');
        $this->db->where('C.user_id', $userCod);
        $this->db->where('C.sorteio_id', $sorteioID);
        $resultado = $this->db->get()->row()->id;
        
        if($resultado == null){
            return $sorteioCodSecreto . $userCod . $valor_inicial;
        }else{
            return $this->verifica_CriarCodigo_do_Sorteio($resultado) + 1;
        }   
    }
    
    public function verifica_CriarCodigo_do_Sorteio($id) {
        $valor_inicial = 0;
        $this->db->select('C.cod_sorteio');
        $this->db->from('user_sorteio C');
        $this->db->where('C.id', $id);
        $resultado = $this->db->get()->row()->cod_sorteio;
        $rest = substr($resultado, -1);
        if($rest == 9){
            return $resultado.$valor_inicial;
        }else{
            return $resultado;
        }
    }
    public function buscarCartelasD($id_cartela){
        $this->db->select('*');
        $this->db->from('cartela_diaria');
        $this->db->where('id =', $id_cartela);
        $query = $this->db->get();
        $resultado = $query->row_array();
        //if (count($resultado) == 1) {
        if ($resultado) {
            return $resultado;
        } else {
            return FALSE;
        }
    }
    public function buscarCartelasS($id_cartela){
        $this->db->select('*');
        $this->db->from('cartela_semanal');
        $this->db->where('id =', $id_cartela);
        $query = $this->db->get();
        $resultado = $query->row_array();
        //if (count($resultado) == 1) {
        if ($resultado) {
            return $resultado;
        } else {
            return FALSE;
        }
    }
    public function buscarCartelasM($id_cartela){
        $this->db->select('*');
        $this->db->from('cartela_mensal');
        $this->db->where('id =', $id_cartela);
        $query = $this->db->get();
        $resultado = $query->row_array();
        //if (count($resultado) == 1) {
        if ($resultado) {
            return $resultado;
        } else {
            return FALSE;
        }
    }
    public function pegarUser_telefone($utilizador){
        $this->db->select('*');
        $this->db->from('user');
        $this->db->where('telefone =', $utilizador);
        $resultado = $this->db->get()->row();
        //if (count($resultado) == 1) {
        if ($resultado) {
            return $resultado;
        } else {
            return FALSE;
        }
    }
    
    
    
    
    public function buscarCodigosSorteioUserDosPerdedores($codSorteio) {
        // Listar Sorteio
        $winner = $this->VencedoresDoSorteio($codSorteio);    
            $resul = array();
            $i = 1;
            foreach ($winner as $value) {
                $resul[$i] = $value['user_id'];
                $i++;
            }
            if(empty($resul)){
                $resul = array (0);
            }
            
            $estadoReferencia = '1';
            $this->db->select('U.*, R.cod_sorteio, R.custo, R.modo_pagamento, R.created_at as DataPayment');
            $this->db->from('user_sorteio R');
            $this->db->join('user U', 'U.id = R.user_id');
            $this->db->where('R.sorteio_id', $codSorteio);
            $this->db->where('R.paymentState =', $estadoReferencia);
            $this->db->where_not_in('R.user_id',$resul);
            $query = $this->db->get();
            return $query->result_array();
    }
    
    
    public function VencedoresDoSorteio($id ) { 
        $this->db->select('R.*, U.nome as NomeUser, U.telefone, Q.cod_sorteio as cod_Secreto');
        $this->db->from('resultados R');
        $this->db->join('user_sorteio Q', 'Q.id = R.userSorteioID');
        $this->db->join('user U', 'U.id = R.user_id');
        $this->db->where('R.sorteio_id', $id);
        $query = $this->db->get();
        return $query->result_array();
    }
    
    public function ContarUserPorParticipacaoSorteio($id ) { 
//        $this->db->select('U.id, U.nome as NomeUser, U.telefone, COUNT(Q.custo) as TotalSorteio ');
        $this->db->select('U.*, SUM(Q.custo) as TotalSorteio ');
        $this->db->from('user U');
        $this->db->join('user_sorteio Q', 'Q.user_id = U.id');
        $this->db->where('Q.sorteio_id', $id);
        $this->db->where('Q.paymentState', '1');
        $this->db->group_by('U.id');
        $this->db->order_by('U.nome DESC');
        $query = $this->db->get();
        return $query->result_array();
    }
    
    public function ContarTodasParticipacaoSorteioMesAno($mes, $ano) { 
//        $this->db->select('U.id, U.nome as NomeUser, U.telefone, COUNT(Q.custo) as TotalSorteio ');
        $this->db->select('COUNT(U.id) as TotalMes');
        $this->db->from('user_sorteio U');
        $this->db->where('U.mes', $mes);
        $this->db->where('U.ano', $ano);
        $this->db->where('U.paymentState', '1');
//        $this->db->group_by('U.id');
//        $this->db->order_by('U.nome DESC');
        $query = $this->db->get();
        return $query->row()->TotalMes;
    }
    
    public function ContarTodasParticipacaoSorteioDiaMesAno($data) { 
        $this->db->select('U.*');
        $this->db->from('user_sorteio U');
//        $this->db->where('U.dia', '2023-01-26');
        $this->db->where('U.dia', $data);
        $this->db->where('U.paymentState', '1');
        //$query = $this->db->get();
        $query = $this->db->count_all_results();
        if ($query == NULL) {
            return 0;
        } else {
            return $query;
        }
    }
    
    
    public function salvar_referenciaAPI_KYAMI($estado,$amount,$entity_id,$expiry_date,$id_reference_wiki,$number,$id_user) {
        $data = array(
            'estado'=>$estado,
            'data_criacao' => date('Y-m-d H:i:s'),
            'data_vencimento' => $expiry_date,
            'cod_payment' => $id_reference_wiki,
            'valor' => $amount,
            'reference_number' => $number,
            'entidade' => $entity_id,
            'user_id'=> $id_user,
            'created_at' => date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s')
        );
        
        if ($this->db->insert('referencia', $data)) {
            return $this->db->insert_id();
        }
    }
    
    
    public function buscar_BYcusto_sorteio($custoSorteio,$categoria) {
        $query = $this->db->get_where('sorteio', array('categoria =' => $categoria,'custo_sorteio =' => $custoSorteio,'estado =' => '1'));
        $resultado = $query->row_array();
        //if (count($resultado) > 0) {
        if ($resultado) {
//            return TRUE;
            return $resultado;
        } else {
            return FALSE;
        }
    }
    
    public function ContarTodasParticipacaoSorteioSemanaMes($inicio,$fim) {
//        $this->db->select('COUNT(U.id) as TotalSemana');
        $this->db->select('U.*');
        $this->db->from('user_sorteio U');
        $this->db->where('U.created_at >=', date('Y-m-'.$inicio));
        $this->db->where('U.created_at <=', date('Y-m-'.$fim));
        $this->db->where('U.paymentState', '1');
        $this->db->group_by('U.id');
//        $this->db->order_by('U.nome DESC');
        //$query = $this->db->get();
        $query = $this->db->count_all_results();
        if($query == NULL){
            return 0;
        } else {
            return $query;
        }
    }
    
    public function listarSorteiosPorDataFocus($sorteioState,$data_inicio,$data_fim) {
        if ($sorteioState == '3' ) {
            $this->db->select('n.*, u.nome as NomeUser, u.telefone, s.nome as NomeSorteio');
            $this->db->from('user_sorteio n');
            $this->db->join('user u', 'u.id = n.user_id');
            $this->db->join('sorteio s', 's.id = n.sorteio_id');
            $this->db->where('n.paymentState', '1'); // SORTEIO COM ESTADO PAGO
            $this->db->where('n.created_at >= ', $data_inicio);
            $this->db->where('n.created_at <= ', $data_fim);
            $query = $this->db->get();
            return $query->result_array();
        } else {
            $this->db->select('n.*, u.nome as NomeUser, u.telefone, s.nome as NomeSorteio');
            $this->db->from('user_sorteio n');
            $this->db->join('user u', 'u.id = n.user_id');
            $this->db->join('sorteio s', 's.id = n.sorteio_id');
            $this->db->where('n.paymentState', '1'); // SORTEIO COM ESTADO PAGO
            $this->db->where('s.estado ', $sorteioState);
            $this->db->where('n.created_at >= ', $data_inicio);
            $this->db->where('n.created_at <= ', $data_fim);
            $query = $this->db->get();
            return $query->result_array();
        }
    }
    
    public function newVposForPostKyamiAPI($CURL_url,$body) {
        $curl = curl_init($CURL_url);
        curl_setopt($curl, CURLOPT_URL, $CURL_url);
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_HEADER, FALSE);

        $headers = array(
            
            'Content-Type: application/json',
            'Sys-Marc-Zone: '. kyami_hash(),
            'Sys-Factory-Bag: Application/kapp',
            'Authorization: Bearer '. kyami_token()
        );
        curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($body));

        $resp = curl_exec($curl);
	$dados['resp'] = json_decode($resp);
        $dados['httpcode'] = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        curl_close($curl);

        return $dados;
    }
    
    public function newPostKyamiForPartners($CURL_url,$body) {
        $curl = curl_init($CURL_url);
        curl_setopt($curl, CURLOPT_URL, $CURL_url);
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_HEADER, FALSE);

        curl_setopt($curl, CURLOPT_POSTFIELDS, $body);

        $resp = curl_exec($curl);
	$dados['resp'] = json_decode($resp);
        $dados['httpcode'] = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        curl_close($curl);

        return $dados;
    }

}
