<?php
class Users extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('Users_m', 'm');
    }

    public function perfil() {
        $id_user = $this->session->userdata('user_session') == null? '':$this->session->userdata('user_session')['id'];
        $cabecario['menu'] = 'users';
        $cabecario['submenu']='perfil';
        $cabecario['sidebar'] = '';
        $data['paises']= $this->m->listarPaises();
//        $data['provincia']= $this->m->listarProvincias(6);
//        $data['municipio']= $this->m->listarMunicipio(185);
        $data['users']= $this->m->listarUsers($id_user);
        $cabecario['notificacoes']= $this->m->notificacoes($id_user);
        $this->load->view('template/header',$cabecario);
        $this->load->view('users/perfil',$data);
        $this->load->view('template/footer');
        
    }
    
    public function changePass() {
        $id_user = $this->session->userdata('user_session') == null? '':$this->session->userdata('user_session')['id'];
        $dados = $this->m->pegaLogin_byID($id_user);
        $password = strrev(sha1(strtoupper(trim($this->input->post('old_password')))));
        $data['success']='';
        if ($dados->password != $password ) {
            $data['success'] ='senhaAntigaErrada';
            echo json_encode($data);
        } else {
            $this->m->actualizarPassword($this->input->post('new_password'),$id_user);
            $data['success'] ='actualizou';
            echo json_encode($data);
        }
    }
    public function actualizar() {
        $email = $this->input->post('email');
//        $telefone = $this->input->post('telefone');
        $bilhete = $this->input->post('bi');
        $data_nascimento = $this->input->post('data_nasc');
        if ( !$_FILES['imagem']['error']) {
            $tipos_arquivos = array(".jpg", ".JPG", ".gif", ".GIF", ".png", ".PNG");
            $imagem = $_FILES['imagem']['name']; //pega o nome do arquivo escolhido
            $tipo = strrchr($imagem, "."); //pega a extensao (tipo do arquivo que deverá ser jpg gif png)
            $name = date('Ymdhis') . $tipo;
            $nome_antigo = $this->input->post('photo_User');
            $destino = 'assets/images/user/';
            $this->actualizarComImagem($tipo, $tipos_arquivos, $email, $bilhete, $data_nascimento, $destino, $nome_antigo, $name);
            
        }
        elseif ($_FILES['imagem']['size'] > 200000) {
            echo 'imgGrande';
        } 
        else {
            $this->actulalizarSemImagem($email, $bilhete, $data_nascimento);
        }
    }
    public function actulalizarSemImagem($email,$bilhete,$data_nascimento) {
        if ($this->m->verifica_email($email)) {
            echo 'existe_email';
        } 
//        elseif ($this->m->verifica_telefone($telefone)) {
//            echo 'existe_telefone';
//        } 
        elseif ($this->m->verifica_BILHETE($bilhete)) {
            echo 'existe_bilhete';
        } elseif ($this->m->verifica_datanascimento($data_nascimento)) {
            echo 'dataMaior';
        } elseif ($this->m->calcular_idade($data_nascimento)) {
            echo 'menor_idade';
        } else {
            $this->m->actualizar();
            echo 'actualizou';
        }
    }
    public function actualizarComImagem($tipo,$tipos_arquivos,$email,$bilhete,$data_nascimento,$destino,$nome_antigo,$name) {
        if (!in_array($tipo, $tipos_arquivos)) {
                echo 'desconhecido';
            }elseif ($this->m->verifica_email($email)) {
                echo 'existe_email';
            }
            elseif ($this->m->verifica_BILHETE($bilhete)) {
                echo 'existe_bilhete';
            }elseif ($this->m->verifica_datanascimento($data_nascimento)) {
                echo 'dataMaior';
            }elseif ($this->m->calcular_idade($data_nascimento)) {
                echo 'menor_idade';
            } else {
                if (file_exists($destino . $nome_antigo)) {
                    unlink($destino . $nome_antigo);
                    move_uploaded_file($_FILES['imagem']['tmp_name'], $destino . $name);
                    $this->m->actualizar($name);
                    echo 'actualizou';
                } elseif (!file_exists($destino . $nome_antigo)) {
                    move_uploaded_file($_FILES['imagem']['tmp_name'], $destino . $name);
                    $this->m->actualizar($name);
                    echo 'actualizou';
                } else {
                    echo 'nao_actualizou';
                }
            }
    }

    public function home() {
        $id_user = $this->session->userdata('user_session') == null? '':$this->session->userdata('user_session')['id'];
        $data['sorteios'] = $this->m->sorteios();
        $cabecario['submenu'] = 'todosSorteios';
        $cabecario['menu'] = 'users';
        $cabecario['sidebar'] = '';
        $cabecario['notificacoes']= $this->m->notificacoes($id_user);
        $this->load->view('template/header',$cabecario);
        $this->load->view('users/home',$data);
        $this->load->view('template/footer');
    }
    
    public function changeStatesUser() {
        $id=$this->input->post('userID');
        $status=$this->input->post('userSTATE');
        if ($status =='1') {
            $status ='0'; // caso o status passado por paramatro já for S entao desativa caso contrario activa
        } elseif($status =='0') {
            $status ='1';
        }
//        echo json_encode($status);
        if($this->m->activarDesactivarUserRole($id, $status)){
            echo json_encode('alterou');
        } else {
            echo json_encode('Nao_alterou');
        }
    }
    public function checkPerfil() {
        
        
        if($this->m->Pegar_EstadoPerfil() == 0){
            $data['resposta'] = 'nao_concluiu';
            echo json_encode($data);
        }elseif($this->m->Pegar_EstadoPerfil() == 1){
            $data['resposta'] = 'concluiu';
            echo json_encode($data);
        }
    }
    public function todasNotificacoes() {
        $cabecario['submenu'] = 'notificar';
        $cabecario['menu'] = 'users';
        $cabecario['sidebar'] = '';
        
        $data['notificacoesH']= $this->m->notificacoes($this->session->userdata('user_session')['id']);
        $cabecario['notificacoes']= $this->m->notificacoes($this->session->userdata('user_session')['id']);
        $this->load->view('template/header',$cabecario);
        $this->load->view('users/notificacoes',$data);
        $this->load->view('template/footer');
    }
    public function consolidarReferencia() {
        if ($this->session->userdata('user_session')['role']=='1') {
            $CURL_url = wikipayAPI_url() . 'payment';
            $TodosPagamentos = $this->m->GetAllPaymentCURL($CURL_url);
            foreach ($TodosPagamentos->payments as $value) {
                $result_refencia = $this->m->listar_ReferenciaUnica($value->reference_id);
                if ($result_refencia) {
                    $this->m->actualizaEstadoReferencia($value->reference_id, $result_refencia['id']);
                    $CURL_url2 = wikipayAPI_url() . 'payment/' . $value->id;
                    $this->m->newCurlforDELETE($CURL_url2);
                }
            }
            echo json_encode('funciona');
        }else{
            echo json_encode('NaoAdmin');
        }
        
    }
    public function participar($id) {
        $id_sorteio= $_GET['r'];
        $codigo = base64_decode($id_sorteio);
        
//        $CURL_url= vpos_url() . 'transactions/2KoUIUeWLTgfnmoq9Iz1ob5xBSL';
//        $data['testeDoAdilson'] = json_decode( $this->m->NewVposForGetONE($CURL_url) );
        
        $cabecario['notificacoes']= $this->m->notificacoes($this->session->userdata('user_session')['id']);
        $data['ReferenceAPI'] = $this->m->listar_user_sorteio($this->session->userdata('user_session')['id'],$codigo);
//        $data['testeDoAdilson'] = $this->m->verificarEstadoSorteio(1);
        $data['sorteios'] = $this->m->listarSorteio($codigo);
        $data['premios_sorteios'] = $this->m->listar_sorteios_premios($codigo);
        $cabecario['submenu'] = 'todosSorteios';
        $cabecario['menu'] = 'users';
        $cabecario['sidebar'] = 'activo';
//        if (empty($data['sorteios'])) {
//            show_404();
//        }


        $this->load->view('template/header',$cabecario);
        $this->load->view('users/participar',$data);
        $this->load->view('template/footer');
    }
    
    
    
    public function allReferences() {
       
        $datas = new DateTime('+1 day');
        $data_convert =  $datas->format('Y-m-d H:i:s');
        
        $CURL_url= wikipayAPI_url() . 'reference/create';
        $arrayHeader = array(
            'reference' => array(
                    'amount' => $this->input->post('amount_sorteio'),
                    'expiry_date' => $data_convert,
                    'custom_fields' => array(
                    'telefone' => $this->session->userdata('user_session')['telefone'],
                    )
                )
        );
        $response = $this->m->newCurlforPOST($CURL_url, json_encode($arrayHeader));

        $referenciaDecod = json_decode($response);
        $referencias=$referenciaDecod->reference;
        $modoPayment='R';
        $userSorteioID = $this->m->salvar_referencia($modoPayment,$referencias->amount,$referencias->entity_id,$referencias->expiry_date,$referencias->id,$referencias->number);
        $ReferenceAPI = $this->m->listar_user_sorteio($this->session->userdata('user_session')['id'],$this->input->post('cod_sorteioID'));
//        $referenciaUnica=$this->m->listar_one_user_sorteio($userSorteioID);
//            $this->listAllReferences($referencias);
            
            $dados['referenciaActual'] = '<div style="text-align:center" id = "mostarReferenciasCriadas">';
            $dados['referenciaActual'] .= '<h4>Entidade: '.$referencias->entity_id.'</h4>';
            $dados['referenciaActual'] .= '<h4>Referência: '.$referencias->number.' </h4>';
            $dados['referenciaActual'] .= '<h4>Valor : '.$referencias->amount.' KZ</h4><br></div>';
            
            
            
        $dados['retornoTabela'] = '<div class="panel-body" id="painelReferencias">';
        $dados['retornoTabela'] .= '<table id="data-table-responsive" class="table table-striped table-bordered">';
        $dados['retornoTabela'] .= '<thead><tr>';
        $dados['retornoTabela'] .= '<th width="1%"></th>';
        $dados['retornoTabela'] .= '<th class="text-nowrap">Codico Secreto</th>';
        $dados['retornoTabela'] .= '<th class="text-nowrap">Entidate</th>';
        $dados['retornoTabela'] .= '<th class="text-nowrap">Referência</th>';
        $dados['retornoTabela'] .= '<th class="text-nowrap">Investimento</th>';
        $dados['retornoTabela'] .= '<th class="text-nowrap">Estado</th></tr></thead>';
        $dados['retornoTabela'] .= '<tbody id="mostarReferenciasUser">';
        $countPedidos = 0;
        foreach ($ReferenceAPI as $referencia):
            $countPedidos = $countPedidos + 1;

            $dados['retornoTabela'] .= '<tr class="odd gradeX">';
            $dados['retornoTabela'] .= '<td width="1%" class="f-s-600 text-inverse">' . $countPedidos . '</td>';
            $dados['retornoTabela'] .= '<td><a href="#" class="btn btn-yellow disabled"><b>' . $referencia['cod_sorteio'] . '</b></a> </td>';
            $dados['retornoTabela'] .= '<td>' . $referencia['entidade'] . '</td>';
            $dados['retornoTabela'] .= '<td>' . $referencia['reference_number'] . '</td>';
            $dados['retornoTabela'] .= '<td>' . number_format($referencia['custo'], 2, ".", ",") . ' KZ</td><td>';
            if ($referencia['estado'] == 1):
                $dados['retornoTabela'] .= '<a href="#" class="btn btn-success disabled"><b>Pago</b></a>';
            else:
                $dados['retornoTabela'] .= '<a href="#" class="btn btn-danger disabled"><b style="color: #000">Pendende</b></a>';
            endif;
            $dados['retornoTabela'] .= '</td></tr>';
        endforeach;
        $dados['retornoTabela'] .= '</tbody> </table></div>';

        echo json_encode($dados);
       
    }
    
    public function VPOSenviarCURL_NewTransation() {
        $FimSorteio = $this->m->verificarEstadoSorteio($this->input->post('cod_sorteioID'));
        if($FimSorteio == TRUE){
            $data['message'] = 'sorteio_negado';
            echo json_encode($data);
        } elseif ($FimSorteio == FALSE) {
            $CURL_url = vpos_url() . 'transactions';
            $arrayHeader = array(
                'type' => 'payment',
                'pos_id' => '258931',
//                'pos_id' => '2589',
                'mobile' => $this->input->post('telefoneVPOS'),
                'amount' => $this->input->post('custo_sorteio')
//                'callback_url' => base_url().'users/home',
            );
            $ReferenceVPOS = $this->m->newVposForPost($CURL_url, $arrayHeader);
            $SepararPorENTER = preg_split('/\r\n|\r|\n/', $ReferenceVPOS);
            $SepararPorEspaco = explode(' ', $SepararPorENTER[0]);
            $resposta_VPOS = $SepararPorEspaco[1];
            if($resposta_VPOS == 503){
                $data['message'] = 'server_unvailible';
                echo json_encode($data);            
            }else if($resposta_VPOS == 500){
                $data['message'] = 'server_error';
                echo json_encode($data);            
            }else if($resposta_VPOS == 202){
                $SepararPorBarra = explode('/', $SepararPorENTER[6]);
                $codigo_VPOS = $SepararPorBarra[4];
                // Agora vamos passar a guardar antes e actualizar depois
                $this->salvarPaymentVPOS($codigo_VPOS);
//        $ReferenceAPI = $this->m->listar_user_sorteio($this->session->userdata('user_session')['id'],$this->input->post('cod_sorteioID'));
                $data['output'] = $codigo_VPOS;
                $data['message'] = 'sorteio_permitido';
                echo json_encode($data);
            }
        }
        
    }
    
    public function salvarPaymentVPOS($codigo_VPOS) {
        $datas = new DateTime('+1 day');
        $expiry_date =  $datas->format('Y-m-d H:i:s');
        $amount = $this->input->post('custo_sorteio');
        $entity_id = null;
        $referencias_number = null;
        $modoPayment = 'V';
        $estado = '0';
        if($this->m->verifica_referenciaVPOS($codigo_VPOS) == FALSE){
            $this->m->salvar_referenciaVPOS($estado,$modoPayment, $amount, $entity_id, $expiry_date, $codigo_VPOS, $referencias_number);
        } else {
            return;
        }
        
    }
    
    public function verificarTransacaoVPOSOFFLINE() {
        
        $cod_Referencia = $this->input->post('CodVposReferencia');
        $idTransation = $this->m->buscar_Referencia_By_CODE($cod_Referencia);
        $CURL_url= vpos_url() . 'transactions/'.$idTransation;
        $EstadoTransationVPOS = json_decode( $this->m->NewVposForGetONE($CURL_url) );
        
        if ($EstadoTransationVPOS->status == 'rejected') {
//            if ($this->m->Eliminar_Participacao_user_sorteio($cod_Referencia)) {
//                $this->m->Eliminar_ReferenciaTransation($cod_Referencia);
//            }
            $data['responseVPOS'] = 'Negou';
            echo json_encode($data);
        }elseif ($EstadoTransationVPOS->status == 'accepted') {
            // Aqui vamos simplesmente actualizar ao invez de guardar
            $this->m->ActualizarReferenciaTransation($idTransation);
            $this->m->Actualizar_Participacao_user_sorteio($cod_Referencia);
            $data['responseVPOS'] = 'aceitou';
            echo json_encode($data);
        }
    }
    
    public function verificarTransacaoVPOS() {
        $idTransation = $this->input->post('CodVposTrans');
        $CURL_url= vpos_url() . 'transactions/'.$idTransation;
        $EstadoTransationVPOS = json_decode( $this->m->NewVposForGetONE($CURL_url) );
        
        if ($EstadoTransationVPOS->status == 'rejected') {
            $cod_Referencia1 = $this->m->buscar_COD_Referencia($idTransation);
            if ($this->m->Eliminar_Participacao_user_sorteio($cod_Referencia1)) {
                $this->m->Eliminar_ReferenciaTransation($cod_Referencia1);
            }
            $this->session->set_flashdata('vposNegado', 'NÃO ENTENDEMOS O PORQUE, QUE CANCELASTE O PAGAMENTO...');
            $data['responseVPOS'] = 'Negou';
            echo json_encode($data);
        }elseif ($EstadoTransationVPOS->status == 'accepted') {
            $cod_Referencia = $this->m->buscar_COD_Referencia($idTransation);
            // Aqui vamos simplesmente actualizar ao invez de guardar
            $this->m->ActualizarReferenciaTransation($idTransation);
            $this->m->Actualizar_Participacao_user_sorteio($cod_Referencia);
            //$this->salvarPaymentVPOS($idTransation);
            $data['responseVPOS'] = 'aceitou';
            echo json_encode($data);
        }
    }
    
    
    


// Bloquear um utilizador ou seja activar e desactivar
    public function bloquear($id, $status) {
        $this->m->activarDesactivarUser($id, $status);
        redirect('users');
    }

    

}
