<?php
class Users extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('Users_m', 'm');
        $this->load->model('Api_m', 'u');
    }

    public function perfil() {
        $id_user = $this->session->userdata('user_session') == null? '':$this->session->userdata('user_session')['id'];
        $cabecario['menu'] = 'users';
        $cabecario['submenu']='perfil';
        $cabecario['sidebar'] = '';
        $data['paises']= $this->m->listarPaises();
//        $data['provincia']= $this->m->listarProvincias(6);
//        $data['municipio']= $this->m->listarMunicipio(185);
        $data['users']= $this->m->listarUsers($id_user);
        $cabecario['notificacoes']= $this->m->notificacoes($id_user);
        $this->load->view('template/header',$cabecario);
        $this->load->view('users/perfil',$data);
        $this->load->view('template/footer');
        
    }
    
    
    public function newVposForPostKyamiTeste() {
         
        $body = array(
            'cazola' => '244928806560] [to:46594] [content:"Cazola D 4"]'
        );
        $url = "https://cazola.mojogos.ao/Api/MassageParticipation";
        $curl = curl_init($url);
        //curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $body);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

        $resp = curl_exec($curl);
        curl_close($curl);

//        return json_decode($resp);

        return $resp;
    }
    
    public function bingo() {
        $data ['curlServer'] = $this->newVposForPostKyamiTeste();
        $this->load->view('users/bingo',$data);
        
    }
    
    public function changePass() {
        $id_user = $this->session->userdata('user_session') == null? '':$this->session->userdata('user_session')['id'];
        $dados = $this->m->pegaLogin_byID($id_user);
        $password = strrev(sha1(strtoupper(trim($this->input->post('old_password')))));
        $data['success']='';
        if ($dados->password != $password ) {
            $data['success'] ='senhaAntigaErrada';
            echo json_encode($data);
        } else {
            $this->m->actualizarPassword($this->input->post('new_password'),$id_user);
            $data['success'] ='actualizou';
            echo json_encode($data);
        }
    }
    public function actualizar() {
        $email = $this->input->post('email');
//        $telefone = $this->input->post('telefone');
        $bilhete = $this->input->post('bi');
        $data_nascimento = $this->input->post('data_nasc');
        if ( !$_FILES['imagem']['error']) {
            $tipos_arquivos = array(".jpg", ".JPG", ".gif", ".GIF", ".png", ".PNG");
            $imagem = $_FILES['imagem']['name']; //pega o nome do arquivo escolhido
            $tipo = strrchr($imagem, "."); //pega a extensao (tipo do arquivo que deverá ser jpg gif png)
            $name = date('Ymdhis') . $tipo;
            $nome_antigo = $this->input->post('photo_User');
            $destino = 'assets/images/user/';
            $this->actualizarComImagem($tipo, $tipos_arquivos, $email, $bilhete, $data_nascimento, $destino, $nome_antigo, $name);
            
        }
        elseif ($_FILES['imagem']['size'] > 200000) {
            echo 'imgGrande';
        } 
        else {
            $this->actulalizarSemImagem($email, $bilhete, $data_nascimento);
        }
    }
    
    public function removerConta() {
        $motivoRemocao = $this->input->post('motivoRemocao');
        $userCod = $this->session->userdata('user_session')['id'];
        if (!empty($motivoRemocao)) {
            $this->m->guardarDadosRemocao($motivoRemocao,$userCod);
            $this->m->actualizarParaRemocao($userCod);
            echo 'removida';
        }else {
            echo 'nao_removida';
        }
    }
    public function actulalizarSemImagem($email,$bilhete,$data_nascimento) {
        if ($this->m->verifica_email($email)) {
            echo 'existe_email';
        } 
//        elseif ($this->m->verifica_telefone($telefone)) {
//            echo 'existe_telefone';
//        } 
        elseif ($this->m->verifica_BILHETE($bilhete)) {
            echo 'existe_bilhete';
        } elseif ($this->m->verifica_datanascimento($data_nascimento)) {
            echo 'dataMaior';
        } elseif ($this->m->calcular_idade($data_nascimento)) {
            echo 'menor_idade';
        } else {
            $this->m->actualizar();
            echo 'actualizou';
        }
    }
    public function actualizarComImagem($tipo,$tipos_arquivos,$email,$bilhete,$data_nascimento,$destino,$nome_antigo,$name) {
        if (!in_array($tipo, $tipos_arquivos)) {
                echo 'desconhecido';
            }elseif ($this->m->verifica_email($email)) {
                echo 'existe_email';
            }
            elseif ($this->m->verifica_BILHETE($bilhete)) {
                echo 'existe_bilhete';
            }elseif ($this->m->verifica_datanascimento($data_nascimento)) {
                echo 'dataMaior';
            }elseif ($this->m->calcular_idade($data_nascimento)) {
                echo 'menor_idade';
            } else {
                if (file_exists($destino . $nome_antigo)) {
                    unlink($destino . $nome_antigo);
                    move_uploaded_file($_FILES['imagem']['tmp_name'], $destino . $name);
                    $this->m->actualizar($name);
                    echo 'actualizou';
                } elseif (!file_exists($destino . $nome_antigo)) {
                    move_uploaded_file($_FILES['imagem']['tmp_name'], $destino . $name);
                    $this->m->actualizar($name);
                    echo 'actualizou';
                } else {
                    echo 'nao_actualizou';
                }
            }
    }

    public function home() {
        $id_user = $this->session->userdata('user_session') == null? '':$this->session->userdata('user_session')['id'];
        $data['sorteios_diario'] = $this->m->sorteios('D');
        $data['sorteios_semanal'] = $this->m->sorteios('S');
        $data['sorteios_mensal'] = $this->m->sorteios('M');
        
        $cabecario['submenu'] = 'todosSorteios';
        $cabecario['menu'] = 'users';
        $cabecario['sidebar'] = '';
        $cabecario['notificacoes']= $this->m->notificacoes($id_user);
        $this->load->view('template/header',$cabecario);
        $this->load->view('users/home',$data);
        $this->load->view('template/footer');
    }
    
    
    public function lockUnlockUser() {
        $id=$this->input->post('userID');
        $status=$this->input->post('userSTATE');
        if ($status =='1') {
            $status ='2'; 
        } elseif($status =='2') {
            $status ='1';
        }
//        echo json_encode($status);
        if($this->m->BloaquearDesbloquearUser($id, $status)){
            echo json_encode('alterou');
        } else {
            echo json_encode('Nao_alterou');
        }
    }
    public function changeStatesUser() {
        $id=$this->input->post('userID');
        $status=$this->input->post('userSTATE');
        if ($status =='1') {
            $status ='0'; // caso o status passado por paramatro já for S entao desativa caso contrario activa
        } elseif($status =='0') {
            $status ='1';
        }
//        echo json_encode($status);
        if($this->m->activarDesactivarUserRole($id, $status)){
            echo json_encode('alterou');
        } else {
            echo json_encode('Nao_alterou');
        }
    }
    public function checkPerfil() {
        
        if($this->m->Pegar_EstadoPerfil() == 0){
            $data['resposta'] = 'nao_concluiu';
            echo json_encode($data);
        }elseif($this->m->Pegar_EstadoPerfil() == 1){
            $data['resposta'] = 'concluiu';
            echo json_encode($data);
        }
    }
    public function todasNotificacoes() {
        $cabecario['submenu'] = 'notificar';
        $cabecario['menu'] = 'users';
        $cabecario['sidebar'] = 'activo';
        
        $data['notificacoesH']= $this->m->notificacoes($this->session->userdata('user_session')['id']);
        $cabecario['notificacoes']= $this->m->notificacoes($this->session->userdata('user_session')['id']);
        $this->load->view('template/header',$cabecario);
        $this->load->view('users/notificacoes',$data);
        $this->load->view('template/footer');
    }
    public function consolidarReferencia() {
        if ($this->session->userdata('user_session')['role']=='1') {
            $CURL_url = wikipayAPI_url() . 'payment';
            $TodosPagamentos = $this->m->GetAllPaymentCURL($CURL_url);
            foreach ($TodosPagamentos->payments as $value) {
                $result_refencia = $this->m->listar_ReferenciaUnica($value->reference_id);
                if ($result_refencia) {
                    $this->m->actualizaEstadoReferencia($value->reference_id, $result_refencia['id']);
                    $CURL_url2 = wikipayAPI_url() . 'payment/' . $value->id;
                    $this->m->newCurlforDELETE($CURL_url2);
                }
            }
            echo json_encode('funciona');
        }else{
            echo json_encode('NaoAdmin');
        }
        
    }
    
    public function conta() {
        $data = [];
        $cabecario['menu'] = 'users';
        $cabecario['submenu'] = 'users_acount';
        $cabecario['sidebar'] = '';
        $data['ContaUser'] = $this->m->CalcularSaldoClubeCazola($this->session->userdata('user_session')['id']);
        $data['DetalhesContaUser'] = $this->m->listar_DetalhesContaUserID($this->session->userdata('user_session')['id']);
        $cabecario['notificacoes']= $this->m->notificacoes($this->session->userdata('user_session')['id']);
        $this->load->view('template/header', $cabecario);
        $this->load->view('users/conta', $data);
        $this->load->view('template/footer');
    }
    
    public function referenceNotPaid($codigo) {
        $arrayRefNotPaid = $this->m->listar_user_sorteioBY_Reference($this->session->userdata('user_session')['id'],$codigo);
        if(!is_null($arrayRefNotPaid)){
            foreach ($arrayRefNotPaid as $value) {
                $idTransation = $this->m->buscar_Referencia_By_CODE($value['referencia_id']);
                $body = array( 'reference' => $idTransation,);
                $uri = kyami_GPO_url() . 'reference/paid';
                $EstadoTransationVPOS = $this->m->newVposForPostKyami($uri, $body);
                if (!empty($EstadoTransationVPOS['resp']->data) && !empty($EstadoTransationVPOS['resp']->movement_time)) {
                    // Aqui vamos simplesmente actualizar ao invez de guardar
                    $this->m->ActualizarReferenciaTransation($idTransation);
                    $this->m->Actualizar_Participacao_user_sorteio($value['referencia_id']);
                }
            }
        }
    }

    public function participar() {
        date_default_timezone_set('Africa/Luanda');
        $codigo= urldecode(base64_decode(filter_input(INPUT_GET,'r')));
        //$this->referenceNotPaid($codigo);
        $cabecario['notificacoes']= $this->m->notificacoes($this->session->userdata('user_session')['id']);
        $categoriaSorte = $this->m->listarSorteio($codigo);
        if($categoriaSorte['categoria'] == 'D'){
            $data['ReferenceAPI'] = $this->m->listar_user_sorteioDiaria($this->session->userdata('user_session')['id'],$codigo);
        } elseif ($categoriaSorte['categoria'] == 'S') {
            $data['ReferenceAPI'] = $this->m->listar_user_sorteioSemanal($this->session->userdata('user_session')['id'],$codigo);
        } else {
            $data['ReferenceAPI'] = $this->m->listar_user_sorteioMensal($this->session->userdata('user_session')['id'],$codigo);
        }
        $data['sorteios'] = $this->m->listarSorteio($codigo);
        
        $data['premios_sorteios'] = $this->m->listar_sorteios_premios($codigo);
        $data['ContaUser'] = $this->m->CalcularSaldoClubeCazola($this->session->userdata('user_session')['id']);
        $cabecario['submenu'] = 'users_history';
        $cabecario['menu'] = 'users';
        $cabecario['sidebar'] = 'activo';
        
        $this->load->view('template/header',$cabecario);
        $this->load->view('users/participar',$data);
        $this->load->view('template/footer');
        
    }
    
    
    public function historicoCazola() {

        $user = $this->input->post('sorteioName') == '' ? FALSE : $this->input->post('sorteioName');
        $cabecario['notificacoes']= $this->m->notificacoes($this->session->userdata('user_session')['id']);
        if ($user === FALSE) {
            $utilizadores = $this->m->listarSorteiosHistorico();
            if ($utilizadores == null) {
                $data['allSorteios'] = (object) [];
            } else {
                $data['allSorteios'] = $utilizadores;
            }
        } else {
            $utilizadores = $this->m->listarSorteiosHistorico($user);
            if ($utilizadores == null) {
                $data['allSorteios'] = (object) [];
            } else {
                $data['allSorteios'] = $utilizadores;
            }
        }
        $data['imgAway'] = base_url().'assets/images/sorteio/';
        $cabecario['submenu'] = 'users_history';
        $cabecario['menu'] = 'users';
        $cabecario['sidebar'] = 'activo';

        $this->load->view('template/header',$cabecario);
        $this->load->view('users/buscarCazola',$data);
        //$this->load->view('template/footer');
    }
    
    public function cazdetalhes() {
        $codigo= urldecode(base64_decode(filter_input(INPUT_GET,'r')));
        $cabecario['notificacoes']= $this->m->notificacoes($this->session->userdata('user_session')['id']);
        $cabecario['submenu'] = 'todosSorteios';
        $cabecario['menu'] = 'users';
        $cabecario['sidebar'] = '';
        
        $query = $this->u->listarONESorteioFocus($codigo);
        if($query){
            $data['sorteios'] = $query;
            $data['participantes'] = $this->m->listarPorParticipacoesPorCazolas($codigo, $query['categoria']);
            $data['premiosSorteios'] = $this->u->listar_premiosDosSorteios($codigo);
            $data['imgAway'] = base_url().'assets/images/sorteio/';
            $data['imgPremioAway'] = base_url().'assets/images/premio/';
            
        }else{
            $data['sorteios']=[];
            $data['participantes']=[];
            $data['premiosSorteios']=[];
        }
        
        $this->load->view('template/header',$cabecario);
        $this->load->view('users/cazola_detalhes',$data);
        //$this->load->view('template/footer');
    }

    public function allReferences() {
       date_default_timezone_set('Africa/Luanda');
        $datas = new DateTime('+1 day');
        $data_convert =  $datas->format('Y-m-d H:i:s');
//        $montante = floatval($this->input->post('amount_sorteio'));
        $body = array(
            'entity' => '01223',
            'price' => $this->input->post('amount_sorteio'),
            'expiry' => $data_convert,
            'description' => '',
        );
        $uri = kyami_GPO_url() . 'reference/generate';
        $response =  $this->m->newVposForPostKyami($uri, $body);
        $total_numeros = $this->limeteBingo($this->input->post('categoriaSorteio'));

        $referencias=$response['resp'];
        $modoPayment='R';
        
        if($response['httpcode'] == 400){
            $dados['apiDetalil'] = $referencias;
            $dados['messageReference'] ='existeRefe';
        }elseif ($response['httpcode'] == 401) {
            $dados['apiDetalil'] = $referencias;
            $dados['messageReference'] ='nao_autorizado';
        }elseif ($response['httpcode'] == 422) {
            $dados['apiDetalil'] = $referencias;
            $dados['messageReference'] ='ManyRequest';
        }elseif ($response['httpcode'] == 500 || $response['httpcode'] == 505) {
            $dados['apiDetalil'] = $referencias;
            $dados['messageReference'] ='InternalServerError';
        }elseif ($response['httpcode'] == 200) {
            $this->m->salvar_referencia($modoPayment,$referencias->price,$referencias->entity,$data_convert,$referencias->reference,$referencias->reference,$total_numeros);
            $dados['messageReference'] ='successo';
            $dados['referenciaActual'] = '<div style="text-align:center" id = "mostarReferenciasCriadas">';
            $dados['referenciaActual'] .= '<h4>Entidade: ' . $referencias->entity . '</h4>';
            $dados['referenciaActual'] .= '<h4>Referência: ' .$referencias->reference. ' </h4>';
            $dados['referenciaActual'] .= '<h4>Valor : ' . $referencias->price . ' KZ</h4><br></div>';
        } else {
            $dados['apiDetalil'] = $response;
            $dados['messageReference'] ='NOApi';
        }
         
        echo json_encode($dados);
       
    }
    
    public function VPOSenviarCURL_NewTransation() {
        $FimSorteio = $this->m->verificarEstadoSorteio($this->input->post('cod_sorteioID'));
        if($FimSorteio == TRUE){
            $data['message'] = 'sorteio_negado';
            $this->session->set_flashdata('NegadoKYAMI', 'SORTEIO INACTIVO OU FINALIZADO');
            echo json_encode($data);
        } elseif ($FimSorteio == FALSE) {
            $uri = kyami_GPO_url() . 'gpo/payment';
            $montante = floatval($this->input->post('custo_sorteioVPOS'));
            $body = array(
                'cellphone' => $this->input->post('telefoneVPOS'),
                'amount' => $montante,
                'pos' => 258931
            );
            
            $ReferenceVPOS = $this->m->newVposForPostKyami($uri, $body);
//            $data['kyami_resp'] = $ReferenceVPOS;
//            echo json_encode($data);
            if($ReferenceVPOS['httpcode'] == 505 || $ReferenceVPOS['httpcode'] == 500){
                $this->session->set_flashdata('NegadoKYAMI', 'SERVIDOR INDISPONÍVEL, TENTE MAIS TARDE');
                $data['message'] = 'server_error';
                echo json_encode($data);            
            }else if($ReferenceVPOS['httpcode'] == 422){
                $this->session->set_flashdata('NegadoKYAMI', 'CANCELASTE A COMPRA OU SEU BANCO CANCELOU A COMPRA, TENTE NOVAMENTE');
                $data['kyami_resp'] = $ReferenceVPOS;
                $data['message'] = 'outher_errors';
                echo json_encode($data);            
            }else if($ReferenceVPOS['httpcode'] == 400){
                $this->session->set_flashdata('NegadoKYAMI', 'ERRO NOS FORMATOS, CONTACTE O ADMIN');
                $data['kyami_resp'] = $ReferenceVPOS;
                $data['message'] = 'format_errors';
                echo json_encode($data);            
            }else if($ReferenceVPOS['httpcode'] == 401){
                $this->session->set_flashdata('NegadoKYAMI', 'ERRO DE AUTHORIZAÇÃO, CONTACTE O ADMIN');
                $data['message'] = 'nao_auth';
                echo json_encode($data);            
            }else if($ReferenceVPOS['httpcode'] == 0){
                $this->session->set_flashdata('NegadoKYAMI', 'NÃO HOUVE COMUNICAÇÃO COM O SERVIDOR, VERIFIQUE A SUA CONEXÃO');
                $data['message'] = 'nao_conection';
                echo json_encode($data);            
            }else if($ReferenceVPOS['httpcode'] == 200){
                // Agora vamos passar a guardar antes e actualizar depois
                $this->salvarPaymentVPOS($ReferenceVPOS['resp']->id);
                $this->session->set_flashdata('EXPRESSAceiteKYAMI', 'OBRIGADO, Quanto mais jogares, mais chance tens de GANHAR!');
//        $ReferenceAPI = $this->m->listar_user_sorteio($this->session->userdata('user_session')['id'],$this->input->post('cod_sorteioID'));
                $data['output'] = $ReferenceVPOS['resp']->id;
                $data['message'] = 'sorteio_permitido';
                echo json_encode($data);
            }
        }
        
    }
    public function limeteBingo($categoria) {
        if ($categoria == 'D') {
            $total_numeros = 9;
        } elseif ($categoria == 'S') {
            $total_numeros = 16;
        } elseif ($categoria == 'M') {
            $total_numeros = 25;
        }
        return $total_numeros;
    }
    
    
    public function salvarPaymentVPOS($codigo_VPOS) {
        $datas = new DateTime('+1 day');
        $expiry_date = $datas->format('Y-m-d H:i:s');
        $amount = $this->input->post('custo_sorteioVPOS');
        $entity_id = null;
        $referencias_number = null;
        $modoPayment = 'V';
        $estado = '1';
        
        $total_numeros = $this->limeteBingo($this->input->post('categoriaSorteio'));
        if($this->m->verifica_referenciaVPOS($codigo_VPOS) == FALSE){
            $this->m->salvar_referenciaVPOS($estado,$modoPayment, $amount, $entity_id, $expiry_date, $codigo_VPOS, $referencias_number,$total_numeros);
        } else {
            return;
        }
        
    }
    
    public function participarComSaldoConta() {
        date_default_timezone_set('Africa/Luanda');
        $FimSorteio = $this->m->verificarEstadoSorteio($this->input->post('cod_sorteioID'));
        $saldoUser = $this->m->CalcularSaldoClubeCazola($this->session->userdata('user_session')['id']);
        $amount = $this->input->post('amount_sorteio');
        $total_numeros = $this->limeteBingo($this->input->post('categoriaSorteio'));
        if($FimSorteio == TRUE){
            $data['messageAcount'] = 'sorteio_negado';
            echo json_encode($data);
        }elseif($FimSorteio == false){
                if($saldoUser < $amount){
                    $data['messageAcount'] = 'saldo_inferior';
                } elseif ($saldoUser >= $amount) {
                    $modoPayment = 'S';
                    $estado = '1';
                    
                    $this->m->salvar_DebitarConta_USER($modoPayment, $amount, $estado, $total_numeros);
                    $data['messageAcount'] = 'sorteio_permitido';
                    
                }
                echo json_encode($data);
            }
    }
    
    public function verificarTransacaoVPOSOFFLINE() {
        
        $cod_Referencia = $this->input->post('CodVposReferencia');
        $idTransation = $this->m->buscar_Referencia_By_CODE($cod_Referencia);
        $CURL_url= vpos_url() . 'transactions/'.$idTransation;
        $EstadoTransationVPOS = json_decode( $this->m->NewVposForGetONE($CURL_url) );
        
        if ($EstadoTransationVPOS->status == 'rejected') {
//            if ($this->m->Eliminar_Participacao_user_sorteio($cod_Referencia)) {
//                $this->m->Eliminar_ReferenciaTransation($cod_Referencia);
//            }
            $data['responseVPOS'] = 'Negou';
            echo json_encode($data);
        }elseif ($EstadoTransationVPOS->status == 'accepted') {
            // Aqui vamos simplesmente actualizar ao invez de guardar
            $this->m->ActualizarReferenciaTransation($idTransation);
            $this->m->Actualizar_Participacao_user_sorteio($cod_Referencia);
            $data['responseVPOS'] = 'aceitou';
            echo json_encode($data);
        }
    }
    
    public function verificarTransacaoKYAMI() {
        
        $cod_Referencia = $this->input->post('CodKYAMIReferencia');
        $idTransation = $this->m->buscar_Referencia_By_CODE($cod_Referencia);
        $body = array(
//            'entity' => '01223',
            'reference' => $idTransation,
            
        );
        $uri = kyami_GPO_url() . 'reference/paid';
        $EstadoTransationVPOS = $this->m->newVposForPostKyami($uri, $body);
        
        if (!empty($EstadoTransationVPOS['resp']->data) && !empty($EstadoTransationVPOS['resp']->movement_time)) {
            // Aqui vamos simplesmente actualizar ao invez de guardar
            $this->m->ActualizarReferenciaTransation($idTransation);
            $this->m->Actualizar_Participacao_user_sorteio($cod_Referencia);
            $data['responseVPOS'] = 'aceitou';
            echo json_encode($data);
        }else {
//            if ($this->m->Eliminar_Participacao_user_sorteio($cod_Referencia)) {
//                $this->m->Eliminar_ReferenciaTransation($cod_Referencia);
//            }
            
            $data['responseVPOS'] = 'Negou';
            echo json_encode($data);
        }
    }
    
    public function verificarTransacaoKYAMIConta() {
        
        $cod_Referencia = $this->input->post('CodKYAMIReferencia');
        $idTransation = $this->m->buscar_Referencia_By_CODE($cod_Referencia);
        $body = array(
//            'entity' => '01223',
            'reference' => $idTransation,
            
        );
        $uri = kyami_GPO_url() . 'reference/paid';
        $EstadoTransationVPOS = $this->m->newVposForPostKyami($uri, $body);
        
        if (!empty($EstadoTransationVPOS['resp']->data) && !empty($EstadoTransationVPOS['resp']->movement_time)) {
            // Aqui vamos simplesmente actualizar ao invez de guardar
            $this->m->ActualizarReferenciaTransation($idTransation);
            $this->m->Actualizar_Carregar_user_conta($cod_Referencia);
            $data['responseVPOS'] = 'aceitou';
            echo json_encode($data);
        }else {
//            if ($this->m->Eliminar_Participacao_user_sorteio($cod_Referencia)) {
//                $this->m->Eliminar_ReferenciaTransation($cod_Referencia);
//            }
            
            $data['responseVPOS'] = 'Negou';
            echo json_encode($data);
        }
    }
    
    public function verReferenciaPendenteKYAMI() {
        $cod_Referencia = $this->input->post('CodKYAMIReferencia');
        $result_refencia = $this->m->listar_ReferenciaUnicaPorID($cod_Referencia);
//        if ($result_refencia) {
            
//        }
        if($result_refencia){
            $dados['message'] = 'sucesso';
            $dados['referenciaActual'] = '<div style="text-align:center" id = "mostarReferenciasCriadas">';
            $dados['referenciaActual'] .= '<h4>Entidade: ' . $result_refencia['entidade'] . '</h4>';
            $dados['referenciaActual'] .= '<h4>Referência: ' .$result_refencia['reference_number']. ' </h4>';
            $dados['referenciaActual'] .= '<h4>Valor : ' . $result_refencia['valor'] . ' KZ</h4><br></div>';
        } else {
            $dados['message'] = 'erro';
        }
        echo json_encode($dados);
    }
    
    public function verificarTransacaoVPOS() {
        $idTransation = $this->input->post('CodVposTrans');
        $CURL_url= vpos_url() . 'transactions/'.$idTransation;
        $EstadoTransationVPOS = json_decode( $this->m->NewVposForGetONE($CURL_url) );
        
        if ($EstadoTransationVPOS->status == 'rejected') {
            $cod_Referencia1 = $this->m->buscar_COD_Referencia($idTransation);
            if ($this->m->Eliminar_Participacao_user_sorteio($cod_Referencia1)) {
                $this->m->Eliminar_ReferenciaTransation($cod_Referencia1);
            }
            $this->session->set_flashdata('NegadoKYAMI', 'NÃO ENTENDEMOS O PORQUE, QUE CANCELASTE O PAGAMENTO, TENTE DE NOVO...');
            $data['responseVPOS'] = 'Negou';
            echo json_encode($data);
        }elseif ($EstadoTransationVPOS->status == 'accepted') {
            $cod_Referencia = $this->m->buscar_COD_Referencia($idTransation);
            // Aqui vamos simplesmente actualizar ao invez de guardar
            $this->m->ActualizarReferenciaTransation($idTransation);
            $this->m->Actualizar_Participacao_user_sorteio($cod_Referencia);
            //$this->salvarPaymentVPOS($idTransation);
            $data['responseVPOS'] = 'aceitou';
            echo json_encode($data);
        }
    }
    
    
    


// Bloquear um utilizador ou seja activar e desactivar
    public function bloquear($id, $status) {
        $this->m->activarDesactivarUser($id, $status);
        redirect('users');
    }
    public function carregarContaPorReferencia() {
        $valor_carregar = $this->input->post('valorReferenciaKYAMI');
        if($valor_carregar < 50){
            $dados['messageReference'] = 'valor_inferior';
            echo json_encode($dados);
        }else if($valor_carregar >= 50){
            $this->allReferencesForAcount($valor_carregar);
        }
        
    }
    public function allReferencesForAcount($valor_carregar) {
        date_default_timezone_set('Africa/Luanda');
        $FimSorteio = $this->m->verificarEstadoSorteio($this->input->post('cod_sorteioID'));
        if($FimSorteio == TRUE){
            $dados['messageReference'] = 'inativo_finalizado';
        }elseif($FimSorteio == false){
            
            $datas = new DateTime('+1 day');
            $data_convert = $datas->format('Y-m-d H:i:s');
//        $montante = floatval($this->input->post('amount_sorteio'));
            $body = array(
//            'numero' => $this->session->userdata('user_session')['telefone'],
                'entity' => '01223',
                'price' => $valor_carregar,
                'expiry' => $data_convert,
                'description' => '',
            );
            $uri = kyami_GPO_url() . 'reference/generate';
            $response = $this->m->newVposForPostKyami($uri, $body);

            $referencias = $response['resp'];
            $modoPayment = 'R';
            $estado = '0';
            if ($response['httpcode'] == 400) {
                $dados['apiDetalil'] = $referencias;
                $dados['messageReference'] = 'existeRefe';
            } elseif ($response['httpcode'] == 401) {
                $dados['apiDetalil'] = $referencias;
                $dados['messageReference'] = 'nao_autorizado';
            } elseif ($response['httpcode'] == 422) {
                $dados['apiDetalil'] = $referencias;
                $dados['messageReference'] = 'ManyRequest';
            } elseif ($response['httpcode'] == 500 || $response['httpcode'] == 505) {
                $dados['apiDetalil'] = $referencias;
                $dados['messageReference'] = 'InternalServerError';
            } elseif ($response['httpcode'] == 200) {
                $this->m->salvar_referenciaKYAMI($estado, $modoPayment, $referencias->price, $referencias->entity, $data_convert, $referencias->reference, $referencias->reference);
//            $this->m->salvar_referencia($estado, $modoPayment, $referencias->price, $referencias->entity, $data_convert, $referencias->reference, $referencias->reference);
                $dados['messageReference'] = 'successo';
                $dados['referenciaActual'] = '<div style="text-align:center" id = "mostarReferenciasCriadas">';
                $dados['referenciaActual'] .= '<h4>Entidade: ' . $referencias->entity . '</h4>';
                $dados['referenciaActual'] .= '<h4>Referência: ' . $referencias->reference . ' </h4>';
                $dados['referenciaActual'] .= '<h4>Valor : ' . $referencias->price . ' KZ</h4><br></div>';
            } else {
                $dados['apiDetalil'] = $response;
                $dados['messageReference'] = 'NOApi';
            }
        }
        
        echo json_encode($dados);
    }

    public function CarregarContaGPO_NewTransation() {
            $uri = kyami_GPO_url() . 'gpo/payment';
            $montante = floatval($this->input->post('valorKYAMI'));
            $body = array(
                'cellphone' => $this->input->post('telefoneKYAMI'),
                'amount' => $montante,
                'pos' => 258931
            );
            $ReferenceVPOS = $this->m->newVposForPostKyami($uri, $body);
            if ($ReferenceVPOS['httpcode'] == 505 || $ReferenceVPOS['httpcode'] == 500) {
                $this->session->set_flashdata('NegadoKYAMI', 'SERVIDOR INDISPONÍVEL, TENTE MAIS TARDE');
                $data['message'] = 'server_error';
                echo json_encode($data);
            } else if ($ReferenceVPOS['httpcode'] == 422) {
                $this->session->set_flashdata('NegadoKYAMI', 'CANCELASTE OU SEU BANCO CANCELOU A COMPRA, TENTE NOVAMENTE');
                $data['kyami_resp'] = $ReferenceVPOS;
                $data['message'] = 'outher_errors';
                echo json_encode($data);
            } else if ($ReferenceVPOS['httpcode'] == 400) {
                $this->session->set_flashdata('NegadoKYAMI', 'ERRO NOS FORMATOS, CONTACTE O ADMIN');
                $data['kyami_resp'] = $ReferenceVPOS;
                $data['message'] = 'format_errors';
                echo json_encode($data);
            } else if ($ReferenceVPOS['httpcode'] == 401) {
                $this->session->set_flashdata('NegadoKYAMI', 'ERRO DE AUTHORIZAÇÃO, CONTACTE O ADMIN');
                $data['message'] = 'nao_auth';
                echo json_encode($data);
            } else if ($ReferenceVPOS['httpcode'] == 0) {
                $this->session->set_flashdata('NegadoKYAMI', 'NÃO HOUVE COMUNICAÇÃO COM O SERVIDOR, VERIFIQUE A SUA CONEXÃO');
                $data['message'] = 'nao_conection';
                echo json_encode($data);
            } else if ($ReferenceVPOS['httpcode'] == 200) {
                // Agora vamos passar a guardar antes e actualizar depois
                $this->salvarPaymentGPO_KYAMI($ReferenceVPOS['resp']->id, $this->input->post('valorKYAMI'));
//        $ReferenceAPI = $this->m->listar_user_sorteio($this->session->userdata('user_session')['id'],$this->input->post('cod_sorteioID'));
                $data['output'] = $ReferenceVPOS['resp']->id;
                $data['message'] = 'conta_carregada';
                echo json_encode($data);
            }
    }
    
    public function salvarPaymentGPO_KYAMI($codigo_VPOS,$amount) {
        $datas = new DateTime('+1 day');
        $expiry_date = $datas->format('Y-m-d H:i:s');
//        $amount = $this->input->post('custo_sorteioVPOS');
        $entity_id = null;
        $referencias_number = null;
        $modoPayment = 'V';
        $estado = '1';
        if ($this->m->verifica_referenciaVPOS($codigo_VPOS) == FALSE) {
            $this->m->salvar_referenciaKYAMI($estado, $modoPayment, $amount, $entity_id, $expiry_date, $codigo_VPOS, $referencias_number);
        } else {
            return;
        }
    }

}
