<?php
class Relatorios extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->load->library('Pdf_report');
        $this->load->model('Relatorios_m', 'm');
        $this->load->model('Resultados_m', 'u');
    }

    public function index() {
        $data['tableHead'] =NULL;
        $cabecario['submenu'] = 'relatorioSorteio';
        $cabecario['menu'] = 'relatorioAdm';
        $cabecario['sidebar'] = 'activo';
        $cabecario['notificacoes']= $this->m->notificacoes($this->session->userdata('user_session')['id']);
        $codigoSorteio= urldecode(base64_decode(filter_input(INPUT_GET,'r')));
            
        $data['sorteios'] = $this->m->listarSorteio($codigoSorteio);
        $sorteios = $this->m->listarSorteio($codigoSorteio);
        $data['tableHead'] = array(
        'SorteioCOD' => $codigoSorteio,
        'DataInicio' => $sorteios['data_inicio'],
        'DataFim' => $sorteios['data_fim']
        );
        
        if($sorteios['categoria']=='D'){$data['relatorio']= $this->m->listarSorteiosPorDataD($codigoSorteio,$sorteios['data_inicio'],$sorteios['data_fim']);}
        elseif($sorteios['categoria']=='S'){$data['relatorio']= $this->m->listarSorteiosPorDataS($codigoSorteio,$sorteios['data_inicio'],$sorteios['data_fim']);}
        elseif($sorteios['categoria']=='M'){$data['relatorio']= $this->m->listarSorteiosPorDataM($codigoSorteio,$sorteios['data_inicio'],$sorteios['data_fim']);}
         
        $data['inscritos'] = $this->m->totalDInscritos();
        $data['removidos'] = $this->m->totalDRemovidos();
        $this->load->view('template/header',$cabecario);
        $this->load->view('relatorios/RelatorioSorteios',$data);
        $this->load->view('template/footer');
    }
    
    public function cazolas() {
        $cabecario['sidebar'] = 'activo';
        $cabecario['submenu'] = 'relatorioSorteio';
        $cabecario['menu'] = 'relatorioAdm';
        if (!empty($this->input->post('sorteioState')) && !empty($this->input->post('sorteioCategory')) && !empty($this->input->post('data_inicio'))) {
            $estado = $this->input->post('sorteioState');
            $categoria = $this->input->post('sorteioCategory');
            $Data = date('Y-m-d', strtotime($this->input->post('data_inicio')));
            $NomeSorteio = $this->input->post('nomeSorteio');
            $data['sorteios'] = $this->m->BuscarSorteioEscolhidoPorNome($estado, $categoria, $Data,$NomeSorteio);
        }else { $data['sorteios'] = $this->u->listar();}
        $cabecario['notificacoes'] = $this->m->notificacoes($this->session->userdata('user_session')['id']);
        $this->load->view('template/header', $cabecario);
        $this->load->view('relatorios/listar', $data);
        $this->load->view('template/footer');
    }
    
    public function participacoes() {
//        $data['sorteios'] = $this->m->sorteios();$this->uri->segment(3)
        $data['tableHead'] =NULL;
        $data['user_actual'] = $this->session->userdata('user_session')['nome'];
        if(!empty($this->input->post('data_inicio')) && !empty($this->input->post('data_fim'))){
            $data['tableHead'] = array(
            'SorteioCOD' => $this->input->post('sorteioID'),
            'DataInicio' => $this->input->post('data_inicio'),
            'DataFim' => $this->input->post('data_fim')
            );
            
            $data['sorteios'] = $this->m->listarSorteio($this->input->post('sorteioID'));
            $sorteios = $this->m->listarSorteio($this->input->post('sorteioID'));
            if ($sorteios['categoria'] == 'D') {
                $data['relatorio'] = $this->m->listarSorteiosPorDataDulimited();
            } elseif ($sorteios['categoria'] == 'S') {
                $data['relatorio'] = $this->m->listarSorteiosPorDataSulimited();
            } elseif ($sorteios['categoria'] == 'M') {
                $data['relatorio'] = $this->m->listarSorteiosPorDataMulimited();
            }
        }
        $this->load->view('relatorios/RelatorioPDF',$data);
    }
    
    
    public function getSorteiosState() {
        $sorteioState = $this->input->post('sorteioStado');
        $sorteios = $this->m->sorteiosByState($sorteioState);
        $pro_select_box = '';
        if (!empty($sorteios)) {
            $pro_select_box .= '<option value="">Escolha um Sorteio</option>';
            foreach ($sorteios as $sorteio) {
                $pro_select_box .='<option value="' . $sorteio->id . '">'.$sorteio->nome.'   -   '. date('d-m-Y', strtotime( $sorteio->data_inicio)). '</option>';
            }
            echo json_encode($pro_select_box);
        }else{
            $pro_select_box .= '<option value="">Nenhum Sorteio Encontrado</option>';
            echo json_encode($pro_select_box);
        }
    }
    

}
