<?php

class Municipios extends CI_Controller {

    function __construct() {
        parent::__construct();
//        ini_set('memory_limit', 'M');
        $this->load->model('municipios_m', 'm');
    }

    public function index() {
        $data['municipios'] = $this->m->listar();
        $this->load->view('templates/header');
        $this->load->view('municipios/index', $data);
        $this->load->view('templates/footer');
    }

    public function salvar() {
        $this->form_validation->set_rules('name', 'name', 'required');
        if ($this->form_validation->run() === false) {
            $data['pais'] = $this->m->buscar_pais();
            $this->load->view('templates/header');
            $this->load->view('municipios/salvar', $data);
            $this->load->view('templates/footer');
        } else {
            $this->m->salvar();
            redirect('municipios');
        }
    }

    public function eliminar($id) { // Eliminar pais
        $this->m->eliminar($id);
        redirect('municipios');
    }

    public function editar($id) {
        $data['municipios'] = $this->m->listar($id);
        $data['pais'] = $this->m->buscar_pais();
        if (empty($data['municipios'])) {
            show_404();
        }
        $this->load->view('templates/header');
        $this->load->view('municipios/actualizar', $data);
        $this->load->view('templates/footer');
    }

    public function actualizar() {
        $this->m->actualizar();
        redirect('municipios');
    }

    public function getMunicipio() {
        $provincia_id = $this->input->post('provincia_id');
        $municipios = $this->m->buscar_municipios($provincia_id);
        if (count($municipios) > 0) {
            $pro_select_box = '';
            foreach ($municipios as $municipio) {
                $pro_select_box .='<option value = "'.$municipio->id.'">'.$municipio->name.'</option>';
            }
            echo json_encode($pro_select_box);
        }
    }

}
