<?php

class Api extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('Api_m', 'm');
        $this->load->model('Users_m', 'u');
    }
    public function index() {
//        $jwt = new JWT();
        $data= array(
            'Company' => 'Organizações Sangunga & Filhos Lda, Mô-Jogos',
            'Aplicação' => 'Sistema de Sorteio',
            'Developer' => 'Adilson Dinis Figueira'
        );
        header('Content-type: application/json');
        echo json_encode($data);
    }
    
    // LISTAR TODOS OS SORTEIOS PARA AGENTES
    public function listar() {
        $sorteioD = $this->m->listarByCategory('D');
        $sorteioS = $this->m->listarByCategory('S');
        $sorteioM = $this->m->listarByCategory('M');
        if( !empty($sorteioD) or !empty($sorteioS) or !empty($sorteioM)){
            $data['sorteioD'] = $this->m->listarByCategory('D');
            $data['sorteioS'] = $this->m->listarByCategory('S');
            $data['sorteioM'] = $this->m->listarByCategory('M');
            $data['imgAway'] = base_url().'assets/images/sorteio/';
            $data['success'] = TRUE;
            $data['message'] = 'Sorteios Existente';
            $data['code'] = 200;
            
        }else{
            $data['sorteioD'] = [];
            $data['sorteioS'] = [];
            $data['sorteioM'] = [];
            $data['success'] = FALSE;
            $data['message'] = 'Erro ao encontrar Sorteios';
            $data['code'] = 400;
        }
        header('Content-type: application/json');
        echo json_encode($data);
    }
    
    // LISTAR TODOS OS SORTEIOS PARA FOCUS E UM ESPECÍFICO
    public function listarAllSorteios() {
        $dataYear= $this->input->post('utilizador');
        if($dataYear == FALSE){
            $query = $this->m->listarSorteios();
        }else{
            $query = $this->m->listarSorteios($dataYear);
        }
//        $query = $this->m->listarSorteios();
        if($query){
            $data['sorteios'] = $query;
            $data['imgAway'] = base_url().'assets/images/sorteio/';
            $data['success'] = TRUE;
            $data['message'] = 'Sorteios Existente';
            $data['code'] = 200;
            
        }else{
            $data['sorteios'] = [];
            $data['success'] = FALSE;
            $data['message'] = 'Erro ao encontrar Sorteios';
            $data['code'] = 400;
        }
        header('Content-type: application/json');
        echo json_encode($data);
    }
    
    
    // LISTAR UM SORTEIOS PARA FOCUS COM TODOS OS SEUS DETALHES
    public function listarONESorteioFocus() {
        $cod= $this->input->post('id');
//        $query = $this->m->listarSorteios($dataYear);
        $query = $this->m->listarONESorteioFocus($cod);
        if($query){
            $data['sorteios'] = $query;
            $data['participantes'] = $this->m->listarSorteiosPorParticipantes($cod);
            $data['premiosSorteios'] = $this->m->listar_premiosDosSorteios($cod);
            $data['winner'] = $this->m->ResultadosDoSorteio($cod);
            $data['loosers'] = $this->m->buscarCodigosSorteioUserDosPerdedores($cod);
            $data['userParticipation'] = $this->m->ContarUserPorParticipacaoSorteio($cod);
            $data['imgAway'] = base_url().'assets/images/sorteio/';
            $data['imgPremioAway'] = base_url().'assets/images/premio/';
            $data['success'] = TRUE;
            $data['message'] = 'Sorteio Encontrado';
            $data['code'] = 200;
            
        }else{
            $data['sorteios']=[];
            $data['participantes']=[];
            $data['premiosSorteios']=[];
            $data['winner']=[];
            $data['loosers']=[];
            $data['userParticipation'] = [];
            $data['success'] = FALSE;
            $data['message'] = 'Erro ao encontrar Sorteios';
            $data['code'] = 400;
        }
        header('Content-type: application/json');
        echo json_encode($data);
    }
    // LISTAR NÚMERO DE PARTICIPAÇÕES DOS SORTEIOS PARA FOCUS NUM PERIODO DO CachIN
    public function cashINFocus() {
        $sorteioState= $this->input->post('sorteioState');
        $data_inicio= $this->input->post('data_inicio');
        $data_fim= $this->input->post('data_fim');
//        $query = $this->m->listarSorteios($dataYear);
        $query = $this->m->listarSorteiosPorDataFocus($sorteioState,$data_inicio,$data_fim);
        if($query){
            $data['relatorio'] = $query;
            $data['code'] = 200;
            
        }else{
            $data['relatorio']=[];
            $data['code'] = 400;
        }
        header('Content-type: application/json');
        echo json_encode($data);
    }
    
    // LISTAR NÚMERO DE PARTICIPAÇÕES DOS SORTEIOS PARA FOCUS NUM MÉS
    public function sorteioMonth() {
        $mes= $this->input->post('mes');
        $ano= $this->input->post('ano');
//        $query = $this->m->listarSorteios($dataYear);
        $query = $this->m->ContarTodasParticipacaoSorteioMesAno($mes,$ano);
        if($query){
            $data['sorteios'] = $query;
            $data['code'] = 200;
            
        }else{
            $data['sorteios']=0;
            $data['code'] = 400;
        }
        header('Content-type: application/json');
        echo json_encode($data);
    }
    
    // LISTAR NÚMERO DE PARTICIPAÇÕES DOS SORTEIOS PARA FOCUS NUM DIA DA SEMANA
    public function sorteioDayWeek() {
        $dataAPI= $this->input->post('data');
//        $query = $this->m->listarSorteios($dataYear);
        $query = $this->m->ContarTodasParticipacaoSorteioDiaMesAno($dataAPI);
        if($query){
            $data['sorteios'] = $query;
            $data['code'] = 200;
            
        }else{
            $data['sorteios']=0;
            $data['code'] = 400;
        }
        header('Content-type: application/json');
        echo json_encode($data);
    }
    
    // LISTAR NÚMERO DE PARTICIPAÇÕES DOS SORTEIOS NUM MÉS PARA FOCUS
    public function sorteioSemanalMes() {
        $inicio= $this->input->post('diaInicio');
        $fim= $this->input->post('diaFim');
//        $query = $this->m->listarSorteios($dataYear);
        $query = $this->m->ContarTodasParticipacaoSorteioSemanaMes($inicio,$fim);
        if($query != NULL){
            $data['sorteios'] = $query;
            $data['code'] = 200;
            
        }else{
            $data['sorteios']=0;
            $data['code'] = 400;
        }
        header('Content-type: application/json');
        echo json_encode($data);
    }
    
    // LISTAR CashIN por data e Estado para Sorteio - FOCUS
    public function sorteioCashINDataState() {
        $inicio= $this->input->post('diaInicio');
        $fim= $this->input->post('diaFim');
//        $query = $this->m->listarSorteios($dataYear);
        $query = $this->m->ContarTodasParticipacaoSorteioSemanaMes($inicio,$fim);
        if($query != NULL){
            $data['sorteios'] = $query;
            $data['code'] = 200;
            
        }else{
            $data['sorteios']=0;
            $data['code'] = 400;
        }
        header('Content-type: application/json');
        echo json_encode($data);
    }
    
    // BUSCAR TODOS OS UTLIZADORES DO SORTEIO POR NOME, TELEFONE, ETC... PARA FOCUS
    public function sorteioUsersByUser() {
        $user= $this->input->post('utilizador');
        $query = $this->m->sorteioUsersByUser($user);
        if( $query != null){
            $data['users'] = $query;
            $data['message'] = 'Sucessos';
            $data['code'] = 200;  
        }else{
            $data['message'] = 'Não Existe Utilizadores';
            $data['code'] = 400;
            $data['nome'] = $user;
            $data['users'] = null;
        }
        header('Content-type: application/json');
        echo json_encode($data);
    }
    
    // BUSCAR TODOS OS UTLIZADORES DO SORTEIO PARA FOCUS
    public function sorteioUsers() {
        $query = $this->m->listarUsers();
        if( $query != null){
            $data['users'] = $query;
            $data['message'] = 'Sucessos';
            $data['code'] = 200;  
        }else{
            $data['users'] = [];
            $data['message'] = 'Não Existe Utilizadores';
            $data['code'] = 201;
        }
        header('Content-type: application/json');
        echo json_encode($data);
    }
    
    // Listar um Utilizador por ID pelo Focus
    public function sorteioONEUsers() {
        $id_user= $this->input->post('id');
        $query = $this->m->listarONEUser($id_user);
        $participar = $this->m->sorteioPerUsers($id_user);
        if( $query != null || $participar != null){
            $data['user'] = $query;
            $data['participation'] = $participar;
            $data['otherInformation'] = $this->m->listarInformationONEUser($id_user);
            $data['message'] = 'Sucessos';
            $data['code'] = 200;  
        }else{
            $data['user'] = [];
            $data['participation'] = [];
            $data['message'] = 'Não Existe Utilizadores';
            $data['code'] = 201;
            $data['utilizador'] = $id_user;
        }
        header('Content-type: application/json');
        echo json_encode($data);
    }
    
    // LISTAR UM SORTEIO PARA OS AGENTES
    public function listarONE() {
//        $id_sorteio= $_SERVER['REQUEST_METHOD'];
//        $id_sorteio= $_POST;
        $id_sorteio= $this->input->post('sorteioID');
        $sorteios = $this->m->listarONE($id_sorteio);
        
        if($sorteios == NULL){
            $data['SorteioCode'] = $id_sorteio;
            $data['success'] = FALSE;
            $data['message'] = 'Erro ao encontrar o Sorteio Solicitado';
            $data['code'] = 400;
        }elseif($sorteios != NULL){
            $data['sorteios'] = $sorteios;
            $data['imgAway'] = base_url() . 'assets/images/sorteio/';
            $data['code'] = 200;
        }
//        $data['SorteioCode'] = $id_sorteio;
        echo json_encode($data);
    }
    
    //PAGAMENTO E CRIAÇÃO DOS UTILIZADORES ATRAVÉS DOS AGENTES
    public function Addpayment() {
        $telefone = $this->input->post('telefone');
        $nomeUser = $this->input->post('nome');
        $custo = $this->input->post('custo').'.00';
        $sorteioCodSecre = $this->input->post('sorteioCodSecre');
        $sorteioCod = $this->input->post('sorteioID');
        $referencia_id = null;
        $modo_pagamento = 'A';
        $paymentState = 1;
        $retorno_telefone = $this->m->verifica_telefoneAPI($telefone);
        if ($retorno_telefone === true) {
            $dados = $this->m->pegarUser_telefone($telefone);
//            $codSecreto = $this->m->verifica_vezes_do_Sorteio($dados->id,$sorteioCodSecre,$sorteioCod);
            $codSecreto = $this->m->NovoCodigoSecreto($dados->id,$sorteioCodSecre,$sorteioCod);
            $id_user_sorteio = $this->m->salvar_user_sorteio($custo, $dados->id, $codSecreto, $sorteioCod,$referencia_id,$modo_pagamento,$paymentState);
            $data['adicionais'] = array(
                'id_user' => $dados->id,
                'id_user_sorteio' => $id_user_sorteio,
                'CodSecretSorteio' =>$codSecreto
            );
            $data['success'] = 'telefone_existe';
            $data['code'] = 200;
        } else {
            $data['code'] = 200;
            $data['success'] = 'telefone_nao_existe';
            $id_user = $this->m->guardarNewUser($telefone,$nomeUser);
                       $this->m->conta_userAPI($id_user);
            // Guardar Sorteio com novo user
            $codSecreto = $this->m->NovoCodigoSecreto($id_user,$sorteioCodSecre,$sorteioCod);
            $id_user_sorteio = $this->m->salvar_user_sorteio($custo, $id_user, $codSecreto, $sorteioCod,$referencia_id,$modo_pagamento,$paymentState);
            $data['adicionais'] = array(
                'id_user' => $id_user,
                'id_user_sorteio' => $id_user_sorteio,
                'CodSecretSorteio' =>$codSecreto
            );
        }
        
        echo json_encode($data);
    }
    
    //PAGAMENTO E CRIAÇÃO DOS UTILIZADORES ATRAVÉS DOS AGENTES
    public function MassageParticipation() {
//        $mensagem = ;
        $json_data = $this->input->raw_input_stream;
        $conteudo = json_decode($json_data);
        $msgConteudo = explode(' ', $conteudo->mensagem);
        $cazolaName = !isset($msgConteudo[0]) ? '' : ucwords($msgConteudo[0]);
        $cazolaCategoaria = !isset($msgConteudo[1]) ? '' : strtoupper($msgConteudo[1]);
        $cazolaCusto = !isset($msgConteudo[2]) ? '' : $msgConteudo[2];
        $numero = @substr($conteudo->telefone, 3, 9);
        $Dados_cazola = $this->m->buscar_BYcusto_sorteio($cazolaCusto,$cazolaCategoaria);
        if (empty($conteudo) ) {
            $message = "Comando sem conteudo, Siga as instrucoes abaixo:\nCazola D valor\nCazola S valor\nCazola M valor";
            $data['message'] = 'Conteudo vazio, preencha a mensagem';
            $data['code'] = 501;
            header('Content-type: application/json');
            echo json_encode($data);
            $this->sendMessageParticipationAPI($numero, $message);
        }elseif (empty($cazolaName) || $cazolaName != 'Cazola' || empty($cazolaCategoaria) || empty($cazolaCusto)) {
            $message = "Comando errado, Siga as instrucoes abaixo:\nCazola D valor\nCazola S valor\nCazola M valor";
            $this->sendMessageParticipationAPI($numero, $message);
            $data['message'] = 'Conteudo vazio, preencha a mensagem';
            $data['code'] = 502;
            header('Content-type: application/json');
            echo json_encode($data);
//           $data['message'] = 'Os Campos para participar não estão preenchidos';
        }elseif($Dados_cazola == false){
            $message = "Nao encontramos a cazola que dezeja, tente de novo";
            $this->sendMessageParticipationAPI($numero, $message);
            $data['message'] = 'Conteudo vazio, preencha a mensagem '.$numero;
            $data['code'] = 503;
            header('Content-type: application/json');
            echo json_encode($data);
//            $data['message'] = 'Não existe uma cazola com esta descrição';
        }elseif($Dados_cazola){
            $this->allReferencesAPI_KYAMI($cazolaCusto,$numero,$cazolaCategoaria,$Dados_cazola);
        }
    }
    
    public function allReferencesAPI_KYAMI($cazolaCusto,$numero,$cazolaCategoaria,$Dados_cazola) {
            date_default_timezone_set('Africa/Luanda');
            $datas = new DateTime('+1 day');
            $data_convert = $datas->format('Y-m-d H:i:s');
//        $montante = floatval($this->input->post('amount_sorteio'));
            $body = array(
                'entity' => '01223',
                'price' => $cazolaCusto,
                'expiry' => $data_convert,
                'description' => '',
            );
            $uri = kyami_GPO_url() . 'reference/generate';
            $response = $this->m->newVposForPostKyamiAPI($uri, $body);
            $referencias = $response['resp'];
            $modoPayment = 'M';
            $estado = '0';
            if ($response['httpcode'] == 400) {
                $message = "Servidor Indisponivel, tente mais tarde";
                $this->sendMessageParticipationAPI($numero, $message);
                return 1;
            } elseif ($response['httpcode'] == 401) {
                $message = "Servidor Indisponivel, tente mais tarde";
                $this->sendMessageParticipationAPI($numero, $message);
                return 1;
            } elseif ($response['httpcode'] == 422) {
                $message = "Servidor Indisponivel, tente mais tarde";
                $this->sendMessageParticipationAPI($numero, $message);
                return 1;
            } elseif ($response['httpcode'] == 500 || $response['httpcode'] == 505) {
                $message = "Servidor Indisponivel, tente mais tarde";
                $this->sendMessageParticipationAPI($numero, $message);
                return 1;
        } elseif ($response['httpcode'] == 200) {
                $this->gurdarCriarUserParticipatio($modoPayment,$estado,$numero,$data_convert,$cazolaCategoaria,$cazolaCusto,$Dados_cazola,$referencias);
            } else {
                return 'NOApi';
            }
    }
    
    public function gurdarCriarUserParticipatio($modoPayment,$estado,$numero,$data_convert,$cazolaCategoaria,$cazolaCusto,$Dados_cazola,$referencias) {
        $retorno_telefone = $this->m->verifica_telefoneAPI($numero);
        $total_numerosAPI = $this->limeteBingoAPI($cazolaCategoaria);
        $paymentState = 0;
        if ($retorno_telefone === true) {
            $dados = $this->m->pegarUser_telefone($numero);
//            $codSecreto = $this->criarBingoAPI($total_numerosAPI);
            $codSecreto = $this->u->criarBingo($total_numerosAPI);
            if ($cazolaCategoaria == 'D') {
                $combineCartelas = $this->m->buscarCartelasD($codSecreto);
                $lianhas = $combineCartelas['linha1'] . ',' . $combineCartelas['linha2'] . ',' . $combineCartelas['linha3'];
            } elseif ($cazolaCategoaria == 'S') {
                $combineCartelas = $this->m->buscarCartelasS($codSecreto);
                $lianhas = $combineCartelas['linha1'] . ',' . $combineCartelas['linha2'] . ',' . $combineCartelas['linha3']. ',' . $combineCartelas['linha4'];
            } elseif ($cazolaCategoaria == 'M') {
                $combineCartelas = $this->m->buscarCartelasM($codSecreto);
                $lianhas = $combineCartelas['linha1'] . ',' . $combineCartelas['linha2'] . ',' . $combineCartelas['linha3']. ',' . $combineCartelas['linha4']. ',' . $combineCartelas['linha5'];
            }
            $referencia_id = $this->m->salvar_referenciaAPI_KYAMI($estado, $referencias->price, $referencias->entity, $data_convert, $referencias->reference, $referencias->reference,$dados->id);
            $id_user_sorteio = $this->m->salvar_user_sorteio($cazolaCusto, $dados->id, $codSecreto, $Dados_cazola['id'],$referencia_id,$modoPayment,$paymentState);
            $newCodSecret = implode('-',explode(',', $lianhas));
            $message = "Acabas de participar na Cazola, com a cartela. ".$newCodSecret.". falta pagar a referencia abaixo.";
            $message .= "\nEntidade:  ".$referencias->entity."\n Referencia:  ".$referencias->reference."\n Valor: ".$referencias->price." KZ";
            $this->sendMessageParticipationAPI($numero, $message);
            header('Content-type: application/json');
            echo json_encode($referencias);
            // Enviar Mensagem
        } else {
            $id_user = $this->m->guardarNewUser($numero,$numero);
            $this->m->conta_userAPI($id_user);
            // Guardar Sorteio com novo user
            $codSecreto = $this->u->criarBingo($total_numerosAPI);
            if ($cazolaCategoaria == 'D') {
                $combineCartelas = $this->m->buscarCartelasD($codSecreto);
                $lianhas = $combineCartelas['linha1'] . ',' . $combineCartelas['linha2'] . ',' . $combineCartelas['linha3'];
            } elseif ($cazolaCategoaria == 'S') {
                $combineCartelas = $this->m->buscarCartelasS($codSecreto);
                $lianhas = $combineCartelas['linha1'] . ',' . $combineCartelas['linha2'] . ',' . $combineCartelas['linha3'] . ',' . $combineCartelas['linha4'];
            } elseif ($cazolaCategoaria == 'M') {
                $combineCartelas = $this->m->buscarCartelasM($codSecreto);
                $lianhas = $combineCartelas['linha1'] . ',' . $combineCartelas['linha2'] . ',' . $combineCartelas['linha3'] . ',' . $combineCartelas['linha4'] . ',' . $combineCartelas['linha5'];
            }
            $referencia_id = $this->m->salvar_referenciaAPI_KYAMI($estado, $referencias->price, $referencias->entity, $data_convert, $referencias->reference, $referencias->reference,$id_user);
            $id_user_sorteio = $this->m->salvar_user_sorteio($cazolaCusto, $id_user, $codSecreto, $Dados_cazola['id'],$referencia_id,$modoPayment,$paymentState);
            $newCodSecret = implode('-',explode(',', $lianhas));
            $message = "Acabas de participar na Cazola! com a cartela. ".$newCodSecret.". falta pagar a referencia abaixo.";
            $message .= "\nEntidade:  ".$referencias->entity."\n Referencia:  ".$referencias->reference."\n Valor: ".$referencias->price." KZ";
            $this->sendMessageParticipationAPI($numero, $message);
            header('Content-type: application/json');
            echo json_encode($referencias);
            // Enviar Mensagem
        }
    }
    
    public function limeteIntervaloBingoAPI($total_numeros) {
        if ($total_numeros == 9) {
//            $total_intervalo = 30;
            $total_intervalo = 60;
        } elseif ($total_numeros == 16) {
//            $total_intervalo = 60;
            $total_intervalo = 75;
        } elseif ($total_numeros == 25) {
//            $total_intervalo = 75;
            $total_intervalo = 90;
        }
        return $total_intervalo;
    }
    public function criarBingoAPI($total_numeros) {
        $numeros = array();
        $intervalo = $this->limeteIntervaloBingoAPI($total_numeros);

        while (count($numeros) < $total_numeros) {
            $numero = mt_rand(1, $intervalo);
            if (!in_array($numero, $numeros)) {
                $numeros[] = $numero;
            }
        }
        return implode(',', $numeros);
    }
    public function limeteBingoAPI($categoria) {
        if ($categoria == 'D') {
            $total_numeros = 9;
        } elseif ($categoria == 'S') {
            $total_numeros = 16;
        } elseif ($categoria == 'M') {
            $total_numeros = 25;
        }
        return $total_numeros;
    }
    
    public function weebhooksAPI() {
        $json_data = $this->input->raw_input_stream;
        $conteudo = json_decode($json_data);
        $url_Indianos = 'https://tabuleiros.mojogos.ao/api';
        $url_Sirplay = 'https://dev.mojogosbet.ao/api';
        header('Content-type: application/json');
        $cont = $this->webhookCazola($conteudo->reference);
        if($cont == 200){
           $data['code'] = 200;
           echo json_encode($data); 
        }
//        elseif($this->m->newVposForPostKyami($url_Indianos, $json_data)['resp'] == 200){
//           $data['code'] = 200;
//           echo json_encode($data);
//        }elseif($this->m->newVposForPostKyami($url_Sirplay, $json_data)['resp'] == 200){
//           $data['code'] = 200;
//           echo json_encode($data);
//        }
        else{
            $data['code'] = 400;
           echo json_encode($data);
        }
    }
    
    public function webhookCazola($referencia) {
        if ($referencia == null) {
            $data = 400;
            return $data;
        } else{
            $result = $this->m->listarReferenciaUnicaWHook(intval($referencia));
            if($this->m->verificarReferenciaUserConta($result['id'])){
                return $this->actualizarContaUser(intval($referencia),$result);
            }elseif($this->m->verificarReferenciaUserConta($result['id']) == false){
                return $this->actualizarUserSorteioParticipation(intval($referencia),$result);
            }
        }
    }
    
    public function actualizarContaUser($referencia,$result) {
        $this->u->ActualizarReferenciaTransation($referencia);
        $this->u->Actualizar_Carregar_user_conta($result['id']);
        $data = 200;
        return $data;
    }
    
    public function actualizarUserSorteioParticipation($referencia,$result) {
//        $result = $this->m->listarReferenciaUnicaWHook(intval($referencia));
        if ($result == false) {
            $data = 400;
            return $data;
        } elseif ($result) {
            $this->m->Actualizar_Participacao_userSorteioAPI($result['id']);
            $this->m->ActualizarReferenciaTransationAPI(intval($referencia));
            $participante = $this->m->listarReferenciaPTelefone(intval($referencia));
            if ($participante['modo_pagamento'] == 'M') {
                $message = "Obrigado pelo pagamento, \nParticipacao na cazola de referencia $referencia, confirmada com sucesso";
                $this->sendMessageParticipationAPI($participante['telefone'], $message);
            }

            $data = 200;
            return $data;
        }
    }
    
    
    public function sendMessageParticipationAPI($telefone, $message) {
//        $phone = '244931539318';
        $phone = '244'.$telefone;

        $baseurl = jasmin_url();
        $params = '?username=' . jasmin_user();
        $params .= '&password=' . jasmin_password();
        $params .= '&to=' . urlencode($phone);
        $params .= '&content=' . urlencode($message);

        $mensagemUser = file_get_contents($baseurl . $params);
        if ($mensagemUser) {
            return 1;
        }
    }
    
}

