<?php

class Provincias_m extends CI_Model {

    public function __construct() {
        $this->load->database();
    }

    public function listar($id = false) { // Listar provincias onde o id da provincia é igual ao id pais em provincia
        if ($id === false) {
            $pais ='Angola'; // Esta consulta traz apenas as província de Angola
            $this->db->select('P.id, P.name as provincia, P.created, P.modified, PA.name as pais');
            $this->db->from('provincias P');
            $this->db->join('paises PA', 'PA.id = P.paise_id');
            $this->db->where('PA.name', $pais);
            $query = $this->db->get();
            return $query->result_array();
        }

        $this->db->select('P.id, P.name as provincia, P.created, P.modified, PA.name as pais, PA.id as paise_id');
        $this->db->from('provincias P');
        $this->db->join('paises PA', 'PA.id = P.paise_id');
        $this->db->where('P.id', $id);
        $query = $this->db->get();
        return $query->row_array();
    }

    public function salvar() {
        $data = array(
            'name' => $this->input->post('name'),
            'paise_id' => $this->input->post('paise_id'),
            'created' => date('Y-m-d H:i:s'),
            'modified' => date('Y-m-d H:i:s')
        );
        return $this->db->insert('provincias', $data);
    }

    public function eliminar($id) {
        $this->db->where('id', $id);
        $this->db->delete('provincias');
        return true;
    }

    public function actualizar() {
        $data = array(
            'name' => $this->input->post('name'),
            'paise_id' => $this->input->post('paise_id'),
            'created' => date('Y-m-d H:i:s'),
            'modified' => date('Y-m-d H:i:s')
        );
        $this->db->where('id', $this->input->post('id'));
        return $this->db->update('provincias', $data);
    }

    // buscar pais
    public function buscar_pais() {
        $this->db->order_by('name');
        $query = $this->db->get('paises');
        return $query->result_array();
    }
    
     // buscar províncias
    public function buscar_provincias($id) {
        //$this->db->order_by('name');
        $query = $this->db->get_where('provincias', array('paise_id'=>$id));
        return $query->result();
    }
  

}
