<?php

class Sorteio_premio extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('Sorteio_premio_m', 'm');
        
    }

    
    public function vincular($id) {
        $id_sorteio= $_GET['r'];
        $codigo = base64_decode($id_sorteio);
        $cabecario['notificacoes']= $this->m->notificacoes($this->session->userdata('user_session')['id']);
        $data['premios'] = $this->m->listarPremios();
        $data['sorteios'] = $this->m->listarSorteio($codigo);
        $data['pedidos'] = $this->m->listar_sorteios_premios($codigo);
        $cabecario['menu'] = 'sorteioAdm';
        $cabecario['submenu'] = 'listar';
        $cabecario['sidebar'] = '';
//        if (empty($data['sorteios'])) {
//            show_404();
//        }
        $this->load->view('template/header',$cabecario);
        $this->load->view('sorteio_premio/vincular',$data);
        $this->load->view('template/footer');
    }
    
    public function verificar_PedidoSorteio() 
    {
        $cod_premio=$this->input->post('cod_premio');
        $cod_Sorteio=$this->input->post('cod_Sorteio');
//        $cantidade=1;
        if($this->m->verificarPremioInserido($cod_premio,$cod_Sorteio)){
            $output['stock']='existe';
            echo json_encode($output);
        }else{
            $output['stock'] = 'adicione';
            echo json_encode($output);
        }
    }
    
    public function adcionar_tabela() {
        $data['message'] = '';
        $cod_premio = $this->input->post('cod_premio');
        $cod_Sorteio = $this->input->post('cod_Sorteio');
        $nivelPremio = $this->input->post('nivelPremio');
        $premio=$this->m->listarPremios($cod_premio);
        $cantidade=$this->input->post('qtd');
        if ($this->m->verificarClassificaPremio($nivelPremio,$cod_Sorteio)) {
            $data['message'] = 'erroNivel';
            echo json_encode($data);
        }elseif($cantidade < 1 ){
            $data['message'] = 'erro';
            echo json_encode($data);
        }else{
            $this->m->guardar_pedidoPagamento($nivelPremio,$cod_Sorteio, $cod_premio, $cantidade, $premio['nome'],$premio['photo']);
            echo $this->index_preco($cod_Sorteio); // chama automaticamente o metodo index quendo salvar os dados do pedido
        }
        
    }
    
    public function index_preco($cod_Sorteio) {
//        $sorteioCodigo=$this->m->listarSorteio($cod_Sorteio);
        $pedidos = $this->m->listar_sorteios_premios($cod_Sorteio);
        $data['message'] = 'sucesso';
        if (count($pedidos) > 0) {
            $data['output'] = '';
            $countPedidos = 0;
            foreach ($pedidos as $pedido) {
                $countPedidos = $countPedidos + 1;
                $position = $pedido['nivel_premio'] == '0' ? 'Única' : $pedido['nivel_premio'].'º Lugar';
                $data['output'] .= '<tr class="odd gradeX" id="row_'.$pedido['id'].'">
                               <td width="1%" class="f-s-600 text-inverse">'.$countPedidos.'</td>
                               <td>'.$position.' </td>
                               <td width="1%" class="with-img">
                                   <img src="'.base_url().'assets/images/premio/'.$pedido['photo_premio'].'" class="img-rounded height-50" alt="" />
                               </td>
                               <td>'.$pedido['nome_premio'].'</td>
                               <td>'.$pedido['quantidade'].'</td>
                               <td class="f-s-600 text-inverse">
                                   <a href="#" id="'.$pedido['id'].'"  class="btn btn-danger btn-icon btn-circle btn-lg eliminarPremio_linha">
                                       <i class="fa fa-trash-alt"></i>
                                   </a>
                               </td>
                           </tr>';
            }
            echo json_encode($data);
        }
    }
    
    
    public function tabela_premio_qtd() {
        $cod_premio = $this->input->post('cod_premio');
        $classificar = $this->input->post('classific');
        $premio=$this->m->listarPremios($cod_premio);
        if (count($premio) > 0) {
            $output = '';
              $output .='<fieldset id="tabela_qtd_premio">
                        <table id="data-table-responsive2" class="table table-striped table-bordered">
                            <thead>
                                <tr>
                                    <th width="1%" data-orderable="false"></th>
                                    <th class="text-nowrap" width="5%">Nome</th>
                                    
                                    <th style="width: 5px" >Qtd</th>
                                    <th width="5%">Classif.</th>
                                    <th class="text-nowrap" data-orderable="false" width="1%">Operação</th>
                                </tr>
                            </thead>
                            <tbody>
                            <input type="hidden" name="cod_premio" value="'.$premio['id'].'" />
                            <tr class="odd gradeX">
                                <td width="1%" class="with-img">
                                    <img src="'.base_url().'assets/images/premio/'.$premio['photo'].'" class="img-rounded height-50" alt="" />
                                </td>
                                <td width="5%">'.$premio['nome'].'</td>
                                
                                <td style="width: 5px" class="col-md-4">
                                    <input type="number" style="width: 40px" min="1" name="qtd" value="1" />
                                </td>
                                <td >';
                                    if($classificar == 'U'){
                                        $output .='<select class="custom-select   mb-8" style="width: 80px" name="nivelPremio" required="">
                                                    <option value="0">Única</option>
                                                </select>';
                                    }else {
                                       $output .='<select class="custom-select   mb-8" style="width: 80px" name="nivelPremio" required="">
                                                    <option value="1">1º</option>
                                                    <option value="2">2º</option>
                                                    <option value="3">3º</option>
                                                </select>'; 
                                    }
                    $output .= '</td>
                                <td class="f-s-600 text-inverse" width="1%">
                                    <button type="submit" class="btn btn-lg btn-green ">
                                        <i class="fa fa-save"></i>
                                    </button>
                                </td>
                            </tr>
                        </tbody></table></fieldset>';
            echo json_encode($output);
        }
    }
    
    public function eliminarPremio_sorteio() {
        if (!empty($this->input->post('id'))) {
            $id = $this->input->post('id');
            $this->m->eliminar_one_premio($id);
//            echo 'eliminou';
            echo json_encode('eliminou');
        }
    }

    

}
