<?php
ini_set('memory_limit', '4028M');
class Relatorios extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->load->library('Pdf_report');
        $this->load->model('Relatorios_m', 'm');
    }

    public function index() {
//        $data['sorteios'] = $this->m->sorteios();$this->uri->segment(3)
        $data['tableHead'] =NULL;
        $cabecario['submenu'] = 'relatorioSorteio';
        $cabecario['menu'] = 'relatorioAdm';
        $cabecario['sidebar'] = '';
        $cabecario['notificacoes']= $this->m->notificacoes($this->session->userdata('user_session')['id']);
        $data['relatorio']= $this->m->listarSorteiosPorData(); 
        $data['sorteios'] = $this->m->listarSorteio();
        if(!empty($this->input->post('data_inicio')) && !empty($this->input->post('data_fim'))){
            $data['tableHead'] = array(
            'SorteioCOD' => $this->input->post('sorteioID'),
            'DataInicio' => $this->input->post('data_inicio'),
            'DataFim' => $this->input->post('data_fim')
            );
        }
        $this->load->view('template/header',$cabecario);
        $this->load->view('relatorios/RelatorioSorteios',$data);
        $this->load->view('template/footer');
    }
    
    public function participacoes() {
//        $data['sorteios'] = $this->m->sorteios();$this->uri->segment(3)
        $data['tableHead'] =NULL;
        $data['relatorio']= $this->m->listarSorteiosPorData(); 
        $data['sorteios'] = $this->m->listarSorteio();
        $data['user_actual'] = $this->session->userdata('user_session')['nome'];
        if(!empty($this->input->post('data_inicio')) && !empty($this->input->post('data_fim'))){
            $data['tableHead'] = array(
            'SorteioCOD' => $this->input->post('sorteioID'),
            'DataInicio' => $this->input->post('data_inicio'),
            'DataFim' => $this->input->post('data_fim')
            );
        }
        $this->load->view('relatorios/RelatorioPDF',$data);
    }
    
    
    public function getSorteiosState() {
        $sorteioState = $this->input->post('sorteioStado');
        $sorteios = $this->m->sorteiosByState($sorteioState);
        $pro_select_box = '';
        if (!empty($sorteios)) {
            $pro_select_box .= '<option value="">Escolha um Sorteio</option>';
            foreach ($sorteios as $sorteio) {
                $pro_select_box .='<option value="' . $sorteio->id . '">'.$sorteio->nome. '</option>';
            }
            echo json_encode($pro_select_box);
        }else{
            $pro_select_box .= '<option value="">Nenhum Sorteio Encontrado</option>';
            echo json_encode($pro_select_box);
        }
    }
    

}
